/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDiagnosticItem;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.util.DetailedLog;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class OchDiagnosticPane
extends AbstractPane
implements Runnable {
    private static final String TITLE = "Diagnostic and Fix";
    private static final String START = "Start";
    private static final String SAVE = "Save";
    private INetCircuit ckt;
    private JButton startButton;
    private JButton saveButton;
    private DetailedLogPane logPane;
    private DetailedLog logRoot;
    private DetailedLog nodeDl;
    private JProgressBar progressBar;
    private static final SDebug db = new SDebug("OchDiagnosticPane");

    public OchDiagnosticPane(TabbedView tabbedView, INetCircuit iNetCircuit) {
        super(TITLE, tabbedView);
        this.ckt = iNetCircuit;
        this.initPane();
    }

    static boolean isOchDiagnosticAvailable(INetCircuit iNetCircuit) {
        if (iNetCircuit.getCircuitTypeObj().isOchncType() || iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            List list = iNetCircuit.getCircuitNodes();
            for (INetCircuitNode iNetCircuitNode : list) {
                if (!iNetCircuitNode.getNodeModel().provides(Feature.OCH_DIAGNOSTIC)) continue;
                return true;
            }
        }
        return false;
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
    }

    public void refresh() throws Exception {
    }

    private void initPane() {
        this.setLayout(new BorderLayout());
        this.logRoot = new DetailedLog(1, "OCH diagnostic");
        this.logPane = new DetailedLogPane(this.logRoot, false, false);
        JTree jTree = this.logPane.getTree();
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
        DiagCellRendererAndEditor diagCellRendererAndEditor = new DiagCellRendererAndEditor(defaultTreeCellRenderer);
        jTree.setCellRenderer(diagCellRendererAndEditor);
        jTree.setCellEditor(diagCellRendererAndEditor);
        jTree.setEditable(true);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 10)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 200;
                return dimension;
            }
        };
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        jPanel2.add(this.progressBar);
        JPanel jPanel3 = new JPanel();
        this.startButton = new JButton(START);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(OchDiagnosticPane.this).start();
            }
        });
        this.saveButton = new JButton(SAVE);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OchDiagnosticPane.this.save();
            }
        });
        jPanel3.add((Component)this.startButton, "East");
        jPanel3.add((Component)this.saveButton, "West");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.add((Component)this.logPane, "Center");
        this.add(jPanel, "South");
    }

    private void save() {
        this.logPane.saveToFile("Save Diagnostic and Fix to file", "Select the file where the log message will be saved to", "ctc.dialog.dl", "save", "OCHNC Diagnostic and Fix for circuit \"" + this.ckt.getCircuitName() + "\"");
    }

    public void run() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.startButton.setEnabled(false);
        this.progressBar.setVisible(true);
        this.progressBar.setValue(0);
        this.logPane.removeDetailedLog(this.logRoot);
        this.logRoot = new DetailedLog(1, "OCH diagnostic");
        this.logPane.addDetailedLog(this.logRoot, true);
        try {
            List list = this.ckt.getCircuitNodes();
            if (list.size() > 0) {
                double d = 100.0 / (double)list.size();
                for (INetCircuitNode iNetCircuitNode : list) {
                    this.startNode(iNetCircuitNode);
                    this.progressBar.setValue((int)((double)this.progressBar.getValue() + d));
                }
            }
        }
        catch (Exception exception) {
            db.warning("Diagnosys failed: " + exception.getMessage());
            SDebug.printStackTrace((Throwable)exception);
        }
        this.setCursor(cursor);
        this.startButton.setEnabled(true);
        this.progressBar.setVisible(false);
    }

    private void startNode(INetCircuitNode iNetCircuitNode) {
        INodeModel iNodeModel = iNetCircuitNode.getNodeModel();
        if (db.on()) {
            db.println("startNode for node " + iNodeModel.getName());
        }
        if (iNodeModel.provides(Feature.OCH_DIAGNOSTIC)) {
            boolean bl = false;
            if (iNetCircuitNode instanceof OchncCircuitNode) {
                bl = this.diagOchnc((IOchncConnectionModel)iNetCircuitNode.getConn());
            } else if (iNetCircuitNode instanceof OchTrailTunnelNode) {
                bl = this.diagOchTrail((IOchTrailAditModel)iNetCircuitNode.getConn());
            } else if (iNetCircuitNode instanceof DualConnectionCircuitNode) {
                DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)iNetCircuitNode;
                bl = this.diagOchTrail((IOchTrailAditModel)dualConnectionCircuitNode.getFstCircuitNode().getConn());
                boolean bl2 = bl = bl && this.diagOchnc((IOchncConnectionModel)dualConnectionCircuitNode.getSecCircuitNode().getConn());
            }
            if (bl) {
                this.addNoIssues(iNetCircuitNode.getConn());
            }
        } else {
            if (db.on()) {
                db.println("Diagnostic not supported");
            }
            this.nodeDl = new DetailedLog(1, iNodeModel.getName() + " does not provide OCHNC diagnostic");
            this.logRoot.addChild(this.nodeDl);
        }
        this.logPane.updateDetailedLog(this.logRoot, true);
    }

    private boolean diagOchnc(IOchncConnectionModel iOchncConnectionModel) {
        boolean bl = false;
        IOchncPathDiagnosticItem[] iOchncPathDiagnosticItemArray = iOchncConnectionModel.getDiagInfo();
        if (this.anyIssue(iOchncPathDiagnosticItemArray)) {
            if (iOchncPathDiagnosticItemArray.length == 2 && iOchncPathDiagnosticItemArray[0].equals(iOchncPathDiagnosticItemArray[1])) {
                if (db.on()) {
                    db.println("Diag instances are equal: removing the second.");
                }
                iOchncPathDiagnosticItemArray = new IOchncPathDiagnosticItem[]{iOchncPathDiagnosticItemArray[0]};
            }
            IOchncPathDiagnosticItem[] iOchncPathDiagnosticItemArray2 = iOchncPathDiagnosticItemArray;
            int n = iOchncPathDiagnosticItemArray2.length;
            for (int i = 0; i < n; ++i) {
                IOchncPathDiagnosticItem iOchncPathDiagnosticItem;
                IOchncPathDiagnosticItem iOchncPathDiagnosticItem2 = iOchncPathDiagnosticItem = iOchncPathDiagnosticItemArray2[i];
                if (db.on()) {
                    db.println("diagOchnc for " + iOchncConnectionModel + " : state = " + iOchncPathDiagnosticItem2.getDiagState() + ", port = " + Integer.toHexString(iOchncPathDiagnosticItem2.getTargetPortIndex()));
                }
                if (!this.hasFixesAvailable(iOchncPathDiagnosticItem2)) continue;
                this.nodeDl = iOchncPathDiagnosticItem2.getTargetPortIndex() != 0 ? new DetailedLog(1, this.getPortString((IConnectionModel)iOchncConnectionModel, iOchncPathDiagnosticItem2)) : new DetailedLog(1, iOchncConnectionModel.getNodeModel().getName());
                this.logRoot.addChild(this.nodeDl);
                DetailedLog detailedLog = new DetailedLog(this.getLogType(iOchncPathDiagnosticItem2), this.buildLogMessage((IConnectionModel)iOchncConnectionModel, iOchncPathDiagnosticItem2));
                this.nodeDl.setType(Math.max(this.nodeDl.getType(), detailedLog.getType()));
                this.nodeDl.addChild(detailedLog);
                if (db.on()) {
                    db.println("Fixes available");
                }
                detailedLog = new DetailedLog(1, this.buildFixMessage((IConnectionModel)iOchncConnectionModel, iOchncPathDiagnosticItem2));
                this.buildFixAction((IConnectionModel)iOchncConnectionModel, iOchncPathDiagnosticItem2, detailedLog);
                this.nodeDl.addChild(detailedLog);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean diagOchTrail(IOchTrailAditModel iOchTrailAditModel) {
        boolean bl = false;
        IPortModel iPortModel = iOchTrailAditModel.getPortModel();
        try {
            if (iPortModel.getAdminState() != 0) {
                this.nodeDl = new DetailedLog(1, "[OCHTRAIL] " + this.getPortString((IEntityModel)iPortModel));
                this.logRoot.addChild(this.nodeDl);
                OchncPathDiagnosticItemHolder ochncPathDiagnosticItemHolder = new OchncPathDiagnosticItemHolder((IEntityModel)iPortModel, 2);
                DetailedLog detailedLog = new DetailedLog(this.getLogType(ochncPathDiagnosticItemHolder), this.buildLogMessage((IConnectionModel)iOchTrailAditModel, ochncPathDiagnosticItemHolder));
                this.nodeDl.setType(Math.max(this.nodeDl.getType(), detailedLog.getType()));
                this.nodeDl.addChild(detailedLog);
                detailedLog = new DetailedLog(1, this.buildFixMessage((IConnectionModel)iOchTrailAditModel, ochncPathDiagnosticItemHolder));
                this.buildFixAction((IConnectionModel)iOchTrailAditModel, ochncPathDiagnosticItemHolder, detailedLog);
                this.nodeDl.addChild(detailedLog);
            } else {
                bl = true;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Cannot run Diag and Fix: " + noSuchInterface.getMessage());
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            CerentDialog.errorDialog((Component)((Object)this), (String)("Cannot verify admin state for port:\n" + this.getPortString((IEntityModel)iPortModel)));
        }
        return bl;
    }

    private void addNoIssues(IConnectionModel iConnectionModel) {
        OchncPathDiagnosticItemHolder ochncPathDiagnosticItemHolder = new OchncPathDiagnosticItemHolder(null, 0);
        this.nodeDl = new DetailedLog(1, iConnectionModel.getNodeModel().getName() + ": " + this.buildLogMessage(iConnectionModel, ochncPathDiagnosticItemHolder));
        this.logRoot.addChild(this.nodeDl);
    }

    private int getLogType(IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        switch (iOchncPathDiagnosticItem.getDiagState()) {
            case 0: 
            case 6: 
            case 9: {
                return 1;
            }
        }
        return 3;
    }

    private boolean anyIssue(IOchncPathDiagnosticItem[] iOchncPathDiagnosticItemArray) {
        for (IOchncPathDiagnosticItem iOchncPathDiagnosticItem : iOchncPathDiagnosticItemArray) {
            if (!this.hasFixesAvailable(iOchncPathDiagnosticItem)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFixesAvailable(IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        return iOchncPathDiagnosticItem.getDiagState() != 0;
    }

    private String buildLogMessage(IConnectionModel iConnectionModel, IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        switch (iOchncPathDiagnosticItem.getDiagState()) {
            case 9: {
                return "No issues found";
            }
            case 0: {
                return "No issues found";
            }
            case 1: {
                return "Invalid connection state for " + this.getConnString(iConnectionModel) + ": " + NetAdminState.getAdminStateStringFromAdminState(iConnectionModel.getAdminState());
            }
            case 2: {
                return "Invalid admin state: " + this.getPortAdminState(iConnectionModel, iOchncPathDiagnosticItem);
            }
            case 10: {
                return "Circuit IS but alarmed check cause";
            }
            case 3: {
                return "ANS couldn't regulate port";
            }
            case 4: {
                return "APC is not enabled for this side";
            }
            case 5: {
                return "APC couldn't regulate the port";
            }
            case 6: {
                return "APC regulation is running for the port";
            }
            case 12: {
                return "Next node is not reachable by DCN";
            }
            case 7: {
                return "Splitter not alligned (working vs protected)";
            }
            case 8: {
                return "Splitter not alligned";
            }
            case 11: {
                return "Wrong lambda provisioned on txp";
            }
            case 13: {
                return "Raman not tuned or tuning in progress";
            }
            case 14: {
                return "Channel startup is in locked state";
            }
        }
        if (db.on()) {
            db.println("buildLogMessage INVALID state value: " + iOchncPathDiagnosticItem.getDiagState());
        }
        return "";
    }

    private String buildFixMessage(IConnectionModel iConnectionModel, IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        switch (iOchncPathDiagnosticItem.getDiagState()) {
            case 9: {
                return "Not yet started, wait scheduling";
            }
            case 0: {
                return "No fixes";
            }
            case 10: {
                return "Check alarm and fix cause";
            }
            case 1: {
                return "Change connection state by switching to the State panel";
            }
            case 2: {
                return "Modify port state";
            }
            case 3: {
                return "Check ANS regulations and relaunch the application ";
            }
            case 4: {
                return "Enable APC ";
            }
            case 5: {
                return "Check APC regulations and relaunch the application ";
            }
            case 6: {
                return "No fixes. Just wait for the APC regulation completes ";
            }
            case 12: {
                return "Check DCN configuration and state ";
            }
            case 7: {
                return "Check cabling";
            }
            case 8: {
                return "Check switch position";
            }
            case 11: {
                return "Check lambda tuning on txp";
            }
            case 13: {
                return "Tune Raman and wait until is tuned";
            }
            case 14: {
                return "Verify the upstream amplifier and eventually try to force the channel startup";
            }
        }
        if (db.on()) {
            db.println("buildFixMessage INVALID state value: " + iOchncPathDiagnosticItem.getDiagState());
        }
        return "";
    }

    private void buildFixAction(IConnectionModel iConnectionModel, IOchncPathDiagnosticItem iOchncPathDiagnosticItem, DetailedLog detailedLog) {
        FixAction fixAction = new FixAction();
        INodeModel iNodeModel = iConnectionModel.getNodeModel();
        int n = iNodeModel.getNodeId();
        IEntityModel iEntityModel = this.getPortModel(iConnectionModel, iOchncPathDiagnosticItem);
        switch (iOchncPathDiagnosticItem.getDiagState()) {
            case 1: {
                fixAction.initJumpToState();
                break;
            }
            case 2: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 5}, new String[]{"Provisioning"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 10: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 1}, new String[]{"Alarms"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 3: {
                ViewName viewName = new ViewName(new int[]{n, 0, 0, 0, 0, 5}, new String[]{"Provisioning", "WDM-ANS", "Port Status"});
                fixAction.init(viewName, true);
                break;
            }
            case 4: {
                ViewName viewName = new ViewName(new int[]{0, 0, 0, 0, 0, 7}, new String[]{"Maintenance", "APC"});
                fixAction.init(viewName, true);
                break;
            }
            case 5: {
                ViewName viewName = new ViewName(new int[]{0, 0, 0, 0, 0, 7}, new String[]{"Maintenance", "APC"});
                fixAction.init(viewName, true);
                break;
            }
            case 6: {
                ViewName viewName = new ViewName(new int[]{n, 0, 0, 0, 0, 7}, new String[]{"Maintenance", "DWDM", "APC"});
                fixAction.init(viewName, false);
                break;
            }
            case 12: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 5}, new String[]{"Provisioning"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 7: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 7}, new String[]{"Maintenance", "Protection"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 8: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 7}, new String[]{"Maintenance", "Protection"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 11: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 5}, new String[]{"Provisioning"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 13: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 5}, new String[]{"Provisioning"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            case 14: {
                ViewName viewName = iEntityModel != null ? new ViewName(new int[]{n, this.getShelfId(iEntityModel), iEntityModel.getSlot(), 0, 0, 5}, new String[]{"Provisioning"}) : new ViewName(n);
                fixAction.init(viewName, true);
                break;
            }
            default: {
                if (db.on()) {
                    db.println("buildFixAction INVALID state value: " + iOchncPathDiagnosticItem.getDiagState());
                }
                return;
            }
        }
        detailedLog.setAction((Action)fixAction);
    }

    private int getShelfId(IEntityModel iEntityModel) {
        if (iEntityModel.getNodeModel().isMultishelf()) {
            return iEntityModel.getShelfId();
        }
        return 0;
    }

    private String getConnString(IConnectionModel iConnectionModel) {
        return "\"" + iConnectionModel.getConnectionName() + "\"";
    }

    private IEntityModel getPortModel(IConnectionModel iConnectionModel, IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        try {
            return iConnectionModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchncPathDiagnosticItem.getTargetPortIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.println("getPortModel Cannot get port model: " + abstractCmsNoSuchEntityException.getMessage());
            }
            return null;
        }
    }

    private String getPortString(IConnectionModel iConnectionModel, IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        IEntityModel iEntityModel = this.getPortModel(iConnectionModel, iOchncPathDiagnosticItem);
        return iEntityModel != null ? this.getPortString(iEntityModel) : iConnectionModel.getNodeModel().getName() + ", unknown port " + Integer.toHexString(iOchncPathDiagnosticItem.getTargetPortIndex());
    }

    private String getPortAdminState(IConnectionModel iConnectionModel, IOchncPathDiagnosticItem iOchncPathDiagnosticItem) {
        block3: {
            IEntityModel iEntityModel = this.getPortModel(iConnectionModel, iOchncPathDiagnosticItem);
            if (iEntityModel instanceof IPortModel) {
                IPortModel iPortModel = (IPortModel)iEntityModel;
                try {
                    return NetAdminState.getAdminStateStringFromAdminState(iPortModel.getAdminState());
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) break block3;
                    db.println("getPortAdminState Cannot get port admin state: " + noSuchInterface.getMessage());
                }
            }
        }
        return NetAdminState.getAdminStateStringFromAdminState(-1);
    }

    private String getPortString(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel());
        StringBuffer stringBuffer = new StringBuffer(iNodeModel.getName()).append(", ");
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel, "shelf "));
        } else {
            stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel, "slot "));
        }
        return stringBuffer.toString();
    }

    private class FixAction
    extends AbstractAction {
        private NetworkViewController nvc;
        private ViewName viewName;

        FixAction() {
            this.putValue("Name", "Fix");
            this.nvc = NetworkViewController.instance();
        }

        void init(ViewName viewName, boolean bl) {
            this.viewName = viewName;
            if (bl) {
                this.putValue("Name", "Fix");
            } else {
                this.putValue("Name", "Check");
            }
        }

        void initJumpToState() {
            this.viewName = null;
            this.putValue("Name", "Fix");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (this.viewName != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FixAction.this.nvc.tryJumpView(FixAction.this.viewName);
                    }
                });
            } else {
                object = OchDiagnosticPane.this.getParentView();
                for (int i = 0; i < object.getTabCount(); ++i) {
                    String string = object.getTitleAt(i);
                    if (!string.equals("State")) continue;
                    object.setSelectedIndex(i);
                    break;
                }
            }
            object = (DiagCellRendererAndEditor)OchDiagnosticPane.this.logPane.getTree().getCellEditor();
            ((DiagCellRendererAndEditor)object).finishEdit();
        }
    }

    private class DiagCellRendererAndEditor
    extends AbstractCellEditor
    implements TreeCellRenderer,
    TreeCellEditor {
        private DefaultTreeCellRenderer defaultRenderer;
        private RowPanel rendererRowpanel;
        private RowPanel editorRowpanel;

        DiagCellRendererAndEditor(DefaultTreeCellRenderer defaultTreeCellRenderer) {
            this.defaultRenderer = defaultTreeCellRenderer;
        }

        private RowPanel getRendererPanel(DefaultMutableTreeNode defaultMutableTreeNode) {
            if (this.rendererRowpanel == null) {
                this.rendererRowpanel = new RowPanel();
            }
            return this.rendererRowpanel;
        }

        private RowPanel getEditorPanel(DefaultMutableTreeNode defaultMutableTreeNode) {
            if (this.editorRowpanel == null) {
                this.editorRowpanel = new RowPanel();
            }
            return this.editorRowpanel;
        }

        private Component getNodePanel(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, boolean bl5) {
            DetailedLog detailedLog;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof DetailedLog && (detailedLog = (DetailedLog)object2).getAction() != null) {
                RowPanel rowPanel = bl5 ? this.getEditorPanel(defaultMutableTreeNode) : this.getRendererPanel(defaultMutableTreeNode);
                rowPanel.init(detailedLog, bl, bl4);
                return rowPanel;
            }
            return this.defaultRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        public Object getCellEditorValue() {
            return null;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return this.getNodePanel(jTree, object, bl, bl2, bl3, n, bl4, false);
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this.getNodePanel(jTree, object, true, bl2, bl3, n, true, true);
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object;
                TreePath treePath;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                JTree jTree = OchDiagnosticPane.this.logPane.getTree();
                if (eventObject.getSource() == jTree && (treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof DetailedLog) {
                    DetailedLog detailedLog = (DetailedLog)object;
                    return detailedLog.getAction() != null;
                }
            }
            return super.isCellEditable(eventObject);
        }

        void finishEdit() {
            this.fireEditingCanceled();
        }

        private class RowPanel
        extends JPanel {
            private boolean drawsFocusBorderAroundIcon;
            private boolean drawDashedFocusIndicator;
            private Color treeBGColor;
            private Color focusBGColor;
            JLabel label;
            JButton button;
            boolean selected;
            boolean hasFocus;

            RowPanel() {
                super(new FlowLayout(0, 0, 5));
                this.setOpaque(false);
                this.label = new JLabel("");
                this.add(this.label);
                this.add(new JLabel(" "));
                this.button = new JButton("");
                this.add(this.button);
                this.button.setForeground(DiagCellRendererAndEditor.this.defaultRenderer.getTextNonSelectionColor());
                this.button.setBackground(DiagCellRendererAndEditor.this.defaultRenderer.getBackgroundNonSelectionColor());
                Dimension dimension = new Dimension(55, 20);
                this.button.setMinimumSize(dimension);
                this.button.setMaximumSize(dimension);
                JTree jTree = OchDiagnosticPane.this.logPane.getTree();
                Font font = jTree.getFont();
                this.label.setFont(font);
                this.button.setFont(font.deriveFont((float)font.getSize() - 2.0f));
                Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
                this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
                object = UIManager.get("Tree.drawDashedFocusIndicator");
                this.drawDashedFocusIndicator = object != null && (Boolean)object != false;
            }

            void init(DetailedLog detailedLog, boolean bl, boolean bl2) {
                this.label.setIcon(DetailedLogPane.getIcon((DetailedLog)detailedLog));
                this.label.setText(DetailedLogPane.getDesc((DetailedLog)detailedLog));
                if (bl) {
                    this.label.setForeground(DiagCellRendererAndEditor.this.defaultRenderer.getTextSelectionColor());
                } else {
                    this.label.setForeground(DiagCellRendererAndEditor.this.defaultRenderer.getTextNonSelectionColor());
                }
                this.button.setAction(detailedLog.getAction());
                this.selected = bl;
                this.hasFocus = bl2;
            }

            public void paint(Graphics graphics) {
                Color color = this.selected ? DiagCellRendererAndEditor.this.defaultRenderer.getBackgroundSelectionColor() : DiagCellRendererAndEditor.this.defaultRenderer.getBackgroundNonSelectionColor();
                Icon icon = this.label.getIcon();
                int n = icon.getIconWidth() + Math.max(0, this.label.getIconTextGap() - 1);
                graphics.setColor(color);
                graphics.fillRect(n, 0, this.label.getWidth() - n, this.getHeight());
                if (this.hasFocus) {
                    if (this.drawsFocusBorderAroundIcon) {
                        n = 0;
                    }
                    this.paintFocus(graphics, n, 0, this.label.getWidth() - n, this.getHeight());
                }
                super.paint(graphics);
            }

            private void paintFocus(Graphics graphics, int n, int n2, int n3, int n4) {
                Color color = DiagCellRendererAndEditor.this.defaultRenderer.getBorderSelectionColor();
                if (color != null && (this.selected || !this.drawDashedFocusIndicator)) {
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                }
                if (this.drawDashedFocusIndicator) {
                    Color color2;
                    if (this.selected) {
                        color2 = DiagCellRendererAndEditor.this.defaultRenderer.getBackgroundSelectionColor();
                    } else {
                        color2 = DiagCellRendererAndEditor.this.defaultRenderer.getBackgroundNonSelectionColor();
                        if (color2 == null) {
                            color2 = this.getBackground();
                        }
                    }
                    if (this.treeBGColor != color2) {
                        this.treeBGColor = color2;
                        this.focusBGColor = new Color(~color2.getRGB());
                    }
                    graphics.setColor(this.focusBGColor);
                    BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
                }
            }
        }
    }

    private class OchncPathDiagnosticItemHolder
    implements IOchncPathDiagnosticItem {
        private IEntityModel port;
        private int diagState;

        OchncPathDiagnosticItemHolder(int n) {
            this(null, n);
        }

        OchncPathDiagnosticItemHolder(IEntityModel iEntityModel, int n) {
            this.port = iEntityModel;
            this.diagState = n;
        }

        public int getDiagState() {
            return this.diagState;
        }

        public int getTargetPortIndex() {
            return this.port != null ? this.port.getEntityIndex() : 0;
        }
    }
}

