/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.UpsrSelector;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.AnnotatedException;
import cerent.util.PluralisationUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PathSelectorDialog
extends UDialog
implements ActionListener,
ProgressDialogControl {
    private static TDMTerminology tdmTerm;
    private static final SDebug db;
    static final String TITLE = "Path Selector Attributes";
    private INetCircuit[] circuits;
    private static final int MARGIN = 15;
    private static final int[] cktStatusesAllowPathSelectorEdit;
    private int hoPSCount;
    private int loPSCount;
    private int noPSCount;
    private int hoPDISupportedCount;
    private int hoBlsrDriNodesCount;
    private int loBerSupportedCount;
    private RevertiveBehaviorPanel upsrRBP;
    private JComboBox loSfThCB;
    private JComboBox loSdThCB;
    private JComboBox hoSfThCB;
    private JComboBox hoSdThCB;
    private JCheckBox swOnPdipCB;
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea textPane;
    private IRevertiveBehavior upsrReversion;
    private Attribute upsrLoSfBerLevel;
    private Attribute upsrLoSdBerLevel;
    private Attribute upsrHoSfBerLevel;
    private Attribute upsrHoSdBerLevel;
    private boolean upsrSwitchOnPdip;
    private StringBuffer failures = new StringBuffer();
    private boolean bAbort = false;
    private int adminState;
    private static final int IS_LO = 0;
    private static final int IS_HO = 1;
    private static final int HAS_PDI = 2;
    private static final int HAS_UPSR = 3;
    private static final int HAS_BLSR_DRI = 4;
    private static final int HAS_BER_MONITORING = 5;
    private static final int NUMBER_OF_CIRCUIT_CHARACTERISTICS = 6;

    private PathSelectorDialog(Frame frame, String string, boolean bl, INetCircuit[] iNetCircuitArray) {
        super(frame, string, bl, (Object)iNetCircuitArray);
    }

    public static PathSelectorDialog instance(Frame frame, INetCircuit[] iNetCircuitArray) {
        return new PathSelectorDialog(frame, TITLE, true, iNetCircuitArray);
    }

    private void displayCircuitInfo() {
        int n = this.hoPSCount + this.loPSCount + this.noPSCount;
        this.textPane.append(" " + n + "\n\n");
        if (this.hoPSCount > 0) {
            String string = tdmTerm.getGeneralTerms(9);
            String string2 = tdmTerm.getRingTerms(1);
            String string3 = string2 + "-DRI";
            this.textPane.append(this.hoPSCount + " " + tdmTerm.getGeneralTerms(0) + " " + PluralisationUtil.s("circuit", this.hoPSCount) + " " + PluralisationUtil.s("has", this.hoPSCount) + " path selectors.\n");
            this.textPane.append(PluralisationUtil.ofThese("has", this.hoPDISupportedCount, this.hoPSCount));
            this.textPane.append(" selectors that support switching on " + string + ".\n");
            if (this.hoBlsrDriNodesCount > 0) {
                this.textPane.append(PluralisationUtil.ofThese("has", this.hoBlsrDriNodesCount, this.hoPDISupportedCount));
                this.textPane.append(" " + string3 + ", for which the service selectors' switch on " + string + " attribute is not configurable, and is always enabled.\n");
            }
            this.textPane.append("\n");
        }
        if (this.loPSCount > 0) {
            this.textPane.append(this.loPSCount + " " + tdmTerm.getGeneralTerms(1) + " " + PluralisationUtil.s("circuit", this.loPSCount) + " " + PluralisationUtil.s("has", this.loPSCount) + " path selectors.\n");
            this.textPane.append(PluralisationUtil.ofThese("has", this.loBerSupportedCount, this.loPSCount));
            this.textPane.append(" selectors that support signal BER monitoring.\n\n");
        }
        if (this.noPSCount > 0) {
            this.textPane.append(this.noPSCount + " " + PluralisationUtil.s("circuit", this.noPSCount) + " " + PluralisationUtil.s("has", this.noPSCount) + " no path selector.\nNo changes will be made.");
        }
    }

    private boolean supportsBerMonitoring(boolean bl, INetCircuitNode iNetCircuitNode) {
        boolean bl2 = false;
        if (iNetCircuitNode.isUpsrSelector()) {
            bl2 = true;
            if (!bl) {
                List list = iNetCircuitNode.getUpsrConns();
                for (IConnectionModel iConnectionModel : list) {
                    if (!(iConnectionModel instanceof UpsrSelector)) continue;
                    UpsrSelector upsrSelector = (UpsrSelector)iConnectionModel;
                    try {
                        upsrSelector.getUpsrSfBerLevel();
                        upsrSelector.getUpsrSdBerLevel();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        bl2 = false;
                    }
                }
            }
        }
        return bl2;
    }

    private boolean isSonet(INodeModel iNodeModel) {
        boolean bl = false;
        if (iNodeModel.getTdmProtocolTypeObj().isSonet()) {
            bl = true;
        }
        return bl;
    }

    private boolean supportsPDI(boolean bl, INetCircuitNode iNetCircuitNode) {
        boolean bl2 = false;
        if (bl && this.isSonet(iNetCircuitNode.getNodeModel())) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean moreToDo(boolean[] blArray, int n, int n2) {
        boolean bl = n == n2;
        for (int i = 3; !bl && i < blArray.length; ++i) {
            bl = !blArray[i];
        }
        return bl;
    }

    private void characterizeCircuit(INetCircuit iNetCircuit, boolean[] blArray) {
        if (PathSelectorDialog.db.on) {
            db.fine("characterizeCircuit(" + iNetCircuit + ")");
        }
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
        blArray[1] = iCircuitType.isHoCircuitType();
        blArray[0] = iCircuitType.isLoCircuitType();
        int n = iNetCircuit.getProtType();
        List list = iNetCircuit.getCircuitNodes();
        Iterator iterator = list.iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext() && this.moreToDo(blArray, n2, n3)) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            ++n2;
            if (this.supportsPDI(blArray[1], iNetCircuitNode)) {
                ++n3;
            }
            if (blArray[3] || iNetCircuitNode.isUpsr() && n == 13) {
                blArray[3] = true;
                if (!blArray[5] && this.supportsBerMonitoring(blArray[1], iNetCircuitNode)) {
                    blArray[5] = true;
                }
            }
            blArray[4] = blArray[4] | CircuitMapUtil.isBlsrDriNode(iNetCircuitNode);
        }
        if (blArray[3] && n2 == n3) {
            blArray[2] = true;
        }
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.circuits = (INetCircuit[])object;
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>(this.circuits.length);
        this.loBerSupportedCount = 0;
        this.hoBlsrDriNodesCount = 0;
        this.hoPDISupportedCount = 0;
        this.noPSCount = 0;
        this.loPSCount = 0;
        this.hoPSCount = 0;
        for (int i = 0; i < this.circuits.length; ++i) {
            INetCircuit iNetCircuit = this.circuits[i];
            tdmTerm = CircuitMapUtil.getTDMTerminology(iNetCircuit);
            boolean[] blArray = new boolean[6];
            this.characterizeCircuit(iNetCircuit, blArray);
            if (blArray[1]) {
                if (blArray[3]) {
                    arrayList.add(iNetCircuit);
                    ++this.hoPSCount;
                    if (!blArray[2]) continue;
                    ++this.hoPDISupportedCount;
                    if (!blArray[4]) continue;
                    ++this.hoBlsrDriNodesCount;
                    continue;
                }
                ++this.noPSCount;
                continue;
            }
            if (blArray[0]) {
                if (blArray[3]) {
                    ++this.loPSCount;
                    arrayList.add(iNetCircuit);
                    if (!blArray[5]) continue;
                    ++this.loBerSupportedCount;
                    continue;
                }
                ++this.noPSCount;
                continue;
            }
            ++this.noPSCount;
        }
        this.circuits = arrayList.toArray(new INetCircuit[this.hoPSCount + this.loPSCount]);
        jPanel.add((Component)this.getStatusPanel(), "West");
        jPanel.add((Component)this.getPanel(), "Center");
        if (this.hoPSCount < 1) {
            this.disableHoUI();
        } else if (this.hoPDISupportedCount == 0) {
            this.swOnPdipCB.setEnabled(false);
        }
        if (this.loBerSupportedCount < 1 || this.loPSCount < 1) {
            this.disableLoUI();
        }
        if (this.hoPSCount < 1 && this.loPSCount < 1) {
            this.upsrRBP.setRevertiveEnabled(false);
            this.okButton.setEnabled(false);
        }
        this.displayCircuitInfo();
    }

    private JPanel getStatusPanel() {
        JPanel jPanel = AbstractPane.createHorizontalPanel("Selected Circuits:");
        this.textPane = new JTextArea();
        this.textPane.setEditable(false);
        this.textPane.setLineWrap(true);
        this.textPane.setWrapStyleWord(true);
        this.textPane.setOpaque(false);
        this.textPane.setText("Number of Selected Circuits: ");
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        jScrollPane.setPreferredSize(new Dimension(260, 120));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createUpsrPanel(String string, JComboBox jComboBox, JComboBox jComboBox2) {
        JPanel jPanel = AbstractPane.createHorizontalPanel(null);
        jPanel.setBorder(BorderFactory.createTitledBorder(string + " Circuits Only"));
        jPanel.setLayout(new GridLayout(3, 1, 2, 2));
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.add(new JLabel("SF threshold: "));
        jPanel2.add(jComboBox);
        jPanel.add(jPanel2);
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.add(new JLabel("SD threshold: "));
        jPanel2.add(jComboBox2);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel getPanel() {
        String string = tdmTerm.getRingTerms(0);
        JPanel jPanel = AbstractPane.createHorizontalPanel("Path Selectors (" + string + " protection)");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add(Box.createVerticalStrut(15), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.upsrRBP = new RevertiveBehaviorPanel(null);
        jPanel.add((Component)this.upsrRBP, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add(Box.createVerticalStrut(15), gridBagConstraints);
        this.hoSfThCB = new JComboBox<Attribute>(NetworkDefaults.getAttributeMap().getAttributeArray("declareSfBerLevel"));
        this.hoSdThCB = new JComboBox<Attribute>(NetworkDefaults.getAttributeMap().getAttributeArray("declareSdBerLevel"));
        JPanel jPanel2 = this.createUpsrPanel(tdmTerm.getGeneralTerms(0), this.hoSfThCB, this.hoSdThCB);
        JPanel jPanel3 = AbstractPane.createHorizontalPanel(null);
        String string2 = tdmTerm.getGeneralTerms(9);
        this.swOnPdipCB = new JCheckBox("Switch on " + string2, false);
        jPanel3.add(this.swOnPdipCB);
        jPanel2.add(jPanel3);
        this.loSfThCB = new JComboBox<Attribute>(NetworkDefaults.getAttributeMap().getAttributeArray("declareSfBerLevel"));
        this.loSdThCB = new JComboBox<Attribute>(NetworkDefaults.getAttributeMap().getAttributeArray("declareSdBerLevel"));
        JPanel jPanel4 = this.createUpsrPanel(tdmTerm.getGeneralTerms(1), this.loSfThCB, this.loSdThCB);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = AbstractPane.createHorizontalPanel(null);
        jPanel5.setLayout(new GridLayout(1, 2, 2, 2));
        this.okButton = new JButton("OK");
        jPanel5.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        jPanel5.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel jPanel6 = AbstractPane.createHorizontalPanel(null);
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        jPanel6.add((Component)jPanel, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        jPanel6.add(Box.createVerticalStrut(30), gridBagConstraints);
        gridBagConstraints2.weightx = 1.0;
        jPanel6.add((Component)jPanel5, gridBagConstraints2);
        this.readPrefs();
        this.upsrRBP.setRevertiveBehavior(this.upsrReversion);
        this.loSfThCB.setSelectedItem(this.upsrLoSfBerLevel);
        this.loSdThCB.setSelectedItem(this.upsrLoSdBerLevel);
        this.hoSfThCB.setSelectedItem(this.upsrHoSfBerLevel);
        this.hoSdThCB.setSelectedItem(this.upsrHoSdBerLevel);
        this.swOnPdipCB.setSelected(this.upsrSwitchOnPdip);
        return jPanel6;
    }

    private void disableHoUI() {
        this.hoSfThCB.setEnabled(false);
        this.hoSdThCB.setEnabled(false);
        this.swOnPdipCB.setEnabled(false);
    }

    private void disableLoUI() {
        this.loSfThCB.setEnabled(false);
        this.loSdThCB.setEnabled(false);
    }

    private synchronized boolean isAborted() {
        return this.bAbort;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.upsrReversion = this.upsrRBP.getRevertiveBehavior();
            this.upsrLoSfBerLevel = (Attribute)this.loSfThCB.getSelectedItem();
            this.upsrLoSdBerLevel = (Attribute)this.loSdThCB.getSelectedItem();
            this.upsrHoSfBerLevel = (Attribute)this.hoSfThCB.getSelectedItem();
            this.upsrHoSdBerLevel = (Attribute)this.hoSdThCB.getSelectedItem();
            this.upsrSwitchOnPdip = this.swOnPdipCB.isSelected();
            this.writePrefs();
            ProgressDialog.start((Component)((Object)this), "Update Path Selector Attributes", "Path selector attributes are being updated.  Please wait...", this, true);
            this.showResult();
            super.dispose();
        } else if (object == this.cancelButton) {
            super.dispose();
        }
    }

    public void executeTask(Observer observer) throws Exception {
        int n = 0;
        while (n < this.circuits.length && !this.isAborted()) {
            INetCircuit iNetCircuit = this.circuits[n++];
            ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
            boolean bl = iCircuitType.isHoCircuitType();
            List list = iNetCircuit.getCircuitNodes();
            Iterator iterator = list.iterator();
            observer.update(null, "Updating " + iNetCircuit.getCircuitName());
            while (iterator.hasNext()) {
                INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
                String string = iNetCircuitNode.getNodeModel().getName();
                if (!iNetCircuitNode.isUpsr()) continue;
                db.info(string + " is UPSR.");
                try {
                    boolean bl2 = CircuitMapUtil.connectionHasSecondSelector(iNetCircuitNode.getConn());
                    boolean bl3 = CircuitMapUtil.isBlsrDriNode(iNetCircuitNode);
                    if (db.isInfoEnabled()) {
                        db.info(string + " has second selector? " + bl2);
                        db.info(string + " is BLSR-DRI node? " + bl3);
                    }
                    iNetCircuitNode.getUpsrOps().setUpsrReversion(this.upsrReversion);
                    short s = (short)this.upsrLoSfBerLevel.getIntValue();
                    short s2 = (short)this.upsrLoSdBerLevel.getIntValue();
                    if (bl) {
                        s = (short)this.upsrHoSfBerLevel.getIntValue();
                        s2 = (short)this.upsrHoSdBerLevel.getIntValue();
                    }
                    iNetCircuitNode.getUpsrOps().setUpsrSfBerLevel(s);
                    iNetCircuitNode.getUpsrOps().setUpsrSdBerLevel(s2);
                    if (!bl3) {
                        iNetCircuitNode.getUpsrOps().setUpsrSwitchOnPdiP(this.upsrSwitchOnPdip);
                    }
                    db.fine("set UPSR attribs on " + string);
                    if (!bl2) continue;
                    iNetCircuitNode.getUpsrOps().setReverseUpsrReversion(this.upsrReversion);
                    iNetCircuitNode.getUpsrOps().setReverseUpsrSfBerLevel(s);
                    iNetCircuitNode.getUpsrOps().setReverseUpsrSdBerLevel(s2);
                    if (!bl3) {
                        iNetCircuitNode.getUpsrOps().setReverseUpsrSwitchOnPdiP(this.upsrSwitchOnPdip);
                    }
                    db.fine("set reverse UPSR attribs on " + string);
                }
                catch (Exception exception) {
                    this.logFailure(iNetCircuit.getCircuitName() + ": " + string, AnnotatedException.getString((Exception)exception));
                }
            }
            observer.update(null, new Integer(n * 100 / this.circuits.length));
        }
    }

    private void logFailure(String string, String string2) {
        this.failures.append("\n    ");
        this.failures.append(string);
        this.failures.append(": ");
        this.failures.append(string2);
    }

    private void showResult() {
        if (this.failures.length() > 0) {
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent((Component)((Object)this)), (String)"Failure Setting Circuit Attributes");
            detailedDialog.setText("The path selector updates have completed, but some changes requested were not applied.", CerentDialog.FATAL_ICON);
            this.failures.append("\nPlease edit the circuit to verify or fix this.");
            detailedDialog.append(this.failures.toString());
            detailedDialog.setSize(320, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void readPrefs() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getBoolean("ctc.circuit.creation", "revertive", false) ? 2 : 1;
        int n2 = preferences.getInt("ctc.circuit.creation", "revertTime", 300);
        if (n2 == 0) {
            n2 = 30;
        }
        this.upsrReversion = new RevertiveBehavior(n, n2);
        INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
        int n3 = 4;
        int n4 = 6;
        int n5 = 3;
        int n6 = 5;
        if (iNodeModel != null && iNodeModel.isInited()) {
            try {
                n3 = iNodeModel.getUpsrSfBerLevel(2);
                n4 = iNodeModel.getUpsrSdBerLevel(2);
                n5 = iNodeModel.getUpsrSfBerLevel(1);
                n6 = iNodeModel.getUpsrSdBerLevel(1);
            }
            catch (Exception exception) {
                db.severe("Could not get default bers:" + exception);
                n3 = 4;
                n4 = 6;
                n5 = 3;
                n6 = 5;
            }
        }
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        this.upsrHoSfBerLevel = attributeMaps.getAttributeForVal("declareSfBerLevel", n3);
        this.upsrHoSdBerLevel = attributeMaps.getAttributeForVal("declareSdBerLevel", n4);
        this.upsrLoSfBerLevel = attributeMaps.getAttributeForVal("declareSfBerLevel", n5);
        this.upsrLoSdBerLevel = attributeMaps.getAttributeForVal("declareSdBerLevel", n6);
        this.upsrSwitchOnPdip = this.isSonet(iNodeModel) ? preferences.getBoolean("ctc.circuit.creation", "pdip", false) : false;
    }

    private void writePrefs() {
        Preferences preferences = Preferences.instance();
        preferences.setBoolean("ctc.circuit.creation", "revertive", this.upsrReversion.getReversionMode() == 2);
        preferences.setInt("ctc.circuit.creation", "revertTime", this.upsrReversion.getReversionTime());
        if (this.isSonet(NetworkModel.instance().getCmsHostModel())) {
            preferences.setBoolean("ctc.circuit.creation", "pdip", this.upsrSwitchOnPdip);
        }
    }

    private boolean hasUPSR() {
        return this.hoPSCount >= 1 || this.loPSCount >= 1;
    }

    public static int[] circuitStatusesAllowPathSelectorEdit() {
        return cktStatusesAllowPathSelectorEdit;
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        return null;
    }

    public synchronized void stop() {
        this.bAbort = true;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return this.bAbort;
    }

    static {
        db = new SDebug("PathSelectorDialog");
        cktStatusesAllowPathSelectorEdit = new int[]{1, 4, 5, 6};
    }
}

