/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IRollState;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class RollColumnRenderer
extends AbstractColumnRenderer {
    public static final int ROLL_FROM_CKT = 0;
    public static final int ROLL_TO_CKT = 1;
    public static final int ROLL_STATE = 2;
    public static final int ROLL_VALID_SIGNAL = 3;
    public static final int ROLL_MODE = 4;
    public static final int ROLL_PATH = 5;
    public static final int ROLL_FROM_PATH = 6;
    public static final int ROLL_TO_PATH = 7;
    private static final int[] columns = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final String ROLL_MODE_AUTO = "Auto";
    private static final String ROLL_MODE_MANUAL = "Manual";
    private JLabel label;
    private int mode;
    private static int EBW = 2;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
    private static final SDebug db = new SDebug("RollColumnRenderer");

    public RollColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        this.label.setText("");
        NetRoll netRoll = (NetRoll)((Object)object);
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        try {
            switch (this.mode) {
                case 0: {
                    this.label.setText(netRoll.getRollFromCircuitName());
                    break;
                }
                case 1: {
                    this.label.setText(netRoll.getRollToCircuitName());
                    break;
                }
                case 2: {
                    this.label.setText(EnumStrings.getString(IRollState.class, (int)netRoll.getState()));
                    break;
                }
                case 3: {
                    this.label.setText(String.valueOf(netRoll.getRollValidSignal()));
                    break;
                }
                case 4: {
                    object2 = netRoll.getCircuitRollMode() == 1 ? ROLL_MODE_MANUAL : ROLL_MODE_AUTO;
                    this.label.setText((String)object2);
                    break;
                }
                case 5: {
                    this.label.setText(CircuitColumnRenderer.getEndpoints(netRoll.getFromCircuit(), new INetCircuitEnd[]{netRoll.getRollPathCktEnd()}));
                    break;
                }
                case 6: {
                    this.label.setText(CircuitColumnRenderer.getEndpoints(netRoll.getFromCircuit(), new INetCircuitEnd[]{netRoll.getRollFromCktEnd()}));
                    break;
                }
                case 7: {
                    this.label.setText(CircuitColumnRenderer.getEndpoints(netRoll.getFromCircuit(), new INetCircuitEnd[]{netRoll.getRollToCktEnd()}));
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.label.setText("");
        }
        object2 = this.label;
        ((Component)object2).setForeground(color);
        ((Component)object2).setBackground(color2);
        return object2;
    }

    public int compareColumn(Object object, Object object2, int n) {
        NetRoll netRoll = (NetRoll)((Object)object);
        NetRoll netRoll2 = (NetRoll)((Object)object2);
        int n2 = 0;
        switch (this.mode) {
            case 0: {
                n2 = netRoll.getRollFromCircuitName().compareTo(netRoll2.getRollFromCircuitName());
                break;
            }
            case 1: {
                n2 = netRoll.getRollToCircuitName().compareTo(netRoll2.getRollToCircuitName());
                break;
            }
            case 2: {
                n2 = EnumStrings.getString(IRollState.class, (int)netRoll.getState()).compareTo(EnumStrings.getString(IRollState.class, (int)netRoll2.getState()));
                break;
            }
            case 3: {
                n2 = netRoll.getRollValidSignal() == netRoll2.getRollValidSignal() ? 0 : (netRoll.getRollValidSignal() ? 1 : -1);
                break;
            }
            case 4: {
                n2 = netRoll.getCircuitRollMode() == netRoll2.getCircuitRollMode() ? 0 : (netRoll.getCircuitRollMode() == 1 ? -1 : 1);
                break;
            }
            case 5: {
                n2 = CircuitColumnRenderer.getEndpoints(netRoll.getFromCircuit(), new INetCircuitEnd[]{netRoll.getRollPathCktEnd()}).compareTo(CircuitColumnRenderer.getEndpoints(netRoll2.getFromCircuit(), new INetCircuitEnd[]{netRoll2.getRollPathCktEnd()}));
                break;
            }
            case 6: {
                n2 = CircuitColumnRenderer.getEndpoints(netRoll.getFromCircuit(), new INetCircuitEnd[]{netRoll.getRollFromCktEnd()}).compareTo(CircuitColumnRenderer.getEndpoints(netRoll2.getFromCircuit(), new INetCircuitEnd[]{netRoll2.getRollFromCktEnd()}));
                break;
            }
            case 7: {
                n2 = CircuitColumnRenderer.getEndpoints(netRoll.getFromCircuit(), new INetCircuitEnd[]{netRoll.getRollToCktEnd()}).compareTo(CircuitColumnRenderer.getEndpoints(netRoll2.getFromCircuit(), new INetCircuitEnd[]{netRoll2.getRollToCktEnd()}));
            }
        }
        return n2;
    }

    public static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columns.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = RollColumnRenderer.createRollColumnRenderer(columns[i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createRollColumnRenderer(int n) {
        int n2;
        String string;
        int n3 = 2;
        boolean bl = true;
        switch (n) {
            case 0: {
                string = "Roll From Circuit";
                n2 = 120;
                break;
            }
            case 1: {
                string = "Roll To Circuit";
                n2 = 120;
                break;
            }
            case 2: {
                string = "Roll State";
                n2 = 120;
                break;
            }
            case 3: {
                string = "Roll Valid Signal";
                n2 = 100;
                break;
            }
            case 4: {
                string = "Roll Mode";
                n2 = 80;
                break;
            }
            case 5: {
                string = "Roll Path";
                n2 = 120;
                break;
            }
            case 6: {
                string = "Roll From Path";
                n2 = 120;
                break;
            }
            case 7: {
                string = "Roll To Path";
                n2 = 120;
                break;
            }
            default: {
                string = "???";
                n2 = 20;
                bl = false;
                n3 = 2;
            }
        }
        return new RollColumnRenderer(n, string, n2, bl, n3);
    }
}

