/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.SDebug;
import java.util.ArrayList;

public class RoutingConstraint {
    public static final int NETLINK_ONLY = 0;
    public static final int NETELEM_ONLY = 1;
    public static final int NETELEM_TRAD_DRI = 2;
    public static final int NETELEM_NONTRAD_DRI = 3;
    public static final int ELEM_AS_PRIMARY = 0;
    public static final int ELEM_AS_SECONDARY = 1;
    public static final int ELEM_AS_EITHER = 2;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_FWD = 1;
    public static final int ARROW_REVERSE = 2;
    public static final int ARROW_OMNI = 3;
    public int arrowType = 0;
    private static final SDebug db = new SDebug("RoutingConstraint");
    int constraintType;
    String label;
    ArrayList netLinkList;
    ArrayList primaryElemList;
    ArrayList secondaryElemList;
    boolean usePca = false;
    BlsrRingModel firstRingModel = null;
    BlsrRingModel secondRingModel = null;

    public RoutingConstraint(int n) {
        this.constraintType = n;
        if (n == 0) {
            this.netLinkList = new ArrayList();
        } else {
            this.primaryElemList = new ArrayList();
            this.secondaryElemList = new ArrayList();
        }
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public boolean getUsePca() {
        return this.usePca;
    }

    public void setUsePca(boolean bl) {
        this.usePca = bl;
    }

    public boolean isLinkConstraint() {
        return this.constraintType == 0;
    }

    public boolean isElemConstraint() {
        return this.constraintType != 0;
    }

    public boolean isBlsrDriConstraint() {
        return this.constraintType == 2 || this.constraintType == 3;
    }

    public ArrayList getLinkConstraintList() {
        return this.netLinkList;
    }

    public void addLinkConstraint(Object object) {
        if (this.netLinkList != null) {
            this.netLinkList.add(object);
        } else if (db.on()) {
            db.println("can't add link to elem constraint");
        }
    }

    public void removeLinkConstraint(Object object) {
        if (this.netLinkList != null) {
            this.netLinkList.remove(object);
        } else if (db.on()) {
            db.println("can't remove link from elem constraint");
        }
    }

    public ArrayList getPriElemConstraintList() {
        return this.primaryElemList;
    }

    public ArrayList getSecElemConstraintList() {
        return this.secondaryElemList;
    }

    public void addElementConstraint(Object object) {
        this.addElementConstraint(object, null);
    }

    public void addElementConstraint(Object object, Object object2) {
        this.primaryElemList.add(object);
        if (object2 != null) {
            this.secondaryElemList.add(object2);
        }
    }

    public synchronized boolean containsNetLink(Object object) {
        if (this.netLinkList == null) {
            return false;
        }
        return this.netLinkList.contains(object);
    }

    public synchronized boolean containsNetElement(Object object, int n) {
        boolean bl = this.primaryElemList == null ? false : this.primaryElemList.contains(object);
        boolean bl2 = this.secondaryElemList == null ? false : this.secondaryElemList.contains(object);
        switch (n) {
            case 0: {
                return bl;
            }
            case 1: {
                return bl2;
            }
        }
        return bl || bl2;
    }

    public void setFirstRingModel(BlsrRingModel blsrRingModel) {
        this.firstRingModel = blsrRingModel;
    }

    public void setSecondRingModel(BlsrRingModel blsrRingModel) {
        this.secondRingModel = blsrRingModel;
    }

    protected BlsrRingModel getFirstRingModel() {
        return this.firstRingModel;
    }

    protected BlsrRingModel getSecondRingModel() {
        return this.secondRingModel;
    }

    public static String getConstraintString(int n) {
        switch (n) {
            case 0: {
                return "NetLink Only";
            }
            case 1: {
                return "NetElem Only";
            }
            case 2: {
                return "NetElem, Trad. DRI";
            }
            case 3: {
                return "NetElem, NonTrad. DRI";
            }
        }
        return "Unknown #" + n;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        return super.toString();
    }

    protected String getShortDriString(INetElement iNetElement) {
        if (this.constraintType == 0 || this.constraintType == 1) {
            return null;
        }
        int n = this.primaryElemList.indexOf(iNetElement);
        if (n > -1) {
            return "Pri #" + (n + 1);
        }
        n = this.secondaryElemList.indexOf(iNetElement);
        if (n > -1) {
            return "Sec #" + (n + 1);
        }
        return null;
    }

    public static String getBlsrDriString(RoutingConstraint routingConstraint, INetElement iNetElement) {
        if (routingConstraint == null) {
            return null;
        }
        String string = routingConstraint.getShortDriString(iNetElement);
        if (string == null) {
            return null;
        }
        return string;
    }

    public static String tryPrettyString(Object object) {
        if (object instanceof INetElement) {
            return ((INetElement)object).prettyString();
        }
        if (object instanceof INetLink) {
            return ((INetLink)object).prettyString();
        }
        return object.toString();
    }

    public static void dump(RoutingConstraint routingConstraint, SDebug sDebug) {
        int n;
        int n2 = routingConstraint.getConstraintType();
        sDebug.println("type of constraint: " + RoutingConstraint.getConstraintString(n2));
        if (n2 == 0) {
            ArrayList arrayList = routingConstraint.getLinkConstraintList();
            if (arrayList == null) {
                sDebug.println("Is NULL!");
            } else {
                for (n = 0; n < arrayList.size(); ++n) {
                    sDebug.println("#" + n + "\t" + RoutingConstraint.tryPrettyString(arrayList.get(n)));
                }
            }
        } else {
            sDebug.println("Primary:");
            ArrayList arrayList = routingConstraint.getPriElemConstraintList();
            if (arrayList == null) {
                sDebug.println("Primary List is NULL!");
            } else {
                for (n = 0; n < arrayList.size(); ++n) {
                    sDebug.println("#" + n + "\t" + RoutingConstraint.tryPrettyString(arrayList.get(n)));
                }
            }
            sDebug.println("Secondary:");
            arrayList = routingConstraint.getSecElemConstraintList();
            if (arrayList == null) {
                sDebug.println("Secondary List is NULL!");
            } else {
                for (n = 0; n < arrayList.size(); ++n) {
                    sDebug.println("#" + n + "\t" + RoutingConstraint.tryPrettyString(arrayList.get(n)));
                }
                if (arrayList.size() > 0) {
                    sDebug.println("Use PCA? " + routingConstraint.getUsePca());
                }
            }
        }
        if (routingConstraint.isBlsrDriConstraint()) {
            BlsrRingModel blsrRingModel = routingConstraint.getFirstRingModel();
            if (blsrRingModel != null) {
                sDebug.println("First Ring Model: " + blsrRingModel.getBlsrRingInfo().toString());
            } else {
                sDebug.println("No first ring model defined/UPSR");
            }
            blsrRingModel = routingConstraint.getSecondRingModel();
            if (blsrRingModel != null) {
                sDebug.println("Second Ring Model: " + blsrRingModel.getBlsrRingInfo().toString());
            } else {
                sDebug.println("No second ring model defined/UPSR");
            }
        }
    }

    public static DriNodes driNodesFromRoutingConstraint(RoutingConstraint routingConstraint) {
        Object object;
        Object object2;
        if (routingConstraint == null) {
            db.println("Routing Constraint was null.");
            return null;
        }
        int n = routingConstraint.getConstraintType();
        int n2 = 2;
        if (n == 2) {
            n2 = 1;
        } else if (n != 3) {
            if (db.on()) {
                db.println("Routing constraint invalid for conversion: " + RoutingConstraint.getConstraintString(n));
                db.println("\tO.K. if not is a non-BLSRDRI element constraint.");
            }
            return null;
        }
        DriNodes driNodes = new DriNodes(n2, routingConstraint.getUsePca());
        ArrayList arrayList = routingConstraint.getPriElemConstraintList();
        ArrayList arrayList2 = routingConstraint.getSecElemConstraintList();
        if (arrayList.size() != arrayList2.size()) {
            if (db.on()) {
                db.println("Routing constraint conversion won't work becausearray sizes are " + arrayList.size() + " and " + arrayList2.size());
            }
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (INetElement)arrayList.get(i);
            object = (INetElement)arrayList2.get(i);
            DriNodePair driNodePair = new DriNodePair((INetElement)object2, (INetElement)object);
            driNodes.addNodePair(driNodePair);
        }
        if (routingConstraint.isBlsrDriConstraint()) {
            BlsrRingModel blsrRingModel = routingConstraint.getFirstRingModel();
            object2 = blsrRingModel != null ? blsrRingModel.getBlsrRingInfo().getRingName() : "";
            blsrRingModel = routingConstraint.getSecondRingModel();
            object = blsrRingModel != null ? blsrRingModel.getBlsrRingInfo().getRingName() : "";
            driNodes.addRequiredRings((String)object2, (String)object);
            if (db.on()) {
                db.println("Added required rings to the drinodes constraint first=" + (String)object2 + ", second= " + (String)object);
            }
        }
        if (db.on()) {
            db.println("RoutingConstraint --> DriNodes was successful");
        }
        return driNodes;
    }
}

