/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.ui.circuits.AbstractSdhHoLoPane;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu4LoNum;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SdhAu4HoLoPane
extends AbstractSdhHoLoPane {
    private SDebug dbg;
    private static final int VC3_LEVEL = 0;
    private static final int TUG2_LEVEL = 1;

    public SdhAu4HoLoPane(SDebug sDebug) {
        super(sDebug);
        this.dbg = sDebug;
    }

    protected void addMoreRows() {
        this.vc4LB = new JLabel("Source VC4");
        this.vc4CB = new JComboBox();
        this.vc4CB.addActionListener(this);
        this.gridPanel.addRow(this.vc4LB, this.vc4CB);
        this.vc3LB = new JLabel("TUG3");
        this.vc3CB = new JComboBox();
        this.vc3CB.addActionListener(this);
        this.gridPanel.addRow(this.vc3LB, this.vc3CB);
        this.tug2LB = new JLabel("TUG2");
        this.tug2CB = new JComboBox();
        this.tug2CB.addActionListener(this);
        this.gridPanel.addRow(this.tug2LB, this.tug2CB);
        this.vc11_12LB = new JLabel("VC12");
        this.vc11_12CB = new JComboBox();
        this.gridPanel.addRow(this.vc11_12LB, this.vc11_12CB);
    }

    public void disablePane() {
        this.cleanupControls();
        super.disablePane();
    }

    protected void initCB() {
        boolean bl;
        boolean bl2 = false;
        if (this.circuitType.isLoCircuitType() || this.circuitType.isLoVcatCircuitType()) {
            bl2 = true;
        }
        this.setComponentsVisible(0, bl2);
        boolean bl3 = bl = this.circuitSize.getEnum() == 11;
        if (bl2) {
            this.setComponentsVisible(1, !bl);
        }
        if (bl) {
            this.vc3LB.setText("VC3");
        } else {
            this.vc3LB.setText("TUG3");
            this.vc11_12LB.setText(this.circuitSize.getEnum() == 9 ? "VC11" : "VC12");
        }
        if (bl2) {
            IHoNum iHoNum = this.vc4CB.isEnabled() && this.vc4CB.getSelectedIndex() >= 0 ? (IHoNum)this.vc4CB.getSelectedItem() : null;
            List list = this.getNetLink().getAvailableLoNumbers(iHoNum, this.circuitSize.getEnum());
            if (this.circuitType.isLoVcatCircuitType()) {
                this.filterLoNumbersForVcat(list, iHoNum);
            }
            if (this.dbg.on()) {
                this.dbg.println("SdhAu4Pane: got LO list size=" + list.size() + " for ho#" + iHoNum.prettyString());
            }
            if (!list.isEmpty()) {
                this.vc3Map = new TreeMap();
                for (ILoNum iLoNum : list) {
                    Integer n = new Integer(((SdhAu4LoNum)iLoNum).getVc3());
                    if (bl) {
                        this.vc3Map.put(n, null);
                        continue;
                    }
                    Integer n2 = new Integer(((SdhAu4LoNum)iLoNum).getTug2());
                    Integer n3 = new Integer(((SdhAu4LoNum)iLoNum).getVc11_12());
                    this.tug2Map = (SortedMap)this.vc3Map.get(n);
                    if (this.tug2Map == null) {
                        this.tug2Map = new TreeMap();
                        this.vc3Map.put(n, this.tug2Map);
                    }
                    this.vc11_12Map = (SortedMap)this.tug2Map.get(n2);
                    if (this.vc11_12Map == null) {
                        this.vc11_12Map = new TreeMap();
                        this.tug2Map.put(n2, this.vc11_12Map);
                    }
                    this.vc11_12Map.put(n3, null);
                }
                this.vc3CB.setModel(new DefaultComboBoxModel<Object>(this.vc3Map.keySet().toArray()));
                if (this.vc3Map.keySet().size() > 1) {
                    this.vc3CB.setEnabled(true);
                }
                this.vc3CB.setSelectedIndex(0);
            }
            this.addButton.setEnabled(this.vc3CB.getSelectedIndex() >= 0 && (bl || this.tug2CB.getSelectedIndex() >= 0 && this.vc11_12CB.getSelectedIndex() >= 0));
        } else {
            this.addButton.setEnabled(true);
        }
    }

    protected JComboBox getHoCB() {
        return this.vc4CB;
    }

    protected void selectHoCB(IHoNum iHoNum) {
        this.vc4CB.setSelectedItem(iHoNum);
    }

    protected void selectLoCB(ILoNum iLoNum) {
        if (iLoNum != null) {
            SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
            this.vc3CB.setSelectedItem(new Integer(sdhAu4LoNum.getVc3()));
            if (!sdhAu4LoNum.isVc3Num()) {
                this.tug2CB.setSelectedItem(new Integer(sdhAu4LoNum.getTug2()));
                this.vc11_12CB.setSelectedItem(new Integer(sdhAu4LoNum.getVc11_12()));
            }
        }
    }

    protected void cleanupControls() {
        this.vc4CB.removeActionListener(this);
        this.vc4CB.removeAllItems();
        this.vc4CB.addActionListener(this);
        this.vc3CB.removeAllItems();
        this.tug2CB.removeAllItems();
        this.vc11_12CB.removeAllItems();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getHoCB()) {
            if (this.circuitType != null && (this.circuitType.isLoCircuitType() || this.circuitType.isLoVcatCircuitType())) {
                this.initCB();
            }
        } else if (actionEvent.getSource() == this.vc3CB) {
            if (this.vc3CB.getSelectedIndex() >= 0) {
                Integer n = (Integer)this.vc3CB.getSelectedItem();
                if (this.circuitSize.getEnum() == 11) {
                    return;
                }
                this.tug2Map = (SortedMap)this.vc3Map.get(n);
                this.tug2CB.setModel(new DefaultComboBoxModel<Object>(this.tug2Map.keySet().toArray()));
                if (this.tug2Map.keySet().size() > 1) {
                    this.tug2CB.setEnabled(true);
                }
                this.tug2CB.setSelectedIndex(0);
            }
        } else if (actionEvent.getSource() == this.tug2CB) {
            if (this.tug2CB.getSelectedIndex() >= 0) {
                Integer n = (Integer)this.tug2CB.getSelectedItem();
                this.vc11_12Map = (SortedMap)this.tug2Map.get(n);
                this.vc11_12CB.setModel(new DefaultComboBoxModel<Object>(this.vc11_12Map.keySet().toArray()));
                if (this.tug2Map.keySet().size() > 1) {
                    this.vc11_12CB.setEnabled(true);
                }
                this.vc11_12CB.setSelectedIndex(0);
            }
            this.addButton.setEnabled(this.vc11_12CB.getSelectedIndex() >= 0);
        }
    }

    public void enable(INetLinkSpan iNetLinkSpan) {
        this.setEnabledControls(false);
        this.from.setEnabled(false);
        this.addButton.setEnabled(false);
        this.setNetLink(iNetLinkSpan.getLink());
        this.setUniqueItem(this.getHoCB(), iNetLinkSpan.getSrcHoNum(), true);
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iNetLinkSpan.getLoNum();
        if (sdhAu4LoNum != null) {
            this.setUniqueItem(this.vc3CB, new Integer(sdhAu4LoNum.getVc3()), true);
            if (!sdhAu4LoNum.isVc3Num()) {
                this.setUniqueItem(this.tug2CB, new Integer(sdhAu4LoNum.getTug2()), true);
                this.setUniqueItem(this.vc11_12CB, new Integer(sdhAu4LoNum.getVc11_12()), false);
            }
        }
    }

    public INetLinkSpan getNetLinkSpan() {
        NetLinkSpan netLinkSpan = null;
        if (this.getNetLink() != null) {
            IHoNum iHoNum = null;
            IHoNum iHoNum2 = null;
            SdhAu4LoNum sdhAu4LoNum = null;
            boolean bl = false;
            if (this.circuitType != null && (this.circuitType.isLoCircuitType() || this.circuitType.isLoVcatCircuitType())) {
                bl = true;
            }
            if (this.circuitType != null && bl) {
                if (this.vc3CB.getSelectedIndex() == -1 || this.vc11_12CB.getSelectedIndex() == -1 && this.circuitSize.getEnum() != 11) {
                    return null;
                }
                if (this.circuitSize != null) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    if (this.vc3CB.getSelectedIndex() >= 0) {
                        n = (Integer)this.vc3CB.getSelectedItem();
                    }
                    if (this.tug2CB.getSelectedIndex() >= 0) {
                        n2 = (Integer)this.tug2CB.getSelectedItem();
                    }
                    if (this.vc11_12CB.getSelectedIndex() >= 0) {
                        n3 = (Integer)this.vc11_12CB.getSelectedItem();
                    }
                    sdhAu4LoNum = HoLoFactory.createSdhAu4LoNum(this.circuitSize.getEnum(), n, n2, n3);
                }
            }
            if (this.getNetLink().isLOTunnel()) {
                iHoNum = this.getNetLink().getSrcHo();
                iHoNum2 = this.getNetLink().getDstHo();
            } else if (this.getNetLink().isServerTrail()) {
                ServerTrailLink serverTrailLink = (ServerTrailLink)this.getNetLink();
                iHoNum = (IHoNum)this.getHoCB().getSelectedItem();
                if (serverTrailLink.getPrefs().isLoTrail()) {
                    IHoLoNum iHoLoNum = serverTrailLink.getDstHoLo(iHoNum, (ILoNum)sdhAu4LoNum);
                    iHoNum2 = iHoLoNum.getHoNum();
                } else {
                    iHoNum2 = serverTrailLink.getDstHo(iHoNum);
                }
            } else if (this.getHoCB().getSelectedIndex() >= 0) {
                iHoNum2 = iHoNum = (IHoNum)this.getHoCB().getSelectedItem();
            }
            netLinkSpan = new NetLinkSpan(this.getNetLink(), this.cktMap.findReverseLink(this.getNetLink()), iHoNum, iHoNum2, (ILoNum)sdhAu4LoNum);
        }
        return netLinkSpan;
    }

    private void setComponentsVisible(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.vc3LB.setVisible(bl);
                this.vc3CB.setVisible(bl);
            }
            case 1: {
                this.tug2LB.setVisible(bl);
                this.tug2CB.setVisible(bl);
                this.vc11_12LB.setVisible(bl);
                this.vc11_12CB.setVisible(bl);
            }
        }
    }

    protected void clearControls() {
        this.vc4CB.removeAllItems();
        this.vc3CB.removeAllItems();
        this.tug2CB.removeAllItems();
        this.vc11_12CB.removeAllItems();
    }

    protected void setEnabledControls(boolean bl) {
        this.vc4CB.setEnabled(bl);
        this.vc3CB.setEnabled(bl);
        this.tug2CB.setEnabled(bl);
        this.vc11_12CB.setEnabled(bl);
    }
}

