/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitSize;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class SvlanCircuitColumnRenderer
extends AbstractColumnRenderer {
    public static final int NAME = 0;
    public static final int TYPE = 1;
    public static final int SVLAN_ID = 2;
    public static final int DIR = 3;
    public static final int PROT = 4;
    public static final int STATUS = 5;
    public static final int END_POINTS = 6;
    public static final int SPANS = 7;
    static final int[] columns = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private JLabel label;
    private JTextArea textArea;
    private int mode;
    private static int EBW = 2;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
    private static final SDebug db = new SDebug("SvlanCircuitColumnRenderer");

    public void setWidth(int n) {
        if (n > 1) {
            this.width = n;
        }
    }

    public SvlanCircuitColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.textArea = new JTextArea();
        this.textArea.setOpaque(true);
        this.textArea.setForeground(Color.black);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
        this.textArea.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.label;
        this.label.setText("");
        INetCircuit iNetCircuit = (INetCircuit)object;
        TDMTerminology tDMTerminology = this.getTerminology(iNetCircuit);
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (this.mode) {
            case 0: {
                this.label.setText(iNetCircuit.getCircuitName());
                break;
            }
            case 1: {
                if (tDMTerminology != null) {
                    this.label.setText(tDMTerminology.getCircuitTypeShortString(iNetCircuit.getCircuitTypeObj()));
                    break;
                }
                this.label.setText("");
                break;
            }
            case 2: {
                this.label.setText(this.getSvlanToString(iNetCircuit));
                break;
            }
            case 4: {
                if (tDMTerminology != null) {
                    this.label.setText(NetworkDefaults.circuitProtTypeToString(iNetCircuit.getProtType(), tDMTerminology));
                    break;
                }
                this.label.setText("");
                break;
            }
            case 3: {
                this.label.setText(NetworkDefaults.circuitDirectionToString(iNetCircuit.getCircuitDir()));
                break;
            }
            case 5: {
                String string = NetworkDefaults.circuitStateToString(iNetCircuit.getState()).replace("_TL1", "");
                this.label.setText(string);
                break;
            }
            case 6: {
                this.textArea.setText(this.getEndPointStr(iNetCircuit));
                jComponent = this.textArea;
                break;
            }
            case 7: {
                int n3 = iNetCircuit.getCircuitSpanNum();
                if (n3 == -1) {
                    this.label.setText("N/A");
                    break;
                }
                this.label.setText(Integer.toString(n3));
            }
        }
        ((Component)jComponent).setForeground(color);
        ((Component)jComponent).setBackground(color2);
        return jComponent;
    }

    protected TDMTerminology getTerminology(INetCircuit iNetCircuit) {
        TDMTerminology tDMTerminology = null;
        INodeModel iNodeModel = null;
        if (iNetCircuit.getPrimarySource() != null) {
            iNodeModel = iNetCircuit.getPrimarySource().getNodeModel();
        } else {
            List list = iNetCircuit.getCircuitNodes();
            if (list.size() != 0) {
                iNodeModel = ((INetCircuitNode)list.get(0)).getNodeModel();
            }
        }
        if (iNodeModel != null) {
            tDMTerminology = iNodeModel.getTDMTerminology();
        }
        return tDMTerminology;
    }

    public int compareColumn(Object object, Object object2, int n) {
        INetCircuit iNetCircuit = (INetCircuit)object;
        INetCircuit iNetCircuit2 = (INetCircuit)object2;
        int n2 = 0;
        switch (this.mode) {
            case 0: {
                n2 = iNetCircuit.getCircuitName().compareTo(iNetCircuit2.getCircuitName());
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getCircuitType(), (int)iNetCircuit2.getCircuitType());
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getProtType(), (int)iNetCircuit2.getProtType());
                break;
            }
            case 2: {
                n2 = this.getSvlanToString(iNetCircuit).compareTo(this.getSvlanToString(iNetCircuit2));
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getCircuitDir(), (int)iNetCircuit2.getCircuitDir());
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)iNetCircuit.getState(), (int)iNetCircuit2.getState());
                break;
            }
            case 6: {
                n2 = this.getEndPointStr(iNetCircuit).compareTo(this.getEndPointStr(iNetCircuit2));
            }
        }
        return n2;
    }

    private String getEndPointStr(INetCircuit iNetCircuit) {
        ArrayList<INetCircuitEnd> arrayList = new ArrayList<INetCircuitEnd>();
        List list = iNetCircuit.getSources();
        if (SvlanCircuitColumnRenderer.db.on) {
            db.println("Source: " + list.size());
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            arrayList.add((INetCircuitEnd)object.next());
        }
        object = iNetCircuit.getDrops();
        if (SvlanCircuitColumnRenderer.db.on) {
            db.println("Drops: " + object.size());
        }
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            arrayList.add((INetCircuitEnd)object2.next());
        }
        if (SvlanCircuitColumnRenderer.db.on) {
            db.println("endPoints: " + arrayList.size());
        }
        Collections.sort(arrayList, new NetCircuitEndStringComparator());
        object2 = new StringBuilder();
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (n > 0) {
                ((StringBuilder)object2).append("\n");
            }
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)iterator.next();
            ((StringBuilder)object2).append(this.getEndPointStr(iNetCircuitEnd.getNetElement(), iNetCircuitEnd, iNetCircuit.getCircuitSizeObj(), false, false));
            ++n;
        }
        return ((StringBuilder)object2).toString();
    }

    private String getEndPointStr(INetElement iNetElement, INetCircuitEnd iNetCircuitEnd, ICircuitSize iCircuitSize, boolean bl, boolean bl2) {
        String string = iNetElement != null ? iNetElement.getName() : "<unknown>";
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string);
        int n = iNetCircuitEnd.getEntityIndex();
        if (n == 0) {
            return string;
        }
        stringBuilder.append("/");
        stringBuilder.append(CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, iCircuitSize, bl, bl2));
        return stringBuilder.toString();
    }

    public static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columns.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = SvlanCircuitColumnRenderer.createCircuitColumnRenderer(columns[i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createCircuitColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Circuit Name";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Type";
                n3 = 60;
                bl = true;
                n2 = 0;
                break;
            }
            case 4: {
                string = "Protection";
                n3 = 80;
                bl = true;
                n2 = 0;
                break;
            }
            case 3: {
                string = "Dir";
                n3 = 60;
                bl = true;
                n2 = 0;
                break;
            }
            case 5: {
                string = "Status";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            case 2: {
                string = "SVLAN";
                n3 = 90;
                bl = true;
                n2 = 0;
                break;
            }
            case 6: {
                string = "End Points";
                n3 = 180;
                bl = true;
                n2 = 2;
                break;
            }
            case 7: {
                string = "# of Spans";
                n3 = 80;
                bl = true;
                n2 = 0;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = true;
                n2 = 2;
            }
        }
        return new SvlanCircuitColumnRenderer(n, string, n3, bl, n2);
    }

    private String getSvlanToString(INetCircuit iNetCircuit) {
        if (iNetCircuit.getCircuitTypeObj().isSVLANType()) {
            return Integer.toString(((SvlanCircuit)iNetCircuit).getSvlan());
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NetCircuitEndStringComparator
    implements Comparator<INetCircuitEnd> {
        NetCircuitEndStringComparator() {
        }

        @Override
        public int compare(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
            if (iNetCircuitEnd.getNodeModel().getName().equals(iNetCircuitEnd2.getNodeModel().getName())) {
                return ComparisonUtil.compare((int)iNetCircuitEnd.getEntityIndex(), (int)iNetCircuitEnd2.getEntityIndex());
            }
            return iNetCircuitEnd.getNodeModel().getName().compareTo(iNetCircuitEnd2.getNodeModel().getName());
        }
    }
}

