/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.SvlanCircuitEnd;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.IDropCreationPane;
import cerent.cms.ui.circuits.WzCcdPane;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class SvlanDropCreationPane
extends WzCcdPane
implements Observer,
IDropCreationPane {
    private CircuitDropCreationDialog parent;
    CcdEndpointsPane newDropPane;
    protected RoutePrefs routePrefs;
    private boolean isSameCktDrop = false;

    public RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    public SvlanDropCreationPane(CircuitDropCreationDialog circuitDropCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitDropCreationDialog, wzDiagDebug, string);
        this.parent = circuitDropCreationDialog;
    }

    protected void initPane() {
        this.setLayout(new BoxLayout(this, 0));
        Box box = Box.createVerticalBox();
        box.add(this.getMainPanel());
        box.add(Box.createVerticalStrut(15));
        this.add(box);
    }

    private JComponent getMainPanel() {
        this.newDropPane = new CcdEndpointsPane(this.parent, this.db, "New Drop", "Drop", false, true);
        this.newDropPane.enteringPane();
        if (this.newDropPane.getNodeCB() != null) {
            this.startObserving();
        }
        return this.newDropPane;
    }

    void startObserving() {
        if (this.newDropPane != null) {
            CcdEndpointsPane.NodeChangedObservable nodeChangedObservable = this.newDropPane.nodeChangeObservable;
            nodeChangedObservable.addObserver(this);
            if (this.db.on()) {
                this.db.println("start observing the nodeChangeObservable");
            }
        }
    }

    public void stopObserving() {
        if (this.newDropPane != null) {
            CcdEndpointsPane.NodeChangedObservable nodeChangedObservable = this.newDropPane.nodeChangeObservable;
            nodeChangedObservable.deleteObserver(this);
            if (this.db.on()) {
                this.db.println("stop observing the nodeChangeObservable");
            }
        }
    }

    public void cleanUpQinQ(short s) throws AbstractCmsNoSuchEntityException, ProvisionError, NoSuchInterface, WrongInterfaceType {
        if (this.newDropPane != null) {
            this.newDropPane.cleanUpQinQ(s);
        }
    }

    public void update(Observable observable, Object object) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        for (INetCircuitNode iNetCircuitNode : this.parent.getCircuit().getCircuitNodes()) {
            hashSet.add(iNetCircuitNode.getNodeModel());
        }
        this.isSameCktDrop = this.parent.getSourceNode() == this.newDropPane.nodeModel || hashSet.contains(this.newDropPane.nodeModel) || this.newDropPane.nodeModel == null;
        this.syncButtons();
    }

    private void syncButtons() {
        this.parent.setNextEnabled(!this.isSameCktDrop);
        this.parent.setFinishEnabled(this.isSameCktDrop);
    }

    void resetMainPanel() {
        this.newDropPane.reset();
    }

    public void validatePage() throws Exception {
        Object object2;
        this.newDropPane.validatePage();
        this.routePrefs = new RoutePrefs();
        this.routePrefs.setSvlan(((SvlanCircuit)this.parent.getCircuit()).getSvlan());
        INetElement iNetElement = this.parent.getCircuit().getSrcNetElement();
        List list = this.parent.getCircuit().getSources();
        INetCircuitEnd iNetCircuitEnd = null;
        for (Object object2 : list) {
            if (((INetCircuitEnd)object2).getNetElement().getNodeId() != iNetElement.getNodeId()) continue;
            iNetCircuitEnd = (INetCircuitEnd)object2;
            break;
        }
        this.routePrefs.setSrc(iNetElement);
        this.routePrefs.setcktSrcEntityIndex(iNetCircuitEnd.getEntityIndex());
        INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)this.newDropPane.getEndpoints().get(0);
        object2 = new SvlanCircuitEnd(this.routePrefs.getSvlan());
        ((NetCircuitEnd)object2).setNodeModel(iNetCircuitEnd2.getNodeModel());
        ((NetCircuitEnd)object2).setEntityIndex(iNetCircuitEnd2.getEntityIndex());
        this.parent.setNewCircuitEnd((INetCircuitEnd)object2);
        this.routePrefs.setDst(((NetCircuitEnd)object2).getNetElement());
        this.routePrefs.setcktDstEntityIndex(((NetCircuitEnd)object2).getEntityIndex());
        try {
            this.parent.addDestination(!this.isSameCktDrop);
            if (this.db.on) {
                this.db.println("validatePage: addDestination() succeeded");
            }
        }
        catch (Exception exception) {
            try {
                this.parent.deleteDestination();
            }
            catch (Exception exception2) {
                this.db.finer("validatePage: deleteDestination exception caught");
            }
            throw exception;
        }
    }

    public void revalidateData() {
        this.syncButtons();
        this.revalidate();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.DropCreationPane;
    }

    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Name: ", this.parent.getCircuit().getCircuitName()});
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.parent.getCircuit().getPrimarySource()};
        arrayList.add(new String[]{"From: ", CircuitColumnRenderer.getEndpoints(this.parent.getCircuit(), iNetCircuitEndArray)});
        String string = this.newDropPane.getStatusText();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, string.length());
        arrayList.add(new String[]{string2, string3});
        int n2 = this.routePrefs.getPathProt();
        String string4 = "";
        String string5 = "N/A";
        if (n2 == 0) {
            string4 = "Fully Protected";
            int n3 = this.routePrefs.getDiversityOption();
            if (n3 == 1) {
                string5 = "Node-diverse";
            } else if (n3 == 3) {
                string5 = "Link-diverse";
            }
        } else if (n2 == 2) {
            string4 = "Unprotected";
        }
        if (!string4.equals("")) {
            arrayList.add(new String[]{"Protection:", string4});
        }
        if (string4.equals("Fully Protected")) {
            arrayList.add(new String[]{"Diversity:", string5});
        }
        return SvlanDropCreationPane.getGridPanel(arrayList);
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: ");
        stringBuffer.append(this.parent.getCircuit().getCircuitName());
        stringBuffer.append("\n");
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.parent.getCircuit().getPrimarySource()};
        stringBuffer.append("\nFrom: ");
        stringBuffer.append(CircuitColumnRenderer.getEndpoints(this.parent.getCircuit(), iNetCircuitEndArray));
        stringBuffer.append(this.newDropPane.getStatusText());
        stringBuffer.append("\nRouting: ");
        int n = this.routePrefs.getPathProt();
        if (n == 0) {
            stringBuffer.append(" fully protected");
            int n2 = this.routePrefs.getDiversityOption();
            if (n2 == 1) {
                stringBuffer.append("\n  Node-diverse");
            } else if (n2 == 3) {
                stringBuffer.append("\n  Link-diverse");
            }
        } else if (n == 2) {
            stringBuffer.append(" unprotected");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void enteringPane() {
        this.startObserving();
        super.enteringPane();
    }

    protected String getNextPaneName() {
        return "SVLAN Circuit Routing Preview";
    }

    public void removeListeners() {
        this.stopObserving();
        super.removeListeners();
    }

    public void dispose() {
        this.routePrefs = null;
        super.dispose();
    }

    public String getDiagString() {
        return super.getDiagString();
    }

    public CcdEndpointsPane getDropPane() {
        return this.newDropPane;
    }

    public boolean isAutoRoute() {
        return false;
    }

    public boolean isPathProt() {
        return false;
    }

    public boolean isPca() {
        return false;
    }

    public boolean isRrbc() {
        return false;
    }

    public boolean isUrn() {
        return false;
    }

    public void setPathProt(boolean bl) {
    }

    public void setPca(boolean bl) {
    }
}

