/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;

class UpgradeOchncRowData {
    private int[] ccNums;
    private OchTrailHelper.OchccCircuitSize cktSize;
    private IEntityModel srcPort;
    private IEntityModel dstPort;
    private boolean isEnabled = true;
    private boolean isOchTrailUpgrade = false;

    public UpgradeOchncRowData(int n, OchTrailHelper.OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        this.ccNums = new int[]{n};
        this.cktSize = ochccCircuitSize;
        this.srcPort = iEntityModel;
        this.dstPort = iEntityModel2;
    }

    public UpgradeOchncRowData(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        this.ccNums = new int[]{1};
        this.cktSize = null;
        this.srcPort = iEntityModel;
        this.dstPort = iEntityModel2;
        this.isOchTrailUpgrade = true;
    }

    public UpgradeOchncRowData(int[] nArray, OchTrailHelper.OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        this.ccNums = nArray;
        this.cktSize = ochccCircuitSize;
        this.srcPort = iEntityModel;
        this.dstPort = iEntityModel2;
    }

    public int[] getCcNums() {
        return this.ccNums;
    }

    public String getCcNumsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.ccNums.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(" ").append(this.ccNums[i]);
        }
        return stringBuffer.toString();
    }

    public String getCktSizeString() {
        String string = "?";
        if (this.cktSize != null) {
            string = this.cktSize.toString();
        } else if (this.isOchTrailUpgrade) {
            string = "Equipped non-specific";
        }
        return string;
    }

    public int getCktSize() {
        return this.cktSize != null ? this.cktSize.intValue() : 0;
    }

    public String getDstString() {
        return this.dstPort != null ? this.dstPort.getNodeModel().getName() + "/" + CircuitEndCellRenderer.asSlashSeparatedString(this.dstPort, null, null, 0, true) : "";
    }

    public IEntityModel getDstPort() {
        return this.dstPort;
    }

    public String getSrcString() {
        return this.srcPort != null ? this.srcPort.getNodeModel().getName() + "/" + CircuitEndCellRenderer.asSlashSeparatedString(this.srcPort, null, null, 0, true) : "";
    }

    public IEntityModel getSrcPort() {
        return this.srcPort;
    }

    public void disable() {
        this.isEnabled = false;
    }

    public boolean isComplete() {
        return this.isEnabled && (this.isOchTrailUpgrade || this.cktSize != null) && this.srcPort != null && this.dstPort != null;
    }
}

