/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class VcgTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{"Node", "VCG Name", "VCG End", " Mode ", "Number of Members"};
    ArrayList tabData = new ArrayList();
    NetVcatCircuit vcatCircuit;
    final int COL0 = 0;
    final int COL1 = 1;
    final int COL2 = 2;
    final int COL3 = 3;
    final int COL4 = 4;

    public VcgTableModel(NetVcatCircuit netVcatCircuit) {
        this.vcatCircuit = netVcatCircuit;
        this.initModelData();
    }

    public void initModelData() {
        this.tabData.clear();
        if (this.vcatCircuit == null) {
            return;
        }
        List list = this.vcatCircuit.getAllVcatTerms();
        for (INetVcatTermination iNetVcatTermination : list) {
            VcgTableData vcgTableData = new VcgTableData(iNetVcatTermination);
            this.tabData.add(vcgTableData);
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.tabData.size();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        if (this.tabData.size() == 0) {
            return null;
        }
        Object[] objectArray = this.tabData.toArray();
        switch (n2) {
            case 0: {
                return ((VcgTableData)objectArray[n]).node;
            }
            case 1: {
                return ((VcgTableData)objectArray[n]).vcgName;
            }
            case 2: {
                return ((VcgTableData)objectArray[n]).vcgEnd;
            }
            case 3: {
                return VcgTableModel.getVcatModeString(((VcgTableData)objectArray[n]).vcgMode);
            }
            case 4: {
                return ((VcgTableData)objectArray[n]).memberCount;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    public void dispose() {
        if (this.vcatCircuit != null) {
            this.vcatCircuit = null;
        }
        this.tabData.clear();
    }

    public static String getVcatModeString(int n) {
        String string = "";
        switch (n) {
            case 2: {
                string = "LCAS";
                break;
            }
            case 0: {
                string = "NO-LCAS";
                break;
            }
            case 1: {
                string = "SW-LCAS";
            }
        }
        return string;
    }

    class VcgTableData {
        String node;
        String vcgName;
        String vcgEnd;
        Integer vcgMode;
        Integer memberCount;

        public VcgTableData(INetVcatTermination iNetVcatTermination) {
            this.node = iNetVcatTermination.getNetElement().getName();
            this.vcgName = ((NetVcatTermination)iNetVcatTermination).getVcatName();
            this.vcgEnd = CircuitEndCellRenderer.asSlashSeparatedString(((NetVcatTermination)iNetVcatTermination).getNetCktEnd());
            this.vcgMode = new Integer(iNetVcatTermination.getLcasMode());
            this.memberCount = new Integer(((NetVcatTermination)iNetVcatTermination).getConfiguredNumOfMembers(2));
        }
    }
}

