/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeCellRenderer;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPoDWDMUtility;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.LabelUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class CoordinatedMaintenanceWizard
extends WizardDialog {
    private static final SDebug db = new SDebug("CoordinatedMaintenanceWizard");
    private IPortModel portModel;
    private List portModels;
    private INodeModel nodeModel;
    private SortedSet shelfSet;
    private SortedSet slotSet;
    private SortedSet portSet;
    private ArrayList<CoordMaintRowObject> rows = new ArrayList();
    private static final String TITLE = "Coordinate(d) Maintenance Wizard";
    private static final String COM_INTRODUCTION = "CoM Introduction";
    private static final String ENTITY_SELECTION = "Select Node/Shelf/Slot/Port";
    private static final String ROUTER_RESPONSE = "Router's Response(s)";
    private static final String CRS_IN_SERVICE_STATE = "in-service";
    private static final String CRS_MAINTENANCE_STATE = "maintenance";
    private static final String FORCE_MAINTENANCE_EMBARGO = "true";
    private static final boolean MSTP_IN_SERVICE_STATE = false;
    private static final boolean MSTP_MAINTENANCE_STATE = true;
    private EntitySelectionPane esp;
    private DisplayTablePane dtp;
    private IPoDWDMUtility dwdmUtil;
    private NetCircuitManager ncm;
    private String currOp;
    private static final String[] operations = new String[]{"Start Maintenance", "End Maintenance", "Evaluate Maintenance Impact"};
    private static final String[] columnNames = new String[]{"Source Name", "Source IP", "Source Embargo Status", "Source Admin State", "Destination Name", "Destination IP", "Destination Embargo Status", "Destination Admin State"};
    public static final int SOURCE_NAME = 0;
    public static final int SOURCE_IP = 1;
    public static final int SOURCE_EMBARGO = 2;
    public static final int SOURCE_TRANSPOR_ADMIN_STATE = 3;
    public static final int DESTINATION_NAME = 4;
    public static final int DESTINATION_IP = 5;
    public static final int DESTINATION_EMBARGO = 6;
    public static final int DESTINATION_TRANSPORT_ADMIN_STATE = 7;

    public CoordinatedMaintenanceWizard(Frame frame) {
        super(frame, TITLE, true, true);
        int n = 180;
        int n2 = 300;
        this.addStatusPanel(new WizardDialog.StatusPanel("/images/CTC_dialogVignette.gif", new Dimension(n, n2)));
        this.initialize();
        this.init();
        this.setBackEnabled(false);
        int n3 = n + 450;
        int n4 = n2 + 20;
        this.setSize(new Dimension(n3, n4));
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void initialize() {
        try {
            this.dwdmUtil = IPoDWDMUtility.instance();
            this.ncm = NetCircuitManager.instance();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while instantiating.");
                KDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INITIALIZATION_ERROR);
        }
    }

    private void init() {
        this.addPage(new COMIntroductionPane(COM_INTRODUCTION));
        this.esp = new EntitySelectionPane(ENTITY_SELECTION);
        this.addPage(this.esp);
        this.dtp = new DisplayTablePane(ROUTER_RESPONSE);
        this.addPage(this.dtp);
    }

    protected void handleBack(String string) {
        if (string.equals(ENTITY_SELECTION)) {
            this.esp.dispose();
            this.esp.initiated = false;
        } else if (string.equals(ROUTER_RESPONSE)) {
            this.dtp.dispose();
        }
        super.handleBack(string);
    }

    protected void apply() throws Exception {
        try {
            if (this.currOp.equals(operations[0])) {
                if (this.rows.size() != 0) {
                    CoordMaintRowObject coordMaintRowObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (int i = 0; i < this.rows.size(); ++i) {
                        coordMaintRowObject = this.rows.get(i);
                        String string = coordMaintRowObject.getSrcEmbargo();
                        String string2 = coordMaintRowObject.getDstEmbargo();
                        if (string.equals(FORCE_MAINTENANCE_EMBARGO) || string2.equals(FORCE_MAINTENANCE_EMBARGO)) {
                            bl = true;
                            continue;
                        }
                        if (!string.equals("UNKNOWN")) {
                            if (!string2.equals("UNKNOWN")) continue;
                        }
                        bl2 = true;
                    }
                    if (bl) {
                        if (ErrorMsg.displayWarningYesNo(this, (EID)NEMC.WID_FORCE_MAINTENANCE, "Force Maintenance")) {
                            this.portModel.getInterfaceModel().setCoordinateMaintState(true);
                            CerentDialog.infoDialog((Component)this, (String)("Successfully set the Transport Admin State\nto maintenance for Node " + this.nodeModel.getName()), (String)"Transport Admin State Update");
                            bl3 = true;
                        }
                    } else if (bl2) {
                        if (ErrorMsg.displayWarningYesNo(this, (EID)NEMC.WID_PARTIAL_ROUTER_RESPONSE_COM, "Force Maintenance")) {
                            this.portModel.getInterfaceModel().setCoordinateMaintState(true);
                            CerentDialog.infoDialog((Component)this, (String)("Successfully set the Transport Admin State\nto maintenance for Node " + this.nodeModel.getName()), (String)"Transport Admin State Update");
                            bl3 = true;
                        }
                    } else {
                        this.portModel.getInterfaceModel().setCoordinateMaintState(true);
                        CerentDialog.infoDialog((Component)this, (String)("Successfully set the Transport Admin State\nto maintenance for Node " + this.nodeModel.getName()), (String)"Transport Admin State Update");
                        bl3 = true;
                    }
                    if (bl3) {
                        for (int i = 0; i < this.rows.size(); ++i) {
                            coordMaintRowObject = this.rows.get(i);
                            NetCircuit netCircuit = coordMaintRowObject.getCircuit();
                            if (!coordMaintRowObject.getSrcAdminState().equals(CRS_MAINTENANCE_STATE)) {
                                INodeModel iNodeModel = this.dwdmUtil.getSourceCRS(netCircuit);
                                this.dwdmUtil.setTransportAdminState(iNodeModel, netCircuit, this.dwdmUtil.getSourceIndex(netCircuit), CRS_MAINTENANCE_STATE);
                            }
                            if (coordMaintRowObject.getDstAdminState().equals(CRS_MAINTENANCE_STATE)) continue;
                            INodeModel iNodeModel = this.dwdmUtil.getDestCRS(netCircuit);
                            this.dwdmUtil.setTransportAdminState(iNodeModel, netCircuit, this.dwdmUtil.getDestIndex(netCircuit), CRS_MAINTENANCE_STATE);
                        }
                    }
                } else {
                    this.portModel.getInterfaceModel().setCoordinateMaintState(true);
                    CerentDialog.infoDialog((Component)this, (String)("Successfully set the Transport Admin State\nto maintenance for Node " + this.nodeModel.getName()), (String)"Transport Admin State Update");
                }
            } else if (this.currOp.equals(operations[1])) {
                boolean bl = false;
                this.portModel.getInterfaceModel().setCoordinateMaintState(false);
                CerentDialog.infoDialog((Component)this, (String)("Successfully set the Transport Admin State\nto in-service for Node " + this.nodeModel.getName()), (String)"Transport Admin State Update");
                if (this.rows.size() != 0) {
                    INodeModel iNodeModel = null;
                    for (int i = 0; i < this.rows.size(); ++i) {
                        bl = false;
                        NetCircuit netCircuit = this.rows.get(i).getCircuit();
                        List list = this.dwdmUtil.filterDuplicateNodes(netCircuit.getCircuitNodes());
                        for (int j = 0; j < list.size(); ++j) {
                            try {
                                NetCircuitNode netCircuitNode = (NetCircuitNode)list.get(j);
                                iNodeModel = netCircuitNode.getNodeModel();
                                if (!this.dwdmUtil.doesSupportSRLGAndCoMFeature(iNodeModel)) continue;
                                int[] nArray = iNodeModel.getCoordMaintList();
                                if (nArray != null) {
                                    for (int k = 0; k < nArray.length; ++k) {
                                        IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(nArray[k]);
                                        for (IConnectionModel iConnectionModel : iEntityModel.getConnectionsList()) {
                                            if (!iConnectionModel.getCircuitId().equals(netCircuit.getCircuitId())) continue;
                                            bl = true;
                                            break;
                                        }
                                        if (bl) break;
                                    }
                                }
                                if (!bl) continue;
                                break;
                            }
                            catch (Exception exception) {
                                if (!db.on()) continue;
                                db.println("Error occurred. Skipping Node: " + iNodeModel.getName());
                                KDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        if (bl) continue;
                        INodeModel iNodeModel2 = this.dwdmUtil.getSourceCRS(netCircuit);
                        this.dwdmUtil.setTransportAdminState(iNodeModel2, netCircuit, this.dwdmUtil.getSourceIndex(netCircuit), CRS_IN_SERVICE_STATE);
                        iNodeModel2 = this.dwdmUtil.getDestCRS(netCircuit);
                        this.dwdmUtil.setTransportAdminState(iNodeModel2, netCircuit, this.dwdmUtil.getDestIndex(netCircuit), CRS_IN_SERVICE_STATE);
                    }
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while setting the Maintenance state.");
                KDebug.printStackTrace((Throwable)exception);
            }
            throw new Exception(NEMC.EID_UNABLE_TO_SET_MAINTENANCE.getMessage().replace("{0}", this.nodeModel.getName()) + "\n\n" + exception.getMessage());
        }
    }

    private String getNodeIpAddr(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return "";
        }
        return InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress());
    }

    private class CoordMaintRowObject {
        private NetCircuit ckt;
        private String srcNodeName;
        private String srcNodeIp;
        private String srcEmbargo;
        private String srcAdminState;
        private String dstNodeName;
        private String dstNodeIp;
        private String dstEmbargo;
        private String dstAdminState;

        CoordMaintRowObject(NetCircuit netCircuit, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.ckt = netCircuit;
            this.srcNodeName = string;
            this.srcNodeIp = string2;
            this.srcEmbargo = string3;
            this.srcAdminState = string4;
            this.dstNodeName = string5;
            this.dstNodeIp = string6;
            this.dstEmbargo = string7;
            this.dstAdminState = string8;
        }

        public NetCircuit getCircuit() {
            return this.ckt;
        }

        public String getSrcNodeName() {
            return this.srcNodeName;
        }

        public String getSrcNodeIP() {
            return this.srcNodeIp;
        }

        public String getSrcEmbargo() {
            return this.srcEmbargo;
        }

        public String getSrcAdminState() {
            return this.srcAdminState;
        }

        public String getDstNodeName() {
            return this.dstNodeName;
        }

        public String getDstNodeIP() {
            return this.dstNodeIp;
        }

        public String getDstEmbargo() {
            return this.dstEmbargo;
        }

        public String getDstAdminState() {
            return this.dstAdminState;
        }
    }

    private class SideColumnRenderer
    extends AbstractColumnRenderer {
        public SideColumnRenderer(int n, int n2, boolean bl, int n3) {
            super(columnNames[n], n2, bl, n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CoordMaintRowObject coordMaintRowObject = (CoordMaintRowObject)object;
            object = this.getColumnContents(coordMaintRowObject, n2);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            return defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getColumnContents(CoordMaintRowObject coordMaintRowObject, int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = coordMaintRowObject.getSrcNodeName();
                    break;
                }
                case 1: {
                    string = coordMaintRowObject.getSrcNodeIP();
                    break;
                }
                case 2: {
                    string = coordMaintRowObject.getSrcEmbargo();
                    break;
                }
                case 3: {
                    string = coordMaintRowObject.getSrcAdminState();
                    break;
                }
                case 4: {
                    string = coordMaintRowObject.getDstNodeName();
                    break;
                }
                case 5: {
                    string = coordMaintRowObject.getDstNodeIP();
                    break;
                }
                case 6: {
                    string = coordMaintRowObject.getDstEmbargo();
                    break;
                }
                case 7: {
                    string = coordMaintRowObject.getDstAdminState();
                    break;
                }
            }
            return string;
        }

        public int compareColumn(Object object, Object object2, int n) {
            CoordMaintRowObject coordMaintRowObject = (CoordMaintRowObject)object;
            CoordMaintRowObject coordMaintRowObject2 = (CoordMaintRowObject)object2;
            String string = this.getColumnContents(coordMaintRowObject, n);
            String string2 = this.getColumnContents(coordMaintRowObject2, n);
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CoordMaintDataSource
    extends AbstractRowDataSource {
        private SDebug sdb = new SDebug("CoordMaintDataSource");
        private IPortModel portModel;

        public CoordMaintDataSource(IPortModel iPortModel) {
            this.portModel = iPortModel;
            this.refresh();
        }

        public void refresh() {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            NetCircuit netCircuit = null;
            if (this.sdb.on()) {
                this.sdb.println("Refreshing the data source.");
            }
            this.deleteAll();
            List list = this.portModel != null ? CoordinatedMaintenanceWizard.this.ncm.getCircuits(this.portModel.getConnectionsList()) : new LinkedList();
            List list2 = CoordinatedMaintenanceWizard.this.dwdmUtil.filterOCHTrailCircuits(list);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                try {
                    netCircuit = (NetCircuit)iterator.next();
                    INodeModel iNodeModel = CoordinatedMaintenanceWizard.this.dwdmUtil.getSourceCRS(netCircuit);
                    INodeModel iNodeModel2 = CoordinatedMaintenanceWizard.this.dwdmUtil.getDestCRS(netCircuit);
                    int n = CoordinatedMaintenanceWizard.this.dwdmUtil.getSourceIndex(netCircuit);
                    int n2 = CoordinatedMaintenanceWizard.this.dwdmUtil.getDestIndex(netCircuit);
                    string = CoordinatedMaintenanceWizard.this.dwdmUtil.getEmbargo(iNodeModel, netCircuit, n);
                    string2 = CoordinatedMaintenanceWizard.this.dwdmUtil.getEmbargo(iNodeModel2, netCircuit, n2);
                    string3 = CoordinatedMaintenanceWizard.this.dwdmUtil.getTransportAdminState(iNodeModel, netCircuit, n);
                    string4 = CoordinatedMaintenanceWizard.this.dwdmUtil.getTransportAdminState(iNodeModel2, netCircuit, n2);
                    CoordinatedMaintenanceWizard.this.rows.add(new CoordMaintRowObject(netCircuit, iNodeModel.getName(), CoordinatedMaintenanceWizard.this.getNodeIpAddr(iNodeModel), string, string3, iNodeModel2.getName(), CoordinatedMaintenanceWizard.this.getNodeIpAddr(iNodeModel2), string2, string4));
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Error occurred. Skipping Circuit: " + netCircuit.getCircuitName());
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
            this.changed();
        }

        public int getRowCount() {
            return CoordinatedMaintenanceWizard.this.rows.size();
        }

        public Object getObjectAtRow(int n) {
            try {
                return CoordinatedMaintenanceWizard.this.rows.get(n);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Collection<CoordMaintRowObject> getAllObjects() {
            return CoordinatedMaintenanceWizard.this.rows;
        }

        public void changed() {
            this.fireDataSourceChanged();
        }

        private void deleteAll() {
            CoordinatedMaintenanceWizard.this.rows.clear();
        }
    }

    private class DisplayTablePane
    extends WizardPane {
        private boolean initiaed;
        private SortableRowTableModel model;
        private CoordMaintDataSource source;

        public DisplayTablePane(String string) {
            super(string);
            this.initiaed = false;
        }

        public void enteringPage() throws Exception {
            if (!this.initiaed) {
                this.initPane();
                this.initiaed = true;
            } else {
                this.removeAll();
                this.initPane();
            }
            CoordinatedMaintenanceWizard.this.setFinishEnabled(true);
        }

        protected void initPane() {
            this.setLayout(null);
            this.source = new CoordMaintDataSource(CoordinatedMaintenanceWizard.this.portModel);
            ColumnRenderer[] columnRendererArray = this.createColumnRenderers();
            this.model = new SortableRowTableModel((RowDataSource)this.source, columnRendererArray, CoordMaintDataSource.class);
            this.table = new UTable((TableModel)((Object)this.model));
            this.model.initTable(this.table);
            this.table.setRowSelectionAllowed(false);
            this.addComponent((Container)((Object)this), (Component)new UScrollPane((Component)this.table), 5, 10, 420, 220);
        }

        private void addComponent(Container container, Component component, int n, int n2, int n3, int n4) {
            component.setBounds(n, n2, n3, n4);
            container.add(component);
        }

        private ColumnRenderer[] createColumnRenderers() {
            ColumnRenderer[] columnRendererArray = new ColumnRenderer[columnNames.length];
            for (int i = 0; i < columnRendererArray.length; ++i) {
                columnRendererArray[i] = this.createColumnRenderer(i);
            }
            return columnRendererArray;
        }

        private ColumnRenderer createColumnRenderer(int n) {
            SideColumnRenderer sideColumnRenderer = null;
            switch (n) {
                case 0: {
                    sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                    break;
                }
                case 1: {
                    sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                    break;
                }
                case 2: {
                    sideColumnRenderer = new SideColumnRenderer(n, 180, true, 2);
                    break;
                }
                case 3: {
                    sideColumnRenderer = new SideColumnRenderer(n, 180, true, 2);
                    break;
                }
                case 4: {
                    sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                    break;
                }
                case 5: {
                    sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                    break;
                }
                case 6: {
                    sideColumnRenderer = new SideColumnRenderer(n, 180, true, 2);
                    break;
                }
                case 7: {
                    sideColumnRenderer = new SideColumnRenderer(n, 180, true, 2);
                    break;
                }
            }
            return sideColumnRenderer;
        }

        public void refresh() {
        }

        public void validatePage() throws Exception {
        }

        public CSHelpID getHelpID() {
            return NetCSHelpConst.DisplayTablePane;
        }
    }

    private class EntitySelectionPane
    extends WizardPane
    implements ActionListener,
    IObserver {
        private boolean initiated;
        private UComboBox nodeCombo;
        private UComboBox shelfCombo;
        private UComboBox slotCombo;
        private UComboBox portCombo;

        public EntitySelectionPane(String string) {
            super(string);
            this.initiated = false;
        }

        public void enteringPage() throws Exception {
            if (!this.initiated) {
                this.removeAll();
                this.initPane();
                this.initiated = true;
            }
        }

        public void update(IObservable iObservable, Object object) {
            block3: {
                try {
                    if (iObservable instanceof INodeModel) {
                        this.removeAll();
                        this.initPane();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    db.println("update(): exception" + exception);
                }
            }
        }

        protected void initPane() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            CoordinatedMaintenanceWizard.this.shelfSet = new TreeSet();
            CoordinatedMaintenanceWizard.this.slotSet = new TreeSet();
            CoordinatedMaintenanceWizard.this.portSet = new TreeSet();
            this.shelfCombo = new UComboBox();
            this.slotCombo = new UComboBox();
            this.slotCombo.setRenderer((ListCellRenderer)new CombosCellRenderer(false));
            this.portCombo = new UComboBox();
            this.portCombo.setRenderer((ListCellRenderer)new CombosCellRenderer(true, false));
            if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[1])) {
                this.nodeCombo = new UComboBox(CoordinatedMaintenanceWizard.this.dwdmUtil.getNodesInMaintenance().toArray());
            } else if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[0]) || CoordinatedMaintenanceWizard.this.currOp.equals(operations[2])) {
                this.nodeCombo = new UComboBox(CoordinatedMaintenanceWizard.this.dwdmUtil.getMSTPNodes().toArray());
            }
            this.nodeCombo.setRenderer((ListCellRenderer)new NodeCellRenderer());
            jPanel.add(new JLabel("Node: "));
            jPanel2.add((Component)this.nodeCombo);
            jPanel2.add(new JPanel());
            jPanel.add(new JPanel());
            this.nodeCombo.addActionListener((ActionListener)this);
            jPanel.add(new JLabel("Shelf: "));
            jPanel2.add((Component)this.shelfCombo);
            jPanel2.add(new JPanel());
            jPanel.add(new JPanel());
            this.shelfCombo.addActionListener((ActionListener)this);
            jPanel.add(new JLabel("Slot: "));
            jPanel2.add((Component)this.slotCombo);
            jPanel2.add(new JPanel());
            jPanel.add(new JPanel());
            this.slotCombo.addActionListener((ActionListener)this);
            jPanel.add(new JLabel("Port: "));
            jPanel2.add((Component)this.portCombo);
            jPanel2.add(new JPanel());
            jPanel.add(new JPanel());
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jPanel2, "East");
            this.add(jPanel3);
            INodeModel iNodeModel = (INodeModel)this.nodeCombo.getSelectedItem();
            iNodeModel.addObserver((IObserver)this);
            this.updateShelfCombo(iNodeModel);
        }

        protected String getStatusText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nNode: ");
            stringBuffer.append(((INodeModel)this.nodeCombo.getSelectedItem()).getName());
            stringBuffer.append("\nShelf: ");
            stringBuffer.append((Integer)this.shelfCombo.getSelectedItem());
            stringBuffer.append("\nSlot: ");
            IModuleModel iModuleModel = (IModuleModel)this.slotCombo.getSelectedItem();
            stringBuffer.append(CombosCellRenderer.toString(iModuleModel));
            stringBuffer.append("\nPort: ");
            IEntityModel iEntityModel = (IEntityModel)this.portCombo.getSelectedItem();
            stringBuffer.append(CombosCellRenderer.toString(iEntityModel, true, false));
            return stringBuffer.toString();
        }

        public void refresh() {
        }

        public void validatePage() throws Exception {
            if (this.nodeCombo.getSelectedItem() == null || this.shelfCombo.getSelectedItem() == null || this.slotCombo.getSelectedItem() == null || this.portCombo.getSelectedItem() == null) {
                throw new Exception(NEMC.EID_PARTIALLY_SPECIFIED_INFO.getMessage());
            }
            CoordinatedMaintenanceWizard.this.nodeModel = (INodeModel)this.nodeCombo.getSelectedItem();
            CoordinatedMaintenanceWizard.this.portModel = this.getPortModelFromPortIndex(CoordinatedMaintenanceWizard.this.portModels, ((IEntityModel)this.portCombo.getSelectedItem()).getIndex());
        }

        public CSHelpID getHelpID() {
            return NetCSHelpConst.EntitySelectionPane;
        }

        private synchronized void updateShelfCombo(INodeModel iNodeModel) {
            this.shelfCombo.removeActionListener((ActionListener)this);
            this.shelfCombo.removeAllItems();
            CoordinatedMaintenanceWizard.this.shelfSet.clear();
            if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[0]) || CoordinatedMaintenanceWizard.this.currOp.equals(operations[2])) {
                IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                int n = -1;
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    n = iEntityModelArray[i].getShelfId();
                    List list = CoordinatedMaintenanceWizard.this.dwdmUtil.getSlotModules(iNodeModel, n);
                    if (list.size() == 0) continue;
                    for (IModuleModel iModuleModel : list) {
                        for (IPortModel iPortModel : CoordinatedMaintenanceWizard.this.dwdmUtil.getPortModels(iNodeModel, CoordinatedMaintenanceWizard.this.dwdmUtil.getBackPlane(iNodeModel.getChassisModels(), n), iModuleModel.getSlot())) {
                            if (CoordinatedMaintenanceWizard.this.dwdmUtil.isPortUnderMaintenance(iNodeModel, iPortModel)) continue;
                            CoordinatedMaintenanceWizard.this.shelfSet.add(n);
                        }
                    }
                }
            } else if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[1])) {
                CoordinatedMaintenanceWizard.this.dwdmUtil.updateAllMaintInfo(iNodeModel);
                CoordinatedMaintenanceWizard.this.shelfSet.addAll(CoordinatedMaintenanceWizard.this.dwdmUtil.getShelvesInMaintenance());
            }
            this.shelfCombo.setModel(new DefaultComboBoxModel<Object>(CoordinatedMaintenanceWizard.this.shelfSet.toArray()));
            this.updateSlotCombo(iNodeModel, (Integer)this.shelfCombo.getSelectedItem());
            this.shelfCombo.addActionListener((ActionListener)this);
        }

        private synchronized void updateSlotCombo(INodeModel iNodeModel, int n) {
            List list;
            this.slotCombo.removeActionListener((ActionListener)this);
            this.slotCombo.removeAllItems();
            CoordinatedMaintenanceWizard.this.slotSet.clear();
            if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[0]) || CoordinatedMaintenanceWizard.this.currOp.equals(operations[2])) {
                list = CoordinatedMaintenanceWizard.this.dwdmUtil.getSlotModules(iNodeModel, n);
                if (list.size() != 0) {
                    for (IModuleModel iModuleModel : list) {
                        for (IPortModel iPortModel : CoordinatedMaintenanceWizard.this.dwdmUtil.getPortModels(iNodeModel, CoordinatedMaintenanceWizard.this.dwdmUtil.getBackPlane(iNodeModel.getChassisModels(), n), iModuleModel.getSlot())) {
                            if (CoordinatedMaintenanceWizard.this.dwdmUtil.isPortUnderMaintenance(iNodeModel, iPortModel)) continue;
                            CoordinatedMaintenanceWizard.this.slotSet.add(iModuleModel);
                        }
                    }
                }
            } else if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[1])) {
                CoordinatedMaintenanceWizard.this.dwdmUtil.updateSlotMaintInfo(iNodeModel, n);
                CoordinatedMaintenanceWizard.this.slotSet.addAll(CoordinatedMaintenanceWizard.this.dwdmUtil.getSlotsInMaintenence());
            }
            this.slotCombo.setModel(new DefaultComboBoxModel<Object>(CoordinatedMaintenanceWizard.this.slotSet.toArray()));
            list = CoordinatedMaintenanceWizard.this.dwdmUtil.getBackPlane(iNodeModel.getChassisModels(), n);
            this.updatePortCombo(iNodeModel, (IEntityModel)list, ((IModuleModel)this.slotCombo.getSelectedItem()).getSlot());
            this.slotCombo.addActionListener((ActionListener)this);
        }

        public synchronized void updatePortCombo(INodeModel iNodeModel, IEntityModel iEntityModel, int n) {
            this.portCombo.removeActionListener((ActionListener)this);
            this.portCombo.removeAllItems();
            CoordinatedMaintenanceWizard.this.portSet.clear();
            if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[0]) || CoordinatedMaintenanceWizard.this.currOp.equals(operations[2])) {
                CoordinatedMaintenanceWizard.this.portModels = CoordinatedMaintenanceWizard.this.dwdmUtil.getPortModels(iNodeModel, iEntityModel, n);
                for (Object e : CoordinatedMaintenanceWizard.this.portModels) {
                    if (!(e instanceof IPortModel)) continue;
                    IPortModel iPortModel = (IPortModel)e;
                    if (CoordinatedMaintenanceWizard.this.dwdmUtil.isPortUnderMaintenance(iNodeModel, iPortModel)) continue;
                    CoordinatedMaintenanceWizard.this.portSet.add((IEntityModel)e);
                }
            } else if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[1])) {
                CoordinatedMaintenanceWizard.this.dwdmUtil.updatePortMaintInfo(iNodeModel, iEntityModel.getShelfId(), (IModuleModel)this.slotCombo.getSelectedItem());
                CoordinatedMaintenanceWizard.this.portModels = CoordinatedMaintenanceWizard.this.dwdmUtil.getPortsInMaintenance();
                CoordinatedMaintenanceWizard.this.portSet.addAll(CoordinatedMaintenanceWizard.this.portModels);
            }
            this.portCombo.setModel(new DefaultComboBoxModel<Object>(CoordinatedMaintenanceWizard.this.portSet.toArray()));
        }

        private IPortModel getPortModelFromPortIndex(List list, int n) {
            if (list == null) {
                return null;
            }
            for (Object e : list) {
                IPortModel iPortModel;
                if (!(e instanceof IPortModel) || (iPortModel = (IPortModel)e).getIndex() != n) continue;
                return iPortModel;
            }
            return null;
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.nodeCombo) {
                Object object = this.nodeCombo.getSelectedItem();
                if (object != null) {
                    INodeModel iNodeModel = (INodeModel)object;
                    iNodeModel.addObserver((IObserver)this);
                    this.updateShelfCombo(iNodeModel);
                }
            } else if (actionEvent.getSource() == this.shelfCombo) {
                Object object = this.nodeCombo.getSelectedItem();
                Object object2 = this.shelfCombo.getSelectedItem();
                if (object != null && object2 != null) {
                    this.updateSlotCombo((INodeModel)object, (Integer)object2);
                }
            } else if (actionEvent.getSource() == this.slotCombo) {
                Object object = this.nodeCombo.getSelectedItem();
                Object object3 = this.shelfCombo.getSelectedItem();
                Object object4 = this.slotCombo.getSelectedItem();
                if (object != null && object3 != null && object4 != null) {
                    INodeModel iNodeModel = (INodeModel)object;
                    IEntityModel iEntityModel = CoordinatedMaintenanceWizard.this.dwdmUtil.getBackPlane(iNodeModel.getChassisModels(), (Integer)object3);
                    this.updatePortCombo(iNodeModel, iEntityModel, ((IModuleModel)object4).getSlot());
                }
            }
        }
    }

    private class COMIntroductionPane
    extends WizardPane {
        private boolean initiaed;
        private UComboBox oprCombo;
        private JPanel typePanel;

        public COMIntroductionPane(String string) {
            super(string);
            this.initiaed = false;
            this.typePanel = new JPanel();
        }

        public void enteringPage() throws Exception {
            if (!this.initiaed) {
                this.initPane();
                this.initiaed = true;
            }
        }

        protected void initPane() {
            JLabel jLabel = new JLabel("Select Operation: ");
            this.oprCombo = new UComboBox((Object[])operations);
            String string = "\nThis wizard will identify all the routers affected by this\nmaintenance activity and display whether this maintenance is\nrecommended or not from router(s) perspective.\n\nThe operator can then decide whether to go ahead with the\nmaintenance activity or skip it.";
            String string2 = "Please select from the following options:";
            JLabel jLabel2 = new JLabel(string);
            JLabel jLabel3 = new JLabel(string2);
            jLabel2.setUI((LabelUI)new MultiLineLabelUI());
            this.add(jLabel2);
            jLabel3.setUI((LabelUI)new MultiLineLabelUI());
            this.typePanel.add(jLabel);
            this.typePanel.add((Component)this.oprCombo);
            this.add(jLabel3);
            this.add(new JPanel());
            this.add(this.typePanel);
        }

        protected String getStatusText() {
            return "Selected operation:\n" + CoordinatedMaintenanceWizard.this.currOp;
        }

        public void refresh() {
        }

        public void validatePage() throws Exception {
            CoordinatedMaintenanceWizard.this.currOp = this.oprCombo.getSelectedItem().toString();
            if (CoordinatedMaintenanceWizard.this.currOp.equals(operations[1])) {
                if (CoordinatedMaintenanceWizard.this.dwdmUtil.filterNodesInMaintenance(CoordinatedMaintenanceWizard.this.dwdmUtil.getMSTPNodes()).size() == 0) {
                    throw new Exception("Nodes that supports Coordinated Maintenance Feature\ncurrently have no port(s) under maintenance.");
                }
            } else if ((CoordinatedMaintenanceWizard.this.currOp.equals(operations[0]) || CoordinatedMaintenanceWizard.this.currOp.equals(operations[2])) && CoordinatedMaintenanceWizard.this.dwdmUtil.getMSTPNodes().size() == 0) {
                throw new Exception("None of the existing nodes supports Coordinated\nMaintenance Feature.");
            }
        }

        public CSHelpID getHelpID() {
            return NetCSHelpConst.CoMIntroductionPane;
        }
    }
}

