/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchProperty;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetMapNode;
import cerent.cms.ui.network.rpr.RprMapCard;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.TextAreaDialog;
import cerent.util.job.JobProgressDialog;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Component;
import java.awt.Frame;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AbstractMap
extends MapToolkit {
    public String CMD_SAVE_NODE_POSITION = "Save Node Position";
    public String CMD_NODE_RESET_POS = "Reset Node Position";
    protected String onWhichNode = "";
    protected String mapUnit = "node";
    private static final String POSITION_XY = "PositionXY";
    private Hashtable localCache;
    private static SDebug dbg;

    public AbstractMap(SDebug sDebug, IMapFactory iMapFactory) {
        super(sDebug, iMapFactory);
        dbg = sDebug;
        this.localCache = new Hashtable();
    }

    public String getResetNodePrompt(boolean bl) {
        String string;
        String string2 = "its";
        String string3 = "position";
        if (bl) {
            string = this.mapUnit;
        } else {
            string = PluralisationUtil.s(this.mapUnit, this.getMapNodes().length);
            string2 = PluralisationUtil.s(string2, this.getMapNodes().length);
            string3 = PluralisationUtil.s(string3, this.getMapNodes().length);
        }
        return "This operation will reset " + string + " to " + string2 + " previously saved " + string3 + ".\nIf no positions have been saved from the Network View, default positions will be used." + "\nIs it OK to continue?";
    }

    protected String getSaveNodePrompt() {
        String string = PluralisationUtil.s(this.mapUnit, this.getMapNodes().length);
        string = string + this.onWhichNode;
        return "Only " + string + " where you are a Superuser\n" + "will be allowed to save.  Is it OK to continue?";
    }

    protected synchronized void doResetNodePosition() {
        if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (String)this.getResetNodePrompt(false), (String)this.CMD_NODE_RESET_POS)) {
            return;
        }
        new GetLocThread(JOptionPane.getFrameForComponent(this.getGraphWindow())).start();
    }

    protected synchronized void doSaveNodePositions() {
        if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (String)this.getSaveNodePrompt(), (String)this.CMD_SAVE_NODE_POSITION)) {
            return;
        }
        new SaveLocThread(JOptionPane.getFrameForComponent(this.getGraphWindow())).start();
    }

    protected boolean getNodeCoordinatesFromCache(Node node) {
        if (node == null) {
            return false;
        }
        boolean bl = false;
        String string = MapPersist.buildLongitudePrefStr(node);
        String string2 = MapPersist.buildLatitudePrefStr(node);
        if (string != null && string2 != null) {
            Double d = (Double)this.localCache.get(string);
            Double d2 = (Double)this.localCache.get(string2);
            if (d != null && d2 != null) {
                node.setCoordinates(d, d2);
                bl = true;
            } else {
                bl = MapPersist.getPersistProperty(node, 101);
                if (bl) {
                    this.saveNodeCoordinatesToCache(node);
                }
            }
        }
        return bl;
    }

    protected void saveNodeCoordinatesToCache(Node node) {
        if (node == null) {
            return;
        }
        String string = MapPersist.buildLongitudePrefStr(node);
        String string2 = MapPersist.buildLatitudePrefStr(node);
        if (string != null && string2 != null) {
            this.localCache.remove(string);
            this.localCache.remove(string2);
            this.localCache.put(string, new Double(node.getCenterX()));
            this.localCache.put(string2, new Double(node.getCenterY()));
        }
    }

    class SaveLocThread
    extends Thread {
        private String message = "";
        private Frame parent;

        public SaveLocThread(Frame frame) {
            this.parent = frame;
        }

        private void initPropertyMap(INodeModel iNodeModel, String string) {
            try {
                iNodeModel.getProperty(string);
            }
            catch (NoSuchProperty noSuchProperty) {
                // empty catch block
            }
        }

        public void run() {
            MapNode[] mapNodeArray = AbstractMap.this.getMapNodes();
            int n = mapNodeArray.length;
            JobProgressDialog jobProgressDialog = new JobProgressDialog(JOptionPane.getFrameForComponent(AbstractMap.this.getGraphWindow()), "Saving Node Position", "");
            for (int i = 0; i < n; ++i) {
                block12: {
                    jobProgressDialog.setPercentCompleted((int)((float)(i + 1) / (float)n * 100.0f));
                    MapNode mapNode = mapNodeArray[i];
                    Object object = mapNode.getUserObject();
                    INodeModel iNodeModel = null;
                    IModuleModel iModuleModel = null;
                    String string = "???";
                    if (object instanceof INodeModel) {
                        iNodeModel = (INodeModel)object;
                        string = iNodeModel.getName();
                    } else {
                        if (!(object instanceof IModuleModel)) continue;
                        iModuleModel = (IModuleModel)object;
                        iNodeModel = iModuleModel.getNodeModel();
                        string = iNodeModel.getName() + ", slot " + iModuleModel.getSlot();
                    }
                    if (!AbstractPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.SUPERUSER)) {
                        this.message = this.message + string + " - not authorized\n";
                        continue;
                    }
                    try {
                        int n2 = MapPersist.toOldX((int)mapNode.getCenterX());
                        int n3 = MapPersist.toOldY((int)mapNode.getCenterY());
                        String string2 = String.valueOf(n2) + "," + String.valueOf(n3);
                        if (dbg.on) {
                            dbg.println("doSaveNodePositions: node" + string + " value=" + string2);
                        }
                        if (iModuleModel == null) {
                            this.initPropertyMap(iNodeModel, AbstractMap.POSITION_XY);
                            iNodeModel.setProperty(AbstractMap.POSITION_XY, string2);
                        } else {
                            String string3 = AbstractMap.POSITION_XY + iModuleModel.getEntityIndex();
                            this.initPropertyMap(iNodeModel, string3);
                            iNodeModel.setProperty(string3, string2);
                            MapPersist.setPersistProperty(mapNode, 101, null, null);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        this.message = this.message + string + " - save failed\n";
                        if (!dbg.on()) break block12;
                        dbg;
                        SDebug.printStackTrace((Throwable)runtimeException);
                    }
                }
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    dbg.severe("Interrupted during thread sleep.");
                }
            }
            jobProgressDialog.dispose();
            jobProgressDialog = null;
            if (this.message.length() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        new TextAreaDialog(SaveLocThread.this.parent, "Save Node Position Error", SaveLocThread.this.message, 250, 150);
                    }
                });
            }
        }
    }

    class GetLocThread
    extends Thread {
        private Frame parent;

        public GetLocThread(Frame frame) {
            this.parent = frame;
        }

        public void run() {
            MapNode[] mapNodeArray = AbstractMap.this.getMapNodes();
            int n = mapNodeArray.length;
            JobProgressDialog jobProgressDialog = new JobProgressDialog(JOptionPane.getFrameForComponent(AbstractMap.this.getGraphWindow()), "Resetting Node Position", "");
            for (int i = 0; i < n; ++i) {
                jobProgressDialog.setPercentCompleted((int)((float)(i + 1) / (float)n * 100.0f));
                if (mapNodeArray[i] instanceof NetMapNode) {
                    ((NetMapNode)mapNodeArray[i]).resetPosition();
                } else if (mapNodeArray[i] instanceof RprMapCard) {
                    ((RprMapCard)mapNodeArray[i]).resetPosition();
                }
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    dbg.severe("Interrupted during thread sleep.");
                }
            }
            jobProgressDialog.dispose();
            jobProgressDialog = null;
        }
    }
}

