/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.util.gui.row.ColumnRenderer;
import com.cisco.crs.model.CrsAlarm;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

class CrsAlarmColumnFactory {
    public static final String COL_EVTID = "EvtID";
    public static final String COL_SRCID = "Source ID";
    public static final String COL_TIMESTAMP = "TimeStamp";
    public static final String COL_CATEGORY = "Category";
    public static final String COL_GROUP = "Group";
    public static final String COL_CODE = "Code";
    public static final String COL_SEVERITY = "Severity";
    public static final String COL_ADMIN = "Admin";
    public static final String COL_ADDITIONALTEXT = "Additional Text";
    private static EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 2);

    public static ColumnRenderer getColumnByName(String string) {
        if (string == COL_EVTID) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_EVTID;
                }

                Class getColumnClass() {
                    return Integer.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return new Integer(crsAlarm.getEventId());
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    if (crsAlarm.getEventId() < crsAlarm2.getEventId()) {
                        return -1;
                    }
                    if (crsAlarm.getEventId() > crsAlarm2.getEventId()) {
                        return 1;
                    }
                    return 0;
                }

                public int getDefaultWidth() {
                    return 35;
                }
            };
        }
        if (string == COL_SRCID) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_SRCID;
                }

                Class getColumnClass() {
                    return String.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return crsAlarm.getSourceId();
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    return crsAlarm.getSourceId().compareTo(crsAlarm2.getSourceId());
                }
            };
        }
        if (string == COL_TIMESTAMP) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_TIMESTAMP;
                }

                Class getColumnClass() {
                    return Date.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return new Date(crsAlarm.getTimeStamp());
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    long l;
                    long l2 = crsAlarm.getTimeStamp();
                    if (l2 < (l = crsAlarm2.getTimeStamp())) {
                        return -1;
                    }
                    if (l2 > l) {
                        return 1;
                    }
                    return 0;
                }

                public int getDefaultWidth() {
                    return 150;
                }
            };
        }
        if (string == COL_CATEGORY) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_CATEGORY;
                }

                Class getColumnClass() {
                    return String.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return crsAlarm.getCategory();
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    return crsAlarm.getCategory().compareTo(crsAlarm2.getCategory());
                }
            };
        }
        if (string == COL_GROUP) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_GROUP;
                }

                Class getColumnClass() {
                    return String.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return crsAlarm.getGroup();
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    return crsAlarm.getGroup().compareTo(crsAlarm2.getGroup());
                }
            };
        }
        if (string == COL_CODE) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_CODE;
                }

                Class getColumnClass() {
                    return String.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return crsAlarm.getCode();
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    return crsAlarm.getCode().compareTo(crsAlarm2.getCode());
                }
            };
        }
        if (string == COL_SEVERITY) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_SEVERITY;
                }

                Class getColumnClass() {
                    return String.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return crsAlarm.getSeverity();
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    return crsAlarm.getSeverity().compareTo(crsAlarm2.getSeverity());
                }

                public int getDefaultWidth() {
                    return 64;
                }
            };
        }
        if (string == COL_ADMIN) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_ADMIN;
                }

                Class getColumnClass() {
                    return Boolean.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return new Boolean(crsAlarm.isAdmin());
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    boolean bl;
                    boolean bl2 = crsAlarm.isAdmin();
                    if (bl2 == (bl = crsAlarm2.isAdmin())) {
                        return 0;
                    }
                    return !bl2 ? -1 : 1;
                }

                public int getDefaultWidth() {
                    return 60;
                }
            };
        }
        if (string == COL_ADDITIONALTEXT) {
            return new Column(){

                public String getName() {
                    return CrsAlarmColumnFactory.COL_ADDITIONALTEXT;
                }

                Class getColumnClass() {
                    return String.class;
                }

                Object getColumnValue(CrsAlarm crsAlarm) {
                    return crsAlarm.getAdditionalText();
                }

                int cmpValue(CrsAlarm crsAlarm, CrsAlarm crsAlarm2) {
                    return crsAlarm.getAdditionalText().compareTo(crsAlarm2.getAdditionalText());
                }

                public int getDefaultWidth() {
                    return 800;
                }

                public int getTextAlignment() {
                    return 2;
                }
            };
        }
        return null;
    }

    private CrsAlarmColumnFactory() {
    }

    private static abstract class Column
    extends JLabel
    implements ColumnRenderer {
        public Column() {
            this.setOpaque(true);
            this.setFont(this.getFont().deriveFont(0));
            this.setBorder(emptyBorder);
            this.setSize(this.getDefaultWidth(), 20);
        }

        public abstract String getName();

        public int getDefaultWidth() {
            return 96;
        }

        public int getTextAlignment() {
            return 0;
        }

        public int getAlignment() {
            return 2;
        }

        abstract Class getColumnClass();

        abstract Object getColumnValue(CrsAlarm var1);

        abstract int cmpValue(CrsAlarm var1, CrsAlarm var2);

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof CrsAlarm) {
                if (object2 instanceof CrsAlarm) {
                    return this.cmpValue((CrsAlarm)object, (CrsAlarm)object2);
                }
                return -1;
            }
            return 1;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CrsAlarm crsAlarm = (CrsAlarm)object;
            if (crsAlarm.getSeverityClass() == CrsAlarm.SeverityClass.CRITICAL) {
                this.setBackground(Color.red);
                this.setForeground(Color.white);
            } else if (crsAlarm.getSeverityClass() == CrsAlarm.SeverityClass.MAJOR) {
                this.setBackground(Color.orange);
                this.setForeground(Color.black);
            } else if (crsAlarm.getSeverityClass() == CrsAlarm.SeverityClass.MINOR) {
                this.setBackground(Color.yellow);
                this.setForeground(Color.black);
            } else if (crsAlarm.getSeverityClass() == CrsAlarm.SeverityClass.INFO) {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            this.setText(this.getColumnValue(crsAlarm).toString());
            this.setHorizontalTextPosition(this.getTextAlignment());
            this.setHorizontalAlignment(this.getTextAlignment());
            return this;
        }
    }
}

