/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.NodeModel;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.helper.ViewHelper;
import cerent.cms.ui.network.CrsAlarmColumnFactory;
import cerent.util.SDebug;
import cerent.util.gui.ExportTableDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import com.cisco.crs.model.CrsAlarm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

class CrsAlarmDialog
extends UDialog
implements ActionListener {
    private JButton closeButton;
    private JButton exportButton;
    private JPanel buttonPanel;
    private static final String TITLE_PREFIX = "Alarm table for ";
    private UTable table;
    private NodeModel node;
    private SDebug db;

    public CrsAlarmDialog(NodeModel nodeModel, SDebug sDebug) {
        super(UiToolkit.instance().getApplicationFrame(), TITLE_PREFIX + nodeModel.getActualHostName(), false, (Object)nodeModel);
        this.node = nodeModel;
        this.db = sDebug;
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        NodeModel nodeModel = (NodeModel)object;
        ArrayList<ColumnRenderer> arrayList = new ArrayList<ColumnRenderer>();
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("EvtID"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Source ID"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("TimeStamp"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Category"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Group"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Code"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Severity"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Admin"));
        arrayList.add(CrsAlarmColumnFactory.getColumnByName("Additional Text"));
        SortableRowTableModel sortableRowTableModel = new SortableRowTableModel((RowDataSource)nodeModel.getNodeModel().getDelegate().getElementAlarmStore(), arrayList.toArray(new ColumnRenderer[arrayList.size()]), CrsAlarm.class);
        this.table = new UTable((TableModel)((Object)sortableRowTableModel));
        sortableRowTableModel.initTable((JTable)this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(800, 150));
        jPanel.add((Component)uScrollPane, "Center");
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.exportButton);
        jPanel.add((Component)this.buttonPanel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exportButton) {
            try {
                ExportTableDialog exportTableDialog = new ExportTableDialog(null, "Export", true);
                exportTableDialog.setLocationRelativeTo((Component)((Object)this));
                if (exportTableDialog.showDialog() == 0) {
                    ViewHelper.instance().exportTable(exportTableDialog.getExportTypeSelection(), true, null, this.node.getHostName(), "Active alarms", (JTable)this.table);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (actionEvent.getSource() == this.closeButton) {
            this.dispose();
        }
    }
}

