/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetworkMap;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class LinkClassFilterDialog
extends JDialog
implements ActionListener {
    public static final int DISPLAY_STATE = 1;
    public static final int HIDDEN_STATE = 2;
    private static final String TITLE = "Link Filter ";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 5;
    private JButton okButton;
    private JButton cancelButton;
    private CheckableList ckList;
    private boolean ok = false;
    private NetworkMap netMap;

    public LinkClassFilterDialog(NetworkMap networkMap) {
        super(JOptionPane.getFrameForComponent((Component)((Object)networkMap)), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LinkClassFilterDialog.this.dispose();
            }
        });
        this.netMap = networkMap;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getListPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.populateLB();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)networkMap));
        this.setVisible(true);
    }

    private JPanel getListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ckList = new CheckableList();
        this.ckList.setVisibleRowCount(6);
        jPanel.add((Component)new JLabel("Select to show/Unselect to hide:"), "North");
        jPanel.add((Component)new UScrollPane((Component)this.ckList), "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.persistDisplayStates();
            this.ok = true;
        }
        this.dispose();
    }

    boolean isOk() {
        return this.ok;
    }

    private void populateLB() {
        TreeMap treeMap = this.netMap.getLinkClassesWithinScope();
        String string = this.netMap.getNetworkViewScope();
        TreeMap treeMap2 = MapPersist.getLinkClassDisplayStates(string);
        this.setTitle("Link Filter (" + string + ")");
        ArrayList<CheckableItem> arrayList = new ArrayList<CheckableItem>();
        for (Map.Entry entry : treeMap.entrySet()) {
            int n;
            boolean bl = true;
            String string2 = (String)entry.getKey();
            if (treeMap2.containsKey(string2) && entry.getValue() instanceof Integer && (n = ((Integer)treeMap2.get(string2)).intValue()) != 1) {
                bl = false;
            }
            arrayList.add(new CheckableItem(string2, bl));
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    CheckableItem checkableItem = (CheckableItem)object;
                    CheckableItem checkableItem2 = (CheckableItem)object2;
                    return checkableItem.toString().compareTo(checkableItem2.toString());
                }
            });
        }
        this.ckList.setListData(arrayList.toArray(new CheckableItem[0]));
    }

    void persistDisplayStates() {
        ListModel listModel = this.ckList.getModel();
        String string = this.netMap.getNetworkViewScope();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            int n = checkableItem.isSelected() ? 1 : 2;
            MapPersist.saveLinkClassDisplayState(checkableItem.toString(), string, String.valueOf(n));
        }
    }
}

