/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.Attribute;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeDeletionHandler;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.AbstractTabbedView;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.AddNode2OnePlusOneDialog;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.circuits.CircuitCreationWizard;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.circuits.CircuitsTabbedView;
import cerent.cms.ui.circuits.SpanCircuitsDialog;
import cerent.cms.ui.network.AbstractNetworkMap;
import cerent.cms.ui.network.IVitalStatsPaneObject;
import cerent.cms.ui.network.LinkClass;
import cerent.cms.ui.network.LinkClassFilterDialog;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetDomainNode;
import cerent.cms.ui.network.NetMapFactory;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.network.NetMapNode;
import cerent.cms.ui.network.NetworkTabbedView;
import cerent.cms.ui.network.NetworkViewFilter;
import cerent.cms.ui.network.SelectionController;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.span.SpanUpgradeDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IPoDWDMUtility;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UPopupMenu;
import cerent.util.gui.UToolBar;
import com.cisco.ctc.CtcApplication;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import ilog.views.IlvGraphic;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class NetworkMap
extends AbstractNetworkMap
implements PropertyChangeListener,
Observer,
ProgressDialogControl,
ActionListener,
INodeDeletionHandler {
    private static final ImageIcon LINK_FILTER_ENABLED = new ImageIcon(NetworkMap.class.getResource("/images/icons/link_filter.gif"));
    private static final String CHANGE_MAP_DOMAIN_POLICY = "ChangeMapDomainPolicy";
    private NetworkViewFilter NVFilter;
    private Attribute currCriteria;
    private JComboBox filterCB;
    private JLabel label;
    private JButton filterLinks;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton zoomSel;
    private JButton linkBundleState;
    private SelectionController selc;
    private static SpanUpgradeDialog dlg = null;
    private static NetworkMap instance;
    private NetCircuitManager taskNcm;
    private INetElement taskNe;
    private INodeModel taskNode;
    private int numberAdded;
    private ArrayList<String> wavelengthsOfCktNotFixed;
    public static final String LINK_TOSRC_CARD = "ToSrcCard";
    public static final String LINK_TODST_CARD = "ToDstCard";
    public static final String LINK_CIRCUITS = "Circuits";
    public static final String LINK_PCA_CIRCUITS = "PCA Circuits";
    public static final String LINK_SPANUPGRADE = "Span Upgrade";
    public static final String NODE_CREATE_CIRCUIT = "Provision Circuit To";
    public static final String NODE_UPDATE_CIRCUITS = "Update Circuits With New Node";
    public static final String UPGRADE_PROTECTION = "Upgrade Protection";
    public static final String TERM_2_LINEAR = "Terminal to Linear";
    protected MapLink popupMapLink;
    protected MapNode popupMapNode;
    private HashMap nodeHash = new HashMap();
    private ViewName toDstView;
    private ViewName toSrcView;
    HashMap hashMap = new HashMap();

    public NetworkMap(NetworkViewController networkViewController) {
        super(new SDebug("NetworkMap"), 2, NetMapFactory.instance(), false, false);
        if (instance == null) {
            instance = this;
        }
    }

    private void initialize() {
        this.label = new JLabel("Network Scope: ");
        this.filterCB = new JComboBox();
        this.filterCB.addItem(new Attribute("All", 0));
        this.filterCB.addItem(new Attribute("DWDM", 1));
        this.filterCB.addItem(new Attribute("TDM", 2));
        this.filterCB.addActionListener(this);
        this.filterCB.setMaximumSize(this.filterCB.getMinimumSize());
        this.filterLinks = new JButton(LINK_FILTER_ENABLED);
        this.filterLinks.setToolTipText("Link Filter...");
        this.filterLinks.addActionListener(this);
        this.nvc.getToolBar().add((Component)this.label, UToolBar.RIGHT_USER_AREA);
        this.nvc.getToolBar().add((Component)this.filterCB, UToolBar.RIGHT_USER_AREA);
        this.nvc.getToolBar().add((Component)this.filterLinks, UToolBar.RIGHT_USER_AREA);
        this.nvc.getToolBar().add(Box.createRigidArea(new Dimension(5, 5)), UToolBar.RIGHT_USER_AREA);
        this.zoomIn = this.nvc.addToolbar(this.getZoomListener(), "/images/icons/zoom_in16.gif", "Zoom In", UToolBar.RIGHT_USER_AREA);
        this.zoomOut = this.nvc.addToolbar(this.getZoomListener(), "/images/icons/zoom_out16.gif", "Zoom Out", UToolBar.RIGHT_USER_AREA);
        this.zoomSel = this.nvc.addToolbar(this.getZoomListener(), "/images/icons/zoom_selected.gif", "Zoom Selected Area", UToolBar.RIGHT_USER_AREA);
        this.linkBundleState = this.nvc.addToolbar(this.getZoomListener(), "/images/icons/collapse_expand_links.gif", "Collapse/Expand Links...", UToolBar.RIGHT_USER_AREA);
        this.selc = new SelectionController(this, this.nvc.getVitalStatsPane());
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        String string = Preferences.instance().getProperty("ctc", "network.view.filter.node.type", "");
        if (string.equals("DWDM")) {
            this.filterCB.setSelectedIndex(1);
        } else if (string.equals("TDM")) {
            this.filterCB.setSelectedIndex(2);
        } else {
            this.filterCB.setSelectedIndex(0);
        }
    }

    public void setVisible(boolean bl) {
        if (this.dbg.on()) {
            this.dbg.println("setVisible( " + bl + " )");
        }
        this.label.setVisible(bl);
        this.filterCB.setVisible(bl);
        this.zoomIn.setVisible(bl);
        this.zoomOut.setVisible(bl);
        this.zoomSel.setVisible(bl);
        this.filterLinks.setVisible(bl);
        this.linkBundleState.setVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeMap(int n) {
        this.currCriteria = null;
        this.NVFilter = new NetworkViewFilter();
        NetworkMap networkMap = this;
        synchronized (networkMap) {
            Collection collection = this.netModel.getAllElements();
            for (INetElement iNetElement : collection) {
                iNetElement.addObserver(this);
            }
            this.initialize();
        }
    }

    protected TreeMap getLinkClassesWithinScope() {
        return LinkClass.getLinkClasses(this.getNetworkViewScope(), NetworkModel.instance().getCmsHostModel().getTDMTerminology());
    }

    private void setLinkFilters() {
        TreeMap treeMap = this.getLinkClassesWithinScope();
        TreeMap treeMap2 = MapPersist.getLinkClassDisplayStates(this.getNetworkViewScope());
        for (Map.Entry entry : treeMap.entrySet()) {
            String string = (String)entry.getKey();
            if (treeMap2.containsKey(string)) {
                int n;
                if (!(entry.getValue() instanceof Integer) || (n = ((Integer)treeMap2.get(string)).intValue()) != 1) continue;
                this.NVFilter.addMatcher(this.NVFilter.createLinkClassMatcher(string));
                continue;
            }
            this.NVFilter.addMatcher(this.NVFilter.createLinkClassMatcher(string));
        }
    }

    private synchronized void setFilterCriteria(Attribute attribute) {
        this.setFilterCriteria(attribute, false);
    }

    private synchronized void setFilterCriteria(Attribute attribute, boolean bl) {
        if (this.currCriteria != attribute || bl) {
            Object object;
            Object object22;
            if (!this.isRootGraph()) {
                this.doGoToRootGraph();
            }
            if (this.currCriteria != null) {
                try {
                    this.reInitMap();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currCriteria = attribute;
            this.nvc.getVitalStatsPane().setText("");
            this.NVFilter.removeAllMatchers();
            if (this.currCriteria.getKey().equals("DWDM")) {
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(2));
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(1));
            } else if (this.currCriteria.getKey().equals("TDM")) {
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(3));
                this.NVFilter.addMatcher(this.NVFilter.createNodeTypeMatcher(1));
            }
            this.setLinkFilters();
            Collection collection = this.netModel.getAllElements();
            for (Object object22 : collection) {
                if (!this.NVFilter.doesMatch(object22.getNodeModel())) continue;
                this.addNode(object22.getNodeModel(), true, null);
            }
            object22 = this.netModel.getNetLinks();
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                object = (INetLink)iterator.next();
                if (this.isLinkAcceptable((INetLink)object) && this.NVFilter.doesMatch((INetLink)object)) {
                    this.addLink((INetLink)object, null);
                    continue;
                }
                object.deleteObserver((Observer)this);
            }
            this.updateView();
            Preferences.instance().setProperty("ctc", "network.view.filter.node.type", this.currCriteria.getKey());
            object = (NetworkTabbedView)this.nvc.getTabbedView();
            if (((AbstractTabbedView)((Object)object)).getCurrentPane() instanceof CircuitsTabbedView) {
                CircuitsPane circuitsPane = ((CircuitsTabbedView)((AbstractTabbedView)((Object)object)).getCurrentPane()).getCircuitsPane();
                circuitsPane.setNetworkViewLayerFilter(this.currCriteria.getIntValue());
            }
        }
    }

    protected boolean isLinkAcceptable(INetLink iNetLink) {
        if (iNetLink.isPca() && iNetLink.getLinkType() == 9) {
            return true;
        }
        return super.isLinkAcceptable(iNetLink);
    }

    String getNetworkViewScope() {
        Attribute attribute = (Attribute)this.filterCB.getSelectedItem();
        return attribute.getKey();
    }

    public void dispose() {
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.zoomIn != null) {
            this.zoomIn.removeActionListener(this.getZoomListener());
            this.zoomOut.removeActionListener(this.getZoomListener());
            this.zoomSel.removeActionListener(this.getZoomListener());
            this.linkBundleState.removeActionListener(this.getZoomListener());
        }
        this.zoomOut = null;
        this.zoomIn = null;
        this.selc = null;
        super.dispose();
    }

    public ViewName getSelectedView() {
        return this.selc == null ? null : this.selc.getSelectedView();
    }

    private INodeModel getSelectedNodeModel() throws Exception {
        Node node = this.selc.getSelectedNode();
        if (node != null && node instanceof MapNode) {
            MapNode mapNode = (MapNode)node;
            return (INodeModel)mapNode.getUserObject();
        }
        return null;
    }

    private INetElement getNetElement(INodeModel iNodeModel) {
        INetElement iNetElement = null;
        if (iNodeModel != null) {
            if (iNodeModel.getNodeId() != 0 && (iNetElement = Network.instance().getNetElem(iNodeModel.getNodeId())) != null) {
                return iNetElement;
            }
            for (INetElement iNetElement2 : Network.instance().getElements()) {
                if (iNetElement2.getNodeModel() != iNodeModel) continue;
                iNetElement = iNetElement2;
                break;
            }
        }
        return iNetElement;
    }

    private void deleteNetElement(INetElement iNetElement) {
        String string = null;
        if (iNetElement != null) {
            if (iNetElement.getNodeModel() != NetworkModel.instance().getCmsHostModel()) {
                VirtualLinksDirector.instance().deleteNode(iNetElement.getNodeModel());
                NetworkModel.instance().deleteNetElement(iNetElement, this);
            } else {
                string = "You cannot delete the login node";
            }
        } else {
            string = "No node selected for deletion.";
        }
        if (string != null) {
            ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (EID)NEMC.EID_NODE_DELETION_ERROR_PARAM_1, (Object)string);
        }
    }

    public void deleteSelectedNetElement() {
        this.deleteSelectedNetElement(null);
    }

    public void deleteSelectedNetElement(INodeModel iNodeModel) {
        try {
            if (iNodeModel == null) {
                iNodeModel = this.getSelectedNodeModel();
            }
            this.deleteNetElement(this.getNetElement(iNodeModel));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void handleResult(int n, Exception exception, INetElement iNetElement) {
        if (exception != null) {
            ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (EID)NEMC.EID_NODE_DELETION_ERROR_PARAM_1, (Object)"You cannot delete nodes with DCC/GCC/PPC/Server Trail terminations.");
        } else if (n != 0) {
            NetworkAlarmStore.instance().flushAlarmStore(n);
            this.nvc.pruneHistory(n);
        }
    }

    private void showLinkCircuits(MapLink mapLink) {
        if (mapLink instanceof NetMapLink) {
            SpanCircuitsDialog spanCircuitsDialog = SpanCircuitsDialog.instance(this.getGraphWindow(), (INetLink)mapLink.getUserObject(), ((NetMapLink)mapLink).getLinkDesc());
            spanCircuitsDialog.show();
        }
    }

    private void showPcaCircuits(INetLink iNetLink, String string) {
        if (iNetLink == null) {
            ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (EID)NEMC.EID_NO_PCA_CIRCUITS_FOUND);
        } else {
            SpanCircuitsDialog spanCircuitsDialog = SpanCircuitsDialog.instance(this.getGraphWindow(), iNetLink, string);
            spanCircuitsDialog.show();
        }
    }

    private void addNode2OnePlusOne(MapLink mapLink) {
        AddNode2OnePlusOneDialog addNode2OnePlusOneDialog = AddNode2OnePlusOneDialog.instance(this.getGraphWindow(), this, (INetLink)mapLink.getUserObject(), "Upgrade Protection: Terminal to Linear");
        addNode2OnePlusOneDialog.show();
    }

    private void updateNetCircuits(INodeModel iNodeModel) {
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        try {
            INetElement iNetElement = this.netModel.findNetElem(iNodeModel.getNodeId());
            this.detectOhCircuit(iNetElement);
            this.taskNe = iNetElement;
            this.taskNcm = netCircuitManager;
            this.taskNode = iNodeModel;
            ProgressDialog.start(JOptionPane.getFrameForComponent(this.getGraphWindow()), "Circuits Update", "Circuits are being updated. Please wait...", this, false);
        }
        catch (NullPointerException nullPointerException) {
            SDebug.printStackTrace((Throwable)nullPointerException);
        }
    }

    public void warnOhCircuit(List list, Component component) {
        for (Object e : list) {
            if (!(e instanceof IOhXconModel) && (!(e instanceof IOhTermModel) || ((IOhTermModel)e).getChannelType() == 0 || ((IOhTermModel)e).getChannelType() == 4)) continue;
            ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (EID)NEMC.EID_OH_CKT_CANT_BE_UPGRADED);
            return;
        }
    }

    private void detectOhCircuit(INetElement iNetElement) {
        LinkedList linkedList = (LinkedList)Network.instance().findAllNetLinksWithSource(iNetElement);
        if (linkedList != null) {
            for (INetLink iNetLink : linkedList) {
                LinkModel linkModel = (LinkModel)iNetLink.getLinkModel();
                IEntityModel iEntityModel = linkModel.getEndEntityModel(false);
                if (!(iEntityModel instanceof ITdmPortModel) || !linkModel.dst().provides(Feature.ADDNODE2OPO)) continue;
                List list = ((ITdmPortModel)iEntityModel).getITdmLineModel().getOhConnectionsList();
                this.warnOhCircuit(list, this.getGraphWindow());
            }
        }
    }

    private void provisionCircuit(MapNode mapNode, MapNode mapNode2) {
        CircuitCreationWizard circuitCreationWizard = new CircuitCreationWizard(JOptionPane.getFrameForComponent(this.getGraphWindow()), false, NetworkModel.instance());
        circuitCreationWizard.setSourceNode((INodeModel)mapNode.getUserObject());
        circuitCreationWizard.setDestNode((INodeModel)mapNode2.getUserObject());
        if (this.dbg.on()) {
            this.dbg.println("new circuit from:" + mapNode.getName() + " to:" + mapNode2.getName());
        }
        circuitCreationWizard.show();
    }

    public void executeTask(Observer observer) throws Exception {
        this.numberAdded = this.taskNcm.addNodeToNetwork(this.taskNe, observer);
        this.wavelengthsOfCktNotFixed = this.taskNcm.getWavelengthsOfCktNotFixed();
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        ProgressDialogResult progressDialogResult = null;
        if (exception == null) {
            if (this.wavelengthsOfCktNotFixed.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.wavelengthsOfCktNotFixed.size(); ++i) {
                    stringBuffer.append(this.wavelengthsOfCktNotFixed.get(i)).append("\n");
                }
                String[] stringArray = new String[]{this.numberAdded + "", this.taskNode.getName(), stringBuffer.toString()};
                progressDialogResult = new ProgressDialogResult(1, NEMC.EID_COULD_NOT_UPDATE_WITH_NODE_ALL_CIRCUITS, stringArray);
            } else {
                progressDialogResult = new ProgressDialogResult("Added " + this.numberAdded + " network circuits to " + this.taskNode.getName());
            }
        } else {
            SDebug.printStackTrace((Throwable)exception);
            String[] stringArray = new String[]{exception.toString()};
            progressDialogResult = new ProgressDialogResult(2, NEMC.EID_ERROR_ADDING_NET_CKTS_PARAM_1, stringArray);
        }
        return progressDialogResult;
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("map.file") || string.equals("map.usedefault") || string.equals("network.defaultmapselected") || string.equals("network.defaultmapfile")) {
            MapPersist.loadMapImage(this.getRootGraph());
            this.updateView();
        }
        if (string.equals("map.longitude.left") || string.equals("map.longitude.right") || string.equals("map.latitude.top") || string.equals("map.latitude.bottom")) {
            MapPersist.getMapCoordinates(this);
        }
        if (string.equals(CHANGE_MAP_DOMAIN_POLICY)) {
            this.changeMapDomainPolicy();
        }
    }

    private void changeMapDomainPolicy() {
        MapNode[] mapNodeArray = this.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            String string;
            String string2;
            MapNode mapNode = mapNodeArray[i];
            Object object = mapNode.getUserObject();
            if (!(object instanceof INodeModel) || (string2 = mapNode.getDomainName()).equals(string = MapPersist.getNodeDomain((INodeModel)object))) continue;
            if (!string.equals("") && !this.containsDomain(string)) {
                this.createDomain(string, 0.0, 0.0, null);
            }
            this.moveNode(mapNode, string);
            this.removeEmptyDomain(string2);
        }
        this.updateView();
    }

    protected void nodeSelected(MapNode mapNode, boolean bl) {
        this.isSelected(mapNode, bl);
        this.updateToolbar();
    }

    protected void nodeSelected(MapDomain mapDomain, boolean bl) {
        this.isSelected(mapDomain, bl);
        this.updateToolbar();
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        this.isSelected(mapLink, bl);
    }

    public void linkSelected(MapLinkBundle mapLinkBundle, boolean bl) {
        this.isSelected(mapLinkBundle, bl);
    }

    private void isSelected(Object object, boolean bl) {
        if (this.selc != null && object instanceof IVitalStatsPaneObject) {
            this.selc.isSelected((IVitalStatsPaneObject)object, bl);
        }
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable instanceof Network.NetElementCreationNotifier) {
            INodeModel iNodeModel = ((INetElement)object).getNodeModel();
            ((INetElement)object).addObserver(this);
            if (this.NVFilter.doesMatch(iNodeModel)) {
                this.addNode(iNodeModel, true, null);
            }
        } else if (observable instanceof Network.NetLinkCreationNotifier) {
            INetLink iNetLink = (INetLink)object;
            if (this.isLinkAcceptable(iNetLink) && this.NVFilter.doesMatch(iNetLink)) {
                this.addLink(iNetLink, null);
            }
        } else if (observable instanceof INetElement) {
            INetElement iNetElement = (INetElement)((Object)observable);
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (object == ModelUpdateType.CHANGED) {
                if (this.NVFilter.doesMatch(iNodeModel)) {
                    this.addNode(iNodeModel, true, null);
                    List list = Network.instance().findAllNetLinksWithNetElem(iNetElement);
                    if (list != null && list.size() > 0) {
                        for (INetLink iNetLink : list) {
                            if (!this.isLinkAcceptable(iNetLink) || !this.NVFilter.doesMatch(iNetLink)) continue;
                            this.addLink(iNetLink, null);
                        }
                    }
                } else if (this.getMapNode(iNodeModel) != null) {
                    List list = Network.instance().findAllNetLinksWithNetElem(iNetElement);
                    if (list != null && list.size() > 0) {
                        for (INetLink iNetLink : list) {
                            if (!this.isLinkAcceptable(iNetLink) || !this.NVFilter.doesMatch(iNetLink)) continue;
                            this.deleteLink(iNetLink);
                        }
                    }
                    this.deleteNode(iNodeModel);
                    this.updateView();
                }
                super.update(observable, object);
            } else if (object == ModelUpdateType.DELETED) {
                iNetElement.deleteObserver(this);
                this.deleteNode(iNetElement.getNodeModel());
                this.updateView();
            }
        } else {
            super.update(observable, object);
        }
    }

    public void initPopupMenu(Object object, ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        if (object instanceof MapLink) {
            this.popupMapLink = (MapLink)object;
            uPopupMenu.clear();
            this.doInitLinkPopup(this.popupMapLink, actionOrganizer, (JComponent)uPopupMenu);
            uPopupMenu.addSeparator();
            actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, this.popupMapLink.CMD_COLLAPSE_SIMILAR_LINKS, 76);
            boolean bl = ((NodeModel)this.popupMapLink.getSrc().getUserObject()).provides(Feature.RAMAN_DAY0_WIZARD);
            if ((this.popupMapLink.getUserObject() instanceof VirtualNetLink || this.popupMapLink.getUserObject() instanceof DwdmNetLink) && (bl &= ((NodeModel)this.popupMapLink.getDst().getUserObject()).provides(Feature.RAMAN_DAY0_WIZARD))) {
                uPopupMenu.addSeparator();
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, "Raman Installation Day0", 82);
            }
            return;
        }
        if (object instanceof MapLinkBundle) {
            MapLinkBundle mapLinkBundle = (MapLinkBundle)object;
            uPopupMenu.clear();
            this.initCascadingPopup((MapLinkBundle)object, uPopupMenu);
            if (!mapLinkBundle.isDomainLink()) {
                uPopupMenu.addSeparator();
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, mapLinkBundle.CMD_EXPAND_SIMILAR_LINKS, 69);
            }
            return;
        }
        super.initPopupMenu(object, actionOrganizer, uPopupMenu);
        if (object instanceof MapNode) {
            this.popupMapNode = (MapNode)object;
            this.doInitNodePopup(actionOrganizer, uPopupMenu);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.filterCB) {
            Attribute attribute = (Attribute)this.filterCB.getSelectedItem();
            this.setFilterCriteria(attribute);
        } else if (actionEvent.getSource() == this.filterLinks) {
            LinkClassFilterDialog linkClassFilterDialog = new LinkClassFilterDialog(this);
            if (linkClassFilterDialog.isOk()) {
                this.setFilterCriteria((Attribute)this.filterCB.getSelectedItem(), true);
            }
        } else if (string == NODE_CREATE_CIRCUIT) {
            if (!CtcApplication.instance().checkCktMgtMode()) {
                return;
            }
            MapNode mapNode = this.popupMapNode;
            MapNode mapNode2 = (MapNode)this.nodeHash.get(actionEvent.getSource());
            this.provisionCircuit(mapNode, mapNode2);
        } else if (string == "Raman Installation Day0 Multi-Span") {
            MapNode mapNode = this.popupMapNode;
            this.ramanDayZero((IlvGraphic)mapNode, mapNode);
        } else if (string == NODE_UPDATE_CIRCUITS) {
            String string2 = "The NE should be a newly created node to the network. \nIf it existed in the network earlier, unexpected \nresults may occur by updating the circuits with this \nnode and the error may not be reversible.\nAre you sure you wish to do this?";
            String string3 = "Update Circuits";
            if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (String)string2, (String)string3)) {
                return;
            }
            if (!CtcApplication.instance().checkCktMgtMode()) {
                this.dbg.println("checkCktMgtMode failed!");
                return;
            }
            this.updateNetCircuits((INodeModel)this.popupMapNode.getUserObject());
        } else if (string == LINK_CIRCUITS) {
            if (!CtcApplication.instance().checkCktMgtMode()) {
                return;
            }
            this.showLinkCircuits(this.popupMapLink);
        } else if (string == LINK_PCA_CIRCUITS) {
            if (!CtcApplication.instance().checkCktMgtMode()) {
                return;
            }
            INetLink iNetLink = this.findPcaLink(this.popupMapLink);
            if (iNetLink != null) {
                this.showPcaCircuits(iNetLink, MapLinkRenderer.getLinkLabel(iNetLink));
            }
        } else if (string == LINK_SPANUPGRADE) {
            this.startSpanUpgrade(this.popupMapLink);
        } else if (string == LINK_TOSRC_CARD) {
            if (this.toSrcView != null) {
                this.tryJumpView(this.toSrcView);
            }
        } else if (string == LINK_TODST_CARD) {
            if (this.toDstView != null) {
                this.tryJumpView(this.toDstView);
            }
        } else if (string == TERM_2_LINEAR) {
            this.addNode2OnePlusOne(this.popupMapLink);
        } else if (string == "Raman Installation Day0") {
            this.ramanDayZero((IlvGraphic)this.popupMapLink, null);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void doInitNodePopup(ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        uPopupMenu.addSeparator();
        if (this.isProvisioningAllowed()) {
            JMenu jMenu = new JMenu(NODE_CREATE_CIRCUIT);
            uPopupMenu.add((JMenuItem)jMenu);
            this.populateCreateMenu(uPopupMenu, jMenu, this.popupMapNode, this.nodeHash);
        }
        actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, NODE_UPDATE_CIRCUITS, 85);
        if (this.isProvisioningAllowed() && ((NodeModel)this.popupMapNode.getUserObject()).provides(Feature.RAMAN_DAY0_WIZARD)) {
            uPopupMenu.addSeparator();
            actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, "Raman Installation Day0 Multi-Span", 82);
        }
    }

    private void populateCreateMenu(UPopupMenu uPopupMenu, JMenu jMenu, MapNode mapNode, HashMap hashMap) {
        MapNode mapNode2 = this.popupMapNode;
        jMenu.setEnabled(true);
        jMenu.removeAll();
        hashMap.clear();
        TreeMap treeMap = this.getTreeMap();
        String string = mapNode.getDomainName();
        this.addMenuItemList(jMenu, (TreeMap)treeMap.get(string), mapNode2, hashMap);
        jMenu.addSeparator();
        treeMap.remove(string);
        TreeMap treeMap2 = (TreeMap)treeMap.get("");
        if (treeMap2 != null) {
            JMenu jMenu2 = new JMenu("Root Domain");
            this.addMenuItemList(jMenu2, treeMap2, mapNode2, hashMap);
            treeMap.remove("");
            jMenu.add(jMenu2);
        }
        for (String string2 : treeMap.keySet()) {
            JMenu jMenu3 = new JMenu(string2);
            this.addMenuItemList(jMenu3, (TreeMap)treeMap.get(string2), mapNode2, hashMap);
            jMenu.add(jMenu3);
        }
    }

    private TreeMap getTreeMap() {
        TreeMap<String, TreeMap<String, MapNode>> treeMap = new TreeMap<String, TreeMap<String, MapNode>>();
        MapNode[] mapNodeArray = this.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            if (!this.nodeIsForwardable(mapNodeArray[i])) continue;
            String string = mapNodeArray[i].getDomainName();
            TreeMap<String, MapNode> treeMap2 = (TreeMap<String, MapNode>)treeMap.get(string);
            if (treeMap2 == null) {
                treeMap2 = new TreeMap<String, MapNode>();
                treeMap.put(string, treeMap2);
            }
            treeMap2.put(mapNodeArray[i].getName(), mapNodeArray[i]);
        }
        return treeMap;
    }

    private void addMenuItemList(JMenu jMenu, TreeMap treeMap, MapNode mapNode, HashMap hashMap) {
        for (String string : treeMap.keySet()) {
            NetMapNode netMapNode;
            MapNode mapNode2 = (MapNode)treeMap.get(string);
            if (mapNode2.isSameNodeAs(mapNode)) {
                string = string + " (self)";
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            hashMap.put(jMenuItem, mapNode2);
            jMenuItem.setActionCommand(jMenu.getText());
            jMenuItem.addActionListener(this);
            if (mapNode2 instanceof NetMapNode && ((netMapNode = (NetMapNode)mapNode2).getState() == 4 || netMapNode.getState() == 5)) {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(jMenuItem);
        }
    }

    protected void doInitLinkPopup(MapLink mapLink, ActionOrganizer actionOrganizer, JComponent jComponent) {
        Object object;
        if (!(jComponent instanceof JMenu) && !(jComponent instanceof UPopupMenu)) {
            return;
        }
        if (mapLink instanceof NetMapLink && jComponent instanceof UPopupMenu) {
            object = "Link: " + ((NetMapLink)this.popupMapLink).getMenuHeaderText();
            actionOrganizer.addMenuItem(jComponent, null, (String)object, 42);
            ((UPopupMenu)jComponent).addSeparator();
            if (this.popupMapLink.getUserObject() instanceof DwdmNetLink || this.popupMapLink.getUserObject() instanceof VirtualNetLink) {
                try {
                    INetLink iNetLink = (INetLink)this.popupMapLink.getUserObject();
                    INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                    INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
                    IPoDWDMUtility iPoDWDMUtility = IPoDWDMUtility.instance();
                    if (iPoDWDMUtility.doesSupportSRLGAndCoMFeature(iNodeModel) && iPoDWDMUtility.doesSupportSRLGAndCoMFeature(iNodeModel2)) {
                        String string = "SRLG: " + ((NetMapLink)this.popupMapLink).getLinkSRLG();
                        actionOrganizer.addMenuItem(jComponent, null, string, 71);
                        ((UPopupMenu)jComponent).addSeparator();
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (this.isRoutableLink(this.popupMapLink) || CompositeNetLink.getCompositeLink((INetLink)this.popupMapLink.getUserObject()) != null) {
            actionOrganizer.addMenuItem(jComponent, null, LINK_CIRCUITS, 67);
        }
        if (this.findPcaLink(this.popupMapLink) != null) {
            actionOrganizer.addMenuItem(jComponent, null, LINK_PCA_CIRCUITS, 80);
        }
        if (this.allowSpanUpgrade(this.popupMapLink)) {
            actionOrganizer.addMenuItem(jComponent, null, LINK_SPANUPGRADE, 85);
        }
        if (this.allowAddNode2OnePlusOne(this.popupMapLink)) {
            object = new JMenu(UPGRADE_PROTECTION);
            ((AbstractButton)object).setMnemonic(80);
            actionOrganizer.addMenuItem(jComponent, (JMenuItem)object, null, UPGRADE_PROTECTION);
            actionOrganizer.addMenuItem((JComponent)object, null, TERM_2_LINEAR, 84);
        }
        if (jComponent instanceof JMenu) {
            ((JMenu)jComponent).addSeparator();
        } else {
            ((UPopupMenu)jComponent).addSeparator();
        }
        this.toSrcView = this.updateEndPoint(LINK_TOSRC_CARD, 'S', actionOrganizer, jComponent);
        this.toDstView = this.updateEndPoint(LINK_TODST_CARD, 'T', actionOrganizer, jComponent);
    }

    protected void initCascadingPopup(MapLinkBundle mapLinkBundle, UPopupMenu uPopupMenu) {
        MapLink[] mapLinkArray = mapLinkBundle.getLinks();
        if (mapLinkArray == null) {
            return;
        }
        uPopupMenu.add(new JMenuItem("Total of " + mapLinkArray.length + (mapLinkArray.length > 1 ? " Links" : " Link")));
        uPopupMenu.addSeparator();
        this.hashMap.clear();
        TreeMap<String, MapLink> treeMap = new TreeMap<String, MapLink>();
        for (int i = 0; i < mapLinkArray.length; ++i) {
            INetLink iNetLink = (INetLink)mapLinkArray[i].getUserObject();
            String string = MapLinkRenderer.getLinkLabel(iNetLink);
            treeMap.put(string, mapLinkArray[i]);
        }
        Set set = treeMap.keySet();
        for (String string : set) {
            this.popupMapLink = (MapLink)treeMap.get(string);
            INetLink iNetLink = (INetLink)this.popupMapLink.getUserObject();
            ILinkModel iLinkModel = iNetLink.getLinkModel();
            if (iLinkModel.isVirtual()) {
                uPopupMenu.add(new JMenuItem(string));
                continue;
            }
            JMenu jMenu = new JMenu(string);
            uPopupMenu.add((JMenuItem)jMenu);
            ActionOrganizer actionOrganizer = new ActionOrganizer(this.popupMapLink);
            this.doInitLinkPopup(this.popupMapLink, actionOrganizer, jMenu);
            LinkSpec linkSpec = new LinkSpec(this.toSrcView, this.toDstView, string, this.popupMapLink);
            this.hashMap.put(string, linkSpec);
            jMenu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent menuEvent) {
                    String string = ((JMenu)menuEvent.getSource()).getText();
                    LinkSpec linkSpec = (LinkSpec)NetworkMap.this.hashMap.get(string);
                    NetworkMap.this.popupMapLink = linkSpec.mapLink;
                    NetworkMap.this.toSrcView = linkSpec.toSrcView;
                    NetworkMap.this.toDstView = linkSpec.toDstView;
                }

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuDeselected(MenuEvent menuEvent) {
                }
            });
        }
    }

    private boolean isRoutableLink(MapLink mapLink) {
        INetLink iNetLink = (INetLink)mapLink.getUserObject();
        return iNetLink.isRoutable();
    }

    private INetLink findPcaLink(MapLink mapLink) {
        INetLink iNetLink = (INetLink)mapLink.getUserObject();
        if (iNetLink instanceof NetLink) {
            NetLink netLink = (NetLink)mapLink.getUserObject();
            if (!netLink.inBLSR()) {
                return null;
            }
            if (netLink.getProtectionType() == 4) {
                if (this.dbg.on()) {
                    this.dbg.println("findPcaLink returning (4F): " + netLink.get4FProtectLink());
                }
                return netLink.get4FProtectLink();
            }
            for (INetLink iNetLink2 : Network.instance().findAllNetLinksWithSource(netLink.getSrc())) {
                if (iNetLink2.getProtectionType() != 5 || netLink.getSrcEntityIndex() != iNetLink2.getSrcEntityIndex() || netLink.getDstEntityIndex() != iNetLink2.getDstEntityIndex()) continue;
                if (this.dbg.on()) {
                    this.dbg.println("findPcaLink returning (2F): " + iNetLink2);
                }
                return iNetLink2;
            }
        }
        return null;
    }

    private boolean allowAddNode2OnePlusOne(MapLink mapLink) {
        if (!this.isProvisioningAllowed()) {
            return false;
        }
        ILinkModel iLinkModel = ((INetLink)mapLink.getUserObject()).getLinkModel();
        if (!iLinkModel.src().provides(Feature.ADDNODE2OPO) || !iLinkModel.dst().provides(Feature.ADDNODE2OPO) || iLinkModel.isVirtual()) {
            return false;
        }
        return iLinkModel.protectionType() == 1;
    }

    private boolean allowSpanUpgrade(MapLink mapLink) {
        if (!this.isProvisioningAllowed()) {
            return false;
        }
        ILinkModel iLinkModel = ((INetLink)mapLink.getUserObject()).getLinkModel();
        if (iLinkModel == null || iLinkModel.linkType() == 6) {
            return false;
        }
        INodeModel iNodeModel = iLinkModel.src();
        INodeModel iNodeModel2 = iLinkModel.dst();
        if (iNodeModel == null || iNodeModel2 == null) {
            return false;
        }
        if (!iNodeModel.provides(Feature.SPAN_UPGRADE) || !iNodeModel2.provides(Feature.SPAN_UPGRADE)) {
            if (this.dbg.on) {
                this.dbg.println("one or both nodes don't support span upgrade");
            }
            return false;
        }
        int n = iLinkModel.protectionType();
        if (n == 1 || n == 0 || n == 3 || n == 4) {
            try {
                return SpanUpgradeDialog.isSpanUpgradable(iLinkModel);
            }
            catch (Exception exception) {
                this.dbg.finer("Exception in allowSpanUpgrade " + exception);
            }
        }
        return false;
    }

    private ViewName updateEndPoint(String string, char c, ActionOrganizer actionOrganizer, JComponent jComponent) {
        ViewName viewName = null;
        try {
            INetLink iNetLink = (INetLink)this.popupMapLink.getUserObject();
            ILinkModel iLinkModel = iNetLink.getLinkModel();
            IEntityModel iEntityModel = null;
            String string2 = "";
            if (string.equals(LINK_TOSRC_CARD)) {
                iEntityModel = ((NetMapLink)this.popupMapLink).getSrcEntity();
                string2 = ((NetMapLink)this.popupMapLink).getSrcEntityString();
            } else {
                iEntityModel = ((NetMapLink)this.popupMapLink).getDstEntity();
                string2 = ((NetMapLink)this.popupMapLink).getDstEntityString();
            }
            if (iEntityModel != null) {
                int n = 0;
                if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.MULTISHELF) && iEntityModel.getNodeModel().isMultishelf()) {
                    n = iEntityModel.getShelfId();
                }
                viewName = new ViewName(new int[]{iEntityModel.getNodeModel().getNodeId(), n, iEntityModel.getSlot(), 0, 0, 0});
                if (iEntityModel.getNodeModel().getConnectionState() && iEntityModel.getNodeModel().getInitializationState() && viewName != null) {
                    actionOrganizer.addMenuItem(jComponent, null, string, c);
                    actionOrganizer.getAbstractButton(string).setText("Go To " + string2);
                }
            }
        }
        catch (Exception exception) {
            this.dbg.finer("Exception in updateEndPoint " + exception);
        }
        return viewName;
    }

    private void startSpanUpgrade(MapLink mapLink) {
        if (dlg != null) {
            CerentDialog.infoDialog((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (String)"An instance of the Span Upgrade dialog box already exists.", (String)LINK_SPANUPGRADE);
            dlg.show();
            return;
        }
        CtcApplication.instance().addProtectedOperation(LINK_SPANUPGRADE);
        dlg = new SpanUpgradeDialog(JOptionPane.getFrameForComponent(this.getGraphWindow()), this, (NetMapLink)mapLink);
    }

    public void endSpanUpgrade() {
        CtcApplication.instance().removeProtectedOperation(LINK_SPANUPGRADE);
        dlg = null;
    }

    void updateVitalStatsPane(IVitalStatsPaneObject iVitalStatsPaneObject) {
        if (this.selc != null) {
            this.selc.updateVitalStatsPane(iVitalStatsPaneObject);
        }
    }

    public void updateToolbar() {
        if (this.selc == null) {
            if (this.dbg.on()) {
                this.dbg.println("updateToolbar(): selc was null!");
            }
            AbstractViewController.setActiveObject(null);
        } else {
            try {
                Node node = this.selc.getSelectedNode();
                if (node != null) {
                    if (node instanceof NetDomainNode) {
                        AbstractViewController.setActiveObject((Object)node);
                    } else if (node instanceof NetMapNode) {
                        NodeModel nodeModel = (NodeModel)node.getUserObject();
                        if (nodeModel != null) {
                            AbstractViewController.setActiveObject((Object)node);
                        } else {
                            AbstractViewController.setActiveObject(null);
                        }
                    }
                } else {
                    AbstractViewController.setActiveObject(null);
                }
            }
            catch (Exception exception) {
                AbstractViewController.setActiveObject(null);
            }
        }
    }

    private void ramanDayZero(IlvGraphic ilvGraphic, MapNode mapNode) {
        RamanDayZeroDialog ramanDayZeroDialog;
        Frame frame = JOptionPane.getFrameForComponent(this.getParent());
        if (ilvGraphic instanceof MapNode) {
            ramanDayZeroDialog = RamanDayZeroDialog.instance(frame, (INodeModel)((MapNode)ilvGraphic).getUserObject(), (INodeModel)mapNode.getUserObject());
        } else if (ilvGraphic instanceof MapLink) {
            ramanDayZeroDialog = RamanDayZeroDialog.instance(frame, (INetLink)((MapLink)ilvGraphic).getUserObject());
        } else {
            return;
        }
        if (ramanDayZeroDialog != null) {
            ramanDayZeroDialog.showModal();
        }
    }

    class LinkSpec {
        ViewName toDstView;
        ViewName toSrcView;
        String spanLabel;
        MapLink mapLink;

        LinkSpec(ViewName viewName, ViewName viewName2, String string, MapLink mapLink) {
            this.toSrcView = viewName;
            this.toDstView = viewName2;
            this.spanLabel = string;
            this.mapLink = mapLink;
        }
    }
}

