/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.network.AbstractNetworkMap;
import cerent.cms.ui.network.NetMapFactory;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanPathPane;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.util.HashMap;

public class RamanNetworkMap
extends AbstractNetworkMap {
    private HashMap<String, Boolean> linkInsert;
    private RamanPathPane RamanPane;
    private static final SDebug db = new SDebug("RamanNetworkMap");

    public RamanNetworkMap(RamanDayZeroDialog ramanDayZeroDialog, RamanPathPane ramanPathPane) {
        super(db, 0, NetMapFactory.instance());
        this.RamanPane = ramanPathPane;
        this.linkInsert = new HashMap();
    }

    public boolean isLinkAcceptable(INetLink iNetLink) {
        if (iNetLink instanceof DwdmNetLink) {
            return true;
        }
        if (iNetLink instanceof VirtualNetLink) {
            return this.handlePpcLink((VirtualNetLink)iNetLink);
        }
        return false;
    }

    private boolean handlePpcLink(VirtualNetLink virtualNetLink) {
        String string = virtualNetLink.getSrc().getName() + virtualNetLink.getDst().getName();
        if (this.linkInsert.containsKey(string)) {
            return true;
        }
        this.linkInsert.put(string, Boolean.TRUE);
        return true;
    }

    public void showCircuitObjects() {
        this.initializeMap(2);
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        this.RamanPane.nodeSelected(mapNode, bl);
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        this.RamanPane.linkSelected(mapLink, bl);
    }

    protected void doubleClicked(MapLink mapLink) {
        super.doubleClicked(mapLink);
        this.RamanPane.includePath();
    }
}

