/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.ui.UiToolkit;
import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Pair;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.tty.CLIShowControllerDwdmAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class RouterPortStatusDialog
extends UDialog
implements ActionListener {
    private JButton closeButton;
    private JButton exportButton;
    private JPanel buttonPanel;
    private static final String TITLE_PREFIX = "Port status for ";
    private JTextArea text;
    private UScrollPane scroll;
    private static final String EXPORT_PATH = "ctc";
    private static final String EXPORT_PROP = "export.file.path";

    public RouterPortStatusDialog(String string, String string2) {
        super(UiToolkit.instance().getApplicationFrame(), TITLE_PREFIX + string2, false, (Object)new Pair((Object)string, (Object)string2));
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        Pair pair = (Pair)object;
        CLIShowControllerDwdmAction cLIShowControllerDwdmAction = new CLIShowControllerDwdmAction((String)pair.getFirst());
        String string = "";
        string = cLIShowControllerDwdmAction.get((String)pair.getSecond());
        if ("".equals(string)) {
            string = "Unable to retreive router port status";
        }
        this.text = new JTextArea(string);
        this.text.setEditable(false);
        this.text.setLineWrap(false);
        this.scroll = new UScrollPane((Component)this.text);
        this.scroll.setPreferredSize(new Dimension(400, 400));
        jPanel.add((Component)this.scroll, "Center");
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.exportButton);
        jPanel.add((Component)this.buttonPanel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exportButton) {
            File file = PersistentFileChooserDialog.getFileUseChooser((Component)UiToolkit.instance().getApplicationFrame(), (byte)2, (String)EXPORT_PATH, (String)EXPORT_PROP, null);
            if (file != null && (!file.exists() || CerentDialog.yesNoDialog((Component)UiToolkit.instance().getApplicationFrame(), (String)("The file " + file.getAbsolutePath() + " already exists.\nDo you want to replace it?"), (String)"File Export"))) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(this.text.getText());
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    String string = KErrorMsg.getString((EID)KEMC.EID_FILE_SAVE_EXCEPTION_PARAM_1, (Object)file.getAbsolutePath());
                    CerentDialog.errorDialog((Component)UiToolkit.instance().getApplicationFrame(), (String)string);
                }
            }
        } else if (actionEvent.getSource() == this.closeButton) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isValidFileName(String string) {
        boolean bl;
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(string);
                fileWriter.write("test");
                fileWriter.flush();
                bl = true;
                Object var7_5 = null;
                if (fileWriter == null) return bl;
            }
            catch (Exception exception) {
                String string2 = KErrorMsg.getString((EID)KEMC.EID_FILE_SAVE_EXCEPTION_PARAM_1, (Object)string);
                CerentDialog.errorDialog((Component)UiToolkit.instance().getApplicationFrame(), (String)string2);
                boolean bl2 = false;
                Object var7_6 = null;
                if (fileWriter == null) return bl2;
                try {
                    fileWriter.close();
                    return bl2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fileWriter == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            fileWriter.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        fileWriter.close();
        return bl;
    }
}

