/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.ConfigError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SideInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.network.raman.RamanAttribute;
import cerent.cms.ui.network.raman.RamanCardSelection;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanDayZeroWzPane;
import cerent.cms.ui.network.raman.RamanDoComandPanel;
import cerent.cms.ui.network.raman.RamanDoMeasurePane;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RamanDayZeroCalPane
extends RamanDayZeroWzPane
implements IRamanDayZeroOperation {
    private String buttonName = "Repeat";
    private RamanDoMeasurePane doMeasurePane;
    private sm doMeasure = sm.StartTest;
    private boolean stopAll = false;
    private RamanDoComandPanel runRamamCommand;
    private RamanCardSelection[] cardSelectionPanel = new RamanCardSelection[2];
    private final String hintsStr = "The following steps will be performed:\n1) The Booster present on the Start Node will be turned on.\n2) The OPT-RAMP card on the start node will be turned on.\n3) Received power and the End Node will be measured.\n";
    private String nextPage;
    protected IRamanModel startRamanModel;
    private RamanAttribute[] allNe;
    private int middleNe;

    public RamanDayZeroCalPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string, RamanDayZeroInfo ramanDayZeroInfo) {
        super(wzDialog, wzDiagDebug, string, ramanDayZeroInfo);
    }

    protected String getNextPaneName() {
        if (this.nextPage == "Error Page") {
            this.info.setErrorPane(this.getName(), 11);
            return this.nextPage;
        }
        if (this.info.getTestIndex() == 1) {
            this.nextPage = "Accept Result";
        } else {
            this.info.incTest();
            this.nextPage = "Setting Parameters";
        }
        return this.nextPage;
    }

    protected void initPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.guiCreate());
        this.add(this.labelButtonResultPane("The following steps will be performed:\n1) The Booster present on the Start Node will be turned on.\n2) The OPT-RAMP card on the start node will be turned on.\n3) Received power and the End Node will be measured.\n"));
        if (this.runRamamCommand == null) {
            this.runRamamCommand = new RamanDoComandPanel(new GridBagLayout(), this, this.buttonName);
            this.add(this.runRamamCommand);
        }
        this.doMeasurePane = new RamanDoMeasurePane(new GridBagLayout());
        this.add(this.doMeasurePane);
    }

    public void enteringPane() {
        super.enteringPane();
        if (this.info.getTestIndex() == 0) {
            this.setRamanModel(this.getNode(1).getNode());
            this.startRamanModel = this.getNode(0).getNode().getRamanModels();
            for (int i = 0; i < 2; ++i) {
                boolean bl = RamanCardSelection.isMultishelf(this.getNode(i).getNode());
                this.findAllRamanUnit(bl, i);
            }
            this.resetSM();
            if (this.stopAll) {
                ErrorMsg.displayError(this, NEMC.EID_COMMAND_ERROR, "Generic", IRamanModel.COMMAND_TYPE_ERR[10]);
                return;
            }
        }
        this.initCommandResult();
        this.runRamamCommand.waitOrButton(true, false, this.info.isAutoRun());
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
        this.sendRamanStartTestToStartNode();
        if (this.doMeasurePane != null) {
            this.doMeasurePane.cleanMesure();
        }
    }

    private void resetSM() {
        try {
            this.startRamanModel.ramanReset(0, this.getNode(0).getSingleRamanLinePort().getIndex());
            this.ramanModel.ramanReset(this.getNode(1).getSingleRamanLinePort().getIndex(), 0);
        }
        catch (WrongNodeSide wrongNodeSide) {
            KDebug.printStackTrace((Throwable)wrongNodeSide);
            this.stopAll = true;
        }
        catch (SideInUse sideInUse) {
            KDebug.printStackTrace((Throwable)sideInUse);
            this.stopAll = true;
        }
        catch (ConfigError configError) {
            KDebug.printStackTrace((Throwable)configError);
            this.stopAll = true;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            this.stopAll = true;
        }
        catch (ProvisionError provisionError) {
            KDebug.printStackTrace((Throwable)provisionError);
            this.stopAll = true;
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
            this.stopAll = true;
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RamanDay0InstallationCalibrationConfigDlg;
    }

    protected RamanAttribute getNode(int n) {
        if (n == 0) {
            return this.info.getStartNode();
        }
        return this.info.getEndNode();
    }

    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < 2; ++i) {
            arrayList.add(new String[]{"Card on Node:  ", this.cardSelectionPanel[i].getNodeName()});
            this.cardSelectionPanel[i].getStatusComponent(arrayList);
        }
        if (this.nextPage != "Error Page") {
            IRamanModel.RamanPowerMeasures ramanPowerMeasures = this.info.getRamanParamsCurrentTest(this.info.getTestIndex());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm:ss");
            arrayList.add(new String[]{"Measure #: ", Integer.toString(this.info.getTestIndex() + 1)});
            Date date = new Date((long)ramanPowerMeasures.measureTimeStamp * 1000L);
            arrayList.add(new String[]{"Time Stamp: ", simpleDateFormat.format(date)});
            arrayList.add(new String[]{"Low Power (dBm): ", Double.toString((double)ramanPowerMeasures.powerMinRamanLevel / 10.0)});
            arrayList.add(new String[]{"High Power (dBm): ", Double.toString((double)ramanPowerMeasures.powerMaxRamanLevel / 10.0)});
        } else {
            arrayList.add(new String[]{"Measure #: ", Integer.toString(this.info.getTestIndex())});
            arrayList.add(new String[]{"Error Measure", "RUN WIZARD AGAIN"});
        }
        return RamanDayZeroCalPane.getGridPanel(arrayList);
    }

    /*
     * Unable to fully structure code
     */
    public void doCommand() {
        if (this.db.on()) {
            this.db.println("RamanDayZeroCalPane -- update()");
        }
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(false);
        var1_1 = this.getNode(1).getSingleRamanLinePort();
        var2_2 = this.info.getTestIndex();
        var3_3 = null;
        switch (1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[this.doMeasure.ordinal()]) {
            case 1: {
                if (this.db.on) {
                    this.db.println("-----DoMeasure " + this.ramanModel.getNodeModel().getName());
                }
                this.doMeasure = sm.GetRamanParam;
                this.ramanModel.ramanMeasure(var1_1.getIndex(), var2_2, (IRamanDayZeroOperation)this);
                var3_3 = this.ramanModel.getNodeModel().getName() + " Raman Measure";
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("-----GetRamanParam " + this.ramanModel.getNodeModel().getName());
                }
                this.doMeasure = sm.GetRamanParamEvent;
                var4_4 = this.ramanModel.getRamanParams(var1_1.getIndex(), var2_2, (IRamanDayZeroOperation)this);
                this.doMeasurePane.updateValues(var4_4);
                this.info.setRamanParamsCurrentTest(var4_4, var2_2);
                var3_3 = this.ramanModel.getNodeModel().getName() + " get Raman Params";
                break;
            }
            case 3: {
                if (this.info.getTestIndex() < 1) {
                    this.runRamamCommand.waitOrButton(false, true, this.info.isAutoRun());
                    this.nextPage = "Setting Parameters";
                    this.doMeasure = sm.StartTest;
                    break;
                }
                this.doMeasure = sm.Calculation;
                this.doCommand();
                break;
            }
            case 4: {
                if (this.db.on) {
                    this.db.println("-----Calculation " + this.ramanModel.getNodeModel().getName());
                }
                this.doMeasure = sm.ReadNewValue;
                try {
                    this.ramanModel.calculation(var1_1.getIndex(), (IRamanDayZeroOperation)this);
                    this.showCommandResult(" executed");
                }
                catch (WrongNodeSide var5_5) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)var5_5);
                }
                catch (SideInUse var5_6) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)var5_6);
                }
                catch (ConfigError var5_7) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)var5_7);
                }
                catch (WrongInterfaceType var5_8) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)var5_8);
                }
                catch (ProvisionError var5_9) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)var5_9);
                }
                catch (NoSuchInterface var5_10) {
                    this.nextPage = "Error Page";
                    KDebug.printStackTrace((Throwable)var5_10);
                }
                var3_3 = this.ramanModel.getNodeModel().getName() + " Raman Calculation";
                break;
            }
            case 5: {
                if (this.db.on) {
                    this.db.println("-----ReadNewValue " + this.ramanModel.getNodeModel().getName());
                }
                this.doMeasure = sm.ReadNewValueEvent;
                this.info.addResultValues(this.ramanModel.getNewValues(var1_1, (IRamanDayZeroOperation)this));
                var3_3 = this.ramanModel.getNodeModel().getName() + " get New Raman Values";
                break;
            }
            case 6: {
                this.doMeasure = sm.StartTest;
                this.runRamamCommand.waitOrButton(false, true, this.info.isAutoRun());
                this.showCommandResult(" executed");
                break;
            }
            case 7: {
                if (!this.info.hasDeltaPwr()) {
                    try {
                        this.info.setDeltaPwr(this.startRamanModel.ramanDeltaPwr(this.getNode(0).getSingleRamanLinePort().getIndex()));
                    }
                    catch (ConfigError var5_11) {
                        KDebug.printStackTrace((Throwable)var5_11);
                        this.stopAll = true;
                    }
                    catch (WrongInterfaceType var5_12) {
                        KDebug.printStackTrace((Throwable)var5_12);
                        this.stopAll = true;
                    }
                    catch (ProvisionError var5_13) {
                        KDebug.printStackTrace((Throwable)var5_13);
                        this.stopAll = true;
                    }
                }
                var5_14 = "";
                if (this.allNe.length <= 0 || this.middleNe >= this.allNe.length) ** GOTO lbl132
                var6_15 = this.allNe[this.middleNe].getNode().getNodeModel();
                var5_14 = var6_15.getName();
                var7_16 = var6_15.getRamanModels();
                try {
                    if (this.db.on) {
                        this.db.println("-----StartTest " + this.ramanModel.getNodeModel().getName() + " _ST_RAMAN_BYPASS_NODE");
                    }
                    var7_16.startTest(this.allNe[this.middleNe].getSingleRamanLinePort().getIndex(), this.allNe[this.middleNe].getOutRamanLinePort().getIndex(), this.info.getTxpLambdaCurrentTest(), IRamanModel.ramanSetupTypeEnum._ST_RAMAN_BYPASS_NODE, this.info.getDeltaPwr(), (IRamanDayZeroOperation)this);
                    ++this.middleNe;
                    if (this.db.on) {
                        this.db.println(this.middleNe + 1 + ") " + this.allNe[this.middleNe].getNode().getName() + "\n" + "     InPort Index  " + this.allNe[this.middleNe].getSingleRamanLinePort().getIndex() + "\n" + "     OutPort Index " + this.allNe[this.middleNe].getOutRamanLinePort().getIndex());
                    }
                    ** GOTO lbl135
                }
                catch (WrongNodeSide var8_17) {
                    KDebug.printStackTrace((Throwable)var8_17);
                    this.stopAll = true;
                }
                catch (SideInUse var8_18) {
                    KDebug.printStackTrace((Throwable)var8_18);
                    this.stopAll = true;
                }
                catch (ConfigError var8_19) {
                    KDebug.printStackTrace((Throwable)var8_19);
                    this.stopAll = true;
                }
                catch (WrongInterfaceType var8_20) {
                    KDebug.printStackTrace((Throwable)var8_20);
                    this.stopAll = true;
                }
                catch (ProvisionError var8_21) {
                    KDebug.printStackTrace((Throwable)var8_21);
                    this.stopAll = true;
                }
                catch (NoSuchInterface var8_22) {
                    KDebug.printStackTrace((Throwable)var8_22);
                    this.stopAll = true;
                }
                ** GOTO lbl135
lbl132:
                // 1 sources

                this.doMeasure = sm.DoMeasure;
                this.sendRamanStartTestToEndNode();
                var5_14 = this.ramanModel.getNodeModel().getName();
lbl135:
                // 9 sources

                var3_3 = var5_14 + " Raman Start Test";
                if (!this.stopAll) break;
                ErrorMsg.displayError(this, NEMC.EID_COMMAND_ERROR, "Generic", IRamanModel.COMMAND_TYPE_ERR[10]);
                break;
            }
        }
        this.runRamamCommand.setExecutingLabel(var3_3);
    }

    public void recovery() {
    }

    public void objChanged(int n, String string) {
        if (n != 0) {
            if (this.db.on()) {
                this.db.println(string + ") objChange with Error = " + n);
            }
            this.stopAll = true;
            this.nextPage = "Error Page";
            ErrorMsg.displayError(this, NEMC.EID_COMMAND_ERROR, string, IRamanModel.COMMAND_TYPE_ERR[n]);
            this.showCommandResult("Error on " + string + ". " + IRamanModel.COMMAND_TYPE_ERR[n]);
        } else {
            this.doCommand();
        }
    }

    public void timeOut(String string) {
        this.nextPage = "Error Page";
        ErrorMsg.displayError(this, NEMC.EID_RAMAN_TIME_OUT, string, " fail");
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(true);
        this.showCommandResult(" TimeOut error on " + string);
        this.stopAll = true;
    }

    private void sendRamanStartTestToEndNode() {
        if (!this.stopAll) {
            try {
                if (this.db.on) {
                    this.db.println("-----StartTest " + this.ramanModel.getNodeModel().getName() + " _ST_RAMAN_MEASURE_NODE");
                }
                this.ramanModel.startTest(this.getNode(1).getSingleRamanLinePort().getIndex(), 0, this.info.getTxpLambdaCurrentTest(), IRamanModel.ramanSetupTypeEnum._ST_RAMAN_MEASURE_NODE, this.info.getDeltaPwr(), (IRamanDayZeroOperation)this);
            }
            catch (WrongNodeSide wrongNodeSide) {
                KDebug.printStackTrace((Throwable)wrongNodeSide);
                this.stopAll = true;
            }
            catch (SideInUse sideInUse) {
                KDebug.printStackTrace((Throwable)sideInUse);
                this.stopAll = true;
            }
            catch (ConfigError configError) {
                KDebug.printStackTrace((Throwable)configError);
                this.stopAll = true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                KDebug.printStackTrace((Throwable)wrongInterfaceType);
                this.stopAll = true;
            }
            catch (ProvisionError provisionError) {
                KDebug.printStackTrace((Throwable)provisionError);
                this.stopAll = true;
            }
            catch (NoSuchInterface noSuchInterface) {
                KDebug.printStackTrace((Throwable)noSuchInterface);
                this.stopAll = true;
            }
        }
    }

    private void sendRamanStartTestToStartNode() {
        Object object;
        int n = 0;
        this.doMeasure = sm.StartTest;
        this.allNe = this.info.getCurrentMiddleNodes().toArray(new RamanAttribute[0]);
        this.middleNe = 0;
        try {
            if (this.info.isDmuxPresent()) {
                object = IRamanModel.ramanSetupTypeEnum._ST_RAMAN_START_NODE_MUX;
                if (this.db.on) {
                    this.db.println("-----StartTest " + this.ramanModel.getNodeModel().getName() + " _ST_RAMAN_START_NODE_MUX");
                }
            } else {
                object = IRamanModel.ramanSetupTypeEnum._ST_RAMAN_START_NODE_BOOSTER;
                if (this.db.on) {
                    this.db.println("-----StartTest " + this.ramanModel.getNodeModel().getName() + " _ST_RAMAN_START_NODE_BOOSTER");
                }
            }
            this.startRamanModel.startTest(this.info.getTrunkCurrentTest().getIndex(), this.getNode(0).getSingleRamanLinePort().getIndex(), this.info.getTxpLambdaCurrentTest(), object, 0, (IRamanDayZeroOperation)this);
        }
        catch (WrongNodeSide wrongNodeSide) {
            KDebug.printStackTrace((Throwable)wrongNodeSide);
            n = 10;
            this.stopAll = true;
        }
        catch (SideInUse sideInUse) {
            KDebug.printStackTrace((Throwable)sideInUse);
            n = 10;
            this.stopAll = true;
        }
        catch (ConfigError configError) {
            KDebug.printStackTrace((Throwable)configError);
            n = 10;
            this.stopAll = true;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            n = 10;
            this.stopAll = true;
        }
        catch (ProvisionError provisionError) {
            KDebug.printStackTrace((Throwable)provisionError);
            n = 10;
            this.stopAll = true;
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
            n = 10;
            this.stopAll = true;
        }
        object = this.startRamanModel.getNodeModel().getName() + " get Raman Params";
        this.runRamamCommand.setExecutingLabel((String)object);
        if (n != 0) {
            ErrorMsg.displayError(this, NEMC.EID_COMMAND_ERROR, this.getNode(0), IRamanModel.COMMAND_TYPE_ERR[n]);
            return;
        }
    }

    public void nextEnable(boolean bl) {
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(bl, this.info.isAutoRun());
    }

    public void validatePage() throws Exception {
    }

    private JPanel guiCreate() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        for (int i = 0; i < 2; ++i) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            if (this.cardSelectionPanel[i] == null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(5, 5, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets.bottom = 15;
                gridBagConstraints.insets.bottom = 0;
                this.internalInitPane(i);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                jPanel2.add((Component)this.cardSelectionPanel[i], gridBagConstraints);
            }
            jPanel.add(jPanel2);
        }
        return jPanel;
    }

    private void internalInitPane(int n) {
        INodeModel iNodeModel = this.getNode(n).getNode();
        this.cardSelectionPanel[n] = new RamanCardSelection(iNodeModel.getName(), new GridBagLayout(), RamanCardSelection.isMultishelf(iNodeModel));
    }

    private void findAllRamanUnit(boolean bl, int n) {
        Vector<IEntityModel> vector = new Vector<IEntityModel>();
        NodeModel nodeModel = (NodeModel)this.getNode(n).getNode();
        if (n == 0) {
            vector.add(this.getNode(0).getSingleRamanLinePort());
        } else {
            vector.add(this.getNode(1).getSingleRamanLinePort());
        }
        this.cardSelectionPanel[n].initModel(vector.toArray(new IEntityModel[0]), bl);
        this.cardSelectionPanel[n].setEnableAll(false);
        this.cardSelectionPanel[n].setNodeStr(nodeModel.getName());
    }

    public void repeatButton() {
        this.doMeasure = sm.DoMeasure;
        this.doCommand();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm;

        static {
            $SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm = new int[sm.values().length];
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.DoMeasure.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.GetRamanParam.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.GetRamanParamEvent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.Calculation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.ReadNewValue.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.ReadNewValueEvent.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$cerent$cms$ui$network$raman$RamanDayZeroCalPane$sm[sm.StartTest.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum sm {
        StartTest,
        DoMeasure,
        GetRamanParam,
        GetRamanParamEvent,
        Calculation,
        ReadNewValue,
        ReadNewValueEvent;

    }
}

