/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.ConfigError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ExternalExportHandler;
import cerent.cms.ui.MainPanel;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzExtendedStatusPanel;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.raman.RamanAttribute;
import cerent.cms.ui.network.raman.RamanDayZeroAcpPane;
import cerent.cms.ui.network.raman.RamanDayZeroCalPane;
import cerent.cms.ui.network.raman.RamanDayZeroEndRoutePane;
import cerent.cms.ui.network.raman.RamanDayZeroErrPane;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanDayZeroSrcPane;
import cerent.cms.ui.network.raman.RamanDayZeroWzPane;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UTable;
import com.cisco.ctc.CtcApplication;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RamanDayZeroDialog
extends WzDialog
implements WindowListener,
IRamanDayZeroOperation {
    public static final String RAMAN_DAY0 = "Raman Installation Day0";
    public static final String RAMAN_DAY0_NODE = "Raman Installation Day0 Multi-Span";
    private static final String TITLE = "Day0 Raman Calibration";
    public static final String WZPANE_Raman_ATTRS = null;
    public static final String WZPANE_Raman_SRC = "Setting Parameters";
    public static final String WZPANE_Raman_CAL = "Calibrate Raman";
    public static final String WZPANE_Raman_ACP = "Accept Result";
    public static final String WZPANE_Raman_ROU = "Routing Page";
    public static final String WZPANE_Raman_ERR = "Error Page";
    public static final int VIGN_WIDTH = 850;
    private static final int VIGN_HEIGHT = 600;
    private static final int FROM_LINK = 0;
    private static final int FROM_NODE = 1;
    private static final String WARNING_MSG = "This operation might be traffic-affecting and will cancel previous settings.\ndo you want to continue ?";
    private static final String TITLE_MSG = "Confirm Wizard";
    private static final int MAX_HISTORY_SIZE = 100;
    private int fromLink = 0;
    private List<RamanAttribute> nodeList = null;
    private RamanDayZeroInfo info;
    private HandleAutoNext autoNext;
    private AbstractViewController nvc;
    private boolean fromExport;
    private static RamanDayZeroDialog _instance = null;

    private RamanDayZeroDialog(Frame frame, String string, WzDiagDebug wzDiagDebug, boolean bl, boolean bl2) {
        super(frame, TITLE, wzDiagDebug, false, bl2);
        MainPanel mainPanel = CtcApplication.instance().getMainPanel();
        this.nvc = mainPanel.getNetworkViewController();
        this.info = new RamanDayZeroInfo(wzDiagDebug);
        this.nodeList = new LinkedList<RamanAttribute>();
        int n = 850;
        int n2 = 600;
        this.setSize(new Dimension(n, n2));
        this.setLocationRelativeTo(frame);
        this.autoNext = new HandleAutoNext();
        this.addWindowListener(this);
    }

    public RamanDayZeroDialog(Frame frame, INetLink iNetLink) {
        this(frame, TITLE, new WzDiagDebug("RamanDayZeroDialog"), true, true);
        this.fromLink = 0;
        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
        IEntityModel iEntityModel = MapLinkRenderer.getEntity(iNodeModel, iNetLink.getSrcEntityIndex());
        RamanAttribute ramanAttribute = new RamanAttribute(iNodeModel, iEntityModel.getParent());
        this.nodeList.add(ramanAttribute);
        iNodeModel = iNetLink.getDst().getNodeModel();
        iEntityModel = MapLinkRenderer.getEntity(iNodeModel, iNetLink.getDstEntityIndex());
        ramanAttribute = new RamanAttribute(iNodeModel, iEntityModel.getParent());
        this.nodeList.add(ramanAttribute);
        this.createPanesAndSetCurrent();
    }

    public RamanDayZeroDialog(Frame frame, INodeModel iNodeModel, INodeModel iNodeModel2) {
        this(frame, TITLE, new WzDiagDebug("RamanDayZeroDialog"), true, true);
        this.fromLink = 1;
        RamanAttribute ramanAttribute = new RamanAttribute(iNodeModel, null);
        this.nodeList.add(ramanAttribute);
        ramanAttribute = new RamanAttribute(iNodeModel2, null);
        this.nodeList.add(ramanAttribute);
        this.createPanesAndSetCurrent();
    }

    protected void initStatusPanel() {
        this.statusPanel = this.statusPanel = new WzExtendedStatusPanel(100);
        this.statusScrollPane = new JScrollPane(this.statusPanel, 20, 30);
    }

    protected void createPanesAndSetCurrent() {
        this.wzPaneMap.put(WZPANE_Raman_SRC, new RamanDayZeroSrcPane(this, this.db, WZPANE_Raman_SRC, this.info));
        this.wzPaneMap.put(WZPANE_Raman_CAL, new RamanDayZeroCalPane(this, this.db, WZPANE_Raman_CAL, this.info));
        this.wzPaneMap.put(WZPANE_Raman_ACP, new RamanDayZeroAcpPane(this, this.db, WZPANE_Raman_ACP, this.info));
        this.wzPaneMap.put(WZPANE_Raman_ERR, new RamanDayZeroErrPane(this, this.db, WZPANE_Raman_ERR, this.info));
        if (!this.startedFromLink()) {
            this.info.setNeedRoute(true);
            this.wzPaneMap.put(WZPANE_Raman_ROU, new RamanDayZeroEndRoutePane(this, this.db, WZPANE_Raman_ROU, WZPANE_Raman_ROU, this.info));
            this.setCurrentPane(WZPANE_Raman_ROU);
        } else {
            this.setCurrentPane(WZPANE_Raman_SRC);
        }
    }

    protected void apply() throws Exception {
    }

    public RamanAttribute[] getNodeList() {
        if (this.info.getStartNode() == null && this.info.getEndNode() == null) {
            return this.nodeList.toArray(new RamanAttribute[0]);
        }
        RamanAttribute[] ramanAttributeArray = new RamanAttribute[]{this.info.getStartNode(), this.info.getEndNode()};
        return ramanAttributeArray;
    }

    public RamanDayZeroInfo getInfo() {
        return this.info;
    }

    public boolean startedFromLink() {
        return this.fromLink == 0;
    }

    public void nextButtonEnable(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    public void nextButtonEnable(boolean bl, boolean bl2) {
        this.nextButton.setEnabled(bl);
        if (bl && bl2) {
            this.autoNext.trigger();
        }
    }

    private void recovery() {
        this.autoNext.destroy();
        this.exportData(false);
        int n = this.wzPaneStack.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.wzPaneStack.get(i);
            if (!(e instanceof RamanDayZeroWzPane)) continue;
            ((RamanDayZeroWzPane)e).recovery();
        }
    }

    protected void handleCancel() {
        this.recovery();
        if (!(this.currentWzPane instanceof RamanDayZeroEndRoutePane)) {
            ((RamanDayZeroWzPane)this.currentWzPane).recovery();
        }
    }

    protected void handleFinish() {
        this.recovery();
        super.handleFinish();
    }

    public INodeModel getSourceNode() {
        if (this.info.getStartNode() == null) {
            RamanAttribute[] ramanAttributeArray = this.getNodeList();
            return ramanAttributeArray[0].getNode();
        }
        return this.info.getStartNode().getNode();
    }

    public INodeModel getDestNode() {
        if (this.info.getEndNode() == null) {
            RamanAttribute[] ramanAttributeArray = this.getNodeList();
            return ramanAttributeArray[0].getNode();
        }
        return this.info.getEndNode().getNode();
    }

    public void setFinishEnabled(boolean bl) {
        this.setButtonsEnabled(this.nextButton.isEnabled(), bl);
        this.cancelButton.setEnabled(false);
        if (this.finishButton.isEnabled()) {
            this.finishButton.requestFocus();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.autoNext.destroy();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void setAutoRun(boolean bl) {
        this.info.setAutoRun(bl);
        if (bl) {
            this.backButton.setVisible(false);
            this.nextButton.setVisible(false);
        } else {
            this.backButton.setVisible(true);
            this.nextButton.setVisible(true);
        }
    }

    public void clearStatusHistory() {
        ((WzExtendedStatusPanel)this.statusPanel).clearAllExcept(0);
    }

    public void exportData(boolean bl) {
        this.info.restoreColumns();
        UTable uTable = this.info.getResultTable();
        if (this.finishButton.isEnabled()) {
            if (this.fromExport && !bl) {
                return;
            }
            this.fromExport = bl;
        }
        if (uTable == null) {
            return;
        }
        UTable[] uTableArray = new UTable[]{uTable};
        String string = this.info.getEndNode().getNode().getUserName();
        ExternalExportHandler externalExportHandler = new ExternalExportHandler(this.nvc, (JTable[])uTableArray, "Raman Installation - ", "User " + string + " installation values");
        externalExportHandler.export();
    }

    public static void restoreRaman(RamanDayZeroInfo ramanDayZeroInfo, IRamanDayZeroOperation iRamanDayZeroOperation) {
        try {
            IRamanModel iRamanModel;
            int n;
            if (ramanDayZeroInfo.getEndNode() != null) {
                n = ramanDayZeroInfo.getEndNode().getSingleRamanLinePort().getIndex();
                iRamanModel = ramanDayZeroInfo.getEndNode().getNode().getRamanModels();
                iRamanModel.restoreRaman(n, 0, ramanDayZeroInfo.getTxpLambdaCurrentTest(), iRamanDayZeroOperation);
            }
            if (ramanDayZeroInfo.getStartNode() != null) {
                n = ramanDayZeroInfo.getStartNode().getSingleRamanLinePort().getIndex();
                iRamanModel = ramanDayZeroInfo.getStartNode().getNode().getRamanModels();
                iRamanModel.restoreRaman(0, n, ramanDayZeroInfo.getTxpLambdaCurrentTest(), iRamanDayZeroOperation);
            }
            if (ramanDayZeroInfo.isMultiSpan()) {
                ArrayList<RamanAttribute> arrayList = ramanDayZeroInfo.getCurrentMiddleNodes();
                for (int i = 0; i < arrayList.size(); ++i) {
                    RamanAttribute ramanAttribute = arrayList.get(i);
                    ramanAttribute.getNode().getRamanModels().restoreRaman(ramanAttribute.getSingleRamanLinePort().getIndex(), ramanAttribute.getOutRamanLinePort().getIndex(), ramanDayZeroInfo.getTxpLambdaCurrentTest(), iRamanDayZeroOperation);
                }
            }
        }
        catch (ConfigError configError) {
            SDebug.printStackTrace((Throwable)configError);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
    }

    public static RamanDayZeroDialog instance(Frame frame, INodeModel iNodeModel, INodeModel iNodeModel2) {
        if (CerentDialog.yesNoDialog((Component)frame, (String)WARNING_MSG, (String)TITLE_MSG)) {
            if (_instance == null) {
                _instance = new RamanDayZeroDialog(frame, iNodeModel, iNodeModel2);
            }
            return _instance;
        }
        return null;
    }

    public static RamanDayZeroDialog instance(Frame frame, INetLink iNetLink) {
        if (CerentDialog.yesNoDialog((Component)frame, (String)WARNING_MSG, (String)TITLE_MSG)) {
            if (_instance == null) {
                _instance = new RamanDayZeroDialog(frame, iNetLink);
            }
            return _instance;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        _instance = null;
    }

    public void objChanged(int n, String string) {
    }

    public void timeOut(String string) {
    }

    private class HandleAutoNext
    implements Runnable {
        private Thread thread = new Thread((Runnable)this, "Raman Auto Next Button");
        private boolean trigger;
        private boolean noExit;

        public HandleAutoNext() {
            this.thread.start();
        }

        public synchronized void trigger() {
            this.trigger = true;
        }

        public void run() {
            this.trigger = false;
            this.noExit = true;
            do {
                try {
                    Thread.sleep(1000L);
                    if (!this.trigger) continue;
                    this.trigger = false;
                    Thread.sleep(1000L);
                    RamanDayZeroDialog.this.nextButton.doClick(300);
                }
                catch (InterruptedException interruptedException) {
                    SDebug.printStackTrace((Throwable)interruptedException);
                }
            } while (this.noExit);
        }

        public void destroy() {
            this.noExit = false;
        }
    }
}

