/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PPCLinkCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.cms.ui.ppc.PPCCreationInfo;
import cerent.cms.ui.ppc.PPCHelper;
import cerent.util.ComparisonUtil;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RamanDayZeroDstPane
extends WzPane {
    private UComboBox nodeList;
    private UComboBox txpList;
    private DefaultComboBoxModel shelfModel;
    private JComboBox shelfCB;
    private DefaultComboBoxModel slotModel;
    private JComboBox slotCB;
    private DefaultComboBoxModel portModel;
    private JComboBox portCB;
    private TreeMap<Integer, TreeMap<IModuleModel, LinkedList<IEntityModel>>> portsMap = new TreeMap();
    private static final Integer DUMMY_SHELF_ID = new Integer(0);

    public RamanDayZeroDstPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    public void validatePage() throws Exception {
    }

    protected String getNextPaneName() {
        return null;
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.bottom = 15;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Shelf: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.shelfModel = new DefaultComboBoxModel();
        this.shelfCB = this.addCB(this.shelfModel, gridBagConstraints, false, jPanel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Slot: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.slotModel = new DefaultComboBoxModel();
        this.slotCB = this.addCB(this.slotModel, gridBagConstraints, false, jPanel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Port: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.portModel = new DefaultComboBoxModel();
        this.portCB = this.addCB(this.portModel, gridBagConstraints, false, jPanel);
        this.initModels();
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    protected PPCCreationInfo getInfo() {
        return ((PPCLinkCreationDialog)this.parent).getInfo();
    }

    private void initModels() {
        RamanDayZeroInfo ramanDayZeroInfo = ((RamanDayZeroDialog)this.parent).getInfo();
        INodeModel iNodeModel = this.getNode();
        IEntityModel[] iEntityModelArray = PPCHelper.getBidiPorts(iNodeModel, ramanDayZeroInfo.getTxpLambdaCurrentTest());
        boolean bl = this.isMultishelf(iNodeModel);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            LinkedList<Object> linkedList;
            IEntityModel iEntityModel = iEntityModelArray[i];
            Integer n = this.getShelfId(iEntityModel);
            if (bl && this.shelfModel.getIndexOf(n) == -1) {
                this.shelfModel.addElement(n);
            }
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            TreeMap<IModuleModel, LinkedList<Object>> treeMap = this.portsMap.get(n);
            if (treeMap == null) {
                treeMap = new TreeMap(new CardComparator());
                this.portsMap.put(n, treeMap);
            }
            if ((linkedList = treeMap.get(iModuleModel)) == null) {
                linkedList = new LinkedList();
                treeMap.put(iModuleModel, linkedList);
            }
            linkedList.add(iEntityModel);
        }
        this.shelfCB.setEnabled(bl);
        if (iEntityModelArray.length > 0) {
            this.loadShelf(this.getShelfId(iEntityModelArray[0]));
        }
    }

    public INodeModel getNode() {
        RamanDayZeroInfo ramanDayZeroInfo = ((RamanDayZeroDialog)this.parent).getInfo();
        return ramanDayZeroInfo.getStartNode().getNode();
    }

    private JComboBox addCB(DefaultComboBoxModel defaultComboBoxModel, GridBagConstraints gridBagConstraints, boolean bl, JPanel jPanel) {
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 160;
                return dimension;
            }
        };
        jComboBox.setRenderer(new CombosCellRenderer(bl));
        jComboBox.addActionListener(this);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jComboBox;
    }

    public CSHelpID getHelpID() {
        return null;
    }

    public JComponent getStatusComponent() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(new String("PAPERINO"));
        return RamanDayZeroDstPane.getGridPanel(arrayList);
    }

    private Integer getShelfId(IEntityModel iEntityModel) {
        if (this.isMultishelf(iEntityModel.getNodeModel())) {
            return iEntityModel.getShelfId();
        }
        return DUMMY_SHELF_ID;
    }

    private boolean isMultishelf(INodeModel iNodeModel) {
        return iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf();
    }

    private void loadShelf(Integer n) {
        this.slotModel.removeAllElements();
        this.portModel.removeAllElements();
        if (n != null) {
            TreeMap<IModuleModel, LinkedList<IEntityModel>> treeMap = this.portsMap.get(n);
            Object[] objectArray = treeMap.keySet().toArray(new IModuleModel[0]);
            this.loadModel(this.slotModel, objectArray);
            this.slotCB.setEnabled(true);
            if (objectArray.length > 0) {
                this.loadSlot((IModuleModel)objectArray[0]);
            }
        } else {
            this.slotCB.setEnabled(false);
            this.portCB.setEnabled(false);
        }
    }

    private void loadModel(DefaultComboBoxModel defaultComboBoxModel, Object[] objectArray) {
        defaultComboBoxModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultComboBoxModel.addElement(objectArray[i]);
        }
    }

    private void loadSlot(IModuleModel iModuleModel) {
        if (iModuleModel != null) {
            Integer n = this.getShelfId((IEntityModel)iModuleModel);
            TreeMap<IModuleModel, LinkedList<IEntityModel>> treeMap = this.portsMap.get(n);
            Object[] objectArray = treeMap.get(iModuleModel).toArray(new IEntityModel[0]);
            this.loadModel(this.portModel, objectArray);
            this.portCB.setEnabled(true);
        } else {
            this.portModel.removeAllElements();
            this.portCB.setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CardComparator
    implements Comparator<IModuleModel> {
        CardComparator() {
        }

        @Override
        public int compare(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            return ComparisonUtil.compare((int)iModuleModel.getSlot(), (int)iModuleModel2.getSlot());
        }
    }
}

