/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.ncp.DataNetworkManager;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitsByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.cms.ui.network.rpr.RprCircuitDataSource;
import cerent.cms.ui.network.rpr.RprTabbedView;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.TableColumnModel;

class RprCircuitsPane
extends AbstractPane
implements Observer {
    private CircuitsTableModel rprCktTableModel;
    private RprCircuitDataSource rprCktSource;
    private DataNetworkManager rprMgr;
    private ColumnRenderer[] columnRenderers = null;
    private UScrollPane scrollPane;
    private boolean inited = false;

    public RprCircuitsPane(TabbedView tabbedView) {
        super("RprCircuitsPane", null, tabbedView);
        this.rprMgr = ((RprTabbedView)tabbedView).rprMap.getRprMgr();
    }

    public void destroy() {
        if (this.inited) {
            this.inited = false;
        }
    }

    public void enteringPage() {
        if (!this.inited) {
            this.rprCktSource = new RprCircuitDataSource(this.rprMgr);
            this.columnRenderers = CircuitColumnRenderer.createTableRenderers(0);
            this.rprCktTableModel = new CircuitsTableModel((RowDataSource)this.rprCktSource, this.columnRenderers, INetCircuit.class);
            this.table = new CircuitsByNameTable(this.rprCktTableModel);
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.inited = true;
        }
        this.reload();
        this.updateColumnWidths();
    }

    protected void reload() {
        this.rprCktSource.reload();
    }

    public synchronized void update(Observable observable, Object object) {
        this.reload();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    private void updateColumnWidths() {
        if (db.on()) {
            db.println(">>> updateColumnWidths()");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            CircuitColumnRenderer circuitColumnRenderer = (CircuitColumnRenderer)this.columnRenderers[i];
            circuitColumnRenderer.setWidth(tableColumnModel.getColumn(i).getPreferredWidth());
        }
    }
}

