/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRprConstants;
import cerent.cms.model.IRprTopoPeer;
import cerent.cms.model.IRprTopoPeers;
import cerent.cms.model.IRprTopoStation;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.ncp.DataNetworkManager;
import cerent.cms.ncp.RPRDeletedException;
import cerent.cms.ncp.RPRException;
import cerent.cms.ncp.RPRInfo;
import cerent.cms.ncp.RprTopoAdapter;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.network.AbstractMap;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetDomainNode;
import cerent.cms.ui.network.NetLinkBundle;
import cerent.cms.ui.network.rpr.RprMapCard;
import cerent.cms.ui.network.rpr.RprMapCardLink;
import cerent.cms.ui.network.rpr.RprMapPort;
import cerent.cms.ui.network.rpr.RprTopoDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.MacAddrFormat;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RprMap
extends AbstractMap
implements Observer,
IRprConstants {
    private static final SDebug dbg = new SDebug("RprMap");
    private RprTopoDialog parent;
    private DataNetworkManager rprMgr;
    private NetworkViewController nvc;
    protected IPortModel selectedPort;
    protected IPortModel defaultUpdatePort;
    protected IRprTopoStation selectedStation;
    protected IRprTopoPeer[] r0TopoPeers;
    protected IRprTopoPeer[] r1TopoPeers;
    private Vector rprLinkKeys = new Vector();
    private boolean wasRprTopologyDeleted = false;

    public RprMap(IMapFactory iMapFactory, RprTopoDialog rprTopoDialog) {
        super(dbg, iMapFactory);
        this.CMD_SAVE_NODE_POSITION = "Save Card Position";
        this.CMD_NODE_RESET_POS = "Reset Card Position";
        this.mapUnit = "card";
        this.onWhichNode = " on which node ";
        this.parent = rprTopoDialog;
        this.rprMgr = rprTopoDialog.rprMgr;
        this.wasRprTopologyDeleted = false;
        this.reInitMapToDetailed();
        this.initializeMap();
        this.setDefaultUpdatePort();
        this.nvc = NetworkViewController.instance();
        if (dbg.on()) {
            dbg.println("RprMap.<init> finished");
        }
    }

    private boolean isAllNodesAlive() {
        for (RPRInfo rPRInfo : this.rprMgr.getRprList()) {
            if (rPRInfo.getSelfEntity().getNodeModel().isInited()) continue;
            return false;
        }
        return true;
    }

    private void clearDefaultUpdatePort() {
        if (this.defaultUpdatePort != null) {
            try {
                IInterfaceModel iInterfaceModel = this.defaultUpdatePort.getInterfaceModel();
                if (iInterfaceModel != null) {
                    ModelIndirectObservable.instance().deleteObserver((IObservable)iInterfaceModel, this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.defaultUpdatePort = null;
        }
    }

    private void setDefaultUpdatePort() {
        if (this.defaultUpdatePort != null) {
            return;
        }
        LinkedList linkedList = this.rprMgr.getRprList();
        if (!linkedList.isEmpty()) {
            boolean bl = false;
            Iterator iterator = linkedList.iterator();
            while (!bl && iterator.hasNext()) {
                IInterfaceModel iInterfaceModel;
                RPRInfo rPRInfo = (RPRInfo)iterator.next();
                this.defaultUpdatePort = rPRInfo.getSelfEntity();
                if (this.defaultUpdatePort == null || (iInterfaceModel = this.defaultUpdatePort.getInterfaceModel()) == null) continue;
                ModelIndirectObservable.instance().addObserver((IObservable)iInterfaceModel, this);
                bl = true;
            }
        }
    }

    protected void reloadRPR(boolean bl) {
        try {
            this.rprMgr.getRPRRing();
        }
        catch (RPRDeletedException rPRDeletedException) {
            if (!this.wasRprTopologyDeleted) {
                this.wasRprTopologyDeleted = true;
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RPR_EXCEPTION_PARAM_1, (Object)rPRDeletedException.getMessage());
                this.parent.rprTopologyDeleted();
            }
            return;
        }
        catch (RPRException rPRException) {
            if (!bl) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RPR_EXCEPTION_PARAM_1, (Object)rPRException.getMessage());
            } else if (dbg.on()) {
                dbg.println("Exception caught in reloadRPR - error message suppressed for update processing.");
                SDebug.printStackTrace((Throwable)rPRException);
            }
            return;
        }
        if (!this.isAllNodesAlive()) {
            if (!bl) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RPR_EXCEPTION_PARAM_1, (Object)"Each Chassis in the RPR topology needs to be alive");
            } else if (dbg.on()) {
                dbg.println("All nodes not alive detected in reloadRPR - error message suppressed for update processing.");
            }
            return;
        }
        this.reInitMapToDetailed();
        this.initializeMap();
        if (this.selectedPort != null) {
            if (this.isPortInRPR(this.selectedPort)) {
                this.loadRprTopo(this.selectedPort, bl);
                this.displayRprTopo(bl);
            } else {
                this.clearRprTopo();
                this.setDefaultUpdatePort();
            }
        } else if (this.defaultUpdatePort != null && !this.isPortInRPR(this.defaultUpdatePort)) {
            this.clearDefaultUpdatePort();
            this.setDefaultUpdatePort();
        }
    }

    protected DataNetworkManager getRprMgr() {
        return this.rprMgr;
    }

    protected void initializeMap() {
        for (RPRInfo rPRInfo : this.rprMgr.getRprList()) {
            this.addNode(rPRInfo.getSelfEntity(), rPRInfo.getSelfMac());
        }
        this.initializeMapLinks();
    }

    protected synchronized MapNode addNode(IPortModel iPortModel, Object object) {
        IModuleModel iModuleModel = (IModuleModel)iPortModel.getParent();
        INodeModel iNodeModel = iPortModel.getNodeModel();
        MapNode mapNode = this.getMapNode(iModuleModel);
        if (mapNode != null) {
            if (RprMap.dbg.on) {
                dbg.println("addNode: node=" + iNodeModel.getName() + " slot number=" + iPortModel.getSlot() + " already exists.");
            }
            return mapNode;
        }
        Point2D.Double double_ = RprMapCard.getPositionXY(this, iModuleModel);
        mapNode = super.addNode(iModuleModel, MapPersist.getNodeDomain(iNodeModel), double_.getX(), double_.getY(), object);
        if (mapNode == null) {
            if (RprMap.dbg.on) {
                dbg.println("addNode: fail to add " + iNodeModel.getName() + " slot " + iPortModel.getSlot());
            }
        } else if (RprMap.dbg.on) {
            dbg.println("addNode: " + iNodeModel.getName() + " slot " + iPortModel.getSlot() + " added to map");
        }
        return mapNode;
    }

    public boolean isPortInRPR(IPortModel iPortModel) {
        boolean bl = false;
        if (iPortModel != null) {
            LinkedList linkedList = this.rprMgr.getRprList();
            Iterator iterator = linkedList.iterator();
            while (!bl && iterator.hasNext()) {
                RPRInfo rPRInfo = (RPRInfo)iterator.next();
                if (rPRInfo.getEastEntity() != iPortModel && rPRInfo.getWestEntity() != iPortModel) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof IInterfaceModel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RprMap.this.reloadRPR(true);
                    if (!RprMap.this.wasRprTopologyDeleted) {
                        RprMap.this.parent.reloadRprState();
                        RprMap.this.parent.reloadRprCircuits();
                    }
                }
            });
        }
    }

    public void dispose() {
        if (dbg.on()) {
            dbg.println("dispose");
        }
        this.clearRprTopo();
        this.clearDefaultUpdatePort();
        super.destroy();
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (!this.isRootGraph()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Go To Parent View", 71);
            uPopupMenu.addSeparator();
        }
        this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_in16.gif", "Zoom In", 73);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_out16.gif", "Zoom Out", 79);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Reset Zoom", 90);
        this.actOrg.getAbstractButton("Reset Zoom").setEnabled(this.getZoomCount() != 0);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Center View", 67);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Fit Content to View", 70);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Auto Layout...", 76);
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, this.CMD_SAVE_NODE_POSITION, 80);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, this.CMD_NODE_RESET_POS, 82);
    }

    protected void initializeMapLinks() {
        for (RPRInfo rPRInfo : this.rprMgr.getRprList()) {
            if (rPRInfo.getEastEntity() == null) continue;
            IModuleModel iModuleModel = (IModuleModel)rPRInfo.getSelfEntity().getParent();
            IModuleModel iModuleModel2 = (IModuleModel)rPRInfo.getEastEntity().getParent();
            RprMapCardLink rprMapCardLink = (RprMapCardLink)this.addLink(rPRInfo, iModuleModel, iModuleModel2, null, null);
            rprMapCardLink.setState(0);
        }
    }

    private void loadRprTopo(IPortModel iPortModel, boolean bl) {
        block3: {
            try {
                this.selectedStation = RprTopoAdapter.getRprTopoStation(iPortModel.getEntityIndex(), iPortModel.getNodeModel(), (IEntityModel)iPortModel);
                IRprTopoPeers iRprTopoPeers = RprTopoAdapter.getRprTopoPeers(iPortModel.getEntityIndex(), iPortModel.getNodeModel(), (IEntityModel)iPortModel);
                this.r0TopoPeers = iRprTopoPeers.getRinglet0Peers();
                this.r1TopoPeers = iRprTopoPeers.getRinglet1Peers();
            }
            catch (Exception exception) {
                if (!bl) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RPR_EXCEPTION_PARAM_1, (Object)exception.getMessage());
                }
                if (!dbg.on()) break block3;
                dbg.println("Exception caught in loadRprTopo - error message suppressed for update processing.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private RprMapCard getRprMapCard(IEtherMacAddr iEtherMacAddr) {
        MapNode[] mapNodeArray = this.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            RprMapCard rprMapCard = (RprMapCard)mapNodeArray[i];
            IEtherMacAddr iEtherMacAddr2 = (IEtherMacAddr)rprMapCard.getUserCookie();
            if (iEtherMacAddr2 == null || !MacAddrFormat.format(iEtherMacAddr2.getAddr()).equals(MacAddrFormat.format(iEtherMacAddr.getAddr()))) continue;
            return rprMapCard;
        }
        return null;
    }

    private void setPortStatus(IRprTopoPeer iRprTopoPeer, boolean bl) {
        RprMapCard rprMapCard = this.getRprMapCard(iRprTopoPeer.getMacAddr());
        if (rprMapCard == null) {
            dbg.severe("Alert: MAC address in rpr topology does not exist in circuit topo: " + MacAddrFormat.format(iRprTopoPeer.getMacAddr().getAddr()));
        } else {
            char c;
            char c2;
            RprMapPort rprMapPort = rprMapCard.getEastMapPort();
            RprMapPort rprMapPort2 = rprMapCard.getWestMapPort();
            if (this.selectedStation.isRingClosed()) {
                c2 = this.getProtChar(iRprTopoPeer.getProtStatus()[1]);
                c = this.getProtChar(iRprTopoPeer.getProtStatus()[0]);
            } else {
                RprMapPort rprMapPort3 = rprMapPort;
                if (rprMapPort3 == null) {
                    rprMapPort3 = rprMapPort2;
                }
                int[] nArray = this.getProtValue(rprMapPort3, bl);
                c2 = this.getProtChar(nArray[1]);
                c = this.getProtChar(nArray[0]);
            }
            if (rprMapPort != null) {
                rprMapPort.setLetter(c2);
            }
            if (rprMapPort2 != null) {
                rprMapPort2.setLetter(c);
            }
        }
    }

    private int[] getProtValue(RprMapPort rprMapPort, boolean bl) {
        int[] nArray = new int[2];
        IPortModel iPortModel = (IPortModel)rprMapPort.getUserObject();
        try {
            IRprTopoStation iRprTopoStation = RprTopoAdapter.getRprTopoStation(iPortModel.getEntityIndex(), iPortModel.getNodeModel(), (IEntityModel)iPortModel);
            int[] nArray2 = iRprTopoStation.getSelfRequests();
            int[] nArray3 = iRprTopoStation.getRemoteRequests();
            nArray[1] = nArray2[1] | nArray3[1];
            nArray[0] = nArray2[0] | nArray3[0];
        }
        catch (Exception exception) {
            if (!bl) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RPR_EXCEPTION_PARAM_1, (Object)exception.getMessage());
            } else if (dbg.on()) {
                dbg.println("Exception caught in getProtValue - error message suppressed for update processing.");
                SDebug.printStackTrace((Throwable)exception);
            }
            nArray[1] = 0;
            nArray[0] = 0;
        }
        return nArray;
    }

    private void clearPortStatus() {
        MapNode[] mapNodeArray = this.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            RprMapCard rprMapCard = (RprMapCard)mapNodeArray[i];
            RprMapPort rprMapPort = rprMapCard.getEastMapPort();
            if (rprMapPort != null) {
                rprMapPort.setLetter(' ');
            }
            if ((rprMapPort = rprMapCard.getWestMapPort()) == null) continue;
            rprMapPort.setLetter(' ');
        }
    }

    private char getProtChar(int n) {
        switch (n) {
            case 0: {
                return 'I';
            }
            case 1: {
                return 'W';
            }
            case 2: {
                return 'M';
            }
            case 3: {
                return 'D';
            }
            case 4: {
                return 'S';
            }
            case 5: {
                return 'F';
            }
        }
        return ' ';
    }

    protected void displayRprTopo(boolean bl) {
        int n;
        if (this.r0TopoPeers == null || this.r1TopoPeers == null) {
            return;
        }
        if (this.r0TopoPeers.length >= 1) {
            for (n = 0; n < this.r0TopoPeers.length - 1; ++n) {
                this.addRprMapLink(this.r0TopoPeers[n + 1].getMacAddr(), this.r0TopoPeers[n].getMacAddr(), 0, bl);
            }
            for (n = 0; n < this.r0TopoPeers.length; ++n) {
                this.setPortStatus(this.r0TopoPeers[n], bl);
            }
        }
        if (this.r1TopoPeers.length >= 1) {
            for (n = 0; n < this.r1TopoPeers.length - 1; ++n) {
                this.addRprMapLink(this.r1TopoPeers[n].getMacAddr(), this.r1TopoPeers[n + 1].getMacAddr(), 1, bl);
            }
            for (n = 1; n < this.r1TopoPeers.length; ++n) {
                this.setPortStatus(this.r1TopoPeers[n], bl);
            }
        }
    }

    protected void drawRprTopo(IPortModel iPortModel) {
        this.clearRprTopo();
        this.clearDefaultUpdatePort();
        this.selectedPort = iPortModel;
        IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
        if (iInterfaceModel != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)iInterfaceModel, this);
        }
        this.loadRprTopo(iPortModel, false);
        this.displayRprTopo(false);
        this.parent.reloadRprState();
    }

    private void addRprMapLink(IEtherMacAddr iEtherMacAddr, IEtherMacAddr iEtherMacAddr2, int n, boolean bl) {
        if (MacAddrFormat.format(iEtherMacAddr.getAddr()).equals(MacAddrFormat.format(iEtherMacAddr2.getAddr()))) {
            return;
        }
        for (RPRInfo rPRInfo : this.rprMgr.getRprList()) {
            RprMapCardLink rprMapCardLink;
            IEtherMacAddr iEtherMacAddr3 = rPRInfo.getEastMac();
            IEtherMacAddr iEtherMacAddr4 = rPRInfo.getSelfMac();
            if (iEtherMacAddr3 == null || iEtherMacAddr4 == null || !MacAddrFormat.format(iEtherMacAddr3.getAddr()).equals(MacAddrFormat.format(iEtherMacAddr2.getAddr())) || !MacAddrFormat.format(iEtherMacAddr4.getAddr()).equals(MacAddrFormat.format(iEtherMacAddr.getAddr())) || (rprMapCardLink = (RprMapCardLink)this.getMapLink(rPRInfo)) == null) continue;
            if (n == 0) {
                rprMapCardLink.addR0LinkStyle();
            } else if (n == 1) {
                if (rprMapCardLink.hasR0LinkStyle()) {
                    rprMapCardLink.removeRprStyle();
                    rprMapCardLink.addR01LinkStyle();
                } else {
                    rprMapCardLink.addR1LinkStyle();
                }
            }
            return;
        }
        this.addRprOnlyLink(iEtherMacAddr, iEtherMacAddr2, n, bl);
    }

    private IPortModel getRprPort(IEtherMacAddr iEtherMacAddr) {
        for (RPRInfo rPRInfo : this.rprMgr.getRprList()) {
            if (rPRInfo.getSelfMac() == null || !MacAddrFormat.format(iEtherMacAddr.getAddr()).equals(MacAddrFormat.format(rPRInfo.getSelfMac().getAddr()))) continue;
            return rPRInfo.getSelfEntity();
        }
        return null;
    }

    private void addRprOnlyLink(IEtherMacAddr iEtherMacAddr, IEtherMacAddr iEtherMacAddr2, int n, boolean bl) {
        RprMapCardLink rprMapCardLink;
        IPortModel iPortModel = this.getRprPort(iEtherMacAddr);
        IPortModel iPortModel2 = this.getRprPort(iEtherMacAddr2);
        int n2 = iPortModel2.getModuleModel().getEqType();
        int n3 = n2 == 285 ? 165 : 105;
        List list = iPortModel2.getModuleModel().getDescendantsOfEqType(n3);
        IPortModel iPortModel3 = (IPortModel)list.get(1);
        if (iPortModel == null || iPortModel3 == null) {
            if (!bl) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RPR_EXCEPTION_PARAM_1, (Object)"The node is not active or is in pass-through mode.");
            } else if (dbg.on()) {
                dbg.println("Node is not active or is in pass-through mode detected in addRprOnlyLink - error message suppressed for update processing.");
            }
            return;
        }
        IModuleModel iModuleModel = (IModuleModel)iPortModel.getParent();
        IModuleModel iModuleModel2 = (IModuleModel)iPortModel3.getParent();
        RPRInfo rPRInfo = null;
        for (int i = 0; i < this.rprLinkKeys.size(); ++i) {
            RPRInfo rPRInfo2 = (RPRInfo)this.rprLinkKeys.get(i);
            if (!MacAddrFormat.format(iEtherMacAddr.getAddr()).equals(MacAddrFormat.format(rPRInfo2.getSelfMac().getAddr())) || !MacAddrFormat.format(iEtherMacAddr2.getAddr()).equals(MacAddrFormat.format(rPRInfo2.getEastMac().getAddr()))) continue;
            rPRInfo = rPRInfo2;
            break;
        }
        if (rPRInfo == null) {
            rPRInfo = new RPRInfo(iPortModel, iPortModel3, null, iEtherMacAddr, iEtherMacAddr2, null, null, null);
        }
        if ((rprMapCardLink = (RprMapCardLink)this.getMapLink(rPRInfo)) == null) {
            rprMapCardLink = (RprMapCardLink)this.addLink(rPRInfo, iModuleModel, iModuleModel2, null, null);
            this.rprLinkKeys.add(rPRInfo);
            rprMapCardLink.setState(0);
            rprMapCardLink.clearStyles();
            if (n == 0) {
                rprMapCardLink.addR0LinkStyle();
            } else if (n == 1) {
                rprMapCardLink.addR1LinkStyle();
            }
        } else {
            rprMapCardLink.removeRprStyle();
            rprMapCardLink.addR01LinkStyle();
        }
    }

    protected void clearRprTopo() {
        this.selectedStation = null;
        if (this.selectedPort != null) {
            try {
                IInterfaceModel iInterfaceModel = this.selectedPort.getInterfaceModel();
                if (iInterfaceModel != null) {
                    ModelIndirectObservable.instance().deleteObserver((IObservable)iInterfaceModel, this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selectedPort = null;
        this.r0TopoPeers = null;
        this.r1TopoPeers = null;
        for (RPRInfo rPRInfo : this.rprMgr.getRprList()) {
            RprMapCardLink rprMapCardLink = (RprMapCardLink)this.getMapLink(rPRInfo);
            if (rprMapCardLink == null || !rprMapCardLink.hasRprStyle()) continue;
            rprMapCardLink.removeRprStyle();
        }
        for (int i = 0; i < this.rprLinkKeys.size(); ++i) {
            this.deleteLink(this.rprLinkKeys.get(i));
        }
        this.rprLinkKeys.clear();
        this.clearPortStatus();
    }

    protected void doubleClicked(MapNode mapNode) {
        if (mapNode == null) {
            return;
        }
        IModuleModel iModuleModel = (IModuleModel)mapNode.getUserObject();
        INodeModel iNodeModel = iModuleModel.getNodeModel();
        int n = 0;
        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            n = iModuleModel.getShelfId();
        }
        ViewName viewName = new ViewName(new int[]{iNodeModel.getNodeId(), n, iModuleModel.getSlot()});
        this.nvc.tryJumpView(viewName);
    }

    protected void doubleClicked(MapDomain mapDomain) {
        super.doubleClicked(mapDomain);
    }

    protected MapLinkBundle createLinkBundle(Node node, Node node2, String string, int n) {
        return new NetLinkBundle(this, node, node2, string, n);
    }

    public boolean getMapProperty(Object object, int n) {
        if (n == 101) {
            return MapPersist.getPersistProperty(object, n);
        }
        return false;
    }

    public void mapPropertyChanged(Object object, int n, String string, String string2) {
        if (n == 101) {
            this.saveNodeCoordinatesToCache((Node)object);
            MapPersist.setPersistProperty(object, n, string, string2);
        }
    }

    public MapDomain createDomain(Object object) {
        return new NetDomainNode(this);
    }

    private void doOpenDomain(MapDomain mapDomain) {
        super.displayDomain(mapDomain);
    }

    protected void doGoToRootGraph() {
        super.doGoToRootGraph();
    }

    protected void doGoToNodeDomain(MapNode mapNode) {
        super.doGoToNodeDomain(mapNode);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CMD_SAVE_NODE_POSITION) {
            this.doSaveNodePositions();
        } else if (string == this.CMD_NODE_RESET_POS) {
            this.doResetNodePosition();
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

