/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.NodeModel;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.ohcircuits.OhNodeSelector;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IpTunnelRepairDialog
extends WizardDialog
implements ProgressDialogControl {
    static final String TITLE = "Ip Tunnel Repair";
    static final String PREAMBLE = "Background";
    static final String GATHER = "Node Address";
    static final String PROCESS = "Repair IP Tunnels";
    public static String IP_STRING = "IP";
    public static String NEW_STRING = "NEW";
    private GatherPane gatherPane;
    private NodeModel node;
    private String oldIpAddr;
    private String currentIpAddr;
    private static final SDebug db = new SDebug("IpTunnelRepairDialog");

    public IpTunnelRepairDialog(Frame frame) {
        super(frame, TITLE, false);
        this.reset(true);
        this.createPages();
        this.setLocationRelativeTo(frame);
    }

    private void createPages() {
        this.addPage(new PreamblePane());
        this.gatherPane = new GatherPane();
        this.addPage(this.gatherPane);
        this.addPage(new ProcessPane());
    }

    private void reset(boolean bl) {
        this.setSize(new Dimension(550, 350));
        this.invalidate();
        this.setFinishEnabled(false);
    }

    public void apply() throws Exception {
        ProgressDialog.start(this, "IP Tunnel Repair", "IP tunnels are being repaired. Please wait...", this, 2000, 20, false);
    }

    public void handleCancel() {
        this.reset();
    }

    public void handleFinish() {
        this.reset();
        super.handleFinish();
    }

    public void reset() {
        this.showPage(PREAMBLE, false);
        if (this.gatherPane != null) {
            this.gatherPane.reset();
        }
    }

    public void setNode(NodeModel nodeModel) {
        this.node = nodeModel;
    }

    public void setOldIpAddr(String string) {
        this.oldIpAddr = string;
    }

    public void setCurrentIpAddr(String string) throws NumberFormatException {
        this.currentIpAddr = string;
    }

    public void repairCircuits(String string, String string2) throws CircuitProvError {
        if (db.on()) {
            db.println("repairCircuits: oldNodeIp = " + string + " newNodeIp = " + string2);
        }
        if (string == null || string2 == null) {
            throw new CircuitProvError(" Invalid Parameter ");
        }
        OhCircuitManager.instance().repairIpTunnels(this.node, string, string2);
    }

    public void executeTask(Observer observer) throws Exception {
        observer.update(null, "Circuits are being repaired.  Please wait...");
        OhCircuitManager.instance().repairIpTunnels(this.node, this.oldIpAddr, this.currentIpAddr);
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        String string = exception == null ? "The IP Tunnel repair completed." : "The IP Tunnel repair failed.\n" + exception.getMessage();
        return new ProgressDialogResult(string);
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return false;
    }

    class ProcessPane
    extends WizardPane {
        JTextArea confirmText;

        ProcessPane() {
            super(IpTunnelRepairDialog.PROCESS, IpTunnelRepairDialog.this);
            this.setLayout(new BorderLayout(5, 5));
            this.confirmText = new JTextArea("");
            this.add(this.confirmText, "Center");
        }

        public void validatePage() throws Exception {
        }

        public void refresh() {
            String string = "CTC is ready to repair circuits due to the change of the node " + IpTunnelRepairDialog.this.node.getName() + "'s Node address\n" + "from " + IpTunnelRepairDialog.this.oldIpAddr + " to " + IpTunnelRepairDialog.this.currentIpAddr + ".\n" + "\nOnce the repair is complete, you can find any remaining partial" + "\nIP tunnel circuits in the overhead circuit table if you sort it by circuit state.";
            this.confirmText.setText(string);
        }

        public void leavingPage() throws Exception {
            IpTunnelRepairDialog.this.setNextEnabled(false);
            IpTunnelRepairDialog.this.setFinishEnabled(false);
        }

        public void enteringPage() {
            IpTunnelRepairDialog.this.setFinishEnabled(true);
            IpTunnelRepairDialog.this.setNextEnabled(false);
        }
    }

    class GatherPane
    extends WizardPane
    implements ActionListener {
        private OhNodeSelector nodeCB;
        private JTextField oldIpTF;
        private JTextField currentIpTF;

        GatherPane() {
            super(IpTunnelRepairDialog.GATHER, IpTunnelRepairDialog.this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 2, 5, 5));
            this.createNodePanel(jPanel, "Node");
            this.currentIpTF = this.createIpPanel(jPanel, "Current Node Address", false);
            this.oldIpTF = this.createIpPanel(jPanel, "Old Node Address", false);
            this.add(jPanel);
        }

        void reset() {
            this.nodeCB.setSelectedItem(null);
            this.oldIpTF.setText("");
            this.currentIpTF.setText("");
        }

        private void createNodePanel(JPanel jPanel, String string) {
            jPanel.add(new JLabel(string + ": ", 4));
            this.nodeCB = new OhNodeSelector(6);
            jPanel.add(this.nodeCB);
            this.nodeCB.setSelectedItem(null);
            this.nodeCB.addActionListener(this);
        }

        private JTextField createIpPanel(JPanel jPanel, String string, boolean bl) {
            JTextField jTextField = new JTextField();
            if (bl) {
                jTextField.setEditable(false);
            }
            jPanel.add(new JLabel(string + ": ", 4));
            jPanel.add(jTextField);
            return jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IpTunnelRepairDialog.this.setNode((NodeModel)this.nodeCB.getSelectedItem());
            this.checkNodeState();
        }

        private void checkNodeState() {
            if (IpTunnelRepairDialog.this.node != null) {
                boolean bl = IpTunnelRepairDialog.this.node.getConnectionState();
                if (bl) {
                    IIpAddr iIpAddr = IpTunnelRepairDialog.this.node.getIpConfig().getIpAddress();
                    String string = InetUtil.makeDottedString(iIpAddr);
                    this.currentIpTF.setText(string);
                    IpTunnelRepairDialog.this.setNextEnabled(true);
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_IPTUNNEL_NODE_DISCONNECT);
                    IpTunnelRepairDialog.this.setNextEnabled(false);
                }
            }
        }

        public void validatePage() throws Exception {
            if (IpTunnelRepairDialog.this.node == null) {
                throw new Exception("Please select a Node");
            }
            if (!IpTunnelRepairDialog.this.node.getConnectionState()) {
                throw new Exception("The node is disconnected.\nPlease try later");
            }
            IIpAddr iIpAddr = IpTunnelRepairDialog.this.node.getIpConfig().getIpAddress();
            String string = InetUtil.makeDottedString(iIpAddr);
            if (this.currentIpTF.getText() == null) {
                throw new Exception("Please specify a value for the current IP address of the node.");
            }
            try {
                IpTunnelRepairDialog.this.setCurrentIpAddr(this.currentIpTF.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The current IP adress is invalid.");
            }
            if (!string.equals(IpTunnelRepairDialog.this.currentIpAddr)) {
                throw new Exception("The current IP address \"" + IpTunnelRepairDialog.this.currentIpAddr + "\" does not match node's IP address \"" + string + "\".");
            }
            if (this.oldIpTF == null) {
                throw new Exception("Please enter a value for the old Node Address for the node");
            }
            try {
                IpTunnelRepairDialog.this.setOldIpAddr(this.oldIpTF.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The old IP address is invalid.");
            }
            if (IpTunnelRepairDialog.this.oldIpAddr.equals(IpTunnelRepairDialog.this.currentIpAddr)) {
                throw new Exception("The old IP Address \"" + IpTunnelRepairDialog.this.oldIpAddr + "\" is identical to current IP address \"" + IpTunnelRepairDialog.this.currentIpAddr + "\".");
            }
            NetElement netElement = (NetElement)Network.instance().findNetElemByIp(IpTunnelRepairDialog.this.oldIpAddr);
            if (netElement != null) {
                throw new Exception("The node with the old IP address \"" + netElement.getNodeModel().getName() + "\" is still in the network.");
            }
        }

        public void refresh() {
        }
    }

    class PreamblePane
    extends WizardPane {
        private final String preamble = "<html><body><p> IP Tunnel repair fixes circuits stuck in the <b>PARTIAL</b> state due to changes in a node address. </p><p>Before you continue, ensure you have done the following:<ol><li>Obtain the old Node address of the node in question. </li><li>Wait until circuit discovery is complete:  Refer to the CKT annunciator in the status bar - a gray background indicates circuit discovery is complete.  (IP Tunnels in need of repair will remain in the PARTIAL state.)</li></ol></p><p>If you have not completed all of these steps, the tunnel repair will not succeed.</p></body></html>";

        PreamblePane() {
            super(IpTunnelRepairDialog.PREAMBLE, IpTunnelRepairDialog.this);
            this.preamble = "<html><body><p> IP Tunnel repair fixes circuits stuck in the <b>PARTIAL</b> state due to changes in a node address. </p><p>Before you continue, ensure you have done the following:<ol><li>Obtain the old Node address of the node in question. </li><li>Wait until circuit discovery is complete:  Refer to the CKT annunciator in the status bar - a gray background indicates circuit discovery is complete.  (IP Tunnels in need of repair will remain in the PARTIAL state.)</li></ol></p><p>If you have not completed all of these steps, the tunnel repair will not succeed.</p></body></html>";
            this.setLayout(new BorderLayout(5, 5));
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body><p> IP Tunnel repair fixes circuits stuck in the <b>PARTIAL</b> state due to changes in a node address. </p><p>Before you continue, ensure you have done the following:<ol><li>Obtain the old Node address of the node in question. </li><li>Wait until circuit discovery is complete:  Refer to the CKT annunciator in the status bar - a gray background indicates circuit discovery is complete.  (IP Tunnels in need of repair will remain in the PARTIAL state.)</li></ol></p><p>If you have not completed all of these steps, the tunnel repair will not succeed.</p></body></html>");
            jEditorPane.setEditable(false);
            this.add((Component)new UScrollPane((Component)jEditorPane), "Center");
        }

        public void validatePage() throws Exception {
        }

        public void refresh() {
        }
    }
}

