/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PCMCoding;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ohcircuits.OhNetCircuitModel;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OwCircuit;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.NodeCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ohcircuits.OhCircuitCreationDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DualListModel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OhCedOwPane
extends NetworkProvPane
implements ActionListener,
ListDataListener {
    private OhCircuit curCircuit;
    private static final String EXISTING_DEST = "Existing Destinations";
    private static final String AVAIL_DEST = "Available Destinations";
    private UComboBox pcmCB;
    private boolean pcmChanged;
    private JButton removeDestPB = new JButton(">> (Remove Destinations)");
    private JButton addDestPB = new JButton("<< (Add Destinations)");
    private JList destNodes = new JList();
    private JList availableNodes = new JList();
    private ListCellRenderer cellRenderer;
    private DualListModel listsModel = new DualListModel(this.destNodes, this.availableNodes, null, null, this.removeDestPB, this.addDestPB, 0);
    private boolean destinationsChanged;
    private List oldDestinations;
    private static final int LIST_ROW_COUNT = 6;
    private static final SDebug db = new SDebug("OhCedOwPane");

    public OhCedOwPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        OhNetCircuitModel ohNetCircuitModel = (OhNetCircuitModel)tabbedView.getUiModel();
        this.curCircuit = ohNetCircuitModel.getOhCircuit();
        this.curCircuit.addObserver((Observer)((Object)this));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.cellRenderer = new NodeCellRenderer();
        JPanel jPanel2 = this.getAttributesPanel();
        jPanel.add((Component)jPanel2, "Center");
        if (this.curCircuit instanceof OwCircuit && this.curCircuit.isComplete() && this.curCircuit.isTerm2TermCircuit() && !this.curCircuit.getSource().equals(this.curCircuit.getFirstDestination())) {
            jPanel.add((Component)this.getDestinationsPanel(), "South");
        }
        this.setEnabled(this.isUserAuthorized());
        this.add(jPanel);
        this.listsModel.addListDataListener(this);
        this.setLists();
        this.pcmChanged = false;
        this.destinationsChanged = false;
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage");
        }
        super.enteringPage();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pcmCB) {
            this.setPCMChanged(true);
        }
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage: deleting observer");
        }
        super.leavingPage();
    }

    private List getNodeModels(Set set) {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((INetElement)iterator.next()).getNodeModel());
        }
        return arrayList;
    }

    private void setLists() {
        Network network = Network.instance();
        NetElemComparator netElemComparator = new NetElemComparator();
        TreeSet treeSet = new TreeSet(netElemComparator);
        treeSet.addAll(network.getElements());
        if (this.curCircuit != null) {
            INetElement iNetElement = network.getNetElem(this.curCircuit.getSource().getNodeId());
            treeSet.remove(iNetElement);
            TreeSet<INetElement> treeSet2 = new TreeSet<INetElement>(netElemComparator);
            Object object = this.curCircuit.getDestinations().iterator();
            while (object.hasNext()) {
                int n = ((IOhCircuitEnd)object.next()).getNodeId();
                treeSet2.add(network.getNetElem(n));
            }
            treeSet.removeAll(treeSet2);
            object = treeSet.iterator();
            while (object.hasNext()) {
                INodeModel iNodeModel = ((INetElement)object.next()).getNodeModel();
                if (!iNodeModel.provides(Feature.AICI)) {
                    object.remove();
                    continue;
                }
                Set set = iNodeModel.getOhConnectionModels().getAvailAicPorts(this.curCircuit.getCircuitTypeObj());
                if (set != null && !set.isEmpty()) continue;
                object.remove();
            }
            object = this.getNodeModels(treeSet);
            this.oldDestinations = this.getNodeModels(treeSet2);
            this.listsModel.setContent(this.oldDestinations, this.getNodeModels(treeSet));
        } else {
            this.listsModel.setContent(null, null);
        }
    }

    public void setEnabled(boolean bl) {
        this.listsModel.setEnabled(bl);
        this.pcmCB.setEnabled(bl);
        super.setEnabled(bl);
    }

    private JPanel getAttributesPanel() {
        JPanel jPanel = AbstractPane.createVerticalPanel("Attributes");
        if (this.curCircuit.isComplete() && this.curCircuit instanceof OwCircuit && ((OwCircuit)this.curCircuit).haveTerminationsInCircuit()) {
            jPanel.add(Box.createVerticalStrut(5));
            JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
            jPanel2.setAlignmentX(0.0f);
            jPanel2.add(new JLabel("PCM:  "));
            this.pcmCB = new UComboBox((Object[])PCMCoding.getAllPCMCodings());
            jPanel2.add((Component)this.pcmCB);
            jPanel2.add(Box.createHorizontalStrut(354));
            jPanel.add(jPanel2);
        }
        return jPanel;
    }

    private void setPcmCB() {
        this.pcmCB.removeActionListener((ActionListener)this);
        this.pcmCB.setSelectedIndex(((OwCircuit)this.curCircuit).getCircuitPCMCoding());
        this.pcmCB.addActionListener((ActionListener)this);
    }

    private JPanel getDestinationsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createAttrsPanel(), "Center");
        return jPanel;
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = AbstractPane.createHorizontalPanel(null);
        JPanel jPanel2 = AbstractPane.createVerticalPanel(EXISTING_DEST);
        jPanel2.add(this.configureList(this.destNodes));
        jPanel.add(jPanel2);
        jPanel2 = AbstractPane.createVerticalPanel(null);
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(this.removeDestPB);
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(this.addDestPB);
        jPanel2.add(Box.createVerticalGlue());
        jPanel.add(jPanel2);
        jPanel2 = AbstractPane.createVerticalPanel(AVAIL_DEST);
        jPanel2.add(this.configureList(this.availableNodes));
        jPanel.add(jPanel2);
        return jPanel;
    }

    private Component configureList(JList jList) {
        jList.setCellRenderer(this.cellRenderer);
        jList.setPrototypeCellValue("                                ");
        jList.setVisibleRowCount(6);
        return new UScrollPane((Component)jList);
    }

    private void setDestinationsChanged(boolean bl) {
        if (bl) {
            this.setDirty();
        }
        this.destinationsChanged = bl;
    }

    public void setCircuit(OhCircuit ohCircuit) {
        this.curCircuit = ohCircuit;
    }

    void reset() {
        if (OhCedOwPane.db.on) {
            db.println("reset");
        }
        this.listsModel.setContent(null, null);
    }

    public void validatePage() throws Exception {
        Object object;
        try {
            if (this.destinationsChanged) {
                object = this.listsModel.getSrcContent();
                HashSet hashSet = new HashSet(object);
                HashSet hashSet2 = new HashSet(this.oldDestinations);
                HashSet hashSet3 = new HashSet(hashSet2);
                hashSet3.removeAll(hashSet);
                HashSet hashSet4 = new HashSet(hashSet);
                hashSet4.removeAll(hashSet2);
                if (db.on()) {
                    db.fine("deletedNodes=" + hashSet3 + ", addedNodes=" + hashSet4);
                }
                if (!hashSet3.isEmpty()) {
                    if (hashSet3.size() == this.curCircuit.getDestinations().size()) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_DELETE_ALL_DESTINATIONS);
                        return;
                    }
                    ((OwCircuit)this.curCircuit).deleteDestinations(hashSet3);
                }
                if (!hashSet4.isEmpty()) {
                    int n = ((OwCircuit)this.curCircuit).getCircuitPCMCoding();
                    ((OwCircuit)this.curCircuit).addDestinations(hashSet4);
                    int n2 = ((OwCircuit)this.curCircuit).getCircuitPCMCoding();
                    if (n2 != n) {
                        OhCircuitCreationDialog.notifyPCMCodingChange((Component)((Object)this), n, n2);
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_UPDATING_DESTINATIONS);
        }
        if (this.pcmChanged) {
            object = (OwCircuit)this.curCircuit;
            int n = ((OwCircuit)object).getCircuitPCMCoding();
            int n3 = this.pcmCB.getSelectedIndex();
            if (n3 != n) {
                if (((OwCircuit)object).supportPCMCoding(n3)) {
                    ((OwCircuit)object).changeCircuitPCMCoding(n3);
                } else {
                    CerentDialog.infoDialog((Component)((Object)this), (String)"The circuit's PCM coding cannot changed because some node  does not support it. ", (String)"Change PCM Coding");
                }
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setDestinationsChanged(true);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setDestinationsChanged(true);
    }

    private void setPCMChanged(boolean bl) {
        if (bl) {
            this.setDirty();
        }
        this.pcmChanged = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        this.listsModel.removeListDataListener(this);
        OhCedOwPane ohCedOwPane = this;
        synchronized (ohCedOwPane) {
            this.curCircuit.deleteObserver((Observer)((Object)this));
            this.curCircuit = null;
        }
        super.destroy();
    }

    public void applyChangesToModel() throws Exception {
        block4: {
            if (db.on()) {
                db.println("applyChangesToModel: start");
            }
            try {
                this.validatePage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("applyChangesToModel: finish");
            }
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        this.updateInfo();
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof OhCircuit && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.requestRefresh(this, null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OhCedOwPane.this.updateInfo();
                }
            });
        }
    }

    private void updateInfo() {
        if (db.on()) {
            db.println("updating info");
        }
        if (this.curCircuit != null) {
            this.setPcmCB();
            this.setLists();
        }
    }
}

