/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.model.WarningMessageException;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ppc.PPCCreationInfo;
import cerent.cms.ui.ppc.PPCRollbackFailed;
import cerent.util.CEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;

public class PPCCreateOperator {
    private static final SDebug db = new SDebug("PPCCreateOperator");
    private Component parentPanel;
    private PPCCreationInfo info;
    private List<PPCCreationHolder> createdTerms;
    private VirtualLinksDirector vld = VirtualLinksDirector.instance();
    private INodeModel currentNode;
    private IEntityModel currentPort;
    private int currentSrcID;
    private int currentDstID;

    public PPCCreateOperator(Component component, PPCCreationInfo pPCCreationInfo) {
        this.parentPanel = component;
        this.info = pPCCreationInfo;
        this.createdTerms = new LinkedList<PPCCreationHolder>();
    }

    public void rollback() throws PPCRollbackFailed {
        if (db.on()) {
            db.println("Rollback called. Removing " + this.createdTerms.size() + " link terminations");
        }
        StringBuilder stringBuilder = null;
        for (PPCCreationHolder pPCCreationHolder : this.createdTerms) {
            if (db.on()) {
                db.println("Rollback called. Removing " + pPCCreationHolder);
            }
            try {
                this.vld.deleteVirtualLink(pPCCreationHolder.getIpAddr(), pPCCreationHolder.getLinkID());
            }
            catch (Exception exception) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append("Node: " + VirtualLinksDirector.ipToString(pPCCreationHolder.getIpAddr()) + ", ID: " + pPCCreationHolder.getLinkID());
                if (!db.on()) continue;
                db.println("Cannot delete VL termination on Node: " + VirtualLinksDirector.ipToString(pPCCreationHolder.getIpAddr()) + ", ID: " + pPCCreationHolder.getLinkID() + ": " + exception.getMessage());
            }
        }
        this.createdTerms.clear();
        if (stringBuilder != null) {
            throw new PPCRollbackFailed(stringBuilder.toString());
        }
    }

    public void sanityCheck() throws Exception {
        if (db.on()) {
            db.println("start called");
        }
        this.sanityCheck(this.info.getTerm());
        if (this.info.isProtected()) {
            this.sanityCheck(this.info.getProtectTerm());
        }
    }

    public void createLinks() throws NoSuchInterface, WrongInterfaceType, ProvisionError, DuplicateLocalVlinkId, DuplicateRemoteVlinkId, EndPointInUse, FeatureUnsupported, UnknownHostException {
        if (db.on()) {
            db.println("start called");
        }
        this.createdTerms.clear();
        this.createLinkTerminations(this.info.getTerm());
        if (this.info.isProtected()) {
            this.createLinkTerminations(this.info.getProtectTerm());
        }
    }

    private void sanityCheck(PPCCreationInfo.TermInfo termInfo) throws Exception {
        boolean bl;
        IEntityModel iEntityModel;
        if (db.on()) {
            db.println("sanityCheck: " + termInfo);
        }
        IEntityModel iEntityModel2 = iEntityModel = (bl = this.info.hasSecPort()) ? termInfo.getSecSrcPort() : null;
        if (iEntityModel == null && this.info.isBidi2OCH()) {
            iEntityModel = termInfo.getSrcPort();
        }
        try {
            if (bl) {
                VirtualLinksDirector.sanityCheck(termInfo.getSrcNode(), (short)termInfo.getSrcID(), (short)termInfo.getSecSrcID(), termInfo.getSrcPort(), iEntityModel, termInfo.getDstNode(), (short)termInfo.getDstID(), (short)termInfo.getSecDstID(), termInfo.getSecDstPort(), termInfo.getDstPort());
            } else {
                VirtualLinksDirector.sanityCheck(termInfo.getSrcNode(), (short)termInfo.getSrcID(), (short)-1, termInfo.getSrcPort(), iEntityModel, termInfo.getDstNode(), (short)termInfo.getDstID(), (short)-1, termInfo.getDstPort(), null);
            }
        }
        catch (WarningMessageException warningMessageException) {
            CerentDialog.warningDialog((Component)this.parentPanel, (String)warningMessageException.getMessage());
        }
    }

    private void createLinkTerminations(PPCCreationInfo.TermInfo termInfo) throws NoSuchInterface, WrongInterfaceType, ProvisionError, DuplicateLocalVlinkId, DuplicateRemoteVlinkId, EndPointInUse, FeatureUnsupported, UnknownHostException {
        IEntityModel iEntityModel;
        if (db.on()) {
            db.println("createLinkTerminations: " + termInfo);
        }
        boolean bl = this.info.hasSecPort();
        INodeModel iNodeModel = termInfo.getSrcNode();
        INodeModel iNodeModel2 = termInfo.getDstNode();
        IEntityModel iEntityModel2 = termInfo.getSrcPort();
        IEntityModel iEntityModel3 = termInfo.getDstPort();
        IEntityModel iEntityModel4 = iEntityModel = bl ? termInfo.getSecSrcPort() : null;
        if (iEntityModel == null && this.info.isBidi2OCH()) {
            iEntityModel = iEntityModel2;
        }
        IEntityModel iEntityModel5 = bl ? termInfo.getSecDstPort() : null;
        this.currentNode = null;
        this.currentPort = null;
        this.currentSrcID = -1;
        this.currentDstID = -1;
        short s = (short)termInfo.getSrcID();
        short s2 = (short)termInfo.getDstID();
        short s3 = (short)(bl ? termInfo.getSecSrcID() : -1);
        short s4 = (short)(bl ? termInfo.getSecDstID() : -1);
        if (db.on()) {
            db.println("Creating PPC Termination on " + iNodeModel.getName() + "/" + s + " to " + iNodeModel2.getName() + "/" + s2);
        }
        this.currentNode = iNodeModel;
        this.currentPort = iEntityModel2;
        this.currentSrcID = s;
        this.currentDstID = s2;
        if (iNodeModel.provides(Feature.ML_VERSION_UP_ENH) && iNodeModel.isVersionUpStateEnabled() || iNodeModel2.provides(Feature.ML_VERSION_UP_ENH) && iNodeModel2.isVersionUpStateEnabled()) {
            throw new CmsNodeUpgradingException(CEMC.EID_NODE_UPGRADING_EXCEPTION.getMessage());
        }
        this.vld.createVirtualLink(s, iNodeModel, iEntityModel2, s2, iNodeModel2);
        this.addCreatedLink(iNodeModel, s);
        if (db.on()) {
            db.println("Creating PPC Termination on " + iNodeModel2.getName() + "/" + s2 + " to " + iNodeModel.getName() + "/" + s);
        }
        this.currentNode = iNodeModel2;
        this.currentPort = iEntityModel3;
        this.currentSrcID = s2;
        this.currentDstID = s;
        this.vld.createVirtualLink(s2, iNodeModel2, iEntityModel3, s, iNodeModel);
        this.addCreatedLink(iNodeModel2, s2);
        if (bl) {
            if (db.on()) {
                db.println("Creating secondary PPC Termination on " + iNodeModel.getName() + "/" + s3 + " to " + iNodeModel2.getName() + "/" + s4);
            }
            this.currentNode = iNodeModel;
            this.currentPort = iEntityModel;
            this.currentSrcID = s3;
            this.currentDstID = s4;
            this.vld.createVirtualLink(s3, iNodeModel, iEntityModel, s4, iNodeModel2);
            this.addCreatedLink(iNodeModel, s3);
            if (db.on()) {
                db.println("Creating secondary PPC Termination on " + iNodeModel2.getName() + "/" + s4 + " to " + iNodeModel.getName() + "/" + s3);
            }
            this.currentNode = iNodeModel2;
            this.currentPort = iEntityModel5;
            this.currentSrcID = s4;
            this.currentDstID = s3;
            this.vld.createVirtualLink(s4, iNodeModel2, iEntityModel5, s3, iNodeModel);
            this.addCreatedLink(iNodeModel2, s4);
        }
    }

    private void addCreatedLink(INodeModel iNodeModel, short s) {
        this.createdTerms.add(new PPCCreationHolder(iNodeModel.getIpConfig().getIpAddress(), s));
    }

    public int getCurrentDstID() {
        return this.currentDstID;
    }

    public INodeModel getCurrentNode() {
        return this.currentNode;
    }

    public IEntityModel getCurrentPort() {
        return this.currentPort;
    }

    public int getCurrentSrcID() {
        return this.currentSrcID;
    }

    private static class PPCCreationHolder {
        private IIpAddr ipAddr;
        private short linkID;

        PPCCreationHolder(IIpAddr iIpAddr, short s) {
            this.ipAddr = iIpAddr;
            this.linkID = s;
        }

        IIpAddr getIpAddr() {
            return this.ipAddr;
        }

        short getLinkID() {
            return this.linkID;
        }

        public String toString() {
            return VirtualLinksDirector.ipToString(this.ipAddr) + "/" + this.linkID;
        }
    }
}

