/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.VirtualLinksDirector;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPCCreationInfo {
    private static final int INVALID_ID = -1;
    private INodeModel srcNode;
    private boolean isBidi2Bidi;
    private boolean isSide2SideOTS;
    private boolean isOts2Ots;
    private boolean isBidi2OCH;
    private boolean isL2;
    private int wlen;
    private boolean isProtected;
    TermInfo termInfo = new TermInfo();
    TermInfo protectInfo = new TermInfo();

    public void setSrcNode(INodeModel iNodeModel) {
        this.srcNode = iNodeModel;
    }

    public boolean hasFixedSrcNode() {
        return this.srcNode != null;
    }

    public boolean hasSecPort() {
        return this.isBidi2OCH() || this.isSide2SideOTS() || this.isOts2Ots();
    }

    public INodeModel getSrcNode() {
        return this.srcNode;
    }

    public boolean isBidi2Bidi() {
        return this.isBidi2Bidi;
    }

    public boolean isL2() {
        return this.isL2;
    }

    public void setBidi2Bidi() {
        this.isBidi2Bidi = true;
        this.isSide2SideOTS = false;
        this.isOts2Ots = false;
        this.isBidi2OCH = false;
        this.isL2 = false;
    }

    public void setL2() {
        this.isBidi2Bidi = false;
        this.isSide2SideOTS = false;
        this.isOts2Ots = false;
        this.isBidi2OCH = false;
        this.isL2 = true;
    }

    public boolean isSide2SideOTS() {
        return this.isSide2SideOTS;
    }

    public void setSide2SideOTS() {
        this.isBidi2Bidi = false;
        this.isSide2SideOTS = true;
        this.isOts2Ots = false;
        this.isBidi2OCH = false;
        this.isL2 = false;
    }

    public boolean isOts2Ots() {
        return this.isOts2Ots;
    }

    public void setOts2Ots() {
        this.isBidi2Bidi = false;
        this.isSide2SideOTS = false;
        this.isOts2Ots = true;
        this.isBidi2OCH = false;
        this.isL2 = false;
    }

    public boolean isBidi2OCH() {
        return this.isBidi2OCH;
    }

    public void setBidi2OCH() {
        this.isBidi2Bidi = false;
        this.isSide2SideOTS = false;
        this.isOts2Ots = false;
        this.isBidi2OCH = true;
        this.isL2 = false;
    }

    public int getWavelength() {
        return this.wlen;
    }

    public void setWavelength(int n) {
        this.wlen = n;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean bl) {
        this.isProtected = bl;
    }

    public TermInfo getTerm() {
        return this.termInfo;
    }

    public TermInfo getProtectTerm() {
        return this.protectInfo;
    }

    List<Integer> getIDs(INodeModel iNodeModel) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if (this.termInfo.getSrcPort() != null && this.termInfo.getSrcNode().getNodeId() == iNodeModel.getNodeId()) {
            linkedList.add(this.termInfo.getSrcID());
            if (this.termInfo.getSecSrcID() != -1) {
                linkedList.add(this.termInfo.getSecSrcID());
            }
        } else if (this.termInfo.getDstPort() != null && this.termInfo.getDstNode().getNodeId() == iNodeModel.getNodeId()) {
            linkedList.add(this.termInfo.getDstID());
            if (this.termInfo.getSecDstID() != -1) {
                linkedList.add(this.termInfo.getSecDstID());
            }
        }
        if (this.protectInfo.getSrcNode() != null && this.protectInfo.getSrcNode().getNodeId() == iNodeModel.getNodeId()) {
            linkedList.add(this.protectInfo.getSrcID());
            if (this.protectInfo.getSecSrcID() != -1) {
                linkedList.add(this.protectInfo.getSecSrcID());
            }
        } else if (this.protectInfo.getDstNode() != null && this.protectInfo.getDstNode().getNodeId() == iNodeModel.getNodeId()) {
            linkedList.add(this.protectInfo.getDstID());
            if (this.protectInfo.getSecDstID() != -1) {
                linkedList.add(this.protectInfo.getSecDstID());
            }
        }
        return linkedList;
    }

    public static class TermInfo {
        private IEntityModel srcPort;
        private IEntityModel secSrcPort;
        private IEntityModel dstPort;
        private IEntityModel secDstPort;
        private int srcID = -1;
        private int secSrcID = -1;
        private int dstID = -1;
        private int secDstID = -1;

        public void reset() {
            this.srcPort = null;
            this.secSrcPort = null;
            this.srcID = -1;
            this.secSrcID = -1;
            this.resetDst();
        }

        public void resetDst() {
            this.dstPort = null;
            this.secDstPort = null;
            this.dstID = -1;
            this.secDstID = -1;
        }

        public INodeModel getSrcNode() {
            return this.getSrcPort() != null ? this.getSrcPort().getNodeModel() : null;
        }

        public IEntityModel getSrcPort() {
            return this.srcPort;
        }

        public void setSrcPort(IEntityModel iEntityModel) {
            this.srcPort = iEntityModel;
        }

        public IEntityModel getSecSrcPort() {
            return this.secSrcPort;
        }

        public void setSecSrcPort(IEntityModel iEntityModel) {
            this.secSrcPort = iEntityModel;
        }

        public INodeModel getDstNode() {
            return this.getDstPort() != null ? this.getDstPort().getNodeModel() : null;
        }

        public IEntityModel getDstPort() {
            return this.dstPort;
        }

        public void setDstPort(IEntityModel iEntityModel) {
            this.dstPort = iEntityModel;
        }

        public IEntityModel getSecDstPort() {
            return this.secDstPort;
        }

        public void setSecDstPort(IEntityModel iEntityModel) {
            this.secDstPort = iEntityModel;
        }

        public int getDstID() {
            return this.dstID;
        }

        public void setDstID(int n) {
            this.dstID = n;
        }

        public int getSecDstID() {
            return this.secDstID;
        }

        public void setSecDstID(int n) {
            this.secDstID = n;
        }

        public int getSecSrcID() {
            return this.secSrcID;
        }

        public void setSecSrcID(int n) {
            this.secSrcID = n;
        }

        public int getSrcID() {
            return this.srcID;
        }

        public void setSrcID(int n) {
            this.srcID = n;
        }

        public boolean isValid() {
            return this.srcID != -1 && this.dstID != -1 && this.getSrcPort() != null && this.getDstPort() != null;
        }

        public IVirtualLinkModel toVLModel() {
            IIpAddr iIpAddr = null;
            IIpAddr iIpAddr2 = null;
            iIpAddr = this.getSrcNode().isSecureMode() ? this.getSrcNode().getSecureIpConfig().getIpAddress() : this.getSrcNode().getIpConfig().getIpAddress();
            iIpAddr2 = this.getDstNode().isSecureMode() ? this.getDstNode().getSecureIpConfig().getIpAddress() : this.getDstNode().getIpConfig().getIpAddress();
            return VirtualLinksDirector.instance().getVirtualLinkModel((short)this.srcID, iIpAddr, this.getSrcPort(), (short)this.dstID, iIpAddr2, this.getDstPort());
        }

        public IVirtualLinkModel toSecVLModel() {
            IIpAddr iIpAddr = null;
            IIpAddr iIpAddr2 = null;
            iIpAddr = this.getSrcNode().isSecureMode() ? this.getSrcNode().getSecureIpConfig().getIpAddress() : this.getSrcNode().getIpConfig().getIpAddress();
            iIpAddr2 = this.getDstNode().isSecureMode() ? this.getDstNode().getSecureIpConfig().getIpAddress() : this.getDstNode().getIpConfig().getIpAddress();
            if (this.getSecSrcPort() != null) {
                return VirtualLinksDirector.instance().getVirtualLinkModel((short)this.secSrcID, iIpAddr, this.getSecSrcPort(), (short)this.secDstID, iIpAddr2, this.getSecDstPort());
            }
            return VirtualLinksDirector.instance().getVirtualLinkModel((short)this.secSrcID, iIpAddr, this.getSrcPort(), (short)this.secDstID, iIpAddr2, this.getSecDstPort());
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getSrcNode() != null) {
                stringBuffer.append("Src: ").append(this.getSrcNode().getName()).append(", port: ").append(this.getSrcPort()).append(", ID: ").append(this.getSrcID());
            } else {
                stringBuffer.append("Src: UNDEFINED").append(", ID: ").append(this.getSrcID());
            }
            if (this.getSecSrcPort() != null) {
                stringBuffer.append(", sec. port: ").append(this.getSecSrcPort()).append(", sec. ID: ").append(this.getSrcID());
            }
            if (this.getDstNode() != null) {
                stringBuffer.append("\nDst: ").append(this.getDstNode().getName()).append(", port: ").append(this.getDstPort()).append(", ID: ").append(this.getDstID());
            } else {
                stringBuffer.append("\nDst: UNDEFINED").append(", ID: ").append(this.getDstID());
            }
            if (this.getSecDstPort() != null) {
                stringBuffer.append(", sec. port: ").append(this.getSecDstPort()).append(", sec. ID: ").append(this.getDstID());
            }
            return stringBuffer.toString();
        }
    }
}

