/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppc;

import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.ncp.PPCRepairOperator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.PPCRepairDialog;
import cerent.cms.ui.VirtualLinkDataSource;
import cerent.cms.ui.VirtualLinkPane;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.ppc.PPCRepairInfo;
import cerent.util.IAsyncObserver;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;

public class PPCRepTerms
extends WzPane
implements IAsyncObserver {
    private static final String CAPTION = "Select Finish to repair the following Provisionable Patchcords.";
    protected JTable table = null;
    private VirtualLinkDataSource dataSource;
    private RowTableModel tableModel;
    private List<IVirtualLinkModel> vlinks;

    public PPCRepTerms(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    public void validatePage() {
        PPCRepairInfo pPCRepairInfo = ((PPCRepairDialog)this.parent).getInfo();
        pPCRepairInfo.setTerms(this.vlinks);
    }

    public void enteringPane() {
        super.enteringPane();
        PPCRepairOperator pPCRepairOperator = PPCRepairOperator.newInstance();
        PPCRepairOperator.IpChange ipChange = ((PPCRepairDialog)this.parent).getInfo().getIpChange();
        this.vlinks = pPCRepairOperator.findTermToBeFixed(ipChange);
        this.dataSource.refresh(this);
        ((PPCRepairDialog)this.parent).setFinishEnabled(true);
    }

    protected String getNextPaneName() {
        return null;
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(CAPTION);
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jPanel.add((Component)jTextArea, "North");
        this.dataSource = new VirtualLinkDataSource(null, null){

            protected Set getVirtualLinks() {
                if (PPCRepTerms.this.vlinks == null) {
                    return Collections.emptySet();
                }
                return new LinkedHashSet(PPCRepTerms.this.vlinks);
            }
        };
        VirtualLinksDirector virtualLinksDirector = VirtualLinksDirector.instance();
        this.tableModel = new RowTableModel((RowDataSource)this.dataSource, VirtualLinkPane.createColumnRenderers(virtualLinksDirector, null));
        this.table = new UTable((TableModel)this.tableModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        jPanel.add((Component)uScrollPane, "Center");
        this.tableModel.initTable(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PPCRepTermsPane;
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
    }
}

