/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISnmpModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpV3EngineContainer;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.snmp.GneSelector;
import cerent.cms.ui.snmp.Snmpv3ProxyTablePane;
import cerent.cms.ui.snmp.Snmpv3ProxyTrapTablePane;
import cerent.cms.ui.snmp.Snmpv3RemoteUserPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SnmpProxyPane
extends ObserverPane
implements ActionListener,
Observer {
    private boolean inited = false;
    private INodeModel nm = null;
    private TabbedView parent;
    private GneSelector gneSelect;
    private String curGne;
    private Snmpv3ProxyTablePane snmpv3ProxyTablePane;
    private Snmpv3ProxyTrapTablePane snmpv3ProxyTrapTablePane;
    private Snmpv3RemoteUserPane snmpv3RemoteUsersPane;
    private static Attribute[] gneList;
    private JCheckBox ipv6Config;
    private Map ipv6Toipv4 = new HashMap();

    public ArrayList getAllGnes() {
        return this.gneSelect.getAllGnes();
    }

    public boolean isIpv6Config() {
        return this.ipv6Config.isSelected();
    }

    public String getCurrentGne() {
        return this.curGne;
    }

    public ISnmpModel getCurrentGneSnmpModel() {
        if (this.getCurrentGneNM() != null) {
            return ((INodeModel)this.gneSelect.getSelectedItem()).getSnmpModel();
        }
        return null;
    }

    public INodeModel getCurrentGneNM() {
        return (INodeModel)this.gneSelect.getSelectedItem();
    }

    public SnmpProxyPane(String string, TabbedView tabbedView) {
        super(string, tabbedView.getUiModel(), null);
        this.nm = tabbedView.getUiModel().getNodeModel();
        this.parent = tabbedView;
    }

    public void update(Observable observable, Object object) {
        NetElement netElement;
        if (observable instanceof Network.NetElementCreationNotifier) {
            netElement = (NetElement)object;
            netElement.addObserver(this);
        }
        if (observable instanceof NetElement || object instanceof IAlarmStatus) {
            if (object == ModelUpdateType.DELETED) {
                netElement = (NetElement)((Object)observable);
                this.gneSelect.removeNode(netElement.getNodeModel());
                netElement.deleteObserver(this);
                netElement.getNodeModel().getSnmpModel().deleteObserver((Observer)((Object)this.snmpv3ProxyTablePane));
                netElement.getNodeModel().getSnmpModel().deleteObserver((Observer)((Object)this.snmpv3ProxyTrapTablePane));
                netElement.getNodeModel().getSnmpModel().deleteObserver((Observer)((Object)this.snmpv3RemoteUsersPane));
                netElement.getNodeModel().deleteObserver((Observer)((Object)this.snmpv3ProxyTablePane));
                netElement.getNodeModel().deleteObserver((Observer)((Object)this.snmpv3ProxyTrapTablePane));
                netElement.getNodeModel().deleteObserver((Observer)((Object)this.snmpv3RemoteUsersPane));
            } else if (object == ModelUpdateType.CHANGED) {
                netElement = (NetElement)((Object)observable);
                netElement.getNodeModel().getSnmpModel().addObserver((Observer)((Object)this.snmpv3ProxyTablePane));
                netElement.getNodeModel().getSnmpModel().addObserver((Observer)((Object)this.snmpv3ProxyTrapTablePane));
                netElement.getNodeModel().getSnmpModel().addObserver((Observer)((Object)this.snmpv3RemoteUsersPane));
                netElement.getNodeModel().addObserver((Observer)((Object)this.snmpv3ProxyTablePane));
                netElement.getNodeModel().addObserver((Observer)((Object)this.snmpv3ProxyTrapTablePane));
                netElement.getNodeModel().addObserver((Observer)((Object)this.snmpv3RemoteUsersPane));
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.gneSelect.updateNodeList();
    }

    protected void init() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel2);
        jPanel.add((Component)uScrollPane, "Center");
        this.add(jPanel);
        JPanel jPanel3 = SnmpProxyPane.createHorizontalPanel("SNMPv3 Proxy Server");
        jPanel3.setLayout(new FlowLayout(0, 30, 10));
        jPanel3.setPreferredSize(new Dimension(800, 75));
        jPanel3.add(new JLabel("GNE:"));
        this.gneSelect = new GneSelector();
        this.gneSelect.setPreferredSize(new Dimension(300, 20));
        this.gneSelect.setMaximumSize(new Dimension(300, 20));
        jPanel3.add((Component)((Object)this.gneSelect));
        this.ipv6Config = new JCheckBox("Enable IPv6 Target/Trap");
        jPanel3.add(this.ipv6Config);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = SnmpProxyPane.createHorizontalPanel("SNMPv3 Proxy Forwarder Table");
        jPanel4.setLayout(new GridLayout(1, 1));
        jPanel4.setPreferredSize(new Dimension(800, 150));
        this.snmpv3ProxyTablePane = new Snmpv3ProxyTablePane("SNMPv3 Proxy Forwarder Table", this.parent, this);
        jPanel4.add((Component)((Object)this.snmpv3ProxyTablePane));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = SnmpProxyPane.createHorizontalPanel("SNMPv3 Proxy Trap Forwarder Table");
        jPanel5.setLayout(new GridLayout(1, 1));
        jPanel5.setPreferredSize(new Dimension(800, 150));
        this.snmpv3ProxyTrapTablePane = new Snmpv3ProxyTrapTablePane("SNMPv3 Proxy Trap Forwarder Table", this.parent, this);
        jPanel5.add((Component)((Object)this.snmpv3ProxyTrapTablePane));
        jPanel2.add(jPanel5);
        JPanel jPanel6 = SnmpProxyPane.createHorizontalPanel("SNMPv3 Remote Users");
        jPanel6.setLayout(new GridLayout(1, 1));
        jPanel6.setPreferredSize(new Dimension(800, 150));
        this.snmpv3RemoteUsersPane = new Snmpv3RemoteUserPane("SNMPv3 Remote Users", this.parent, this);
        jPanel6.add((Component)((Object)this.snmpv3RemoteUsersPane));
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        jPanel7.add(new CSHelpButtonPane(this.getHelpID()));
        jPanel.add((Component)jPanel7, "South");
        this.inited = true;
        Network network = Network.instance();
        Network.NetElementCreationNotifier netElementCreationNotifier = network.getNetElementCreationNotifier();
        netElementCreationNotifier.addObserver(this);
        this.gneSelect.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                INodeModel iNodeModel = (INodeModel)SnmpProxyPane.this.gneSelect.getSelectedItem();
                if (null != iNodeModel) {
                    SnmpProxyPane.this.curGne = iNodeModel.getHostName();
                }
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.IPV6_NATPT)) {
                    if (iNodeModel.getIpConfig().getNodeMode()) {
                        SnmpProxyPane.this.ipv6Config.setEnabled(true);
                    } else {
                        SnmpProxyPane.this.ipv6Config.setEnabled(false);
                        SnmpProxyPane.this.ipv6Config.setSelected(false);
                    }
                }
                SnmpProxyPane.this.snmpv3ProxyTablePane.refresh();
                SnmpProxyPane.this.snmpv3ProxyTrapTablePane.refresh();
                SnmpProxyPane.this.snmpv3RemoteUsersPane.refresh();
            }
        });
        this.gneSelect.updateNodeList();
    }

    public ArrayList getClientsForGne() {
        Collection collection;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        block15: {
            arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            this.ipv6Toipv4.clear();
            collection = null;
            try {
                String string = this.getCurrentGneNM().isSecureMode() ? InetUtil.makeDottedString(this.getCurrentGneNM().getSecureIpConfig().getIpAddress()) : this.getCurrentGne();
                collection = CtcProxyFactory.getClients((String)string);
            }
            catch (IOException iOException) {
                if (this.getCurrentGneNM().isSecureMode()) {
                    this.curGne = this.getCurrentGne();
                }
                try {
                    collection = CtcProxyFactory.getClients((String)this.curGne);
                }
                catch (IOException iOException2) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)iOException);
                        db.println("Error while fetching clients for the GNE");
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block15;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while fetching clients for the GNE");
            }
        }
        if (collection != null) {
            for (Object e : collection) {
                INodeModel iNodeModel;
                Object object;
                String string = null;
                if (e instanceof SckfwdClient) {
                    object = ((SckfwdClient)e).getHost();
                    string = ((InetAddress)object).getHostAddress();
                } else if (e instanceof String) {
                    string = (String)e;
                }
                if ((object = (NetElement)Network.instance().findNetElemByIp(string)) == null || !(iNodeModel = ((NetElement)object).getNodeModel()).isInited()) continue;
                IIpConfig iIpConfig = iNodeModel.getIpConfig();
                if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SNMPV3)) continue;
                String string2 = InetUtil.makeDottedString(iIpConfig.getIpAddress(), false);
                String string3 = "0:0:0:0:0:0:0:0";
                if (!arrayList2.contains(string2)) {
                    arrayList2.add(string2);
                }
                if (iIpConfig.getNodeMode() && !arrayList.contains(string3 = InetUtil.makeDottedString(iIpConfig.getIpv6Address(), true))) {
                    arrayList.add(string3);
                }
                this.ipv6Toipv4.put(string3, string2);
            }
        }
        if (this.isIpv6Config()) {
            return arrayList;
        }
        return arrayList2;
    }

    public String getIpv4Address(String string) {
        return (String)this.ipv6Toipv4.get(string);
    }

    public ArrayList getSnmpv3RemoteUsers() {
        ArrayList<SnmpV3ProxyUser> arrayList;
        block4: {
            arrayList = new ArrayList<SnmpV3ProxyUser>();
            try {
                ISnmpModel iSnmpModel = this.getCurrentGneSnmpModel();
                if (iSnmpModel == null) {
                    return arrayList;
                }
                SnmpV3ProxyUser[] snmpV3ProxyUserArray = iSnmpModel.getSnmpV3UserWrapper();
                SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                for (SnmpV3ProxyUser snmpV3ProxyUser : snmpV3ProxyUserArray) {
                    if (snmpV3ProxyUser.getEngine().equals((Object)snmpV3EngineContainer)) continue;
                    arrayList.add(snmpV3ProxyUser);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while getting the Remote users");
            }
        }
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
    }

    public void enteringPage() {
        block3: {
            try {
                if (!this.inited) {
                    this.init();
                }
                this.refresh();
                this.snmpv3ProxyTablePane.enteringPage();
                this.snmpv3ProxyTrapTablePane.enteringPage();
                this.snmpv3RemoteUsersPane.enteringPage();
            }
            catch (Exception exception) {
                if (!SnmpProxyPane.db.on) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void leavingPage() throws Exception {
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.Snmpv3ProxyPane;
    }
}

