/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.Attribute;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISnmpModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpProxyConfigAlreadyExists;
import cerent.cms.model.SnmpV3EngineContainer;
import cerent.cms.model.SnmpV3PassKey;
import cerent.cms.model.SnmpV3ProxyFwd;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.snmp.SnmpProxyPane;
import cerent.cms.ui.snmp.Snmpv3EngineIDTextField;
import cerent.cms.ui.snmp.Snmpv3ProxyAutoConfigDialog;
import cerent.cms.ui.snmp.Snmpv3ProxyManualConfigDialog;
import cerent.cms.ui.snmp.Snmpv3UserDestSelector;
import cerent.cms.ui.snmp.Snmpv3UserDetailsPanel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class Snmpv3ProxyTablePane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    public static final String AUTO_CREATE = "Auto Create...";
    public static final String MANUAL_CREATE = "Manual Create...";
    public static final String DELETE = "Delete...";
    protected Snmpv3ProxyTableModel dataModel;
    protected ArrayList tableDataList;
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton manualCreatePB;
    private JButton autoCreatePB;
    private JButton deletePB;
    private SnmpProxyPane parentPane;
    private boolean inited = false;
    private JCheckBox read;
    private JCheckBox write;
    private Snmpv3EngineIDTextField ctxtEngIDTB;
    private JComboBox targetIPCB;
    private Snmpv3UserDetailsPanel udPane;
    private JComboBox secLevelCB;
    private JComboBox localUserCB;
    private Snmpv3UserDestSelector userDestSel;

    public Snmpv3ProxyTablePane(String string, TabbedView tabbedView, SnmpProxyPane snmpProxyPane) {
        super(string, tabbedView.getUiModel(), tabbedView);
        this.parentPane = snmpProxyPane;
        this.init();
    }

    public boolean isInited() {
        return this.inited;
    }

    protected void init() {
        block5: {
            if (db.on()) {
                db.println(" Snmpv3ProxyTablePane : init");
            }
            this.tableDataList = new ArrayList();
            this.dataModel = this.createTableModel();
            this.dataModel.addTableModelListener(this);
            this.table = new UTable((TableModel)this.dataModel);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(2);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.prepareColumns();
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
            this.buttons = this.getButtonBar();
            this.add(this.buttons, "South");
            ArrayList arrayList = this.parentPane.getAllGnes();
            for (int i = 0; i < arrayList.size(); ++i) {
                ((INodeModel)arrayList.get(i)).getSnmpModel().addObserver((Observer)((Object)this));
            }
            ISnmpModel iSnmpModel = this.parentPane.getCurrentGneSnmpModel();
            if (null != iSnmpModel) {
                try {
                    ArrayList arrayList2 = iSnmpModel.getSnmpV3ProxyFwd();
                    this.tableDataList.addAll(arrayList2);
                    this.refreshTable();
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                    db.println("Error while getting the Proxy table entries");
                }
            }
        }
        this.inited = true;
    }

    protected Snmpv3ProxyTableModel createTableModel() {
        return new Snmpv3ProxyTableModel();
    }

    protected void prepareColumns() {
        Snmpv3ProxyTableRenderer snmpv3ProxyTableRenderer = new Snmpv3ProxyTableRenderer();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.table.getColumn(this.dataModel.getColumnName(i)).setCellRenderer(snmpv3ProxyTableRenderer);
        }
        this.table.getColumn(this.dataModel.getColumnName(0)).setMinWidth(230);
        this.table.getColumn(this.dataModel.getColumnName(1)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(5)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(3)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(2)).setMinWidth(50);
        this.table.getColumn(this.dataModel.getColumnName(4)).setMinWidth(120);
        this.table.getColumn(this.dataModel.getColumnName(6)).setMinWidth(120);
    }

    public void enteringPage() {
        block4: {
            if (db.on()) {
                db.println("Snmpv3ProxyTablePane >>> enteringPage ");
            }
            try {
                if (!this.inited) {
                    this.init();
                }
                this.refresh();
                TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void leavingPage() throws Exception {
        if (Snmpv3ProxyTablePane.db.on) {
            db.println("Snmpv3ProxyTablePane >>> leavingPage()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public ArrayList getProxyTableRows() {
        ArrayList arrayList;
        block3: {
            arrayList = new ArrayList();
            ISnmpModel iSnmpModel = this.parentPane.getCurrentGneSnmpModel();
            if (null != iSnmpModel) {
                try {
                    ArrayList arrayList2 = iSnmpModel.getSnmpV3ProxyFwd();
                    this.tableDataList.addAll(arrayList2);
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                    db.println("Error while getting the Proxy table entries");
                }
            }
        }
        return arrayList;
    }

    public void update(Observable observable, Object object) {
        this.refresh();
    }

    public void refresh() {
        this.tableDataList.clear();
        this.tableDataList.addAll(this.getProxyTableRows());
        this.refreshTable();
    }

    protected void refreshTable() {
        this.dataModel.fireTableDataChanged();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.dataModel.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        if (!this.isUserAuthorized()) {
            bl = false;
        }
        if (!bl) {
            this.clearTableSelection();
        }
        this.deletePB.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    protected void clearTableSelection() {
        if (this.table != null && this.tableDataList.size() != 0) {
            this.table.removeRowSelectionInterval(0, this.tableDataList.size() - 1);
        }
    }

    protected void removeActionListeners() {
        this.manualCreatePB.removeActionListener(this);
        this.autoCreatePB.removeActionListener(this);
        this.deletePB.removeActionListener(this);
    }

    public void destroy() {
        if (db.on()) {
            db.println(">>>  destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.removeActionListeners();
        }
        super.destroy();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.manualCreatePB) {
            this.doActionManualProxyConfigure();
        } else if (object == this.deletePB) {
            this.deleteProxyTableRows();
        } else if (object == this.autoCreatePB) {
            this.doActionAutoProxyConfigure();
        }
    }

    public ArrayList getSnmpv3LocalUsers() {
        ArrayList<String> arrayList;
        block3: {
            arrayList = new ArrayList<String>();
            try {
                SnmpV3ProxyUser[] snmpV3ProxyUserArray = this.parentPane.getCurrentGneSnmpModel().getSnmpV3UserWrapper();
                SnmpV3EngineContainer snmpV3EngineContainer = this.parentPane.getCurrentGneSnmpModel().getSnmpV3EngineWrapper();
                for (SnmpV3ProxyUser snmpV3ProxyUser : snmpV3ProxyUserArray) {
                    if (!snmpV3ProxyUser.getEngine().equals((Object)snmpV3EngineContainer)) continue;
                    arrayList.add(snmpV3ProxyUser.getuserName());
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while getting the Proxy users");
            }
        }
        return arrayList;
    }

    private void doActionAutoProxyConfigure() {
        block9: {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.parentPane.getClientsForGne());
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(this.getSnmpv3LocalUsers());
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 0;
            JPanel jPanel2 = this.getProxyTypePanel();
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            gridBagConstraints.gridy = 1;
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 10));
            this.secLevelCB = new UComboBox((Object[])SnmpUtil.securityLevel, 50);
            this.secLevelCB.removeItemAt(0);
            this.secLevelCB.setSelectedIndex(0);
            this.secLevelCB.setPreferredSize(new Dimension(170, 20));
            this.secLevelCB.setSize(this.secLevelCB.getPreferredSize());
            this.secLevelCB.setMaximumSize(this.secLevelCB.getPreferredSize());
            jPanel3.add(new JLabel("Security Level:       "));
            jPanel3.add(this.secLevelCB);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            this.userDestSel = new Snmpv3UserDestSelector(arrayList, arrayList2, this.parentPane);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.userDestSel.getPanel(), gridBagConstraints);
            jPanel.add(this.userDestSel.getPanel());
            Object[] objectArray = new Object[]{"", jPanel};
            String string = "OK";
            String string2 = "Cancel";
            Object[] objectArray2 = new Object[]{string, string2, CSHelpButton.getCaption()};
            JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            arrayList3.add(jOptionPane);
            arrayList3.add(this.userDestSel);
            Snmpv3ProxyAutoConfigDialog snmpv3ProxyAutoConfigDialog = Snmpv3ProxyAutoConfigDialog.instance((Component)((Object)this), true, "Automatic Configuration of SNMPv3 Proxy Forwarder", arrayList3, false);
            snmpv3ProxyAutoConfigDialog.setResizable(false);
            try {
                snmpv3ProxyAutoConfigDialog.show();
                if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(string)) {
                    Object[] objectArray3 = this.userDestSel.getUserList().getSelectedValues();
                    Object[] objectArray4 = this.userDestSel.getProxyDestinations().getSelectedValues();
                    Object var17_19 = null;
                    Object var18_20 = null;
                    for (int i = 0; i < objectArray4.length; ++i) {
                        Object object;
                        SnmpV3PassKey snmpV3PassKey;
                        Object object2;
                        NetElement netElement = (NetElement)Network.instance().findNetElemByIp((String)objectArray4[i]);
                        if (null == netElement) {
                            netElement = (NetElement)Network.instance().findNetElemByIp(this.parentPane.getIpv4Address((String)objectArray4[i]));
                        }
                        ISnmpModel iSnmpModel = netElement.getNodeModel().getSnmpModel();
                        SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                        SnmpV3ProxyUser snmpV3ProxyUser = iSnmpModel.checkIfUserExists("ons_proxy_user");
                        String string3 = Long.toString(System.currentTimeMillis());
                        if (snmpV3ProxyUser == null) {
                            object2 = new byte[20];
                            int n = 0;
                            snmpV3PassKey = new SnmpV3PassKey(object2, n, string3, true);
                            object = new SnmpV3ProxyUser(snmpV3PassKey, 1, "default_group", snmpV3PassKey, 1, "ons_proxy_user", snmpV3EngineContainer);
                            iSnmpModel.setSnmpV3UserWrapper(object);
                        }
                        snmpV3ProxyUser = iSnmpModel.checkIfUserExists("ons_proxy_user");
                        object2 = new SnmpV3PassKey(snmpV3ProxyUser.getAuthKey().getKey(), snmpV3ProxyUser.getAuthKey().getKeyLen(), "", false);
                        SnmpV3PassKey snmpV3PassKey2 = new SnmpV3PassKey(snmpV3ProxyUser.getPrivKey().getKey(), snmpV3ProxyUser.getPrivKey().getKeyLen(), "", false);
                        snmpV3PassKey = new SnmpV3ProxyUser((SnmpV3PassKey)object2, 1, "default_group", snmpV3PassKey2, 1, "ons_proxy_user", snmpV3EngineContainer);
                        this.parentPane.getCurrentGneSnmpModel().setSnmpV3UserWrapper((Object)snmpV3PassKey);
                        object = (Attribute)this.secLevelCB.getSelectedItem();
                        String string4 = SnmpUtil.toStringEngineID(snmpV3EngineContainer.getContextEngID(), snmpV3EngineContainer.getContextEngIDLength());
                        if (this.read.isSelected()) {
                            this.parentPane.getCurrentGneSnmpModel().setProxyFwd(string4, (String)objectArray4[i], (String)objectArray3[0], SnmpUtil.getSecLevelStdString(((Attribute)object).getKey()), "ons_proxy_user", "SecurityLevel_authPriv", "READ");
                        }
                        if (!this.write.isSelected()) continue;
                        this.parentPane.getCurrentGneSnmpModel().setProxyFwd(string4, (String)objectArray4[i], (String)objectArray3[0], SnmpUtil.getSecLevelStdString(((Attribute)object).getKey()), "ons_proxy_user", "SecurityLevel_authPriv", "WRITE");
                    }
                }
            }
            catch (SnmpProxyConfigAlreadyExists snmpProxyConfigAlreadyExists) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_PROXY_ALREADY_EXISTS);
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)snmpProxyConfigAlreadyExists);
                    db.println("Duplicate SNMPv3 Proxy configuration");
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_PROXY_CONFIG_FAILURE);
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while performing SNMPv3 Proxy configuration");
            }
        }
    }

    public JPanel getProxyTypePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 10));
        JLabel jLabel = new JLabel("Proxy Type:         ");
        jPanel.add(jLabel);
        this.read = new JCheckBox("Read");
        this.write = new JCheckBox("Write");
        jPanel.add(this.read);
        jPanel.add(this.write);
        return jPanel;
    }

    public boolean validateAutoConfig() {
        boolean bl = false;
        if (!this.read.isSelected() && !this.write.isSelected()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_PROXY_TYPE);
            return bl;
        }
        if (this.userDestSel.getUserList().getSelectedValues().length < 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_LOCAL_USER);
            return bl;
        }
        if (this.userDestSel.getProxyDestinations().getSelectedValues().length < 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_PROXY_DEST);
            return bl;
        }
        if (!this.checkIfProxyEntryExistsAuto()) {
            bl = true;
        }
        return bl;
    }

    public boolean validateManualConfig() {
        boolean bl = false;
        if (!this.read.isSelected() && !this.write.isSelected()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_PROXY_TYPE);
            return bl;
        }
        if (this.ctxtEngIDTB.getText().equals("")) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_ENGINE_ID);
            return bl;
        }
        try {
            InetAddress.getByName((String)this.targetIPCB.getSelectedItem());
        }
        catch (UnknownHostException unknownHostException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_INVALID_TARGET_IP);
            return bl;
        }
        if (this.udPane.validateUserAttr() && !this.checkIfProxyEntryExistsManual()) {
            bl = true;
        }
        return bl;
    }

    private void doActionManualProxyConfigure() {
        block10: {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JPanel jPanel2 = this.getProxyTypePanel();
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.parentPane.getClientsForGne());
            gridBagConstraints.gridy = 1;
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 10));
            this.targetIPCB = new JComboBox();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.targetIPCB.addItem(arrayList.get(i));
            }
            this.targetIPCB.setEditable(true);
            this.targetIPCB.setPreferredSize(new Dimension(265, 20));
            this.targetIPCB.setMaximumSize(this.targetIPCB.getPreferredSize());
            this.targetIPCB.setSelectedIndex(-1);
            jPanel3.add(new JLabel("Target Address:     "));
            jPanel3.add(this.targetIPCB);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            gridBagConstraints.gridy = 2;
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 10, 10));
            this.ctxtEngIDTB = new Snmpv3EngineIDTextField();
            this.ctxtEngIDTB.setMaximumSize(this.ctxtEngIDTB.getPreferredSize());
            jPanel4.add(new JLabel("Context Engine ID:"));
            jPanel4.add(this.ctxtEngIDTB);
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            jPanel.add(jPanel4);
            this.ctxtEngIDTB.addActionListener(this);
            gridBagConstraints.gridy = 3;
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createTitledBorder("Local User Details"));
            jPanel5.setLayout(new BoxLayout(jPanel5, 1));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new GridLayout(0, 2, 5, 5));
            jPanel6.add(this.createLabel("      User Name:    ", 80, 20));
            ArrayList arrayList2 = new ArrayList();
            this.localUserCB = new JComboBox();
            ArrayList arrayList3 = this.getSnmpv3LocalUsers();
            for (int i = 0; i < arrayList3.size(); ++i) {
                this.localUserCB.addItem(arrayList3.get(i));
            }
            this.localUserCB.setPreferredSize(new Dimension(170, 20));
            this.localUserCB.setMaximumSize(this.localUserCB.getPreferredSize());
            jPanel6.add(this.localUserCB);
            jPanel6.add(this.createLabel("      Security Level:", 80, 20));
            this.secLevelCB = new UComboBox((Object[])SnmpUtil.securityLevel, 50);
            this.secLevelCB.removeItemAt(0);
            this.secLevelCB.setPreferredSize(new Dimension(170, 20));
            this.secLevelCB.setMaximumSize(this.secLevelCB.getPreferredSize());
            jPanel6.add(this.secLevelCB);
            jPanel5.add(jPanel6);
            gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
            jPanel.add(jPanel5);
            gridBagConstraints.gridy = 4;
            this.udPane = new Snmpv3UserDetailsPanel("Remote User Details", this.parentPane, true);
            gridBagLayout.setConstraints(this.udPane, gridBagConstraints);
            jPanel.add(this.udPane);
            this.targetIPCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        String string = (String)Snmpv3ProxyTablePane.this.targetIPCB.getSelectedItem();
                        if (null != string) {
                            NetElement netElement = (NetElement)Network.instance().findNetElemByIp(string);
                            if (null == netElement) {
                                netElement = (NetElement)Network.instance().findNetElemByIp(Snmpv3ProxyTablePane.this.parentPane.getIpv4Address(string));
                            }
                            ISnmpModel iSnmpModel = netElement.getNodeModel().getSnmpModel();
                            SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                            Snmpv3ProxyTablePane.this.udPane.refreshUserList(snmpV3EngineContainer);
                            Snmpv3ProxyTablePane.this.ctxtEngIDTB.setText(SnmpUtil.toStringEngineID(snmpV3EngineContainer.getContextEngID(), snmpV3EngineContainer.getContextEngIDLength()));
                        }
                    }
                    catch (Exception exception) {
                        Snmpv3ProxyTablePane.this.ctxtEngIDTB.setText("");
                        Snmpv3ProxyTablePane.this.udPane.refreshUserList(null);
                    }
                }
            });
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                    String string = SnmpUtil.getEngineIDPadded(Snmpv3ProxyTablePane.this.ctxtEngIDTB.getText());
                    byte[] byArray = SnmpUtil.toBytesEngineID(string, string.length());
                    SnmpV3EngineContainer snmpV3EngineContainer = new SnmpV3EngineContainer(byArray, string.length() / 2, 0);
                    Snmpv3ProxyTablePane.this.udPane.refreshUserList(snmpV3EngineContainer);
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            this.ctxtEngIDTB.addKeyListener(keyListener);
            Object[] objectArray = new Object[]{"", jPanel};
            String string = "OK";
            String string2 = "Cancel";
            Object[] objectArray2 = new Object[]{string, string2, CSHelpButton.getCaption()};
            JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
            ArrayList<JOptionPane> arrayList4 = new ArrayList<JOptionPane>();
            arrayList4.add(jOptionPane);
            Snmpv3ProxyManualConfigDialog snmpv3ProxyManualConfigDialog = Snmpv3ProxyManualConfigDialog.instance((Component)((Object)this), true, "Manual Configuration of SNMPv3 Proxy Forwarder", arrayList4, false);
            snmpv3ProxyManualConfigDialog.setResizable(false);
            try {
                snmpv3ProxyManualConfigDialog.show();
                if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(string)) {
                    String string3;
                    String string4 = (String)this.localUserCB.getSelectedItem();
                    Attribute attribute = (Attribute)this.secLevelCB.getSelectedItem();
                    String string5 = SnmpUtil.getEngineIDPadded(this.ctxtEngIDTB.getText());
                    byte[] byArray = SnmpUtil.toBytesEngineID(string5, string5.length());
                    if (!this.udPane.checkIfUserReUsed()) {
                        string3 = new SnmpV3ProxyUser(this.udPane.getAuthPassKey(), this.udPane.getAuthProtocol(), "", this.udPane.getPrivPassKey(), this.udPane.getPrivProtocol(), this.udPane.getUserName(), new SnmpV3EngineContainer(byArray, string5.length() / 2, 0));
                        this.parentPane.getCurrentGneSnmpModel().setSnmpV3UserWrapper((Object)string3);
                    }
                    string3 = this.udPane.getUserName();
                    if (this.read.isSelected()) {
                        this.parentPane.getCurrentGneSnmpModel().setProxyFwd(string5, (String)this.targetIPCB.getSelectedItem(), string4, SnmpUtil.getSecLevelStdString(attribute.getKey()), string3, SnmpUtil.getSecLevelStdString(SnmpUtil.securityLevel[this.udPane.getSecurityLevel()].getKey()), "READ");
                    }
                    if (this.write.isSelected()) {
                        this.parentPane.getCurrentGneSnmpModel().setProxyFwd(string5, (String)this.targetIPCB.getSelectedItem(), string4, SnmpUtil.getSecLevelStdString(attribute.getKey()), string3, SnmpUtil.getSecLevelStdString(SnmpUtil.securityLevel[this.udPane.getSecurityLevel()].getKey()), "WRITE");
                    }
                }
            }
            catch (SnmpProxyConfigAlreadyExists snmpProxyConfigAlreadyExists) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SNMPV3_PROXY_ALREADY_EXISTS);
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)snmpProxyConfigAlreadyExists);
                    db.println("Duplicate SNMPv3 Proxy configuration");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while performing SNMPv3 Proxy configuration");
            }
        }
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private boolean checkIfProxyEntryExistsAuto() {
        String string;
        boolean bl;
        block6: {
            bl = false;
            string = null;
            try {
                Object[] objectArray = this.userDestSel.getUserList().getSelectedValues();
                Object[] objectArray2 = this.userDestSel.getProxyDestinations().getSelectedValues();
                String string2 = ((Attribute)this.secLevelCB.getSelectedItem()).getKey();
                for (int i = 0; i < objectArray2.length; ++i) {
                    NetElement netElement = (NetElement)Network.instance().findNetElemByIp((String)objectArray2[i]);
                    if (null == netElement) {
                        netElement = (NetElement)Network.instance().findNetElemByIp(this.parentPane.getIpv4Address((String)objectArray2[i]));
                    }
                    ISnmpModel iSnmpModel = netElement.getNodeModel().getSnmpModel();
                    SnmpV3EngineContainer snmpV3EngineContainer = iSnmpModel.getSnmpV3EngineWrapper();
                    String string3 = SnmpUtil.toStringEngineID(snmpV3EngineContainer.getContextEngID(), snmpV3EngineContainer.getContextEngIDLength());
                    for (int j = 0; j < this.dataModel.getRowCount(); ++j) {
                        if (!string3.equals((String)this.dataModel.getValueAt(j, 0)) || !((String)objectArray2[i]).equals((String)this.dataModel.getValueAt(j, 1)) || !((String)objectArray[0]).equals((String)this.dataModel.getValueAt(j, 3)) || !"ons_proxy_user".equals((String)this.dataModel.getValueAt(j, 5)) || !string2.equals((String)this.dataModel.getValueAt(j, 4))) continue;
                        String string4 = (String)this.dataModel.getValueAt(j, 2);
                        if ((!this.read.isSelected() || !string4.equals("READ")) && (!this.write.isSelected() || !string4.equals("WRITE"))) continue;
                        string = null == string ? (String)objectArray2[i] : string + ", " + (String)objectArray2[i];
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while checking for duplicates.");
            }
        }
        if (bl) {
            ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SNMPV3_PROXY_DUPLICATE, "SNMPv3 Proxy Forwarder", "Target IP(s) : ", string);
        }
        return bl;
    }

    private boolean checkIfProxyEntryExistsManual() {
        boolean bl = false;
        String string = SnmpUtil.getEngineIDPadded(this.ctxtEngIDTB.getText());
        String string2 = (String)this.targetIPCB.getSelectedItem();
        String string3 = (String)this.localUserCB.getSelectedItem();
        String string4 = this.udPane.getUserName();
        String string5 = SnmpUtil.securityLevel[this.udPane.getSecurityLevel()].getKey();
        String string6 = ((Attribute)this.secLevelCB.getSelectedItem()).getKey();
        for (int i = 0; i < this.dataModel.getRowCount(); ++i) {
            if (!string.equals((String)this.dataModel.getValueAt(i, 0)) || !string2.equals((String)this.dataModel.getValueAt(i, 1)) || !string3.equals((String)this.dataModel.getValueAt(i, 3)) || !string4.equals((String)this.dataModel.getValueAt(i, 5)) || !string5.equals((String)this.dataModel.getValueAt(i, 6)) || !string6.equals((String)this.dataModel.getValueAt(i, 4))) continue;
            String string7 = (String)this.dataModel.getValueAt(i, 2);
            if ((!this.read.isSelected() || !string7.equals("READ")) && (!this.write.isSelected() || !string7.equals("WRITE"))) continue;
            bl = true;
        }
        if (bl) {
            ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SNMPV3_PROXY_DUPLICATE, "SNMPv3 Proxy Forwarder", "Target Address : ", string2);
        }
        return bl;
    }

    private void deleteProxyTableRows() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Are you sure you want to delete the selected row" + (nArray.length > 1 ? "s?" : "?")), (String)"Confirmation Dialog")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        String[] stringArray = new String[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0 && nArray[n] < this.dataModel.getRowCount()) {
                stringArray[n] = (String)this.dataModel.getValueAt(nArray[n], 7);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n]);
            stringArray[n] = null;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            try {
                this.parentPane.getCurrentGneSnmpModel().setSnmpV3ProxyWrapper((Object)stringArray[n]);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while deleting Proxy table entry");
            }
        }
    }

    protected JPanel getButtonBar() {
        this.manualCreatePB = this.makeActionButton(MANUAL_CREATE);
        this.autoCreatePB = this.makeActionButton(AUTO_CREATE);
        this.deletePB = this.makeActionButton(DELETE);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.manualCreatePB);
        jPanel.add(this.autoCreatePB);
        jPanel.add(this.deletePB);
        return jPanel;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.dataModel.getRowCount();
                boolean bl = n == 0;
                int n2 = this.table.getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    protected class Snmpv3ProxyTableRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isResizable() {
            return true;
        }

        public int getWidth() {
            return 230;
        }
    }

    protected class Snmpv3ProxyTableModel
    extends AbstractTableModel {
        public static final int ContextEngineID_INDEX = 0;
        public static final int TargetAddress_INDEX = 1;
        public static final int ProxyType_INDEX = 2;
        public static final int LocalUser_INDEX = 3;
        public static final int LocalSecurityLevel_INDEX = 4;
        public static final int RemoteUser_INDEX = 5;
        public static final int RemoteSecurityLevel_INDEX = 6;
        public static final int ProxyName_INDEX = 7;
        public final String[] columnNames = new String[]{"Context Engine ID", "Target Address", "Proxy Type", "Local User", "Local Security Level", "Remote User", "Remote Security Level"};

        protected Snmpv3ProxyTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return Snmpv3ProxyTablePane.this.tableDataList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (Snmpv3ProxyTablePane.this.tableDataList != null && n < Snmpv3ProxyTablePane.this.tableDataList.size()) {
                switch (n2) {
                    case 0: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).contextEngID;
                    }
                    case 1: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).targetIP;
                    }
                    case 3: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).localUser;
                    }
                    case 5: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).remoteUser;
                    }
                    case 2: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).proxyType;
                    }
                    case 7: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).proxyName;
                    }
                    case 4: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).localUserSecLevel;
                    }
                    case 6: {
                        return ((SnmpV3ProxyFwd)Snmpv3ProxyTablePane.this.tableDataList.get((int)n)).remoteUserSecLevel;
                    }
                }
                return "";
            }
            return null;
        }

        public boolean isResizable() {
            return true;
        }

        public int getWidth() {
            return 230;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

