/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISnmpModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpV3EngineContainer;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.snmp.SnmpProxyPane;
import cerent.cms.ui.snmp.Snmpv3UserEditDialog;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class Snmpv3RemoteUserPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    public static final String EDIT = "Edit...";
    public static final String DELETE = "Delete...";
    protected Snmpv3RemoteUserModel dataModel;
    protected ArrayList tableDataList;
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton editPB;
    private JButton deletePB;
    private SnmpProxyPane parentPane;
    private boolean inited = false;

    public Snmpv3RemoteUserPane(String string, TabbedView tabbedView, SnmpProxyPane snmpProxyPane) {
        super(string, tabbedView.getUiModel(), tabbedView);
        this.parentPane = snmpProxyPane;
        this.init();
    }

    public boolean isInited() {
        return this.inited;
    }

    protected void init() {
        block6: {
            if (db.on()) {
                db.println(" Snmpv3RemoteUserPane : init");
            }
            this.tableDataList = new ArrayList();
            this.dataModel = this.createTableModel();
            this.dataModel.addTableModelListener(this);
            this.table = new UTable((TableModel)this.dataModel);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(2);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.prepareColumns();
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
            this.buttons = this.getButtonBar();
            this.add(this.buttons, "South");
            ArrayList arrayList = this.parentPane.getAllGnes();
            for (int i = 0; i < arrayList.size(); ++i) {
                ((INodeModel)arrayList.get(i)).getSnmpModel().addObserver((Observer)((Object)this));
            }
            ISnmpModel iSnmpModel = this.parentPane.getCurrentGneSnmpModel();
            if (null != iSnmpModel) {
                try {
                    SnmpV3ProxyUser[] snmpV3ProxyUserArray = iSnmpModel.getSnmpV3UserWrapper();
                    boolean bl = false;
                    SnmpV3EngineContainer snmpV3EngineContainer = this.parentPane.getCurrentGneSnmpModel().getSnmpV3EngineWrapper();
                    for (SnmpV3ProxyUser snmpV3ProxyUser : snmpV3ProxyUserArray) {
                        if (snmpV3ProxyUser.getEngine().equals((Object)snmpV3EngineContainer)) continue;
                        this.tableDataList.add(snmpV3ProxyUser);
                    }
                    this.refreshTable();
                }
                catch (Exception exception) {
                    if (!db.on()) break block6;
                    SDebug.printStackTrace((Throwable)exception);
                    db.println("Error while getting the Remote users");
                }
            }
        }
        this.inited = true;
    }

    protected Snmpv3RemoteUserModel createTableModel() {
        return new Snmpv3RemoteUserModel();
    }

    protected void prepareColumns() {
        Snmpv3ProxyTableRenderer snmpv3ProxyTableRenderer = new Snmpv3ProxyTableRenderer();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.table.getColumn(this.dataModel.getColumnName(i)).setCellRenderer(snmpv3ProxyTableRenderer);
        }
        this.table.getColumn(this.dataModel.getColumnName(0)).setMinWidth(230);
        this.table.getColumn(this.dataModel.getColumnName(1)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(2)).setMinWidth(200);
        this.table.getColumn(this.dataModel.getColumnName(3)).setMinWidth(200);
    }

    public void enteringPage() {
        block4: {
            if (db.on()) {
                db.println("Snmpv3RemoteUserPane >>> enteringPage ");
            }
            try {
                if (!this.inited) {
                    this.init();
                }
                this.refresh();
                TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void leavingPage() throws Exception {
        if (Snmpv3RemoteUserPane.db.on) {
            db.println("Snmpv3RemoteUserPane >>> leavingPage()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void update(Observable observable, Object object) {
        this.refresh();
    }

    public void refresh() {
        this.tableDataList.clear();
        this.tableDataList.addAll(this.parentPane.getSnmpv3RemoteUsers());
        this.refreshTable();
    }

    protected void refreshTable() {
        this.dataModel.fireTableDataChanged();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.dataModel.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        if (!this.isUserAuthorized()) {
            bl = false;
        }
        if (!bl) {
            this.clearTableSelection();
        }
        this.deletePB.setEnabled(bl && this.table.getSelectedRowCount() > 0);
        this.editPB.setEnabled(bl && this.table.getSelectedRowCount() == 1);
    }

    protected void clearTableSelection() {
        if (this.table != null && this.tableDataList.size() != 0) {
            this.table.removeRowSelectionInterval(0, this.tableDataList.size() - 1);
        }
    }

    protected void removeActionListeners() {
        this.editPB.removeActionListener(this);
        this.deletePB.removeActionListener(this);
    }

    public void destroy() {
        if (db.on()) {
            db.println(">>>  destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.removeActionListeners();
        }
        super.destroy();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deletePB) {
            this.deleteRemoteUsers();
        } else if (object == this.editPB) {
            this.editRemoteUser();
        }
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private void editRemoteUser() {
        int n = this.table.getSelectedRow();
        this.setEditDeleteEnabled(false);
        SnmpV3ProxyUser snmpV3ProxyUser = this.dataModel.getUserRow(n);
        Snmpv3UserEditDialog snmpv3UserEditDialog = Snmpv3UserEditDialog.instance(this, this.parentPane);
        if (snmpV3ProxyUser != null) {
            snmpv3UserEditDialog.setSelectedUser(snmpV3ProxyUser);
        }
        snmpv3UserEditDialog.show();
        snmpv3UserEditDialog.dispose();
    }

    private void deleteRemoteUsers() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Are you sure you want to delete the selected row" + (nArray.length > 1 ? "s?" : "?")), (String)"Confirmation Dialog")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        SnmpV3ProxyUser[] snmpV3ProxyUserArray = new SnmpV3ProxyUser[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0 && nArray[n] < this.dataModel.getRowCount()) {
                snmpV3ProxyUserArray[n] = this.dataModel.getUserRow(nArray[n]);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n]);
            snmpV3ProxyUserArray[n] = null;
        }
        for (n = 0; n < snmpV3ProxyUserArray.length; ++n) {
            if (snmpV3ProxyUserArray[n] == null) continue;
            try {
                Object[] objectArray = new Object[]{snmpV3ProxyUserArray[n].getuserName(), snmpV3ProxyUserArray[n].getEngine()};
                this.parentPane.getCurrentGneSnmpModel().setSnmpV3UserWrapper((Object)objectArray);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while deleting Proxy table entry");
            }
        }
    }

    protected JPanel getButtonBar() {
        this.editPB = this.makeActionButton(EDIT);
        this.deletePB = this.makeActionButton(DELETE);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.editPB);
        jPanel.add(this.deletePB);
        return jPanel;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.dataModel.getRowCount();
                boolean bl = n == 0;
                int n2 = this.table.getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    protected class Snmpv3ProxyTableRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public boolean isResizable() {
            return true;
        }

        public int getWidth() {
            return 230;
        }
    }

    protected class Snmpv3RemoteUserModel
    extends AbstractTableModel {
        public static final int ContextEngineID_INDEX = 0;
        public static final int UserName_INDEX = 1;
        public static final int AuthProtocol_INDEX = 2;
        public static final int PrivacyProtocol_INDEX = 3;
        public final String[] columnNames = new String[]{"Context Engine ID", "User Name", "Authentication Protocol", "Privacy Protocol"};

        protected Snmpv3RemoteUserModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return Snmpv3RemoteUserPane.this.tableDataList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (Snmpv3RemoteUserPane.this.tableDataList != null && n < Snmpv3RemoteUserPane.this.tableDataList.size()) {
                SnmpV3ProxyUser snmpV3ProxyUser = (SnmpV3ProxyUser)Snmpv3RemoteUserPane.this.tableDataList.get(n);
                switch (n2) {
                    case 0: {
                        String string = SnmpUtil.toStringEngineID(((SnmpV3ProxyUser)Snmpv3RemoteUserPane.this.tableDataList.get(n)).getEngine().getContextEngID(), ((SnmpV3ProxyUser)Snmpv3RemoteUserPane.this.tableDataList.get(n)).getEngine().getContextEngIDLength());
                        return string;
                    }
                    case 1: {
                        return snmpV3ProxyUser.getuserName();
                    }
                    case 2: {
                        return this.convertAuthProto(snmpV3ProxyUser.getauthProtocol());
                    }
                    case 3: {
                        return this.convertPrivProto(snmpV3ProxyUser.getprivProtocol());
                    }
                }
                return "";
            }
            return null;
        }

        public SnmpV3ProxyUser getUserRow(int n) {
            SnmpV3ProxyUser snmpV3ProxyUser = null;
            if (Snmpv3RemoteUserPane.this.tableDataList != null && n < Snmpv3RemoteUserPane.this.tableDataList.size()) {
                snmpV3ProxyUser = (SnmpV3ProxyUser)Snmpv3RemoteUserPane.this.tableDataList.get(n);
            }
            return snmpV3ProxyUser;
        }

        public String convertAuthProto(int n) {
            switch (n) {
                case 1: {
                    return "MD5";
                }
                case 2: {
                    return "SHA";
                }
                case 0: {
                    return "NONE";
                }
            }
            return "???";
        }

        protected String convertPrivProto(int n) {
            switch (n) {
                case 1: {
                    return "DES";
                }
                case 0: {
                    return "NONE";
                }
            }
            return "???";
        }

        public boolean isResizable() {
            return true;
        }

        public int getWidth() {
            return 230;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

