/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.ui.span.SdAbstractPane;
import cerent.cms.ui.span.SpanUpgradeDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class SdBlsrPane
extends SdAbstractPane {
    protected static final int FIRST_PAGE = 1;
    protected static final int LAST_PAGE = 6;
    private boolean is4Fiber;

    public SdBlsrPane(String string, SpanUpgradeDialog spanUpgradeDialog, int n, boolean bl) {
        super(string, spanUpgradeDialog, n);
        this.is4Fiber = bl;
    }

    protected int getFirstPageNum() {
        return 1;
    }

    protected int getLastPageNum() {
        return 6;
    }

    protected String getTopMessage() {
        return "You are about to perform a span upgrade.  At each step,\nalways verify that no unexpected service affecting alarms are\nraised.\n \nTo continue, select the upgrade below:";
    }

    protected String getDesc() {
        String string = "";
        switch (this.step) {
            case 2: {
                string = "The system is about to send a force ring command to both end\nports to switch the traffic away from this span.\n \nWhen you are ready, click Next.";
                break;
            }
            case 3: {
                String string2 = "Remove the";
                String string3 = "from the following";
                string = this.getEquipmentChangeString(OLD_EQUIPMENT, string2, string3) + " \nWhen you are done, click Next.";
                break;
            }
            case 4: {
                String string4 = "Insert the";
                String string5 = "into the following";
                string = this.getEquipmentChangeString(NEW_EQUIPMENT, string4, string5) + " \nWhen the cards finish booting, test the optical receive levels\n" + "for the newly installed card and apply attenuation, if needed.\n" + "Refer to the user documentation for minimum/maximum\n" + "optical levels.\n \n" + "When you are ready, reconnect the fibers and click Next.";
                break;
            }
            case 5: {
                string = "Check that no unexpected service affecting alarms are raised\nfor the following slots:\n \n" + this.getStringForAffectedSlots("") + " \nClick Next to send a CLEAR command to both end ports and switch\n" + "the traffic back to this span.";
                break;
            }
            case 6: {
                string = "You have completed a span upgrade.  Click the Finish button\nto exit this dialog box.";
            }
        }
        return string;
    }

    private void performStep1() throws Exception {
        this.parent.setEquipmentInfo(this.srcEqTypeCB.getSelectedItem(), this.dstEqTypeCB.getSelectedItem(), this.portRateCB.getSelectedItem());
        if (!this.linkModel.isBlsrClear()) {
            throw new Exception("The span upgrade cannot proceed because a\nmaintenance command other than CLEAR is in place.");
        }
        this.parent.setStatusText("- Upgrading to " + this.parent.getNewEquipmentsString() + "\n");
    }

    private void performStep2() throws Exception {
        short s = this.linkModel.setBlsrForceRing();
        if (s == -1) {
            throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
        }
        this.parent.setStatusText("- FORCE_RING sent\n");
    }

    private void performStep3() throws Exception {
        this.parent.setStatusText("- Provisioned the slots to " + this.parent.getNewEquipmentsString() + "\n" + this.getSlotString(this.parent.srcInfo, "  ") + "\n" + this.getSlotString(this.parent.dstInfo, "  ") + "\n");
        this.checkNodeInitiations();
        this.parent.srcInfo.changeToNewEquipment();
        this.parent.dstInfo.changeToNewEquipment();
    }

    private void performStep5() throws Exception {
        this.setBlsrClear();
        this.parent.setStatusText("- CLEAR sent\n");
    }

    private void setBlsrClear() throws Exception {
        short s = this.linkModel.setBlsrClear();
        if (s == -1) {
            throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
        }
    }

    public void validatePage() throws Exception {
        try {
            this.parent.setStatusText("");
            switch (this.step) {
                case 1: {
                    this.performStep1();
                    break;
                }
                case 2: {
                    this.performStep2();
                    break;
                }
                case 3: {
                    this.performStep3();
                    break;
                }
                case 5: {
                    this.performStep5();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            SdBlsrPane sdBlsrPane = this;
            sdBlsrPane.parent.getDebug();
            SDebug.printStackTrace((Throwable)nullPointerException);
            throw new Exception("A system or network condition is preventing the span upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
        }
    }

    public void handleCancel() {
        if (this.step == 4 && CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to revert the provision for\n" + this.getSlotString(this.parent.srcInfo, "  ") + "\n" + this.getSlotString(this.parent.dstInfo, "  ") + "?"), (String)"Cancel Span Upgrade", (int)0)) {
            try {
                this.parent.srcInfo.revertToOldEquipment();
                this.parent.dstInfo.revertToOldEquipment();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_GENERAL_EXCEPTION);
            }
        }
        if (this.step >= 3 && this.step <= 5 && CerentDialog.yesNoDialog((Component)this.parent, (String)"Would you like to switch the traffic back to this span?", (String)"Cancel Span Upgrade", (int)0)) {
            try {
                this.setBlsrClear();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_RING_SWITCHING_ERROR);
            }
        }
    }
}

