/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeModelAndIndex;
import cerent.cms.model.ISVlanProfile;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.ISVlanProfileModels;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SVlanProfile;
import cerent.cms.ui.vlan.SVlanProfileChangedEvent;
import cerent.util.IDisposable;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayableSVlanProfile
extends UObservable
implements Comparable<DisplayableSVlanProfile>,
Cloneable,
IObserver,
IObservable,
IDisposable {
    private static ThreadLocal<EventThunk> deferredNotifs = new ThreadLocal<EventThunk>(){

        @Override
        protected synchronized EventThunk initialValue() {
            return null;
        }
    };
    private static final Comparator comp = new Comp();
    public static final String INTERNAL_SOURCE = "None";
    private Obs obs;
    private ObservableManager om;
    private ISVlanProfile profile;
    private SortedSet sources;
    private boolean wasEdited;
    private int numINodeModelAndIndexSources;
    private boolean isDisposed;
    private static SDebug db = new SDebug("DisplayableSVlanProfile");

    private static void resetNotification() {
        for (EventThunk eventThunk = deferredNotifs.get(); eventThunk != null; eventThunk = eventThunk.getNext()) {
            if (eventThunk.wasFired()) continue;
            SDebug.printStackTrace((Throwable)new Exception("warning: unfired thunk will be lost: " + eventThunk));
        }
        deferredNotifs.set(null);
    }

    private static void deferNotification(EventThunk eventThunk) {
        if (db.on() && eventThunk != null) {
            db.println("deferNotification(" + eventThunk + ")");
        }
        EventThunk eventThunk2 = deferredNotifs.get();
        eventThunk.setNext(eventThunk2);
        deferredNotifs.set(eventThunk);
    }

    private static EventThunk performNotification() {
        EventThunk eventThunk;
        int n = 0;
        EventThunk eventThunk2 = eventThunk = deferredNotifs.get();
        while (eventThunk != null) {
            ++n;
            eventThunk = eventThunk.getNext();
        }
        if (n == 0) {
            return null;
        }
        ArrayList<EventThunk> arrayList = new ArrayList<EventThunk>(n);
        for (eventThunk = deferredNotifs.get(); eventThunk != null; eventThunk = eventThunk.getNext()) {
            arrayList.add(eventThunk);
        }
        for (int i = n - 1; i >= 0; --i) {
            eventThunk = (EventThunk)arrayList.get(i);
            if (db.on()) {
                db.println("firing thunk: " + eventThunk);
            }
            eventThunk.run();
        }
        DisplayableSVlanProfile.resetNotification();
        return eventThunk2;
    }

    public DisplayableSVlanProfile(ISVlanProfile iSVlanProfile, Set set) {
        this.checkProfile(iSVlanProfile);
        this.createObserver();
        this.sources = new TreeSet(comp);
        this.profile = iSVlanProfile;
        if (set != null) {
            this.sources.addAll(set);
            this.subscribeForModelUpdates();
        }
        this.removeInternalSource();
    }

    public DisplayableSVlanProfile(ISVlanProfile iSVlanProfile, String string) {
        this.checkProfile(iSVlanProfile);
        this.createObserver();
        this.sources = new TreeSet(comp);
        this.profile = iSVlanProfile;
        if (string != null) {
            this.sources.add(string);
        }
    }

    public DisplayableSVlanProfile(ISVlanProfile iSVlanProfile, String ... stringArray) {
        this.checkProfile(iSVlanProfile);
        this.createObserver();
        this.sources = new TreeSet(comp);
        this.profile = iSVlanProfile;
        Collections.addAll(this.sources, stringArray);
        this.removeInternalSource();
    }

    public DisplayableSVlanProfile(ISVlanProfile iSVlanProfile, INodeModelAndIndex iNodeModelAndIndex) {
        this.checkProfile(iSVlanProfile);
        this.createObserver();
        this.sources = new TreeSet(comp);
        this.profile = iSVlanProfile;
        if (iNodeModelAndIndex != null && this.sources.add(iNodeModelAndIndex)) {
            ++this.numINodeModelAndIndexSources;
            this.subscribeForModelUpdates(iNodeModelAndIndex);
        }
        this.removeInternalSource();
    }

    private void checkProfile(ISVlanProfile iSVlanProfile) {
        if (iSVlanProfile == null) {
            throw new IllegalArgumentException("profile must be non-null");
        }
    }

    private void createObserver() {
        this.obs = new Obs();
        this.om = new ObservableManager(this.obs, true);
        this.om.setPassing(true);
    }

    public synchronized void setPassing(boolean bl) {
        this.om.setPassing(bl);
    }

    public synchronized boolean isDirty() {
        return this.om.getBlockingModeControllerState() > 0;
    }

    public synchronized ISVlanProfile getCopyOfProfile(String string) {
        String string2 = string != null ? string : this.profile.getName();
        SVlanProfile sVlanProfile = new SVlanProfile(this.profile, string2);
        return sVlanProfile;
    }

    public synchronized DisplayableSVlanProfile createNewDisplayableSVlanProfile(ISVlanProfile iSVlanProfile) {
        DisplayableSVlanProfile displayableSVlanProfile = new DisplayableSVlanProfile(iSVlanProfile, this.getSources());
        return displayableSVlanProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNeRefresh() {
        DisplayableSVlanProfile.resetNotification();
        Object object = this;
        synchronized (object) {
            this.refreshFromExistingNeSources();
        }
        object = DisplayableSVlanProfile.performNotification();
        if (object != null && db.on()) {
            ((EventThunk)object).log("forceNeRefresh()");
        }
    }

    public synchronized boolean wasEdited() {
        return this.wasEdited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setWasEdited(boolean bl) {
        DisplayableSVlanProfile.resetNotification();
        boolean bl2 = false;
        Object object = this;
        synchronized (object) {
            bl2 = this._setWasEdited(bl);
        }
        object = DisplayableSVlanProfile.performNotification();
        if (object != null && db.on()) {
            ((EventThunk)object).log("setWasEdited(" + bl + ")");
        }
        return bl2;
    }

    private boolean _setWasEdited(boolean bl) {
        if (db.on()) {
            db.println(this.toShortString() + " _setWasEdited() - # of observers: " + this.countObservers());
        }
        boolean bl2 = this.wasEdited;
        this.wasEdited = bl;
        boolean bl3 = true;
        if (db.on() && bl2 != bl) {
            db.println("setWasEdited(" + bl + ") for profile: " + this);
        }
        if (!bl2 && bl) {
            this.unsubscribeForModelUpdates();
            DisplayableSVlanProfile.deferNotification(new EventThunk(ModelUpdateType.CHANGED));
        } else if (bl2 && !bl) {
            this.subscribeForModelUpdates();
            bl3 = this.refreshFromExistingNeSources();
            this.profile.clearOrigName();
            DisplayableSVlanProfile.deferNotification(new EventThunk(ModelUpdateType.CHANGED));
        }
        return bl3;
    }

    private SortedSet getSources() {
        return this.sources;
    }

    public synchronized Set getCopyOfSources() {
        TreeSet treeSet = new TreeSet(comp);
        treeSet.addAll(this.sources);
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equalSources(DisplayableSVlanProfile displayableSVlanProfile) {
        boolean bl = false;
        if (this == displayableSVlanProfile) {
            return true;
        }
        DisplayableSVlanProfile displayableSVlanProfile2 = displayableSVlanProfile;
        synchronized (displayableSVlanProfile2) {
            bl = this.getSources().equals(displayableSVlanProfile.getSources());
        }
        return bl;
    }

    public synchronized boolean containsSource(Object object) {
        return this.sources.contains(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileSources() {
        LinkedList<String> linkedList = new LinkedList<String>();
        DisplayableSVlanProfile displayableSVlanProfile = this;
        synchronized (displayableSVlanProfile) {
            for (Object e : this.sources) {
                if (!(e instanceof String) || e == INTERNAL_SOURCE) continue;
                linkedList.add((String)e);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<INodeModelAndIndex> getNodeSources() {
        LinkedList<INodeModelAndIndex> linkedList = new LinkedList<INodeModelAndIndex>();
        DisplayableSVlanProfile displayableSVlanProfile = this;
        synchronized (displayableSVlanProfile) {
            for (Object e : this.sources) {
                if (!(e instanceof INodeModelAndIndex)) continue;
                linkedList.add((INodeModelAndIndex)e);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodeModelAndIndex getMatchingNodeSource(INodeModel iNodeModel) {
        INodeModelAndIndex iNodeModelAndIndex = null;
        DisplayableSVlanProfile displayableSVlanProfile = this;
        synchronized (displayableSVlanProfile) {
            for (Object e : this.sources) {
                if (!(e instanceof INodeModelAndIndex)) continue;
                INodeModelAndIndex iNodeModelAndIndex2 = (INodeModelAndIndex)e;
                if (iNodeModelAndIndex2.nm.getNodeId() != iNodeModel.getNodeId()) continue;
                iNodeModelAndIndex = iNodeModelAndIndex2;
                break;
            }
        }
        return iNodeModelAndIndex;
    }

    Object getSource() {
        Object var1_1 = null;
        if (this.sources.size() > 0) {
            Iterator iterator = this.sources.iterator();
            var1_1 = iterator.next();
        }
        return var1_1;
    }

    private int compareSources(SortedSet sortedSet) {
        int n = 0;
        Iterator iterator = this.sources.iterator();
        Iterator iterator2 = sortedSet.iterator();
        iterator = this.sources.iterator();
        iterator2 = sortedSet.iterator();
        while (iterator.hasNext() && iterator2.hasNext() && n == 0) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            n = comp.compare(e, e2);
        }
        if (n == 0) {
            if (iterator.hasNext()) {
                if (!iterator2.hasNext()) {
                    n = 1;
                }
            } else {
                n = -1;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int compareTo(DisplayableSVlanProfile displayableSVlanProfile) {
        int n;
        int n2 = n = this == displayableSVlanProfile ? 0 : -1;
        if (n != 0) {
            DisplayableSVlanProfile displayableSVlanProfile2 = displayableSVlanProfile;
            synchronized (displayableSVlanProfile2) {
                n = this.profile.getName().compareTo(displayableSVlanProfile.profile.getName());
                if (n == 0) {
                    n = this.compareSources(displayableSVlanProfile.sources);
                }
            }
        }
        return n;
    }

    public synchronized String getName() {
        return this.profile.getName();
    }

    public synchronized short getCommittedInfoRate() {
        return this.profile.getCommittedInfoRate();
    }

    public synchronized int getCommittedBurstSize() {
        return this.profile.getCommittedBurstSize();
    }

    public synchronized short getPeakInfoRate() {
        return this.profile.getPeakInfoRate();
    }

    public synchronized int getPeakBurstSize() {
        return this.profile.getPeakBurstSize();
    }

    public synchronized boolean getCouplingFlag() {
        return this.profile.getCouplingFlag();
    }

    public synchronized boolean getColorMode() {
        return this.profile.getColorMode();
    }

    public synchronized boolean getLinkIntegrity() {
        return this.profile.getLinkIntegrity();
    }

    public synchronized String getOrigName() {
        return this.profile.getOrigName();
    }

    public synchronized boolean clearOrigName(String string) {
        boolean bl = false;
        if (string.equals(this.profile.getOrigName())) {
            bl = true;
            this.profile.clearOrigName();
        }
        return bl;
    }

    String checkName(String string) {
        String string2 = null;
        try {
            if (this.profile instanceof SVlanProfile) {
                SVlanProfile cfr_ignored_0 = (SVlanProfile)this.profile;
                SVlanProfile.checkName(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = illegalArgumentException.getMessage();
        }
        return string2;
    }

    public synchronized void setName(String string) {
        if (!this.profile.getName().equals(string)) {
            if (!this.wasEdited) {
                this.profile.clearOrigName();
            }
            this.profile.setName(string);
            this.setWasEdited(true);
        }
    }

    public synchronized void setCommittedInfoRate(short s) {
        if (this.profile.getCommittedInfoRate() != s) {
            this.profile.setCommittedInfoRate(s);
            this.setWasEdited(true);
        }
    }

    public synchronized void setCommittedBurstSize(int n) {
        if (this.profile.getCommittedBurstSize() != n) {
            this.profile.setCommittedBurstSize(n);
            this.setWasEdited(true);
        }
    }

    public synchronized void setPeakInfoRate(short s) {
        if (this.profile.getPeakInfoRate() != s) {
            this.profile.setPeakInfoRate(s);
            this.setWasEdited(true);
        }
    }

    public synchronized void setPeakBurstSize(int n) {
        if (this.profile.getPeakBurstSize() != n) {
            this.profile.setPeakBurstSize(n);
            this.setWasEdited(true);
        }
    }

    public synchronized void setCouplingFlag(boolean bl) {
        if (this.profile.getCouplingFlag() != bl) {
            this.profile.setCouplingFlag(bl);
            this.setWasEdited(true);
        }
    }

    public synchronized void setColorMode(boolean bl) {
        if (this.profile.getColorMode() != bl) {
            this.profile.setColorMode(bl);
            this.setWasEdited(true);
        }
    }

    public synchronized void setLinkIntegrity(boolean bl) {
        if (this.profile.getLinkIntegrity() != bl) {
            this.profile.setLinkIntegrity(bl);
            this.setWasEdited(true);
        }
    }

    public synchronized int hashCode() {
        return this.profile.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof DisplayableSVlanProfile) {
            Object object2 = object;
            synchronized (object2) {
                bl = this.profile.equals(((DisplayableSVlanProfile)object).profile);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean containsSources(DisplayableSVlanProfile displayableSVlanProfile, Object object) {
        boolean bl;
        boolean bl2 = bl = object == null || this.sources.contains(object);
        if (bl && displayableSVlanProfile != null) {
            DisplayableSVlanProfile displayableSVlanProfile2 = displayableSVlanProfile;
            synchronized (displayableSVlanProfile2) {
                bl = this.sources.containsAll(displayableSVlanProfile.getSources());
            }
        }
        return bl;
    }

    private boolean removeInternalSource() {
        return this.sources.size() <= 1 ? false : this.sources.remove(INTERNAL_SOURCE);
    }

    public boolean updateSource(Object object) {
        boolean bl = object instanceof String ? this.updateSource((String)object) : (object instanceof INodeModelAndIndex ? this.updateSource((INodeModelAndIndex)object) : false);
        return bl;
    }

    public synchronized boolean updateSource(String string) {
        boolean bl = false;
        if (!this.sources.contains(string)) {
            this.removeInternalSource();
            this.sources.add(string);
            bl = true;
        }
        return bl;
    }

    public synchronized DisplayableSVlanProfile updateSourceInClone(String string) {
        DisplayableSVlanProfile displayableSVlanProfile = this;
        if (string == null) {
            return displayableSVlanProfile;
        }
        if (!this.sources.contains(string)) {
            displayableSVlanProfile = (DisplayableSVlanProfile)this.clone();
            displayableSVlanProfile.sources.add(string);
            displayableSVlanProfile.removeInternalSource();
        }
        return displayableSVlanProfile;
    }

    public synchronized DisplayableSVlanProfile updateSourceInClone(DisplayableSVlanProfile displayableSVlanProfile, Object object) {
        if (db.on()) {
            db.println("updateSourceInClone(" + displayableSVlanProfile + ", " + object + ")");
            db.println("...for profile: " + this);
        }
        boolean bl = false;
        DisplayableSVlanProfile displayableSVlanProfile2 = null;
        if (displayableSVlanProfile == null || displayableSVlanProfile == this) {
            return displayableSVlanProfile2;
        }
        if (object != null && !this.sources.contains(object)) {
            if (displayableSVlanProfile2 == null) {
                bl = true;
                displayableSVlanProfile2 = (DisplayableSVlanProfile)this.clone();
            }
            displayableSVlanProfile2.sources.add(object);
            displayableSVlanProfile2.subscribeForModelUpdatesOnSource(object);
        }
        for (Object e : displayableSVlanProfile.sources) {
            if (e.equals(object) || this.sources.contains(e)) continue;
            if (displayableSVlanProfile2 == null) {
                bl = true;
                displayableSVlanProfile2 = (DisplayableSVlanProfile)this.clone();
            }
            displayableSVlanProfile2.sources.add(e);
            displayableSVlanProfile2.subscribeForModelUpdatesOnSource(e);
        }
        if (bl) {
            super.removeInternalSource();
        }
        if (displayableSVlanProfile2 != null && db.on()) {
            db.println("updateSourceInClone returned clone: " + displayableSVlanProfile2);
        }
        return displayableSVlanProfile2;
    }

    public synchronized boolean updateSource(INodeModelAndIndex iNodeModelAndIndex) {
        boolean bl = false;
        if (!this.sources.contains(iNodeModelAndIndex)) {
            this.removeInternalSource();
            this.sources.add(iNodeModelAndIndex);
            this.subscribeForModelUpdates();
            ++this.numINodeModelAndIndexSources;
            bl = true;
        }
        return bl;
    }

    public synchronized DisplayableSVlanProfile updateSourceInClone(INodeModelAndIndex iNodeModelAndIndex) {
        DisplayableSVlanProfile displayableSVlanProfile = null;
        if (!this.sources.contains(iNodeModelAndIndex)) {
            displayableSVlanProfile = (DisplayableSVlanProfile)this.clone();
            displayableSVlanProfile.sources.add(iNodeModelAndIndex);
            displayableSVlanProfile.subscribeForModelUpdates(iNodeModelAndIndex);
            ++displayableSVlanProfile.numINodeModelAndIndexSources;
        }
        return displayableSVlanProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSource(String string) {
        DisplayableSVlanProfile.resetNotification();
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            bl = this.sources.remove(string);
            if (this.sources.size() == 0) {
                DisplayableSVlanProfile.deferNotification(new EventThunk(ModelUpdateType.DELETED));
            }
        }
        object = DisplayableSVlanProfile.performNotification();
        if (object != null && db.on()) {
            ((EventThunk)object).log("removeSource(" + string + ")");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSource(INodeModelAndIndex iNodeModelAndIndex) {
        DisplayableSVlanProfile.resetNotification();
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            bl = this._removeSource(iNodeModelAndIndex);
            if (bl && this.sources.size() == 0) {
                DisplayableSVlanProfile.deferNotification(new EventThunk(ModelUpdateType.DELETED));
            }
        }
        object = DisplayableSVlanProfile.performNotification();
        if (object != null && db.on()) {
            ((EventThunk)object).log("removeSource(" + iNodeModelAndIndex + ")");
        }
        return bl;
    }

    private boolean _removeSource(INodeModelAndIndex iNodeModelAndIndex) {
        boolean bl = this.sources.remove(iNodeModelAndIndex);
        if (bl) {
            --this.numINodeModelAndIndexSources;
            this.unsubscribeForModelUpdates(iNodeModelAndIndex);
        }
        if (db.on()) {
            db.println("removeSource(" + iNodeModelAndIndex + ") returned: " + bl + " for " + this + " - # of sources is now: " + this.sources.size());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSource(INodeModel iNodeModel) {
        DisplayableSVlanProfile.resetNotification();
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            INodeModelAndIndex iNodeModelAndIndex = this.findINodeModelAndIndex(iNodeModel);
            bl = this._removeSource(iNodeModelAndIndex);
            if (bl && this.sources.size() == 0) {
                DisplayableSVlanProfile.deferNotification(new EventThunk(ModelUpdateType.DELETED));
            }
        }
        object = DisplayableSVlanProfile.performNotification();
        if (object != null) {
            ((EventThunk)object).log("removeSource(" + iNodeModel + ")");
        }
        return bl;
    }

    private INodeModelAndIndex findINodeModelAndIndex(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return null;
        }
        for (Object e : this.sources) {
            if (!(e instanceof INodeModelAndIndex)) continue;
            INodeModelAndIndex iNodeModelAndIndex = (INodeModelAndIndex)e;
            if (iNodeModelAndIndex.nm != iNodeModel) continue;
            return iNodeModelAndIndex;
        }
        return null;
    }

    public synchronized int getNumSources() {
        return this.sources.size();
    }

    public synchronized int getNumINodeModelAndIndexSources() {
        return this.numINodeModelAndIndexSources;
    }

    public synchronized String toShortString() {
        return "profile(" + System.identityHashCode(this) + (this.wasEdited ? "/edited" : "") + ")";
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.toShortString() + ": ");
        stringBuilder.append(this.profile);
        stringBuilder.append("; sources: [");
        for (Object e : this.sources) {
            if (e instanceof INodeModelAndIndex) {
                INodeModelAndIndex iNodeModelAndIndex = (INodeModelAndIndex)e;
                ISVlanProfileModel iSVlanProfileModel = DisplayableSVlanProfile.getModel(iNodeModelAndIndex);
                stringBuilder.append(iNodeModelAndIndex.getName());
                stringBuilder.append("(" + iNodeModelAndIndex.index + ")");
                if (iSVlanProfileModel != null && iSVlanProfileModel.isObserver((Observer)this.om)) {
                    stringBuilder.append("*");
                }
            } else {
                stringBuilder.append(e);
            }
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public synchronized Object clone() {
        DisplayableSVlanProfile displayableSVlanProfile = new DisplayableSVlanProfile((ISVlanProfile)this.profile.clone(), this.sources);
        if (this.wasEdited) {
            displayableSVlanProfile.setWasEdited(true);
        }
        return displayableSVlanProfile;
    }

    public static Collection<ISVlanProfile> getProfiles(Collection<DisplayableSVlanProfile> collection) {
        ArrayList<ISVlanProfile> arrayList = new ArrayList<ISVlanProfile>(collection.size());
        for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
            arrayList.add(displayableSVlanProfile.getCopyOfProfile(null));
        }
        return arrayList;
    }

    private boolean isSingleModelSourced() {
        return this.getNumSources() == 1 && this.getNumINodeModelAndIndexSources() == 1;
    }

    public synchronized INodeModelAndIndex getModelIfSingleModelSourced() {
        INodeModelAndIndex iNodeModelAndIndex = null;
        if (this.isSingleModelSourced()) {
            iNodeModelAndIndex = (INodeModelAndIndex)this.getSource();
        }
        return iNodeModelAndIndex;
    }

    private ISVlanProfileModel getModel() {
        ISVlanProfileModel iSVlanProfileModel = null;
        Object object = this.getSource();
        if (object instanceof INodeModelAndIndex) {
            iSVlanProfileModel = DisplayableSVlanProfile.getModel((INodeModelAndIndex)object);
        }
        return iSVlanProfileModel;
    }

    public static ISVlanProfileModel getModel(INodeModelAndIndex iNodeModelAndIndex) {
        INodeModelAndIndex iNodeModelAndIndex2 = iNodeModelAndIndex;
        INodeModel iNodeModel = iNodeModelAndIndex2.nm;
        ISVlanProfileModels iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
        ISVlanProfileModel iSVlanProfileModel = iSVlanProfileModels.getSVlanProfileModel(iNodeModelAndIndex2.index);
        return iSVlanProfileModel;
    }

    synchronized void subscribeForModelUpdatesOnNode(INodeModel iNodeModel) {
        for (Object e : this.sources) {
            ISVlanProfileModel iSVlanProfileModel;
            if (!(e instanceof INodeModelAndIndex) || (iSVlanProfileModel = DisplayableSVlanProfile.getModel((INodeModelAndIndex)e)) == null || iSVlanProfileModel.getNodeModel().getNodeId() != iNodeModel.getNodeId()) continue;
            this.subscribeForModelUpdates(iSVlanProfileModel);
            break;
        }
    }

    synchronized void subscribeForModelUpdatesOnSource(Object object) {
        if (object instanceof INodeModelAndIndex) {
            this.subscribeForModelUpdates((INodeModelAndIndex)object);
        }
    }

    private void subscribeForModelUpdates(INodeModelAndIndex iNodeModelAndIndex) {
        ISVlanProfileModel iSVlanProfileModel = DisplayableSVlanProfile.getModel(iNodeModelAndIndex);
        this.subscribeForModelUpdates(iSVlanProfileModel);
    }

    private void subscribeForModelUpdates(ISVlanProfileModel iSVlanProfileModel) {
        if (iSVlanProfileModel != null) {
            this._subscribeForModelUpdates(iSVlanProfileModel);
            if (db.on()) {
                db.println("addObserver on: " + iSVlanProfileModel + " for " + this.toShortString());
            }
        }
    }

    private void _subscribeForModelUpdates(ISVlanProfileModel iSVlanProfileModel) {
        this.om.addObservable((Observable)iSVlanProfileModel);
    }

    private void subscribeForModelUpdates() {
        this.subscribeForModelUpdates(this.sources);
    }

    private void subscribeForModelUpdates(Set set) {
        for (Object e : set) {
            if (!(e instanceof INodeModelAndIndex)) continue;
            this.subscribeForModelUpdates((INodeModelAndIndex)e);
        }
    }

    private void unsubscribeForModelUpdates(INodeModelAndIndex iNodeModelAndIndex) {
        ISVlanProfileModel iSVlanProfileModel = DisplayableSVlanProfile.getModel(iNodeModelAndIndex);
        if (iSVlanProfileModel != null) {
            this._unsubscribeForModelUpdates(iSVlanProfileModel);
            if (db.on()) {
                db.println("deleteObserver on: " + iSVlanProfileModel + " for " + this.toShortString());
            }
        }
    }

    private void _unsubscribeForModelUpdates(ISVlanProfileModel iSVlanProfileModel) {
        this.om.removeObservable((Observable)iSVlanProfileModel);
    }

    private void unsubscribeForModelUpdates() {
        for (Object e : this.sources) {
            if (!(e instanceof INodeModelAndIndex)) continue;
            this.unsubscribeForModelUpdates((INodeModelAndIndex)e);
        }
    }

    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.unsubscribeForModelUpdates();
            this.om.reset();
            this.isDisposed = true;
        }
    }

    public synchronized boolean isDisposed() {
        return this.isDisposed;
    }

    private boolean refreshFromExistingNeSources() {
        if (this.wasEdited) {
            if (db.on()) {
                db.println("refreshFromExistingNeSources() was edited...exiting");
            }
            return true;
        }
        TreeSet treeSet = new TreeSet(comp);
        treeSet.addAll(this.sources);
        if (db.on()) {
            db.println("*** refreshFromExistingNeSources() for this: " + this);
            db.println("...total # of sources: " + treeSet.size());
        }
        boolean bl = true;
        for (Object e : treeSet) {
            if (db.on()) {
                db.println("...considering source: " + e);
            }
            if (e instanceof INodeModelAndIndex) {
                INodeModelAndIndex iNodeModelAndIndex = (INodeModelAndIndex)e;
                INodeModel iNodeModel = iNodeModelAndIndex.nm;
                ISVlanProfileModel iSVlanProfileModel = DisplayableSVlanProfile.getModel(iNodeModelAndIndex);
                if (iSVlanProfileModel != null) {
                    if (db.on()) {
                        db.println("doing a refresh using model: " + iSVlanProfileModel + " - from node: " + iNodeModel.getName());
                    }
                    try {
                        this._update((IObservable)iSVlanProfileModel, ModelUpdateType.CHANGED);
                    }
                    catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                        bl = false;
                        if (!db.on()) continue;
                        SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                    }
                    continue;
                }
                if (db.on()) {
                    db.println("model is missing assuming it's no longer available from node: " + iNodeModel.getName());
                }
                this.handleSourceDelete(iNodeModelAndIndex);
                continue;
            }
            if (!(e instanceof String) || !db.on()) continue;
            db.println("skipping file: " + e);
        }
        if (db.on()) {
            db.println("*** refreshFromExistingNeSources() end");
        }
        return bl;
    }

    private void handleSourceDelete(INodeModelAndIndex iNodeModelAndIndex) {
        if (db.on()) {
            db.println("handleSourceDelete(" + iNodeModelAndIndex + ")");
        }
        Integer n = null;
        n = this._removeSource(iNodeModelAndIndex) ? (this.getNumSources() == 0 ? ModelUpdateType.DELETED : ModelUpdateType.CHANGED) : ModelUpdateType.CHANGED;
        if (n != null) {
            DisplayableSVlanProfile.deferNotification(new EventThunk(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IObservable iObservable, Object object) {
        DisplayableSVlanProfile.resetNotification();
        Object object2 = this;
        synchronized (object2) {
            this._update(iObservable, object);
        }
        object2 = DisplayableSVlanProfile.performNotification();
        if (object2 != null && db.on()) {
            ((EventThunk)object2).log("update(" + iObservable + ", " + object + ")");
        }
    }

    private void _update(IObservable iObservable, Object object) {
        if (object == ModelUpdateType.DELETED) {
            INodeModelAndIndex iNodeModelAndIndex = new INodeModelAndIndex((IModel)iObservable);
            if (db.on()) {
                db.println(this.toShortString() + " - DELETED update() from: " + iObservable);
                db.println("...corresponding to source: " + iNodeModelAndIndex);
            }
            this.handleSourceDelete(iNodeModelAndIndex);
        } else if (object == ModelUpdateType.CHANGED) {
            INodeModelAndIndex iNodeModelAndIndex = new INodeModelAndIndex((IModel)iObservable);
            ISVlanProfileModel iSVlanProfileModel = DisplayableSVlanProfile.getModel(iNodeModelAndIndex);
            if (db.on()) {
                db.println(this.toShortString() + " - CHANGED update() from: " + iObservable);
                db.println("...corresponding to source: " + iNodeModelAndIndex);
                db.println("...for this: " + this);
            }
            if (iSVlanProfileModel != null) {
                ISVlanProfile iSVlanProfile = this.profile;
                ISVlanProfile iSVlanProfile2 = (ISVlanProfile)iSVlanProfileModel.clone();
                if (iSVlanProfile.equals(iSVlanProfile2)) {
                    if (db.on()) {
                        db.println("equal profiles");
                    }
                    if (this.updateSource(iNodeModelAndIndex)) {
                        SVlanProfileChangedEvent sVlanProfileChangedEvent = new SVlanProfileChangedEvent(iNodeModelAndIndex, iSVlanProfile2);
                        if (db.on()) {
                            db.println("updated source: " + iNodeModelAndIndex + " - posting changed event: " + sVlanProfileChangedEvent);
                        }
                        DisplayableSVlanProfile.deferNotification(new EventThunk(sVlanProfileChangedEvent));
                    }
                } else {
                    if (db.on()) {
                        db.println("existing profile: " + iSVlanProfile);
                        db.println("updated  profile: " + iSVlanProfile2);
                    }
                    SVlanProfileChangedEvent sVlanProfileChangedEvent = new SVlanProfileChangedEvent(iNodeModelAndIndex, iSVlanProfile2);
                    if (this._removeSource(iNodeModelAndIndex)) {
                        if (this.getNumSources() == 0) {
                            sVlanProfileChangedEvent.setType(ModelUpdateType.DELETED);
                        } else {
                            sVlanProfileChangedEvent.setType(ModelUpdateType.CHANGED);
                        }
                        if (db.on()) {
                            db.println("... posting changed event: " + sVlanProfileChangedEvent);
                        }
                        DisplayableSVlanProfile.deferNotification(new EventThunk(sVlanProfileChangedEvent));
                    } else {
                        DisplayableSVlanProfile.deferNotification(new EventThunk(sVlanProfileChangedEvent.setType(ModelUpdateType.CHANGED)));
                    }
                }
            }
        } else if (db.on()) {
            db.println("ignoring unexpected/unhandled update(" + iObservable + ", " + object + ")");
        }
    }

    class Obs
    implements IObserver,
    Observer {
        Obs() {
        }

        public void update(IObservable iObservable, Object object) {
            DisplayableSVlanProfile.this.update(iObservable, object);
        }

        public void update(Observable observable, Object object) {
            if (observable instanceof IObservable) {
                this.update((IObservable)observable, object);
            }
        }
    }

    class EventThunk
    implements Runnable {
        private Object evt;
        private boolean fired;
        private EventThunk next;

        public EventThunk() {
        }

        public EventThunk(Integer n) {
            this.evt = n;
        }

        public EventThunk(SVlanProfileChangedEvent sVlanProfileChangedEvent) {
            this.evt = sVlanProfileChangedEvent;
        }

        public void setNext(EventThunk eventThunk) {
            this.next = eventThunk;
        }

        public EventThunk getNext() {
            return this.next;
        }

        public boolean wasFired() {
            return this.fired;
        }

        public void run() {
            this.fired = true;
            if (this.evt != null) {
                DisplayableSVlanProfile.this.changed();
                DisplayableSVlanProfile.this.notifyObservers(this.evt);
            }
        }

        public String toString() {
            String string = "(" + System.identityHashCode(this) + ")";
            return this.fired ? string + " fired " + this.evt : string + " unfired " + this.evt;
        }

        public void log(String string) {
            int n = 0;
            EventThunk eventThunk = this;
            while (eventThunk != null) {
                ++n;
                eventThunk = eventThunk.next;
            }
            ArrayList<EventThunk> arrayList = new ArrayList<EventThunk>(n);
            eventThunk = this;
            while (eventThunk != null) {
                arrayList.add(eventThunk);
                eventThunk = eventThunk.next;
            }
            db.println(string + " - # thunks: " + n);
            for (int i = n - 1; i >= 0; --i) {
                eventThunk = (EventThunk)arrayList.get(i);
                db.println("  " + eventThunk);
            }
        }
    }

    static class Comp
    implements Comparator {
        Comp() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            if (object == null) {
                n = object2 == null ? 0 : 1;
            } else if (object2 == null) {
                n = -1;
            } else if (object instanceof String) {
                n = object2 instanceof String ? ((String)object).compareTo((String)object2) : 1;
            } else if (object instanceof INodeModelAndIndex) {
                n = object2 instanceof INodeModelAndIndex ? ((INodeModelAndIndex)object).getName().compareTo(((INodeModelAndIndex)object2).getName()) : -1;
            }
            return n;
        }
    }
}

