/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractLoNum;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;

public class HoLoNum
implements IHoLoNum {
    protected IHoNum hoNum;
    protected ILoNum loNum;
    public static final String HOLO_SEPARATOR = ":";
    protected static SDebug db = new SDebug("HoLoNum");

    public HoLoNum(IHoNum iHoNum, ILoNum iLoNum) {
        HoLoNum.validate(iHoNum, iLoNum);
        this.hoNum = iHoNum;
        this.loNum = iLoNum;
    }

    private static void validate(IHoNum iHoNum, ILoNum iLoNum) {
        if (iLoNum != null && iHoNum != null && !iLoNum.isCompatible(iHoNum)) {
            throw new IllegalArgumentException("The HO and LO numbers are not compatible because they do not have the same framing type.");
        }
    }

    public IHoNum getHoNum() {
        return this.hoNum;
    }

    public ILoNum getLoNum() {
        return this.loNum;
    }

    public void setHoNum(IHoNum iHoNum) {
        HoLoNum.validate(iHoNum, this.loNum);
        this.hoNum = iHoNum;
    }

    public void setLoNum(ILoNum iLoNum) {
        HoLoNum.validate(this.hoNum, iLoNum);
        this.loNum = iLoNum;
    }

    public void setHoLo(IHoNum iHoNum, ILoNum iLoNum) {
        this.setHoNum(iHoNum);
        this.setLoNum(iLoNum);
    }

    public int getFramingType() {
        return HoLoNum.getFramingType(this.hoNum, this.loNum);
    }

    public static int getFramingType(IHoNum iHoNum, ILoNum iLoNum) {
        if (iLoNum != null) {
            return iLoNum.getFramingType();
        }
        if (iHoNum != null) {
            return iHoNum.getFramingType();
        }
        throw new IllegalStateException("The HO and LO numbers are both null.");
    }

    public boolean isSameTimeslot(IHoLoNum iHoLoNum) {
        return HoLoNum.isSameTimeslot(this.getHoNum(), this.getLoNum(), iHoLoNum);
    }

    public static boolean isSameTimeslot(IHoNum iHoNum, ILoNum iLoNum, IHoLoNum iHoLoNum) {
        boolean bl = false;
        if (iHoLoNum != null) {
            if (iHoNum != null) {
                boolean bl2 = iHoNum.isSameTimeslot(iHoLoNum.getHoNum());
                bl = iLoNum != null ? bl2 && iLoNum.isSameTimeslot(iHoLoNum.getLoNum()) : bl2;
            }
            return bl;
        }
        throw new IllegalArgumentException("The right-hand side HO/LO number is null.");
    }

    public String prettyString(String string) {
        return HoLoNum.prettyString(this.hoNum, this.loNum, string);
    }

    public static String prettyString(IHoNum iHoNum, ILoNum iLoNum, String string) {
        return "ho: " + (iHoNum == null ? "null" : iHoNum.prettyString()) + "; lo: " + (iLoNum == null ? "null" : iLoNum.prettyString());
    }

    public String prettyString() {
        return this.prettyString(HOLO_SEPARATOR);
    }

    public String toString() {
        return this.prettyString();
    }

    public int compareTo(Object object) {
        return HoLoNum.compareTo(this.hoNum, this.loNum, object);
    }

    public static int compareTo(IHoNum iHoNum, ILoNum iLoNum, Object object) {
        IHoLoNum iHoLoNum = (IHoLoNum)object;
        int n = iHoNum.compareTo((Object)iHoLoNum.getHoNum());
        if (n != 0) {
            return n;
        }
        return iLoNum.compareTo((Object)iHoLoNum.getLoNum());
    }

    public static int compareByGroup(IHoNum iHoNum, ILoNum iLoNum, IHoNum iHoNum2, ILoNum iLoNum2) {
        int n = HoLoNum.compare(iHoNum, iHoNum2);
        if (n == 0) {
            n = AbstractLoNum.compareByGroup((ILoNum)iLoNum, (ILoNum)iLoNum2);
        }
        return n;
    }

    public static int compareByGroupIndustryMapped(IHoNum iHoNum, ILoNum iLoNum, IHoNum iHoNum2, ILoNum iLoNum2) {
        int n = HoLoNum.compare(iHoNum, iHoNum2);
        if (n == 0) {
            n = AbstractLoNum.compareByGroupIndustryMapped((ILoNum)iLoNum, (ILoNum)iLoNum2);
        }
        return n;
    }

    public static int compare(IHoNum iHoNum, ILoNum iLoNum, IHoNum iHoNum2, ILoNum iLoNum2) {
        int n = HoLoNum.compare(iHoNum, iHoNum2);
        if (n == 0) {
            n = HoLoNum.compare(iLoNum, iLoNum2);
        }
        return n;
    }

    static int compare(IHoNum iHoNum, IHoNum iHoNum2) {
        int n = 0;
        if (iHoNum == null) {
            if (iHoNum2 != null) {
                n = -1;
            }
        } else {
            n = iHoNum.compareTo((Object)iHoNum2);
        }
        return n;
    }

    static int compare(ILoNum iLoNum, ILoNum iLoNum2) {
        int n = 0;
        if (iLoNum == null) {
            if (iLoNum2 != null) {
                n = -1;
            }
        } else {
            n = iLoNum.compareTo((Object)iLoNum2);
        }
        return n;
    }

    static boolean areBothNull(Object object, Object object2) {
        return object == null && object2 == null;
    }

    protected static boolean equals(IHoNum iHoNum, IHoNum iHoNum2) {
        return HoLoNum.areBothNull(iHoNum, iHoNum2) || iHoNum != null && iHoNum.equals(iHoNum2);
    }

    protected static boolean equals(ILoNum iLoNum, ILoNum iLoNum2) {
        return HoLoNum.areBothNull(iLoNum, iLoNum2) || iLoNum != null && iLoNum.equals(iLoNum2);
    }

    public int hashCode() {
        return HoLoNum.hashCode(this.hoNum, this.loNum, 17);
    }

    public static int hashCode(IHoNum iHoNum, ILoNum iLoNum, int n) {
        int n2 = n;
        int n3 = iHoNum == null ? 0 : iHoNum.hashCode();
        int n4 = iLoNum == null ? 0 : iLoNum.hashCode();
        n2 = 37 * n2 + n3;
        n2 = 37 * n2 + n4;
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IHoLoNum)) {
            return false;
        }
        this.isSameClassLoader(object);
        IHoLoNum iHoLoNum = (IHoLoNum)object;
        return HoLoNum.equals(this.hoNum, this.loNum, iHoLoNum);
    }

    public static boolean equals(IHoNum iHoNum, ILoNum iLoNum, IHoLoNum iHoLoNum) {
        boolean bl = false;
        if (iHoLoNum != null) {
            IHoNum iHoNum2 = iHoLoNum.getHoNum();
            ILoNum iLoNum2 = iHoLoNum.getLoNum();
            bl = HoLoNum.equals(iHoNum, iHoNum2) && HoLoNum.equals(iLoNum, iLoNum2);
        }
        return bl;
    }

    void isSameClassLoader(Object object) {
        String string;
        if (object != null && (string = object.getClass().getName()).equals("cerent.util.IHoLoNum")) {
            this.dumpDebugInfo(string);
        }
    }

    void dumpDebugInfo(String string) {
        if (db.on()) {
            db.println(string + ": object From a different classLoader");
        }
    }
}

