/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultListModel;

public class IPoDWDMUtility {
    private static IPoDWDMUtility instance;
    public static final int MAX_SRLG = 100;
    public static final int MAX_ADDITIONAL_SRLG = 20;
    public static final long MIN_SRLG_VALUE = 0L;
    public static final long MAX_SRLG_VALUE = 0xFFFFFFFEL;
    public static final String DEFAULT_ADDITIONAL_SRLG = "";
    public static final String DWDM_MODULE = "0";
    public static final String DWDM_SEPARATOR = "/";
    public static final String LINK_SEPARATOR = " - ";
    public static final String LINK_INFO_SEPARATOR = "/";
    public static final String SRLG_SEPARATOR = ",";
    public static final String SHELF_STRING = "sh";
    public static final String SLOT_STRING = "s";
    public static final String PORT_STRING = "p";
    public static final String CRS_NODE_STRING = "crs";
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String CRS_DEFAULT_EMBARGO = "";
    public static final String BLANK_EMBARGO_VALUE = "false";
    public static final String IN_SERVICE_STATE = "in-service";
    public static final String MAINTENANCE_STATE = "maintenance";
    public static final String OUT_OF_SERVICE_STATE = "out-of-service";
    public static final String CRS_OUT_OF_SERVICE = "";
    public static final String DWDM_NODE_15454 = "454";
    public static final String DWDM_NODE_15454_SDH = "454SDH";
    private static Network nw;
    private static NetCircuitManager ncm;
    private List nodesInMaintenance;
    private SortedSet shelvesInMaintenance = new TreeSet();
    private SortedSet slotsInMaintenance = new TreeSet();
    private SortedSet portsInMaintenance = new TreeSet();
    protected static final SDebug db;

    public static synchronized IPoDWDMUtility instance() {
        nw = Network.instance();
        ncm = NetCircuitManager.instance();
        if (instance == null) {
            return new IPoDWDMUtility();
        }
        return instance;
    }

    public int getSourceIndex(INetCircuit iNetCircuit) {
        int n = 0;
        INetCircuitEnd iNetCircuitEnd = null;
        List list = ((NetCircuit)iNetCircuit).getSources();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                if (iNetCircuitEnd.getNetElement().getNodeModel().getNeType().indexOf(CRS_NODE_STRING) == -1 || (n = iNetCircuitEnd.getEntityIndex()) == 0) continue;
                return n;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit end.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }

    public int getDestIndex(INetCircuit iNetCircuit) {
        int n = 0;
        OchncCircuit ochncCircuit = null;
        INetCircuitEnd iNetCircuitEnd = null;
        List list = ((NetCircuit)iNetCircuit).getDrops();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                if (iNetCircuitEnd.getNetElement().getNodeModel().getNeType().indexOf(CRS_NODE_STRING) == -1 || (n = (iNetCircuitEnd = (ochncCircuit = (OchncCircuit)iNetCircuit).getEndPointForOchTrail(iNetCircuitEnd.getNetElement())).getEntityIndex()) == 0) continue;
                return n;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit end.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }

    public void addElement(DefaultListModel defaultListModel, String string) {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        Enumeration enumeration = defaultListModel.elements();
        if (defaultListModel.size() == 0) {
            treeSet.add(new Long(string));
        } else {
            while (enumeration.hasMoreElements()) {
                treeSet.add(new Long(enumeration.nextElement().toString()));
            }
            treeSet.add(new Long(string));
        }
        defaultListModel.removeAllElements();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next().toString());
        }
    }

    public void updateAdditionalSRLGList(DefaultListModel defaultListModel, String string) {
        Object object;
        defaultListModel.removeAllElements();
        TreeSet<Long> treeSet = new TreeSet<Long>();
        if (string.indexOf(SRLG_SEPARATOR) == -1 && !string.trim().equals("".trim())) {
            treeSet.add(new Long(string.trim()));
        } else {
            object = new StringTokenizer(string, SRLG_SEPARATOR);
            while (((StringTokenizer)object).hasMoreTokens()) {
                treeSet.add(new Long(((StringTokenizer)object).nextToken().trim()));
            }
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            defaultListModel.addElement(object.next().toString());
        }
    }

    public String getAdditionalSRLGString(DefaultListModel defaultListModel) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            stringBuffer.append(defaultListModel.get(i).toString());
            stringBuffer.append(SRLG_SEPARATOR);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public boolean isSRLGCountOk(DefaultListModel defaultListModel) {
        return defaultListModel.size() < 20;
    }

    public boolean isSRLGValid(String string) {
        try {
            if (string.length() == 0) {
                return false;
            }
            if (string.charAt(0) == '-') {
                return true;
            }
            for (int i = 0; i < string.length(); ++i) {
                Long.parseLong(String.valueOf(string.charAt(i)));
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Invalid SRLG.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
        return true;
    }

    public boolean isSRLGUnique(String[] stringArray, DefaultListModel defaultListModel) {
        if (stringArray.length == 2 && stringArray[0].equals(stringArray[1])) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!defaultListModel.contains(stringArray[i].trim())) continue;
            return false;
        }
        return true;
    }

    public boolean isSRLGUnique(String string, String string2) {
        if (string2.indexOf(SRLG_SEPARATOR) == -1) {
            return string.equals(string2.trim());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SRLG_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().trim().equals(string)) continue;
            return false;
        }
        return true;
    }

    public boolean isSRLGInRange(String string) {
        try {
            long l = Long.parseLong(string);
            return l >= 0L && l <= 0xFFFFFFFEL;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("SRLG not in range.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public String getUpdatedSRLG(long l, String string, String string2) {
        if (string2.indexOf(SRLG_SEPARATOR) == -1) {
            return string.trim();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SRLG_SEPARATOR);
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (string3.equals(Long.toString(l))) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(string3);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i).toString());
            stringBuffer.append(SRLG_SEPARATOR);
        }
        if (stringBuffer.lastIndexOf(SRLG_SEPARATOR) == stringBuffer.length() - 1) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public List getConsolidatedSRLG(INetCircuit iNetCircuit, int n) {
        NetCircuitNode netCircuitNode;
        int n2;
        long l = -1L;
        String string = "";
        TreeSet treeSet = new TreeSet();
        List list = null;
        ArrayList<INetLink> arrayList = new ArrayList<INetLink>();
        INodeModel iNodeModel = null;
        INetLink iNetLink = null;
        String string2 = null;
        list = this.filterDuplicateNodes(iNetCircuit.getCircuitNodes());
        Iterator iterator = iNetCircuit.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            try {
                iNetLink = ((INetCircuitSpan)iterator.next()).getLink();
                if (!(iNetLink instanceof DwdmNetLink) && !(iNetLink instanceof VirtualNetLink) || !this.doesSupportSRLGAndCoMFeature(iNetLink.getSrc().getNodeModel()) || !this.doesSupportSRLGAndCoMFeature(iNetLink.getDst().getNodeModel())) continue;
                arrayList.add(iNetLink);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error occurred. Skipping Link: " + iNetLink);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            try {
                netCircuitNode = (NetCircuitNode)list.get(n2);
                iNodeModel = netCircuitNode.getNodeModel();
                if (!this.doesSupportSRLGAndCoMFeature(iNodeModel)) continue;
                string2 = iNodeModel.getName();
                l = iNodeModel.getUniqueNodeSRLG();
                string = iNodeModel.getAdditionalNodeSRLG().trim();
                this.checkAndAddSRLG(Long.toString(l), treeSet);
                if (string.indexOf(SRLG_SEPARATOR) == -1) {
                    this.checkAndAddSRLG(string, treeSet);
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, SRLG_SEPARATOR);
                while (stringTokenizer.hasMoreTokens()) {
                    this.checkAndAddSRLG(stringTokenizer.nextToken().trim(), treeSet);
                }
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error occurred. Skipping Node: " + string2);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            try {
                iNetLink = (INetLink)arrayList.get(n2);
                iNodeModel = iNetLink.getSrc().getNodeModel();
                netCircuitNode = iNodeModel.getSideModels();
                int n3 = this.getSrcSideId(iNetLink);
                l = netCircuitNode.getUniqueLinkSRLG(n3);
                string = netCircuitNode.getAdditionalLinkSRLG(n3);
                this.checkAndAddSRLG(Long.toString(l), treeSet);
                if (string.indexOf(SRLG_SEPARATOR) == -1) {
                    this.checkAndAddSRLG(string, treeSet);
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, SRLG_SEPARATOR);
                while (stringTokenizer.hasMoreTokens()) {
                    this.checkAndAddSRLG(stringTokenizer.nextToken().trim(), treeSet);
                }
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error occurred. Skipping Link: " + iNetLink);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        if (treeSet.size() > n) {
            ErrorMsg.displayWarning(null, (EID)NEMC.WID_SRLG_MAX_LIMIT_REACHED, iNetCircuit.getCircuitName(), 100);
            return new ArrayList(treeSet).subList(0, n + 1);
        }
        return new ArrayList(treeSet);
    }

    private void checkAndAddSRLG(String string, SortedSet sortedSet) {
        if (string.equals("")) {
            return;
        }
        Long l = new Long(string);
        if (!sortedSet.contains(l)) {
            sortedSet.add(l);
        }
    }

    public boolean deleteSRLG(INodeModel iNodeModel, INetCircuit iNetCircuit, int n) {
        String string = "";
        try {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            int n2 = iEntityModel.getShelfId();
            int n3 = iEntityModel.getSlot();
            int n4 = iEntityModel.getPort();
            string = n2 + "/" + n3 + "/" + DWDM_MODULE + "/" + n4;
            boolean bl = iEntityTableModel.deleteSRLG(iNodeModel.getDelegate(), string);
            if (!bl) {
                ErrorMsg.displayError(null, (EID)NEMC.EID_UNABLE_TO_DELETE_CRS_SRLG, (Object)iNodeModel.getName());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while setting SRLG on CRS.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public boolean setSRLG(INodeModel iNodeModel, INetCircuit iNetCircuit, List list, int n) {
        String string = "";
        try {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            int n2 = iEntityModel.getShelfId();
            int n3 = iEntityModel.getSlot();
            int n4 = iEntityModel.getPort();
            string = n2 + "/" + n3 + "/" + DWDM_MODULE + "/" + n4;
            boolean bl = iEntityTableModel.setSRLG(iNodeModel.getDelegate(), list, string);
            if (!bl) {
                ErrorMsg.displayError(null, (EID)NEMC.EID_UNABLE_TO_SET_CRS_SRLG, (Object)iNodeModel.getName());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while setting SRLG on CRS.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public int getSrcSideId(INetLink iNetLink) {
        INetElement iNetElement = iNetLink.getSrc();
        return OchncHelper.getSideFromPortIndex(iNetElement.getNodeModel(), iNetLink.getSrcEntityIndex());
    }

    public int getDstSideId(INetLink iNetLink) {
        INetElement iNetElement = iNetLink.getDst();
        return OchncHelper.getSideFromPortIndex(iNetElement.getNodeModel(), iNetLink.getDstEntityIndex());
    }

    public String constructLinkFormat(INetLink iNetLink) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        INetElement iNetElement = iNetLink.getSrc();
        string = iNetElement.getName();
        n = iNetLink.getSrcShelfNumber();
        n2 = iNetLink.getSrcSlotNumber();
        nArray = iNetLink.getSrcPortNumber();
        stringBuffer.append(string + "/" + SHELF_STRING + n + "/" + SLOT_STRING + n2 + "/" + PORT_STRING + PortHelper.getConcatenatedString((int[])nArray, (char)'/'));
        iNetElement = iNetLink.getDst();
        string = iNetElement.getName();
        n = iNetLink.getDstShelfNumber();
        n2 = iNetLink.getDstSlotNumber();
        nArray = iNetLink.getDstPortNumber();
        stringBuffer.append(LINK_SEPARATOR + string + "/" + SHELF_STRING + n + "/" + SLOT_STRING + n2 + "/" + PORT_STRING + PortHelper.getConcatenatedString((int[])nArray, (char)'/'));
        return stringBuffer.toString();
    }

    public List getLinksForSRLG() {
        ArrayList<INetLink> arrayList = new ArrayList<INetLink>();
        List list = this.getModelForPPCLinks();
        Iterator iterator = nw.getNetLinks().iterator();
        INetLink iNetLink = null;
        while (iterator.hasNext()) {
            try {
                iNetLink = (INetLink)iterator.next();
                int n = iNetLink.getLinkModel().physicalLinkType();
                if ((n == 5 || n == 4) && iNetLink instanceof DwdmNetLink && this.doesSupportSRLGAndCoMFeature(iNetLink.getSrc().getNodeModel()) && this.doesSupportSRLGAndCoMFeature(iNetLink.getDst().getNodeModel())) {
                    arrayList.add(iNetLink);
                    continue;
                }
                if (n != 6 || !(iNetLink instanceof VirtualNetLink) || !this.shoudAddPPCLink(iNetLink, list)) continue;
                arrayList.add(iNetLink);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while obtaining the Net Links.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList;
    }

    private boolean shoudAddPPCLink(INetLink iNetLink, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Object e = iterator.next();
                IEntityModel iEntityModel = ((IVirtualLinkModel)e).getOrigEntity();
                IEntityModel iEntityModel2 = iNetLink.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex());
                IEntityModel iEntityModel3 = ((IVirtualLinkModel)e).getTermEntity();
                IEntityModel iEntityModel4 = iNetLink.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex());
                if (!iEntityModel.equals(iEntityModel2) || !iEntityModel3.equals(iEntityModel4)) continue;
                return true;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while obtaining the Links.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return false;
    }

    private List getModelForPPCLinks() {
        IVirtualLinkModel iVirtualLinkModel;
        LinkedList<IVirtualLinkModel> linkedList = new LinkedList<IVirtualLinkModel>();
        VirtualLinksDirector virtualLinksDirector = VirtualLinksDirector.instance();
        Set<IVirtualLinkModel> set = virtualLinksDirector.getVirtualLinks();
        Iterator<IVirtualLinkModel> iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                IEntityModel iEntityModel;
                iVirtualLinkModel = iterator.next();
                IEntityModel iEntityModel2 = iVirtualLinkModel.getOrigEntity();
                if (!VirtualLinksDirector.shouldSwap(iEntityModel2, iEntityModel = iVirtualLinkModel.getTermEntity())) continue;
                iVirtualLinkModel.swap();
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while obtaining the Links.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                iVirtualLinkModel = iterator.next();
                if (!this.doesSupportSRLGAndCoMFeature(iVirtualLinkModel.getOrigEntity().getNodeModel()) || !this.doesSupportSRLGAndCoMFeature(iVirtualLinkModel.getTermEntity().getNodeModel())) continue;
                linkedList.add(iVirtualLinkModel);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while obtaining the Links.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return linkedList;
    }

    public INodeModel getSourceCRS(NetCircuit netCircuit) {
        INetCircuitEnd iNetCircuitEnd = null;
        INodeModel iNodeModel = null;
        List list = netCircuit.getSources();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                iNodeModel = iNetCircuitEnd.getNetElement().getNodeModel();
                if (iNodeModel.getNeType().indexOf(CRS_NODE_STRING) == -1) continue;
                return iNodeModel;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit end.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public INodeModel getDestCRS(NetCircuit netCircuit) {
        INetCircuitEnd iNetCircuitEnd = null;
        INodeModel iNodeModel = null;
        List list = netCircuit.getDrops();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                iNodeModel = iNetCircuitEnd.getNetElement().getNodeModel();
                if (iNodeModel.getNeType().indexOf(CRS_NODE_STRING) == -1) continue;
                return iNodeModel;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit end.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public boolean updateCRS(Object object) {
        List list = null;
        if (object instanceof INodeModel) {
            list = this.getCRSOCHTrailCircuits((INodeModel)object);
            if (list.size() == 0) {
                CerentDialog.infoDialog(null, (String)"Selected Node does not pertain in the CRS OCH Trail.", (String)"Information");
                if (db.on()) {
                    db.println("Selected resource does not exist in the CRS OCH Trail. No need to update the CRS.");
                }
                return false;
            }
        } else {
            list = this.getCRSOCHTrailCircuits((INetLink)object);
            if (list.size() == 0) {
                CerentDialog.infoDialog(null, (String)"Selected Link does not pertain in the CRS OCH Trail", (String)"Information");
                if (db.on()) {
                    db.println("Selected resource does not exist in the OCH Trail. No need to update the CRS.");
                }
                return false;
            }
        }
        Iterator iterator = list.iterator();
        List list2 = null;
        INodeModel iNodeModel = null;
        int n = 0;
        while (iterator.hasNext()) {
            try {
                boolean bl;
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                list2 = this.getConsolidatedSRLG(netCircuit, 100);
                if (list2.size() == 0) continue;
                iNodeModel = this.getSourceCRS(netCircuit);
                boolean bl2 = this.deleteSRLG(iNodeModel, netCircuit, n = this.getSourceIndex(netCircuit));
                if (bl2) {
                    if (db.on()) {
                        db.println("Successfully deleted the SRLG on CRS node: " + iNodeModel.getName());
                    }
                    if (bl = this.setSRLG(iNodeModel, netCircuit, list2, n)) {
                        if (db.on()) {
                            db.println("Successfully set the SRLG on CRS node: " + iNodeModel.getName());
                        }
                    } else if (db.on()) {
                        db.println("Unable to set the SRLG on CRS node: " + iNodeModel.getName());
                    }
                } else if (db.on()) {
                    db.println("Unable to delete the SRLG on CRS node: " + iNodeModel.getName());
                }
                if (bl2 = this.deleteSRLG(iNodeModel = this.getDestCRS(netCircuit), netCircuit, n = this.getDestIndex(netCircuit))) {
                    if (db.on()) {
                        db.println("Successfully deleted the SRLG on CRS node: " + iNodeModel.getName());
                    }
                    if (bl = this.setSRLG(iNodeModel, netCircuit, list2, n)) {
                        if (!db.on()) continue;
                        db.println("Successfully set the SRLG on CRS node: " + iNodeModel.getName());
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("Unable to set the SRLG on CRS node: " + iNodeModel.getName());
                    continue;
                }
                if (!db.on()) continue;
                db.println("Unable to delete the SRLG on CRS node: " + iNodeModel.getName());
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return true;
    }

    public List getCRSOCHTrailCircuits(Object object) {
        List list = new ArrayList();
        ArrayList<NetCircuit> arrayList = new ArrayList<NetCircuit>();
        if (object instanceof INodeModel) {
            list = ncm.getCircuits((INodeModel)object);
        } else if (object instanceof INetLink) {
            list = ncm.getCircuits((INetLink)object);
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                NetCircuit netCircuit = (NetCircuit)list.get(i);
                INodeModel iNodeModel = this.getSourceCRS(netCircuit);
                INodeModel iNodeModel2 = this.getDestCRS(netCircuit);
                if (iNodeModel == null || iNodeModel2 == null || netCircuit.getCircuitType() != 15 || iNodeModel.getNeType().indexOf(CRS_NODE_STRING) == -1 || iNodeModel2.getNeType().indexOf(CRS_NODE_STRING) == -1) continue;
                arrayList.add(netCircuit);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList;
    }

    public List filterOCHTrailCircuits(List list) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                INodeModel iNodeModel = this.getSourceCRS(netCircuit);
                INodeModel iNodeModel2 = this.getDestCRS(netCircuit);
                if (iNodeModel == null || iNodeModel2 == null || netCircuit.getCircuitType() != 15 || iNodeModel.getNeType().indexOf(CRS_NODE_STRING) == -1 || iNodeModel2.getNeType().indexOf(CRS_NODE_STRING) == -1) continue;
                linkedList.add(netCircuit);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping circuit.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return linkedList;
    }

    public List getMSTPNodes() {
        LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
        INodeModel iNodeModel = null;
        Iterator iterator = nw.getElements().iterator();
        while (iterator.hasNext()) {
            try {
                iNodeModel = ((INetElement)iterator.next()).getNodeModel();
                if (!this.doesSupportSRLGAndCoMFeature(iNodeModel)) continue;
                linkedList.add(iNodeModel);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while obtaining the MSTP node.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return linkedList;
    }

    public int getEqType(NetCircuit netCircuit) {
        INetCircuitEnd iNetCircuitEnd = null;
        INodeModel iNodeModel = null;
        List list = netCircuit.getSources();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                iNetCircuitEnd = (INetCircuitEnd)iterator.next();
                iNodeModel = iNetCircuitEnd.getNetElement().getNodeModel();
                if (iNodeModel.getNeType().indexOf(CRS_NODE_STRING) == -1) continue;
                return iNetCircuitEnd.getEntityModel().getModuleModel().getEqType();
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while setting SRLG on CRS.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return -1;
    }

    public String getEmbargo(INodeModel iNodeModel, NetCircuit netCircuit, int n) {
        String string = "";
        try {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            int n2 = iEntityModel.getShelfId();
            int n3 = iEntityModel.getSlot();
            int n4 = iEntityModel.getPort();
            string = n2 + "/" + n3 + "/" + DWDM_MODULE + "/" + n4;
            String string2 = iEntityTableModel.getEmbargo(iNodeModel.getDelegate(), this.getEqType(netCircuit), string);
            if (string2 == null) {
                if (db.on()) {
                    db.println("Unable to retrieve the Embargo from CRS: " + iNodeModel.getName() + "Returning " + UNKNOWN_STRING);
                }
                return UNKNOWN_STRING;
            }
            if (string2.trim().equals("")) {
                return BLANK_EMBARGO_VALUE;
            }
            return string2;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while getting Embargo from the CRS.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return UNKNOWN_STRING;
        }
    }

    public String getTransportAdminState(INodeModel iNodeModel, NetCircuit netCircuit, int n) {
        String string = "";
        try {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            int n2 = iEntityModel.getShelfId();
            int n3 = iEntityModel.getSlot();
            int n4 = iEntityModel.getPort();
            string = n2 + "/" + n3 + "/" + DWDM_MODULE + "/" + n4;
            String string2 = iEntityTableModel.getTransportAdminState(iNodeModel.getDelegate(), string);
            if (string2 == null) {
                if (db.on()) {
                    db.println("Unable to retrieve the TAS from CRS: " + iNodeModel.getName() + "Returning " + UNKNOWN_STRING);
                }
                return UNKNOWN_STRING;
            }
            if (string2.trim().equals("")) {
                return OUT_OF_SERVICE_STATE;
            }
            return string2;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while getting the TAS from the CRS.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return UNKNOWN_STRING;
        }
    }

    public boolean setTransportAdminState(INodeModel iNodeModel, NetCircuit netCircuit, int n, String string) {
        String string2 = "";
        try {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            int n2 = iEntityModel.getShelfId();
            int n3 = iEntityModel.getSlot();
            int n4 = iEntityModel.getPort();
            string2 = n2 + "/" + n3 + "/" + DWDM_MODULE + "/" + n4;
            boolean bl = iEntityTableModel.setTransportAdminState(iNodeModel.getDelegate(), string2, string);
            if (!bl) {
                if (db.on()) {
                    db.println("Unable to set the TAS on the CRS: " + iNodeModel.getName());
                }
                ErrorMsg.displayError(null, (EID)NEMC.EID_UNABLE_TO_SET_TAS, (Object)iNodeModel.getName());
                return bl;
            }
            return bl;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while setting SRLG on CRS.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public List filterNodesInMaintenance(List list) {
        this.nodesInMaintenance = new LinkedList();
        INodeModel iNodeModel = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                iNodeModel = (INodeModel)iterator.next();
                int[] nArray = iNodeModel.getCoordMaintList();
                if (nArray == null || nArray.length == 0) continue;
                this.nodesInMaintenance.add(iNodeModel);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping node: " + iNodeModel.getName());
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return new LinkedList(this.nodesInMaintenance);
    }

    public void updateAllMaintInfo(INodeModel iNodeModel) {
        this.shelvesInMaintenance.clear();
        this.slotsInMaintenance.clear();
        this.portsInMaintenance.clear();
        this.filterShelvesInMaintenance(iNodeModel);
    }

    public void updateSlotMaintInfo(INodeModel iNodeModel, int n) {
        this.filterSlotsInMaintenance(iNodeModel, n);
    }

    public void updatePortMaintInfo(INodeModel iNodeModel, int n, IModuleModel iModuleModel) {
        this.filterPortsInMaintenance(iNodeModel, n, iModuleModel.getSlot());
    }

    public List filterShelvesInMaintenance(INodeModel iNodeModel) {
        this.shelvesInMaintenance.clear();
        IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            try {
                int n = iEntityModelArray[i].getShelfId();
                if (this.filterSlotsInMaintenance(iNodeModel, n).size() == 0) continue;
                this.shelvesInMaintenance.add(n);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping shelf.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return new LinkedList(this.shelvesInMaintenance);
    }

    public List filterSlotsInMaintenance(INodeModel iNodeModel, int n) {
        this.slotsInMaintenance.clear();
        List list = this.getSlotModules(iNodeModel, n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                IModuleModel iModuleModel = (IModuleModel)iterator.next();
                if (this.filterPortsInMaintenance(iNodeModel, n, iModuleModel.getSlot()).size() == 0) continue;
                this.slotsInMaintenance.add(iModuleModel);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping slot.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return new LinkedList(this.slotsInMaintenance);
    }

    public List filterPortsInMaintenance(INodeModel iNodeModel, int n, int n2) {
        this.portsInMaintenance.clear();
        List list = this.getPortModels(iNodeModel, this.getBackPlane(iNodeModel.getChassisModels(), n), n2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                IPortModel iPortModel;
                Object e = iterator.next();
                if (!(e instanceof IPortModel) || !this.isPortUnderMaintenance(iNodeModel, iPortModel = (IPortModel)e)) continue;
                this.portsInMaintenance.add((IEntityModel)e);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Skipping port.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return new LinkedList(this.portsInMaintenance);
    }

    public IEntityModel getBackPlane(IEntityModel[] iEntityModelArray, int n) {
        List list = null;
        int n2 = this.getshelfIndexInChassis(n, iEntityModelArray);
        if (n2 == -1) {
            return null;
        }
        list = iEntityModelArray[n2].getChildren();
        return (IEntityModel)list.get(0);
    }

    public int getshelfIndexInChassis(int n, IEntityModel[] iEntityModelArray) {
        int n2 = -1;
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            if (n != iEntityModelArray[i].getShelfId()) continue;
            n2 = i;
        }
        return n2;
    }

    public List getSlotModules(INodeModel iNodeModel, int n) {
        List list = new LinkedList();
        TreeSet<IModuleModel> treeSet = new TreeSet<IModuleModel>();
        IEntityModel iEntityModel = this.getBackPlane(iNodeModel.getChassisModels(), n);
        if (iEntityModel == null) {
            return new LinkedList();
        }
        list = iEntityModel.getChildren();
        if (list != null) {
            int n2 = list.size();
            IEntityModel[] iEntityModelArray = new IEntityModel[list.size()];
            for (int i = 0; i < n2; ++i) {
                try {
                    iEntityModelArray[i] = (IEntityModel)list.get(i);
                    IEntityModel iEntityModel2 = iEntityModelArray[i];
                    List list2 = iEntityModel2.getChildren();
                    int n3 = list2.size();
                    if (n3 == 0) continue;
                    treeSet.add((IModuleModel)((IEntityModel)list.get(i)).getChildren().get(0));
                    continue;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Skipping the slot.");
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return new LinkedList(treeSet);
    }

    public List getPortModels(INodeModel iNodeModel, IEntityModel iEntityModel, int n) {
        Object e;
        List list = new LinkedList();
        TreeSet treeSet = new TreeSet();
        int n2 = this.getSlotIndexInBackplane(n, iEntityModel);
        List list2 = iEntityModel.getChildren();
        IEntityModel iEntityModel2 = (IEntityModel)list2.get(n2);
        List list3 = iEntityModel2.getChildren();
        int n3 = list3.size();
        if (n3 != 0 && (e = list3.get(0)) instanceof IModuleModel) {
            IEntityModel iEntityModel3 = (IEntityModel)e;
            list = iEntityModel3.getDescendantsOfClassType(7);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Object e2 = iterator.next();
                    if (e2 instanceof IPortModel) {
                        IPortModel iPortModel = (IPortModel)e2;
                        if (!(e instanceof IDwdmModuleModel) || iPortModel.getEqType() == 122 || iPortModel.getEqType() == 123) continue;
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Skipping the port.");
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return list;
    }

    public int getSlotIndexInBackplane(int n, IEntityModel iEntityModel) {
        int n2 = -1;
        List list = iEntityModel.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            IEntityModel iEntityModel2 = (IEntityModel)list.get(i);
            if (n != iEntityModel2.getSlot()) continue;
            n2 = i;
        }
        return n2;
    }

    public boolean isPortUnderMaintenance(INodeModel iNodeModel, IPortModel iPortModel) {
        int[] nArray;
        block4: {
            nArray = null;
            try {
                nArray = iNodeModel.getCoordMaintList();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error while fetching the port info.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (iPortModel.getIndex() != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public List getNodesInMaintenance() {
        return new LinkedList(this.nodesInMaintenance);
    }

    public List getShelvesInMaintenance() {
        return new LinkedList(this.shelvesInMaintenance);
    }

    public List getSlotsInMaintenence() {
        return new LinkedList(this.slotsInMaintenance);
    }

    public List getPortsInMaintenance() {
        return new LinkedList(this.portsInMaintenance);
    }

    public List filterDuplicateNodes(List list) {
        LinkedList<INetCircuitNode> linkedList = new LinkedList<INetCircuitNode>();
        if (list != null) {
            LinkedList<String> linkedList2 = new LinkedList<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    INodeModel iNodeModel = ((NetCircuitNode)e).getNodeModel();
                    String string = InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress());
                    if (linkedList2.contains(string)) continue;
                    linkedList2.add(string);
                    linkedList.add((INetCircuitNode)e);
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Error while fetching node.");
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return linkedList;
    }

    public boolean doesSupportSRLGAndCoMFeature(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return false;
        }
        return Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SRLG_COMT_SUPPORT) && iNodeModel.getNodeType() == 2;
    }

    static {
        db = new SDebug("IPoDWDMUtility");
    }
}

