/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.Attribute;
import cerent.cms.model.InvalidData;

public class SnmpUtil {
    public static final String ONS_PROXY_USER = "ons_proxy_user";
    public static final String ONS_TRAP_USER = "ons_trap_user";
    public static final String ONS_TRAP_GROUP = "default_group";
    public static final String ONS_PROXY_GROUP = "default_group";
    public static final String DEFAULT_TRAP_TAG = "_targetTag__";
    public static final short SNMP_PROXY_PORT = 161;
    public static final short SNMP_TRAP_PORT = 162;
    public static final int SNMPV3_PROXY_TIMEOUT = 10000;
    public static final int SNMPV3_PROXY_RETRY = 10;
    public static int _ProxyType_Read = 1;
    public static int _ProxyType_Write = 2;
    public static int _ProxyType_Trap = 3;
    public static final String _str_ProxyType_Read = "READ";
    public static final String _str_ProxyType_Write = "WRITE";
    public static final String _str_ProxyType_Trap = "TRAP";
    private static final int SNMP_PORT_MIN = 1024;
    private static final int SNMP_PORT_MAX = 65535;
    private static final int SNMP_PORT_DEF1 = 161;
    private static final int SNMP_PORT_DEF2 = 162;
    private static final int SNMP_PORT_RELAY = 391;
    static final String DEFAULT_UDP_PORT = Integer.toString(162);
    public static char[] hexCharSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int _SecurityLevel_undefined = 0;
    public static final int _SecurityLevel_noAuthNoPriv = 1;
    public static final int _SecurityLevel_autoNoPriv = 2;
    public static final int _SecurityLevel_authPriv = 3;
    public static final String _str_SecurityLevel_noAuthNoPriv = "SecurityLevel_noAuthNoPriv";
    public static final String _str_SecurityLevel_autoNoPriv = "SecurityLevel_autoNoPriv";
    public static final String _str_SecurityLevel_authPriv = "SecurityLevel_authPriv";
    public static final String _str_SecurityLevel_Undefined = "SecurityLevel_Undefined";
    public static final int _Auth_None = 0;
    public static final int _Auth_MD5 = 1;
    public static final int _Auth_SHA = 2;
    public static final int _Priv_None = 0;
    public static final int _Priv_DES = 1;
    public static final int _Mpm_Undefined = 0;
    public static final int _Mpm_SNMPv1 = 1;
    public static final int _Mpm_SNMPv2 = 2;
    public static final int _Mpm_SNMPv3 = 3;
    public static Attribute[] securityLevel = new Attribute[]{new Attribute("undefined", 0), new Attribute("noAuthNoPriv", 1), new Attribute("authNoPriv", 2), new Attribute("authPriv", 3)};
    public static Attribute[] authProtocol = new Attribute[]{new Attribute("NONE", 0), new Attribute("MD5", 1), new Attribute("SHA", 2)};
    public static Attribute[] privProtocol = new Attribute[]{new Attribute("NONE", 0), new Attribute("DES", 1)};

    public static String toStringEngineID(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(hexCharSet[(byArray[i] & 0xF0) >>> 4]);
            stringBuffer.append(hexCharSet[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte[] toBytesEngineID(String string, int n) {
        int n2 = n / 2;
        byte[] byArray = new byte[16];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(n3, n3 + 2), 16);
            n3 += 2;
        }
        return byArray;
    }

    public static String getEngineIDPadded(String string) {
        String string2 = null;
        int n = string.length() % 2;
        string2 = n == 1 ? "0" + string : string;
        return string2;
    }

    public static void validateUdpPort(int n) throws InvalidData {
        if (n != 161 && n != 162 && n != 391 && (n < 1024 || n > 65535)) {
            throw new InvalidData("The UDP Port must be 161, 162, 391, or between 1024 and 65535.");
        }
    }

    public static int getSecurityLevel(String string) {
        int n = 0;
        if (string.compareTo(_str_SecurityLevel_noAuthNoPriv) == 0) {
            n = 1;
        } else if (string.compareTo(_str_SecurityLevel_autoNoPriv) == 0) {
            n = 2;
        } else if (string.compareTo(_str_SecurityLevel_authPriv) == 0) {
            n = 3;
        }
        return n;
    }

    public static String getSecLevelStdString(String string) {
        if (string.compareTo("noAuthNoPriv") == 0) {
            return _str_SecurityLevel_noAuthNoPriv;
        }
        if (string.compareTo("authNoPriv") == 0) {
            return _str_SecurityLevel_autoNoPriv;
        }
        if (string.compareTo("authPriv") == 0) {
            return _str_SecurityLevel_authPriv;
        }
        if (string.compareTo("undefined") == 0) {
            return _str_SecurityLevel_Undefined;
        }
        return _str_SecurityLevel_Undefined;
    }

    public static int getProxyType(String string) {
        int n = _ProxyType_Read;
        if (string.compareTo(_str_ProxyType_Read) == 0) {
            n = _ProxyType_Read;
        } else if (string.compareTo(_str_ProxyType_Write) == 0) {
            n = _ProxyType_Write;
        } else if (string.compareTo(_str_ProxyType_Trap) == 0) {
            n = _ProxyType_Trap;
        }
        return n;
    }
}

