/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.BusEvent;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.SubsystemStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements Observer {
    protected JLabel mainLabel = new JLabel();
    protected ArrayList items = new ArrayList();
    private LinkedList labelTextList = new LinkedList();
    private LinkedList statusList = new LinkedList();
    private GridBagConstraints gc = new GridBagConstraints();
    private Runnable updThread;
    private Timer timer = new Timer(2000, new TimerListener());
    private RunTimeMemoryBar memoryProgressBar;
    private static StatusBar singleton;
    private static final SDebug db;

    public static StatusBar instance() {
        if (singleton == null) {
            singleton = new StatusBar();
        }
        return singleton;
    }

    private StatusBar() {
        this.setLayout(new GridBagLayout());
        this.gc.anchor = 10;
        this.gc.fill = 1;
        this.gc.gridy = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 1;
        this.gc.weighty = 1.0;
        this.gc.weightx = 1.0;
        this.mainLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.items.add(0, this.mainLabel);
        this.add((Component)this.mainLabel, this.gc);
        this.gc.weightx = 0.0;
        this.gc.weighty = 0.0;
        this.setPreferredSize(new Dimension(640, 22));
        this.updThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LinkedList linkedList = StatusBar.this.labelTextList;
                synchronized (linkedList) {
                    try {
                        Iterator iterator = StatusBar.this.labelTextList.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            JLabel jLabel = (JLabel)e;
                            e = iterator.next();
                            String string = (String)e;
                            jLabel.setText(string);
                        }
                    }
                    catch (Exception exception) {
                        StatusBar.this.labelTextList.clear();
                    }
                }
            }
        };
        EventBus.instance().addObserver((Observer)this, (Object)SubsystemStatus.class.toString());
        this.memoryProgressBar = new RunTimeMemoryBar();
        this.addItem(this.memoryProgressBar);
        this.timer.start();
    }

    void updateMemoryUsage() {
        this.memoryProgressBar.repaint();
    }

    public void addItem(JComponent jComponent) {
        if (!this.items.contains(jComponent)) {
            this.borderizeComponent(jComponent);
            this.installListener(jComponent);
            this.items.add(1, jComponent);
            this.rebuild();
        }
    }

    public void addItemWithTimedRemoval(JComponent jComponent) {
        this.addItem(jComponent);
        new StatusBarManagerThread(jComponent).start();
    }

    public void appendItem(JComponent jComponent) {
        if (!this.items.contains(jComponent)) {
            this.gc.gridx = this.items.size();
            this.borderizeComponent(jComponent);
            this.installListener(jComponent);
            this.add((Component)jComponent, this.gc);
            this.rebuild();
            this.items.add(jComponent);
        }
    }

    public void removeItem(JComponent jComponent) {
        int n = this.items.indexOf(jComponent);
        if (n > 0) {
            if (jComponent == this.mainLabel && db.on()) {
                db.println("StatusBar.removeItem attempting to remove mainLabel!");
            }
            this.items.remove(n);
            this.remove(jComponent);
            this.rebuild();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof BusEvent) {
            BusEvent busEvent = (BusEvent)object;
            String string = (String)busEvent.getSource();
            Object object2 = busEvent.getEvent();
            if (string == null && object2 == null) {
                if (db.on()) {
                    db.println("busEvent source or event is null");
                }
                return;
            }
            if (db.on()) {
                db.println("busEvent source=" + string + ", event=" + object2);
            }
            if (object2 instanceof JComponent) {
                if (this.items.contains(object2)) {
                    this.removeItem((JComponent)object2);
                } else {
                    this.addItem((JComponent)object2);
                }
            } else if (object2 instanceof String) {
                this.setText((String)object2);
            } else if (db.on()) {
                db.println("update:  Unknown event");
            }
        }
    }

    public void setText(String string) {
        this.setText(string, this.mainLabel);
    }

    public void setTextWithTimedRemoval(String string) {
        this.setText(string, this.mainLabel);
        new Thread("StatusBarHelper"){
            private static final int INTERVAL = 5;

            public void run() {
                try {
                    2.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    db.finest("InterruptedException in setTextWithTimedRemoval, " + interruptedException);
                }
                singleton.setText("");
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string, JLabel jLabel) {
        if (SwingUtilities.isEventDispatchThread()) {
            jLabel.setText(string);
            jLabel.revalidate();
            Dimension dimension = jLabel.getSize();
            jLabel.paintImmediately(0, 0, dimension.width, dimension.height);
        } else {
            LinkedList linkedList = this.labelTextList;
            synchronized (linkedList) {
                this.labelTextList.add(jLabel);
                this.labelTextList.add(string);
            }
            SwingUtilities.invokeLater(this.updThread);
        }
    }

    private void installListener(JComponent jComponent) {
        jComponent.addMouseListener(new StatusBlockMouseListener(jComponent));
    }

    private void borderizeComponent(JComponent jComponent) {
        if (jComponent.getBorder() == null) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        }
    }

    protected void rebuild() {
        this.removeAll();
        this.gc.weightx = 1.0;
        for (int i = 0; i < this.items.size(); ++i) {
            this.gc.gridx = i;
            this.add((Component)((JComponent)this.items.get(i)), this.gc);
            this.gc.weightx = 0.0;
        }
        this.revalidate();
    }

    public static Border getLoweredBevelBorder(Color color) {
        return BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, color.brighter(), color.darker().darker()), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    static {
        db = new SDebug("StatusBar");
    }

    private class StatusBarManagerThread
    extends Thread {
        private static final int INTERVAL = 5;
        JComponent comp;

        public StatusBarManagerThread(JComponent jComponent) {
            super("StatusBarManagerThread");
            this.comp = null;
            this.comp = jComponent;
            this.setPriority(1);
        }

        public void run() {
            try {
                StatusBarManagerThread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                db.finest("InterruptedException in StatusBarManagerThread::run(), " + interruptedException);
            }
            StatusBar.instance().removeItem(this.comp);
        }
    }

    private class StatusBlockMouseListener
    implements MouseListener {
        private JComponent comp;

        public StatusBlockMouseListener(JComponent jComponent) {
            this.comp = jComponent;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.comp instanceof JLabel) {
                JLabel jLabel = (JLabel)this.comp;
                String string = "";
                if (jLabel.getText().equals("NET")) {
                    string = "Network Discovery: ";
                } else if (jLabel.getText().equals("CKT")) {
                    string = "Circuit Management: ";
                }
                if (jLabel.getBackground() == Color.green) {
                    jLabel.setToolTipText(string + "Active");
                } else if (jLabel.getForeground() == Color.gray) {
                    jLabel.setToolTipText(string + "Disabled");
                } else {
                    jLabel.setToolTipText(string + "Enabled");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class RunTimeMemoryBar
    extends JPanel
    implements MouseListener {
        private JLabel label;

        public RunTimeMemoryBar() {
            this.setLayout(new FlowLayout(1, 5, 0));
            this.label = new JLabel();
            this.label.addMouseListener(this);
            this.add(this.label);
            this.label.setToolTipText("Click to force garbage collection.");
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            long l3 = Runtime.getRuntime().maxMemory();
            long l4 = l2 - l;
            this.label.setText("Java Heap: " + l4 / 0x100000L + " of " + l3 / 0x100000L + " MB");
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            int n3 = insets.left;
            int n4 = insets.left + (int)((long)n * l4 / l3);
            int n5 = insets.left + (int)((long)n * l2 / l3);
            int n6 = insets.left + n;
            int n7 = insets.top;
            int n8 = insets.top + n2;
            double d = (double)n4 / (double)n6;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            if (d > 0.9) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, n2, Color.RED));
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, n2, Color.GREEN));
            }
            graphics2D.fillRect(n3, n7, n4, n8);
            graphics2D.setPaint(paint);
            graphics2D.setColor(new Color(0x999999));
            graphics2D.fillRect(n4, n7, n5, n8);
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(n5, n7, n6, n8);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Runtime.getRuntime().gc();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Runtime.getRuntime().gc();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class TimerListener
    implements ActionListener,
    Runnable {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            StatusBar.this.updateMemoryUsage();
        }
    }
}

