/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IncompatibleException;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.UObservable;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.INgrp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class NetworkVersionMonitor
implements IObserver {
    private static final IClassLoaderManager clm = ClassLoaderManager.instance();
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private Comparable latestVersionAvailable;
    private Comparable latestVersionUpgraded;
    private HashMap networkElementVersions;
    private HashMap allNetworkElements;
    private IdentityHashMap<NodeModel, NetElement> nm2ne;
    private final NetVersionMonitorDebug db = new NetVersionMonitorDebug("NetworkVersionMonitor");
    private static NetworkVersionMonitor instance;

    public NetworkVersionMonitor() {
        this.latestVersionUpgraded = this.latestVersionAvailable = this.getCurrentVersion();
        this.networkElementVersions = new HashMap();
        this.allNetworkElements = new HashMap();
        this.nm2ne = new IdentityHashMap();
    }

    public static NetworkVersionMonitor instance() {
        if (instance == null) {
            instance = new NetworkVersionMonitor();
        }
        return instance;
    }

    public void initialize() {
        if (this.isVersionMonitoringSupported()) {
            Network.instance().addNetElementCreationObserver(this);
        }
    }

    public boolean isVersionMonitoringSupported() {
        return CoreConstants.isDownloadingPermitted;
    }

    public void setLatestVersionUpgraded(Comparable comparable) {
        if (this.db.on()) {
            this.db.println("Latest version upgraded set to: " + comparable);
        }
        this.latestVersionUpgraded = comparable;
    }

    public String getLatestVersionAvailable() {
        return cvu.prettyDottedMajorMinorMaintString(this.latestVersionAvailable);
    }

    public ArrayList getLatestVersionElements(ComparableHolder comparableHolder) {
        ArrayList arrayList;
        if (comparableHolder != null) {
            comparableHolder.value = this.latestVersionAvailable;
        }
        if ((arrayList = (ArrayList)this.networkElementVersions.get(this.latestVersionAvailable)) == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public ArrayList getLatestVersionElements() {
        return this.getLatestVersionElements(null);
    }

    public boolean isLaterVersionAvailable() {
        boolean bl = this.isLaterVersion(this.latestVersionAvailable, this.getCurrentVersion());
        return bl && this.isLaterVersion(this.latestVersionAvailable, this.latestVersionUpgraded);
    }

    public void update(IObservable iObservable, Object object) {
        if (this.db.on()) {
            this.db.println("from " + iObservable + " got update: " + object);
        }
        if (iObservable instanceof Network.NetElementCreationNotifier && object instanceof NetElement) {
            this.newNetworkElementFound((NetElement)object, ((NetElement)object).getSwVersionOrdinal());
        } else if (iObservable instanceof NetElement && object instanceof Integer) {
            this.networkElementUpdate((NetElement)iObservable, (Integer)object, null);
        } else if (iObservable instanceof UObservable && object instanceof NodeModel) {
            NodeModel nodeModel = (NodeModel)object;
            this.networkElementUpdate(null, ModelUpdateType.CHANGED, nodeModel);
        } else {
            if (this.db.on()) {
                this.db.println("Error in update - non NetElement notification received - aborting.");
            }
            return;
        }
    }

    private void networkElementUpdate(NetElement netElement, Integer n, NodeModel nodeModel) {
        Object object;
        Exception exception = nodeModel == null ? null : nodeModel.getInitFailureException();
        NodeModel nodeModel2 = nodeModel;
        Comparable comparable = null;
        if (netElement == null && n == ModelUpdateType.CHANGED && exception != null && exception instanceof IncompatibleException) {
            object = (IncompatibleException)((Object)exception);
            comparable = object.getNeVersionOrdinal();
            netElement = this.nm2ne.get(nodeModel);
            if (this.db.on()) {
                this.db.println("Incompatible SW version detected for: " + nodeModel.getName() + " NE VO: " + comparable);
            }
        }
        if (netElement == null) {
            if (this.db.on()) {
                this.db.println("aNetworkElement was null");
            }
            return;
        }
        if (n == ModelUpdateType.DELETED) {
            this.allNetworkElements.remove(netElement);
            object = netElement.getSwVersionOrdinal();
            ArrayList arrayList = (ArrayList)this.networkElementVersions.get(object);
            if (arrayList != null) {
                arrayList.remove(netElement);
            }
            this.evaluateForLatestVersionLost((Comparable)object);
            if (this.db.on()) {
                this.db.println("Received DELETED notification for " + netElement.getHostName() + ". Removed this element from the version lists.");
            }
            netElement.deleteObserver(this);
            if (nodeModel2 == null) {
                nodeModel2 = netElement.getNodeModel();
            }
            if (nodeModel2 instanceof NodeModel) {
                nodeModel2.getIncompatibleObservable().deleteObserver((IObserver)this);
            }
        } else if (n == ModelUpdateType.CHANGED) {
            Comparable comparable2;
            object = (Comparable)this.allNetworkElements.get(netElement);
            Comparable comparable3 = comparable2 = comparable != null ? comparable : netElement.getSwVersionOrdinal();
            if (this.db.isFinerEnabled()) {
                this.db.finer("Updated NE: " + netElement.getName() + " has version: " + comparable2);
            }
            if (this.isUnavailable(comparable2) && this.db.on()) {
                this.db.println("ignoring unusable S/W version for NE: " + netElement);
            }
            if (object != null && !object.equals(comparable2)) {
                ArrayList arrayList = (ArrayList)this.networkElementVersions.get(object);
                if (arrayList != null) {
                    arrayList.remove(netElement);
                    this.allNetworkElements.put(netElement, comparable2);
                }
                this.addElementToVersionMappedList(netElement, comparable2);
                this.evaluateForLatestVersionFound(comparable2);
                this.evaluateForLatestVersionLost((Comparable)object);
                if (this.db.on()) {
                    this.db.println("Upon CHANGED notification, moved " + netElement.getHostName() + " from the " + object + " to the " + comparable2 + " list.");
                }
            }
        }
    }

    private void addElementToVersionMappedList(NetElement netElement, Comparable comparable) {
        ArrayList<NetElement> arrayList = (ArrayList<NetElement>)this.networkElementVersions.get(comparable);
        if (arrayList == null) {
            arrayList = new ArrayList<NetElement>();
            arrayList.add(netElement);
            this.networkElementVersions.put(comparable, arrayList);
        } else {
            arrayList.add(netElement);
        }
    }

    private void evaluateForLatestVersionFound(Comparable comparable) {
        if (this.isUnavailable(comparable)) {
            return;
        }
        if (this.isLaterVersion(comparable, this.latestVersionAvailable)) {
            this.latestVersionAvailable = comparable;
            Comparable comparable2 = this.getCurrentVersion();
            String string = cvu.prettyDottedMajorMinorMaintString(this.latestVersionAvailable);
            String string2 = cvu.prettyDottedMajorMinorMaintString(comparable2);
            if (this.isLaterVersion(this.latestVersionAvailable, comparable2)) {
                String string3 = "You are currently running Software Release " + string2 + " of the Cisco Transport Controller (CTC).\n" + "A network element running R" + string + " has been discovered but cannot be managed from this CTC session.\n" + "If you would like to manage this network element, you must download " + "and install CTC R" + string + " on your computer.\n" + "To do so, please select \"Update CTC\" from the Tools menu.";
                DetailedLog detailedLog = new DetailedLog(1, string3);
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            }
        }
    }

    private void evaluateForLatestVersionLost(Comparable comparable) {
        ArrayList arrayList;
        if (this.isUnavailable(comparable)) {
            return;
        }
        if (comparable.equals(this.latestVersionAvailable) && (arrayList = (ArrayList)this.networkElementVersions.get(comparable)).isEmpty()) {
            Iterator iterator = this.networkElementVersions.keySet().iterator();
            Comparable comparable2 = null;
            while (iterator.hasNext()) {
                Comparable comparable3 = (Comparable)iterator.next();
                if (this.isUnavailable(comparable3) || comparable2 != null && !this.isLaterVersion(comparable3, comparable2) || ((ArrayList)this.networkElementVersions.get(comparable3)).isEmpty()) continue;
                comparable2 = comparable3;
            }
            if (comparable2 != null) {
                this.latestVersionAvailable = comparable2;
            }
        }
    }

    private void newNetworkElementFound(NetElement netElement, Comparable comparable) {
        INodeModel iNodeModel;
        if (this.isUnavailable(comparable) && this.db.on()) {
            this.db.println("ignoring unusable S/W version for NE: " + netElement);
        }
        if ((iNodeModel = netElement.getNodeModel()) instanceof NodeModel) {
            this.nm2ne.put((NodeModel)iNodeModel, netElement);
        }
        this.allNetworkElements.put(netElement, comparable);
        this.addElementToVersionMappedList(netElement, comparable);
        netElement.addObserver(this);
        if (iNodeModel instanceof NodeModel) {
            ((NodeModel)iNodeModel).getIncompatibleObservable().addObserver((IObserver)this);
        }
        if (this.db.on()) {
            this.db.println("newNetworkElementFound - adding node: " + netElement.getHostName() + " with version: " + cvu.prettyDottedString(comparable) + " to known versions.");
        }
        this.evaluateForLatestVersionFound(comparable);
    }

    private boolean isLaterVersion(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2) > 0;
    }

    private Comparable getCurrentVersion() {
        INgrp iNgrp = clm.getSystemNgrp();
        return iNgrp.getManifestVersionOrdinal();
    }

    private boolean isUnavailable(Comparable comparable) {
        boolean bl = comparable == null || cvu.isUnavailable(comparable);
        return bl;
    }

    public class NetVersionMonitorDebug
    extends SDebug {
        public NetVersionMonitorDebug(String string) {
            super(string);
        }

        public final void dumpLatestVersion() {
            NetworkVersionMonitor.this.db.println("Latest Version Available: " + cvu.prettyDottedString(NetworkVersionMonitor.this.latestVersionAvailable));
            NetworkVersionMonitor.this.db.println("Latest Version Upgraded: " + cvu.prettyDottedString(NetworkVersionMonitor.this.latestVersionUpgraded));
            NetworkVersionMonitor.this.db.println("Current Running Version: " + cvu.prettyDottedString(NetworkVersionMonitor.this.getCurrentVersion()));
        }

        public final void dumpDiag() {
            this.dump();
        }

        public final void dump() {
            NetworkVersionMonitor.this.db.println("================================");
            NetworkVersionMonitor.this.db.println("Latest version available: " + NetworkVersionMonitor.this.latestVersionAvailable);
            NetworkVersionMonitor.this.db.println("Latest version  upgraded: " + NetworkVersionMonitor.this.latestVersionUpgraded);
            NetworkVersionMonitor.this.db.println("isLaterVersionAvailable: " + NetworkVersionMonitor.this.isLaterVersionAvailable());
            for (Comparable comparable : NetworkVersionMonitor.this.networkElementVersions.keySet()) {
                NetworkVersionMonitor.this.db.println("");
                NetworkVersionMonitor.this.db.println("Version " + cvu.prettyDottedString(comparable) + " nodes");
                NetworkVersionMonitor.this.db.println("-----------------------------");
                ArrayList arrayList = (ArrayList)NetworkVersionMonitor.this.networkElementVersions.get(comparable);
                if (arrayList == null) continue;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    NetworkVersionMonitor.this.db.println(((NetElement)iterator.next()).getHostName());
                }
            }
            NetworkVersionMonitor.this.db.println("================================");
        }
    }

    public static class ComparableHolder {
        public Comparable value;
    }
}

