/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.SDebug;
import cerent.util.view.fv.IViewManagerView;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.InterGraphLink;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLayout;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.fv.grapher.util.FvMapGraph;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvHandlesSelection;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.interactor.IlvSelectInteractorMoveSelection;
import ilog.views.interactor.IlvZoomViewInteractor;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.swing.IlvToolTipManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractView
extends IlvManagerView
implements TransformerListener,
IViewManagerView {
    public static final int VIEW_HEIGHT = 2400;
    public static final int VIEW_WIDTH = 3200;
    private int zoomCount = 0;
    private IlvJScrollManagerView graphWin = null;
    private IlvZoomViewInteractor zoomViewInteractor = null;
    protected LinkedList<InterGraphLink> interGraphLinks;
    protected LinkedList<InterGraphLink> spanInfoInterLinks;

    public AbstractView() {
        CustomSelectInteractor customSelectInteractor = new CustomSelectInteractor();
        customSelectInteractor.setOpaqueMove(true);
        this.pushInteractor((IlvManagerViewInteractor)customSelectInteractor);
        this.setKeepingAspectRatio(true);
        IlvToolTipManager.registerView((IlvManagerView)this);
        IlvHandlesSelection.defaultHandleColor = Color.black;
        IlvHandlesSelection.defaultHandleBackgroundColor = Color.white;
        IlvHandlesSelection.defaultHandleShape = 3;
        IlvHandlesSelection.defaultHandleSize = 1.0f;
        this.setAntiAliasing(true);
        super.ensureVisible(new IlvPoint(1250.0f, 1050.0f));
        this.addTransformerListener(this);
        this.interGraphLinks = new LinkedList();
        this.spanInfoInterLinks = new LinkedList();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setBackgroundI(String string) {
        try {
            MapImageIcon mapImageIcon = new MapImageIcon(new URL(string));
            this.getGraph().add((Object)mapImageIcon);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void setGraph(AbstractGraph abstractGraph) {
        if (abstractGraph != null) {
            super.setManager((IlvManager)abstractGraph);
            this.zoomCount = 0;
        }
    }

    public AbstractGraph getGraph() {
        IlvManager ilvManager = super.getManager();
        if (ilvManager instanceof AbstractGraph) {
            return (AbstractGraph)ilvManager;
        }
        return null;
    }

    public void resetZoom() {
        int n = this.getZoomCount();
        for (int i = 0; i < Math.abs(n - 0); ++i) {
            if (n < 0) {
                this.zoomIn();
                continue;
            }
            this.zoomOut();
        }
    }

    void zoomIn() {
        ++this.zoomCount;
        Dimension dimension = super.getSize();
        super.zoom(new IlvPoint((float)(dimension.width / 2), (float)(dimension.height / 2)), 1.1, 1.1, true);
    }

    void zoomOut() {
        --this.zoomCount;
        Dimension dimension = super.getSize();
        super.zoom(new IlvPoint((float)(dimension.width / 2), (float)(dimension.height / 2)), 0.9090909090909091, 0.9090909090909091, true);
    }

    public int getZoomCount() {
        return this.zoomCount;
    }

    void resetZoomCount() {
        this.zoomCount = 0;
    }

    public void setAntiAliasing(boolean bl) {
        super.setAntialiasing(bl);
    }

    public void doSpringLayout(Rectangle2D rectangle2D) {
        MapLayout.doSpringLayout(this.getGraph(), rectangle2D);
    }

    public void doUniformLengthEdgesLayout(Rectangle2D rectangle2D) {
        MapLayout.doUniformLengthEdgesLayout(this.getGraph(), rectangle2D);
    }

    public void doTreeLayout(MapNode mapNode, Map<? extends Object, ? extends Object> map, float f) {
        AbstractGraph abstractGraph = this.getGraph();
        MapLayout.doTreeLayout(abstractGraph, mapNode, map, f);
    }

    public void reDraw(Rectangle2D rectangle2D) {
        super.invalidateRect(new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()));
        super.reDrawViews();
    }

    void reDraw() {
        super.invalidateView();
        super.reDrawViews();
    }

    public void updateView() {
    }

    public Object getMapObjectAt(float f, float f2) {
        IlvGraphic ilvGraphic = this.getGraph().getObject(new IlvPoint(f, f2), this);
        if (ilvGraphic instanceof MapImage) {
            return null;
        }
        return ilvGraphic;
    }

    public Object getFunctObjectAt(float f, float f2) {
        IlvGraphic ilvGraphic = this.getGraph().getObject(new IlvPoint(f, f2), this, true);
        if (ilvGraphic instanceof MapImage) {
            return null;
        }
        return ilvGraphic;
    }

    public JComponent getGraphWindow() {
        if (this.graphWin == null) {
            this.graphWin = new IlvJScrollManagerView((IlvManagerView)this);
            this.graphWin.setPreferredSize(new Dimension(600, 600));
        }
        return this.graphWin;
    }

    public static int getCanvasCenterX() {
        return 1600;
    }

    public static int getCanvasCenterY() {
        return 1200;
    }

    public static int getCanvasHeight() {
        return 2400;
    }

    public static int getCanvasWidth() {
        return 3200;
    }

    public double getRotationAngle(IlvLinkImage ilvLinkImage) {
        double d = 0.0;
        IlvPoint[] ilvPointArray = ilvLinkImage.getLinkPoints(this.getTransformer());
        if (ilvPointArray.length == 2) {
            double d2 = ilvPointArray[1].getX() - ilvPointArray[0].getX();
            double d3 = ilvPointArray[1].getY() - ilvPointArray[0].getY();
            d = d2 == 0.0 ? 90.0 : Math.toDegrees(Math.atan(d3 / d2));
        }
        if (d < 0.0) {
            d = 360.0 + d;
        }
        return d;
    }

    Point2D.Double getWorldPoint(Point2D.Double double_) {
        IlvPoint ilvPoint = new IlvPoint((float)double_.getX(), (float)double_.getY());
        this.getTransformer().inverse(ilvPoint);
        return new Point2D.Double(ilvPoint.getX(), ilvPoint.getY());
    }

    public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        this.viewChanged();
    }

    protected void viewChanged() {
    }

    public void fitView() {
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null) {
            abstractGraph.enableBorder(false);
            super.fitTransformerToContent();
            this.zoomCount = 0;
            abstractGraph.enableBorder(true);
            this.reDraw();
        }
    }

    boolean isSelectZoom() {
        return this.getInteractor() instanceof IlvZoomViewInteractor;
    }

    void zoomSelectedArea() {
        if (this.zoomViewInteractor == null) {
            this.zoomViewInteractor = new IlvZoomViewInteractor();
        }
        super.pushInteractor((IlvManagerViewInteractor)this.zoomViewInteractor);
        this.resetZoomCount();
    }

    public Rectangle2D getViewRect() {
        return new Rectangle2D.Double(0.0, 0.0, super.visibleRect().getWidth(), super.visibleRect().getHeight());
    }

    public InterGraphLink createInterGraphLinks(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, MapLink mapLink, int n, int n2, boolean bl, boolean bl2, ArrayList<IlvGraphic> arrayList) {
        Object object;
        IlvGraphic ilvGraphic3 = ilvGraphic;
        IlvGraphic ilvGraphic4 = ilvGraphic2;
        ViewPin viewPin = null;
        ViewPin viewPin2 = null;
        if (ilvGraphic instanceof ViewPortGraphic) {
            object = (ViewCardGrapher)((ViewPortGraphic)ilvGraphic).getGraphParent();
            viewPin = (ViewPin)object.getGraphPins().get(((ViewPortGraphic)ilvGraphic).getPortName());
            if (viewPin == null) {
                viewPin = this.getPin(object.getGraphPins(), ((ViewPortGraphic)ilvGraphic).getGraphName());
            }
            ilvGraphic3 = object;
        }
        if (ilvGraphic2 instanceof ViewPortGraphic) {
            object = (ViewCardGrapher)((ViewPortGraphic)ilvGraphic2).getGraphParent();
            viewPin2 = (ViewPin)object.getGraphPins().get(((ViewPortGraphic)ilvGraphic2).getPortName());
            if (viewPin2 == null) {
                viewPin2 = this.getPin(object.getGraphPins(), ((ViewPortGraphic)ilvGraphic2).getGraphName());
            }
            ilvGraphic4 = object;
        }
        object = new InterGraphLink(this, ilvGraphic3, ilvGraphic4, ilvGraphic, ilvGraphic2, mapLink.getLinkClass(), mapLink, n, n2, bl, bl2);
        ((InterGraphLink)object).setAssociatedSrc(ilvGraphic);
        ((InterGraphLink)object).setAssociatedDst(ilvGraphic2);
        if (!this.alreadyExists((InterGraphLink)object)) {
            IlvGrapher ilvGrapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)ilvGraphic3, (IlvGraphic)ilvGraphic4);
            if (ilvGrapher == null) {
                ilvGrapher = this.getGraph();
            }
            ((InterGraphLink)object).placeBalloons();
            this.spanInfoInterLinks.add((InterGraphLink)object);
            IlvGrapher.addInterGraphLink((IlvLinkImage)object, (boolean)true);
            this.getGraph().setLayer((IlvGraphic)object, 10, true);
            this.interGraphLinks.add((InterGraphLink)object);
            if (mapLink.getSrc().getChildGrapher() != null) {
                ((FvMapGraph)mapLink.getSrc().getChildGrapher()).interLinkAdded((InterGraphLink)object);
            }
            if (mapLink.getDst().getChildGrapher() != null) {
                ((FvMapGraph)mapLink.getDst().getChildGrapher()).interLinkAdded((InterGraphLink)object);
            }
            if (viewPin != null) {
                ((ViewCardGrapher)ilvGraphic3).getConnector().connectLink((IlvLinkImage)object, (IlvGrapherPin)viewPin, true);
                arrayList.add(ilvGraphic);
            }
            if (viewPin2 != null) {
                ((ViewCardGrapher)ilvGraphic4).getConnector().connectLink((IlvLinkImage)object, (IlvGrapherPin)viewPin2, false);
                arrayList.add(ilvGraphic2);
            }
        }
        return object;
    }

    private ViewPin getPin(HashMap<String, ViewPin> hashMap, String string) {
        for (String string2 : hashMap.keySet()) {
            if (string2.indexOf(string) < 0) continue;
            return hashMap.get(string2);
        }
        return null;
    }

    private boolean alreadyExists(InterGraphLink interGraphLink) {
        boolean bl = false;
        for (int i = 0; i < this.interGraphLinks.size(); ++i) {
            InterGraphLink interGraphLink2 = this.interGraphLinks.get(i);
            if (!interGraphLink.getFrom().equals(interGraphLink2.getFrom()) || !interGraphLink.getTo().equals(interGraphLink2.getTo()) || !interGraphLink.getAssociatedSrc().equals(interGraphLink2.getAssociatedSrc()) || !interGraphLink.getAssociatedDst().equals(interGraphLink2.getAssociatedDst())) continue;
            bl = true;
        }
        return bl;
    }

    public void removeInterLinkFromList(InterGraphLink interGraphLink) {
        this.interGraphLinks.remove(interGraphLink);
        if (this.spanInfoInterLinks.contains(interGraphLink)) {
            this.spanInfoInterLinks.remove(interGraphLink);
        }
    }

    public void removeInterGraphLink(InterGraphLink interGraphLink) {
        for (int i = 0; i < this.interGraphLinks.size(); ++i) {
            InterGraphLink interGraphLink2 = this.interGraphLinks.get(i);
            if (!interGraphLink2.equals(interGraphLink)) continue;
            IlvGrapher ilvGrapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)interGraphLink.getTo(), (IlvGraphic)interGraphLink.getFrom());
            interGraphLink2.setLinkVisible(false);
            interGraphLink2.reDraw();
            ilvGrapher.removeLink((IlvLinkImage)interGraphLink2, true);
            this.interGraphLinks.remove(interGraphLink2);
            if (!this.spanInfoInterLinks.contains(interGraphLink2)) break;
            this.spanInfoInterLinks.remove(interGraphLink2);
            break;
        }
    }

    public LinkedList<InterGraphLink> getInterGraphLinks() {
        return this.interGraphLinks;
    }

    protected LinkedList<InterGraphLink> getSpanInfoInterLinks() {
        return this.spanInfoInterLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void placeInterLinkIcons() {
        if (this.interGraphLinks != null) {
            LinkedList<InterGraphLink> linkedList = this.interGraphLinks;
            synchronized (linkedList) {
                for (InterGraphLink interGraphLink : this.interGraphLinks) {
                    interGraphLink.placeIcons();
                }
            }
        }
    }

    public boolean isZoomLevelVisible() {
        return true;
    }

    class CustomSelectInteractorMoveSelection
    extends IlvSelectInteractorMoveSelection {
        public CustomSelectInteractorMoveSelection(IlvSelectInteractor ilvSelectInteractor) {
            super(ilvSelectInteractor);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            int n = 0;
            int n2 = 0;
            int n3 = AbstractView.getCanvasWidth();
            int n4 = AbstractView.getCanvasHeight();
            IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
            IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
            ilvTransformer.inverse(ilvPoint);
            if (ilvPoint.getX() > 0.0 && ilvPoint.getX() < (double)n3 && ilvPoint.getY() > 0.0 && ilvPoint.getY() < (double)n4) {
                mouseEvent.translatePoint(n, n2);
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }

    class CustomSelectInteractor
    extends IlvSelectInteractor {
        CustomSelectInteractor() {
        }

        protected IlvManagerViewInteractor getMoveSelectionInteractor() {
            return new CustomSelectInteractorMoveSelection(this);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = 50;
            IlvTransformer ilvTransformer = this.getTransformer();
            int n2 = (int)ilvTransformer.getx0();
            int n3 = (int)ilvTransformer.gety0();
            int n4 = keyEvent.getKeyCode();
            Rectangle rectangle = AbstractView.this.visibleRect();
            int n5 = (int)rectangle.getHeight();
            int n6 = (int)rectangle.getWidth();
            double d = ilvTransformer.getx11();
            double d2 = ilvTransformer.getx22();
            if (n4 == 33 || n4 == 38) {
                if (n3 <= 0) {
                    int n7 = Math.abs(n3) < 2 * n ? Math.abs(n3) : n;
                    AbstractView.this.translate(0.0f, n7, true);
                }
            } else if (n4 == 34 || n4 == 40) {
                double d3 = (double)(Math.abs(n3) + n5) / d2;
                if (d3 < 2400.0) {
                    int n8 = (int)(2400.0 * d2 - (double)Math.abs(n3) - (double)n5);
                    int n9 = Math.min(n8, n);
                    AbstractView.this.translate(0.0f, -1 * n9, true);
                }
            } else if (n4 == 37) {
                if (n2 <= 0) {
                    int n10 = Math.abs(n2) < 2 * n ? Math.abs(n2) : n;
                    AbstractView.this.translate(n10, 0.0f, true);
                }
            } else if (n4 == 39) {
                double d4 = (double)(Math.abs(n2) + n6) / d;
                if (d4 < 3200.0) {
                    int n11 = (int)(3200.0 * d - (double)Math.abs(n2) - (double)n6);
                    int n12 = Math.min(n11, n);
                    AbstractView.this.translate(-1 * n12, 0.0f, true);
                }
            } else if (n4 == 36) {
                // empty if block
            }
        }
    }
}

