/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractLink;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLabel;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.fv.grapher.FunctNetMapLink;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLinkAttachmentLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDwdmGraph {
    private static final double MAX_X_PIXEL_DISTANCE = 3.0;
    private static final Integer SRC = 0;
    private static final Integer DST = 1;
    private MapLabel srcSideLabel = new MapLabel();
    private MapLabel dstSideLabel = new MapLabel();
    private boolean sideLabelVisible;
    private IlvAttachmentConstraint srcSideLabelConstrain = null;
    private IlvAttachmentConstraint dstSideLabelConstrain = null;
    private MapDwdmGraph linkedMapLabel;
    private AbstractLink mapLink;
    private int linkOrderInBundle = 0;
    private static final SDebug db = new SDebug("MapDwdmGraph");
    private static int bundleNr = 1;
    private static int linkNr = 1;
    private int bundleId;
    private int linkId;

    public MapDwdmGraph(AbstractLink abstractLink, int n) {
        this.mapLink = abstractLink;
        this.linkedMapLabel = null;
        this.sideLabelVisible = true;
        this.bundleId = bundleNr++;
        if (abstractLink instanceof MapLinkBundle) {
            if (db.on()) {
                db.println("                  bundle NR" + this.bundleId);
            }
            this.initBundleLink((MapLinkBundle)abstractLink, n);
        } else if (abstractLink instanceof MapLink) {
            this.linkId = linkNr++;
            if (db.on()) {
                db.println("                  link NR" + this.linkId);
            }
            this.initLink((MapLink)abstractLink, n);
        }
    }

    public void initBundleLink(MapLinkBundle mapLinkBundle, int n) {
        int n2;
        try {
            n2 = mapLinkBundle.getLinks().length;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        switch (n2) {
            case 0: {
                if (db.on()) {
                    db.println("BNR_" + this.bundleId + " with 0 Links");
                }
                return;
            }
            case 1: {
                ArrayList<String> arrayList = this.takeSides(mapLinkBundle.getLinks()[0]);
                if (arrayList.size() < 2) {
                    if (db.on()) {
                        db.print("BNR_" + this.bundleId + " with 1 Links");
                        db.println(" has no Sides");
                    }
                    return;
                }
                String string = arrayList.get(0);
                this.srcSideLabel.setText(string);
                this.srcSideLabel.setFont(AbstractLink.getAnnotationFont());
                string = arrayList.get(1);
                this.dstSideLabel.setText(string);
                this.dstSideLabel.setFont(AbstractLink.getAnnotationFont());
                if (!db.on()) break;
                db.print("BNR_" + this.bundleId + " with 1 Links");
                db.println(" and SRCLabel = " + this.srcSideLabel.getText() + "  DSTLabel = " + this.dstSideLabel.getText());
                break;
            }
            default: {
                if (n2 % 2 != 0) {
                    return;
                }
                HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(this.srcSideLabel.getText(), "-");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                hashMap.put(SRC, arrayList);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                stringTokenizer = new StringTokenizer(this.dstSideLabel.getText(), "-");
                String string = this.dstSideLabel.getText();
                if (string.length() < 1) {
                    System.out.println("");
                }
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList2.add(stringTokenizer.nextToken());
                }
                hashMap.put(DST, arrayList2);
                this.attachBoundleSideLabel(this.adjustReverse(new ArrayList<MapLink>(Arrays.asList(mapLinkBundle.getLinks()))), hashMap);
                string = this.dstSideLabel.getText();
                if (string.length() < 1) {
                    System.out.println("");
                }
                if (!db.on()) break;
                db.print("BNR_" + this.bundleId + " with " + n2 + " Links");
                db.println(" and SRCLabel = " + this.srcSideLabel.getText() + "  DSTLabel = " + this.dstSideLabel.getText());
            }
        }
        if (this.srcSideLabelConstrain == null) {
            this.srcSideLabelConstrain = new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, IlvLinkAttachmentLocation.FromLink);
        }
        if (this.dstSideLabelConstrain == null) {
            this.dstSideLabelConstrain = new IlvAttachmentConstraint(IlvAttachmentLocation.CenterPostOrderFirst, IlvLinkAttachmentLocation.ToLink);
        }
        mapLinkBundle.setChildren(++n, (IlvGraphic)this.srcSideLabel);
        mapLinkBundle.setConstraints(n, this.srcSideLabelConstrain);
        mapLinkBundle.setChildren(++n, (IlvGraphic)this.dstSideLabel);
        mapLinkBundle.setConstraints(n, this.dstSideLabelConstrain);
    }

    public void initLink(MapLink mapLink, int n) {
        Network network;
        INetLink iNetLink;
        ILinkModel iLinkModel = null;
        if (mapLink.getUserObject() instanceof AbstractNetLink) {
            iLinkModel = ((AbstractNetLink)mapLink.getUserObject()).getLinkModel();
        }
        if (iLinkModel == null) {
            return;
        }
        if (this.linkedMapLabel != null) {
            this.adjustNetLinkSideLabel();
        }
        IEntityModel iEntityModel = MapLinkRenderer.getEntity(iLinkModel.src(), iLinkModel.srcEntityIndex());
        INodeModel iNodeModel = iLinkModel.dst();
        int n2 = iLinkModel.dstEntityIndex();
        if (mapLink.getUserObject() instanceof VirtualNetLink && (iNetLink = (network = Network.instance()).findReverseLink((INetLink)mapLink.getUserObject())) != null) {
            iLinkModel = iNetLink.getLinkModel();
            iNodeModel = iLinkModel.src();
            n2 = iLinkModel.srcEntityIndex();
        }
        network = MapLinkRenderer.getEntity(iNodeModel, n2);
        if (db.on()) {
            iNetLink = this.getLinkPosition();
            db.print("LNR_" + this.linkId + " Label " + this.srcSideLabel.getText() + ": X=" + iNetLink.getCenterX());
            db.println(" - Y=" + iNetLink.getCenterY());
            if (this.linkedMapLabel != null) {
                db.print("LinkedLNR_" + this.linkedMapLabel.linkId + " Label " + this.linkedMapLabel.srcSideLabel.getText() + ": X=" + this.linkedMapLabel.getLinkPosition().getCenterX());
                db.print(" - Y=" + this.linkedMapLabel.getLinkPosition().getCenterY());
                IlvRect ilvRect = this.linkedMapLabel.getLinkPosition();
                double d = iNetLink.getCenterX();
                double d2 = ilvRect.getCenterX();
                double d3 = iNetLink.getCenterY();
                double d4 = ilvRect.getCenterY();
                db.print("       - deltaX=" + Math.abs(d3 - d4));
                db.println(" - deltaY=" + Math.abs(d - d2) + "\n\n");
            }
        }
        if (!(iEntityModel instanceof IDwdmPortModel || network instanceof IDwdmPortModel || network instanceof ITdmPortModel || iEntityModel instanceof ITdmPortModel)) {
            if (iEntityModel != null) {
                this.srcSideLabel.setText(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.NullSeparated));
                this.srcSideLabel.setFont(AbstractLink.getAnnotationFont());
                mapLink.setChildren(++n, (IlvGraphic)this.srcSideLabel);
                if (this.srcSideLabelConstrain == null) {
                    this.srcSideLabelConstrain = new IlvAttachmentConstraint(IlvAttachmentLocation.TopLeft, IlvLinkAttachmentLocation.FromLink);
                }
                mapLink.setConstraints(n, this.srcSideLabelConstrain);
            }
            if (network != null) {
                this.dstSideLabel.setText(OchPortsHelper.getSideString((IEntityModel)network, OchPortsHelper.SideStringType.NullSeparated));
                this.dstSideLabel.setFont(AbstractLink.getAnnotationFont());
                mapLink.setChildren(++n, (IlvGraphic)this.dstSideLabel);
                if (this.dstSideLabelConstrain == null) {
                    this.dstSideLabelConstrain = new IlvAttachmentConstraint(IlvAttachmentLocation.TopLeft, IlvLinkAttachmentLocation.ToLink);
                }
                mapLink.setConstraints(n, this.dstSideLabelConstrain);
            }
        } else if (db.on()) {
            db.println("Dcn Extension Trunk/Filter");
        }
        this.sideLabelsVisible(this.sideLabelVisible);
    }

    private void sideLabelsVisible(boolean bl) {
        if (this.srcSideLabel != null) {
            this.sideLabelVisible = bl;
            this.srcSideLabel.setVisible(this.sideLabelVisible);
            this.dstSideLabel.setVisible(this.sideLabelVisible);
        }
    }

    private void adjustNetLinkSideLabel() {
        if (!this.sideLabelVisible) {
            return;
        }
        IlvRect ilvRect = this.getLinkPosition();
        IlvRect ilvRect2 = this.linkedMapLabel.getLinkPosition();
        if (ilvRect == null || ilvRect2 == null) {
            return;
        }
        double d = ilvRect.getCenterX();
        double d2 = ilvRect2.getCenterX();
        double d3 = ilvRect.getCenterY();
        double d4 = ilvRect2.getCenterY();
        boolean bl = true;
        if (this.sideLabelVisible && this.linkedMapLabel.sideLabelVisible) {
            bl = this.hiddenIfNotTooFar(this.linkOrderInBundle, this.linkedMapLabel.linkOrderInBundle);
        }
        if (bl) {
            if (db.on()) {
                db.println("Label in the middle of the link");
            }
            boolean bl2 = Math.abs(d - d2) > 3.0;
            float f = 0.0f;
            float f2 = 0.0f;
            if (bl2) {
                f2 = d > d2 ? -8.0f : 0.0f;
            } else {
                f = d3 > d4 ? -12.0f : -2.0f;
            }
            this.dstSideLabelConstrain.setOffset(new IlvPoint(f2, f));
            this.srcSideLabelConstrain.setOffset(new IlvPoint(f2, f));
        } else {
            if (db.on()) {
                db.println("link too far write only one label");
            }
            this.dstSideLabelConstrain.setHotSpot(IlvAttachmentLocation.LeftCenter);
            this.srcSideLabelConstrain.setHotSpot(IlvAttachmentLocation.LeftCenter);
        }
    }

    private boolean hiddenIfNotTooFar(int n, int n2) {
        boolean bl = Math.abs(n - n2) == 1;
        this.linkedMapLabel.sideLabelsVisible(!bl);
        return bl;
    }

    private void setLinkedLabel(MapDwdmGraph mapDwdmGraph) {
        this.linkedMapLabel = mapDwdmGraph;
    }

    private IlvRect getLinkPosition() {
        IlvGraphic[] ilvGraphicArray = this.mapLink.getChildren();
        if (ilvGraphicArray == null) {
            return null;
        }
        for (int i = 0; i < ilvGraphicArray.length; ++i) {
            if (!(ilvGraphicArray[i] instanceof MapImageIcon)) continue;
            return ilvGraphicArray[i].boundingBox();
        }
        return null;
    }

    private void attachBoundleSideLabel(MapLink[] mapLinkArray, HashMap<Integer, ArrayList<String>> hashMap) {
        for (int i = 0; i < mapLinkArray.length; ++i) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2;
            boolean bl;
            boolean bl2 = bl = i > 0 && i % 2 == 1;
            if (!bl) {
                int n;
                arrayList2 = this.takeSides(mapLinkArray[i]);
                if (arrayList2.size() == 0) {
                    return;
                }
                arrayList = hashMap.get(SRC);
                String[] stringArray = arrayList.toArray(new String[0]);
                boolean bl3 = true;
                String string = stringArray.length == 0 ? (String)arrayList2.get(SRC) : "";
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].contains((CharSequence)arrayList2.get(SRC))) {
                        string = "-" + (String)arrayList2.get(SRC);
                        continue;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    this.srcSideLabel.setText(this.srcSideLabel.getText() + string);
                    arrayList.add((String)arrayList2.get(SRC));
                }
                arrayList = hashMap.get(DST);
                stringArray = arrayList.toArray(new String[0]);
                bl3 = true;
                string = stringArray.length == 0 ? (String)arrayList2.get(DST) : "";
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].contains((CharSequence)arrayList2.get(DST))) {
                        string = "-" + (String)arrayList2.get(DST);
                        continue;
                    }
                    bl3 = false;
                }
                if (!bl3) continue;
                this.dstSideLabel.setText(this.dstSideLabel.getText() + string);
                arrayList.add((String)arrayList2.get(DST));
                continue;
            }
            arrayList2 = null;
            arrayList = null;
            if (mapLinkArray[i - 1] instanceof FunctNetMapLink && mapLinkArray[i] instanceof FunctNetMapLink) {
                arrayList2 = ((FunctNetMapLink)mapLinkArray[i - 1]).getSideLabel();
                arrayList = ((FunctNetMapLink)mapLinkArray[i]).getSideLabel();
            } else {
                arrayList2 = ((NetMapLink)mapLinkArray[i - 1]).getSideLabel();
                arrayList = ((NetMapLink)mapLinkArray[i]).getSideLabel();
            }
            if (arrayList2 == null || arrayList == null) continue;
            super.setLinkedLabel((MapDwdmGraph)((Object)arrayList));
            super.setLinkedLabel((MapDwdmGraph)((Object)arrayList2));
        }
    }

    private ArrayList<String> takeSides(MapLink mapLink) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ILinkModel iLinkModel = null;
        if (mapLink.getUserObject() instanceof AbstractNetLink) {
            iLinkModel = ((AbstractNetLink)mapLink.getUserObject()).getLinkModel();
        }
        if (iLinkModel != null) {
            Object object;
            IEntityModel iEntityModel = MapLinkRenderer.getEntity(iLinkModel.src(), iLinkModel.srcEntityIndex());
            INodeModel iNodeModel = iLinkModel.dst();
            int n = iLinkModel.dstEntityIndex();
            if (mapLink.getUserObject() instanceof VirtualNetLink) {
                object = OchncFilterManager.findLinkForReversePath((INetLink)mapLink.getUserObject(), new SDebug("MapDwdmGraphLink2"));
                if (object == null) {
                    return arrayList;
                }
                iLinkModel = object.getLinkModel();
                iNodeModel = iLinkModel.src();
                n = iLinkModel.srcEntityIndex();
            }
            object = MapLinkRenderer.getEntity(iNodeModel, n);
            if (!(iEntityModel instanceof IDwdmPortModel) && !(object instanceof IDwdmPortModel)) {
                if (iEntityModel != null) {
                    arrayList.add(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.NullSeparated));
                } else {
                    arrayList.add("");
                }
                if (object != null) {
                    arrayList.add(OchPortsHelper.getSideString((IEntityModel)object, OchPortsHelper.SideStringType.NullSeparated));
                } else {
                    arrayList.add("");
                }
            }
        }
        return arrayList;
    }

    private int getSideForOtsPort(INodeModel iNodeModel, int n) throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        if (iNodeModel.provides(Feature.OPTICAL_SIDE)) {
            return iNodeModel.getINodeOpticsTopologyModel().getSideForOtsPort(n);
        }
        return 0;
    }

    private MapLink[] adjustReverse(ArrayList<MapLink> arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        int n2 = arrayList.size();
        int n3 = 0;
        int n4 = 1;
        for (MapLink mapLink : arrayList) {
            MapDwdmGraph mapDwdmGraph;
            Object object;
            MapDwdmGraph mapDwdmGraph2;
            if (mapLink instanceof NetMapLink && (mapDwdmGraph2 = ((NetMapLink)(object = (NetMapLink)mapLink)).getSideLabel()) != null) {
                mapDwdmGraph2.setLinkOrderInBundle(n4);
                ++n4;
            }
            if (!(mapLink instanceof FunctNetMapLink) || (mapDwdmGraph = ((FunctNetMapLink)(object = (FunctNetMapLink)mapLink)).getSideLabel()) == null) continue;
            mapDwdmGraph.setLinkOrderInBundle(n4);
            ++n4;
        }
        do {
            MapLink mapLink = arrayList.get(0);
            INetLink iNetLink = (INetLink)mapLink.getUserObject();
            arrayList.remove(0);
            n3 = 0;
            boolean bl = false;
            for (MapLink mapLink2 : arrayList) {
                try {
                    int n5;
                    int n6;
                    INetLink runtimeException = OchncFilterManager.findLinkForReversePath((INetLink)mapLink2.getUserObject(), new SDebug("MapDwdmGraphLink"));
                    if (runtimeException == null) continue;
                    int n7 = iNetLink.getSrc().getNodeId();
                    int n8 = this.getSideForOtsPort(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex());
                    if (!(runtimeException instanceof VirtualNetLink)) {
                        n6 = runtimeException.getSrc().getNodeId();
                        n5 = this.getSideForOtsPort(runtimeException.getSrc().getNodeModel(), runtimeException.getSrcEntityIndex());
                    } else {
                        n6 = runtimeException.getDst().getNodeId();
                        n5 = this.getSideForOtsPort(runtimeException.getDst().getNodeModel(), runtimeException.getDstEntityIndex());
                    }
                    if (n7 == n6 && n8 == n5) {
                        iNetLink = (INetLink)mapLink.getUserObject();
                        arrayList2.add(mapLink);
                        arrayList2.add(mapLink2);
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                catch (FeatureUnsupported featureUnsupported) {
                    SDebug.printStackTrace((Throwable)featureUnsupported);
                }
                catch (CannotPerform cannotPerform) {
                    SDebug.printStackTrace((Throwable)cannotPerform);
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
                catch (RuntimeException runtimeException) {
                    SDebug.printStackTrace((Throwable)runtimeException);
                }
            }
            n += 2;
            if (!bl || arrayList.size() <= 1) continue;
            arrayList.remove(n3);
        } while (n < n2);
        return arrayList2.toArray(new MapLink[0]);
    }

    private void setLinkOrderInBundle(int n) {
        this.linkOrderInBundle = n;
    }

    public MapLabel getSrcSideLabel() {
        return this.srcSideLabel;
    }

    public MapLabel getDstSideLabel() {
        return this.dstSideLabel;
    }
}

