/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapLinkInfo;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JComponent;

public class MapLink
extends Link {
    public String CMD_COLLAPSE_SIMILAR_LINKS = "";
    private Vector containers = new Vector();
    public static final int LINK_UNKNOWN_STATE = -1;
    private int state = -1;

    public MapLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string) {
        super(mapToolkit, mapNode, mapNode2, string);
        this.CMD_COLLAPSE_SIMILAR_LINKS = "Collapse " + this.getLinkClass() + " Links";
    }

    public boolean isConnectedTo(Node node) {
        return node.isSameNodeAs(this.getSourceNode()) || node.isSameNodeAs(this.getTargetNode());
    }

    public MapNode getSourceNode() {
        return (MapNode)this.getSrc();
    }

    public MapNode getSource() {
        return (MapNode)this.getSrc();
    }

    public MapNode getTargetNode() {
        return (MapNode)this.getDst();
    }

    public MapNode getTarget() {
        return (MapNode)this.getDst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContainer(MapLinkBundle mapLinkBundle) {
        Vector vector = this.containers;
        synchronized (vector) {
            this.containers.add(mapLinkBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContainer(MapLinkBundle mapLinkBundle) {
        Vector vector = this.containers;
        synchronized (vector) {
            this.containers.remove(mapLinkBundle);
        }
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (!this.mtk.isDetailed()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, this.CMD_COLLAPSE_SIMILAR_LINKS, 76);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CMD_COLLAPSE_SIMILAR_LINKS) {
            if (!this.mtk.isDetailed()) {
                this.doCollapseSimilarLinks();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected MapLinkBundle doCollapseSimilarLinks() {
        MapLinkBundle mapLinkBundle = this.mtk.getMapLinkBundle(this);
        if (mapLinkBundle != null) {
            mapLinkBundle.doCollapse();
        }
        return mapLinkBundle;
    }

    void refreshContainersUI() {
        if (this.containers != null) {
            for (int i = 0; i < this.containers.size(); ++i) {
                MapLinkBundle mapLinkBundle = (MapLinkBundle)this.containers.get(i);
                mapLinkBundle.refreshUI();
            }
        }
    }

    public int getState() {
        return this.state;
    }

    void setLinkState(int n) {
        this.state = n;
    }

    public void setState(int n) {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            this.setLinkState(n);
        } else {
            mapLinkInfo.setState(n);
        }
    }

    protected void removeVNode(MapNode mapNode) {
        Link[] linkArray = mapNode.getLinks();
        if (linkArray == null || linkArray.length == 0) {
            mapNode.destroy();
        }
    }

    public void setLineColor(Color color) {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            super.setLineColor(color);
            this.refreshContainersUI();
        } else {
            mapLinkInfo.setLineColor(color);
        }
    }

    public void setSrcArrow() {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            super.setSrcArrow();
        } else {
            mapLinkInfo.setSrcArrow();
        }
    }

    public void setTargetArrow() {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            super.setTargetArrow();
        } else {
            mapLinkInfo.setTargetArrow();
        }
    }

    public void setBothArrows() {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            super.setBothArrows();
        } else {
            mapLinkInfo.setBothArrows();
        }
    }

    public void reverseArrow() {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            super.reverseArrow();
        } else {
            mapLinkInfo.reverseArrow();
        }
    }

    public void removeArrows() {
        MapLinkInfo mapLinkInfo = this.mtk.getMapLinkInfo(this.getUserObject());
        if (mapLinkInfo == null) {
            super.removeArrows();
        } else {
            mapLinkInfo.removeArrows();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.containers.size(); ++i) {
            MapLinkBundle mapLinkBundle = (MapLinkBundle)this.containers.get(i);
            mapLinkBundle.removeLink(this);
        }
        try {
            super.destroy();
            if (this.getSourceNode().isVirtual()) {
                this.removeVNode(this.getSourceNode());
            }
            if (this.getTargetNode().isVirtual()) {
                this.removeVNode(this.getTargetNode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setLinkVisible(final boolean bl) {
        LinkBundle linkBundle;
        if (this.getGraphicBag() instanceof LinkBundle && (linkBundle = (LinkBundle)this.getGraphicBag()) != null) {
            linkBundle.getGraphicBag().applyToObject((IlvGraphic)linkBundle, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ilvGraphic.setVisible(bl);
                    ilvGraphic.reDraw();
                }
            }, null, true);
        }
    }
}

