/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv;

import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ExternalExportHandler;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.helper.ViewHelper;
import cerent.util.KDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ExportTableDialog;
import cerent.util.view.fv.ViewPrintingHelper;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctExportTables
extends ExternalExportHandler {
    private String[] subTitleStrings;
    private String title;
    private ViewPrintingHelper printGraph;

    public FunctExportTables(AbstractViewController abstractViewController, ViewPrintingHelper viewPrintingHelper) {
        super(abstractViewController, null, null);
        this.printGraph = viewPrintingHelper;
    }

    @Override
    protected void exportAccepted(ExportTableDialog exportTableDialog) {
        int n = exportTableDialog.getExportTypeSelection();
        this.fvExportView(n, this.table, this.title + new Date(), this.subTitleStrings);
    }

    public void fvExportView(int n, JTable[] jTableArray, String string, String[] stringArray) {
        if (jTableArray.length != stringArray.length) {
            if (db.on()) {
                db.println("error in fvExportView: table and subTitle have different size");
            }
            return;
        }
        try {
            ViewHelper viewHelper = ViewHelper.instance((IUiToolkit)this.avc.getUiToolkit());
            String string2 = viewHelper.multiExportTables(n, true, null, string, stringArray, jTableArray);
            if (string2 != null && n == 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                String string3 = stringTokenizer.nextToken();
                this.addLink(this.printGraph.exportToBitmap(new File(string3)), new FileWriter(string2, true));
            }
        }
        catch (PrinterException printerException) {
            CerentDialog.errorDialog(null, (Exception)printerException, (String)"Network Functional View Export File Error");
            KDebug.printStackTrace((Throwable)printerException);
        }
        catch (IOException iOException) {
            CerentDialog.errorDialog(null, (Exception)iOException, (String)"Network Functional View Export File Error");
            KDebug.printStackTrace((Throwable)iOException);
        }
        catch (Exception exception) {
            CerentDialog.errorDialog(null, (Exception)exception, (String)"Network Functional View Export File Error");
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addLink(List<String> list, FileWriter fileWriter) {
        block10: {
            for (String string : list) {
                if (!string.endsWith(".jpg") && string.lastIndexOf(".") < 0) {
                    string = string + ".png";
                }
                fileWriter.write("<div style=\"text-align: center;\">");
                fileWriter.flush();
                fileWriter.write("<a href=\"" + string + "\">");
                fileWriter.flush();
                fileWriter.write("<img style=\"border: 0px solid ; width: 50%; height: 50%;\" alt=\"Network Image\"");
                fileWriter.write("src=\"" + string + "\"></a><BR>");
                fileWriter.flush();
                fileWriter.write("</div>");
                fileWriter.flush();
            }
            Object var6_6 = null;
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                CerentDialog.errorDialog(null, (Exception)iOException, (String)"Network Functional View BitMap Error");
                KDebug.printStackTrace((Throwable)iOException);
            }
            break block10;
            {
                catch (IOException iOException) {
                    CerentDialog.errorDialog(null, (Exception)iOException, (String)"Network Functional View BitMap Error");
                    KDebug.printStackTrace((Throwable)iOException);
                    Object var6_7 = null;
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException2) {
                        CerentDialog.errorDialog(null, (Exception)iOException2, (String)"Network Functional View BitMap Error");
                        KDebug.printStackTrace((Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    CerentDialog.errorDialog(null, (Exception)iOException, (String)"Network Functional View BitMap Error");
                    KDebug.printStackTrace((Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void setTable(JTable[] jTableArray) {
        this.table = jTableArray;
        this.subTitleStrings = new String[jTableArray.length];
        for (int i = 0; i < jTableArray.length; ++i) {
            this.subTitleStrings[i] = jTableArray[i].getName();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

