/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.alarms;

import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.NetworkAlarmPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import com.cisco.fv.alarms.FVEventPanel;
import com.cisco.fv.alarms.FvNetworkAlarmStore;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class FVNetworkAlarmPane
extends NetworkAlarmPane {
    private boolean handleNewalarms;

    public FVNetworkAlarmPane(String string, TabbedView tabbedView, FvNetworkAlarmStore fvNetworkAlarmStore, IEventPanelController iEventPanelController) {
        super(string, tabbedView, fvNetworkAlarmStore, iEventPanelController);
        fvNetworkAlarmStore.getAlarmStore().getStoreObservable().addObserver((Observer)((Object)this));
        this.handleNewalarms = false;
    }

    protected EventPanel createEventPanel(IEventPanelController iEventPanelController) {
        int n = 31457;
        FVEventPanel fVEventPanel = new FVEventPanel((FvNetworkAlarmStore)this.alarmStore, iEventPanelController, n);
        fVEventPanel.getTable().setName("Network Alarm");
        return fVEventPanel;
    }

    protected int[] createDefaultSorting() {
        int n = this.table.getColumn("Sev").getModelIndex();
        int[] nArray = new int[]{n};
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncAlarms() {
        try {
            try {
                this.setCursor(3);
                this.alarmStore.flushAlarmStore();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
                Object var3_2 = null;
                this.setCursor(0);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setCursor(0);
            throw throwable;
        }
        this.setCursor(0);
    }

    public void enteringPage() {
        try {
            super.enteringPage();
            ((FVEventPanel)this.alrPanel).refresh();
            this.handleNewalarms = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.handleNewalarms = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        ((FVEventPanel)this.alrPanel).refresh();
    }

    public boolean circuitAlarm(EventInfo eventInfo) {
        List list;
        this.setContextMenuEventInfo(eventInfo);
        try {
            list = this.getAffectedCircuitIds();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        for (Object e : list) {
            if (!(e instanceof ICircuitId)) continue;
            return true;
        }
        return false;
    }

    public boolean circuitAlarm(EventInfo eventInfo, ICircuitId iCircuitId) {
        List list;
        this.setContextMenuEventInfo(eventInfo);
        try {
            list = this.getAffectedCircuitIds();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        for (Object e : list) {
            if (!(e instanceof ICircuitId) || !iCircuitId.equals(e)) continue;
            return true;
        }
        return false;
    }

    protected void electricalAffectedCircuit(INodeModel iNodeModel, List list) {
    }

    protected void opticalAffectedCircuit(INodeModel iNodeModel, List list) {
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable instanceof StoreObservable) {
            ((FvNetworkAlarmStore)this.alarmStore).updateReceived();
            ((FVEventPanel)this.alrPanel).refresh();
        }
        super.update(observable, object);
    }

    public void destroy() {
        ((FvNetworkAlarmStore)this.alarmStore).getAlarmStore().getStoreObservable().deleteObserver((Observer)((Object)this));
        super.destroy();
    }
}

