/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.alarms;

import cerent.cms.fv.IFVNodeAlarmed;
import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.model.NodeModel;
import cerent.cms.model.event.EventInfo;
import cerent.util.IFvDebug;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.helper.FunctDebug;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.fv.alarms.FVNodeAlarmed;
import com.cisco.fv.alarms.FvCircuitAlarmStore;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.FvNetworkMap;
import java.util.Collection;
import java.util.HashMap;

public class FVPaintAlarm
implements Runnable {
    private static FVPaintAlarm instance;
    private Boolean threadRuning = false;
    private Thread alarmThread;
    private HashMap<Integer, NodeAlarmedCard> alarmedObject;
    private FvCircuitAlarmStore alarmStore;
    private Boolean alarmMask;
    private IFvDebug sd = FunctDebug.instance().addChild("FVPaintAlarm", "Dump the alam paint for NFV");
    private boolean dispose = false;

    public FVPaintAlarm() {
        this.alarmedObject = new HashMap();
    }

    public void dispose() {
        this.dispose = true;
    }

    private void internalDispose() {
        instance = null;
        this.threadRuning = true;
        this.alarmThread = null;
        this.alarmStore = null;
    }

    public static FVPaintAlarm getInstance() {
        if (instance == null) {
            instance = new FVPaintAlarm();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Boolean bl = this.threadRuning;
        synchronized (bl) {
            this.threadRuning = true;
            this.populateAlarmUnits();
            this.threadRuning = false;
            this.applyMask();
        }
        if (this.sd.on()) {
            this.sd.println("Exit Thread");
        }
    }

    public void addAlarmStore(FvCircuitAlarmStore fvCircuitAlarmStore) {
        this.alarmStore = fvCircuitAlarmStore;
    }

    public void setAlarmMask(boolean bl) {
        if (this.dispose) {
            this.internalDispose();
            return;
        }
        if (!this.threadRuning.booleanValue()) {
            if (this.sd.on()) {
                this.sd.println("");
                this.sd.println("Run Thread");
            }
            this.alarmMask = bl;
            this.alarmThread = new Thread((Runnable)this, "FVPaintAlarm");
            this.alarmThread.start();
        } else if (this.sd.on()) {
            this.sd.println("Thread already running");
        }
    }

    private void applyMask() {
        FvNetworkMap fvNetworkMap = FvNetworkMap.getInstance();
        if (fvNetworkMap == null) {
            return;
        }
        MapNode[] mapNodeArray = fvNetworkMap.getMapNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            IFvNetNode iFvNetNode;
            FunctNetMapNode functNetMapNode = (FunctNetMapNode)mapNodeArray[i];
            if (this.alarmMask.booleanValue()) {
                iFvNetNode = functNetMapNode.getNodeModel();
                NodeAlarmedCard nodeAlarmedCard = this.alarmedObject.get(iFvNetNode.getNodeId());
                if (iFvNetNode.isFVActive()) {
                    this.colorNodeUnits(functNetMapNode, nodeAlarmedCard);
                }
                this.colorNodeIcon(functNetMapNode, nodeAlarmedCard);
                continue;
            }
            if (this.sd.on()) {
                this.sd.println(functNetMapNode.getNodeModel().getName() + " clear alm");
            }
            functNetMapNode.maskAlarm(false, -1);
            iFvNetNode = functNetMapNode.getNodeModel();
            if (iFvNetNode.isInCircuit() || !iFvNetNode.isFVActive()) continue;
            functNetMapNode.getNodeFv().maskAlarmForCircuit(false);
        }
        this.alarmedObject.clear();
    }

    private void colorNodeUnits(FunctNetMapNode functNetMapNode, NodeAlarmedCard nodeAlarmedCard) {
        ViewManagerToolKit viewManagerToolKit = functNetMapNode.getNodeFv();
        IFVNodeAlarmed iFVNodeAlarmed = null;
        if (nodeAlarmedCard != null) {
            iFVNodeAlarmed = nodeAlarmedCard.getAlarms();
        }
        viewManagerToolKit.showCircuitCardAlarm(true, iFVNodeAlarmed);
        viewManagerToolKit.showCircuitPortAlarm(true, iFVNodeAlarmed);
    }

    private void colorNodeIcon(FunctNetMapNode functNetMapNode, NodeAlarmedCard nodeAlarmedCard) {
        Object object;
        Integer n;
        IFvNetNode iFvNetNode = functNetMapNode.getNodeModel();
        if (nodeAlarmedCard == null) {
            n = 0;
        } else {
            n = nodeAlarmedCard.getAlarms().getSeverity(Integer.valueOf(iFvNetNode.getNodeId()));
            if (n == null) {
                return;
            }
            object = n;
            Integer n2 = n = Integer.valueOf(n - 1);
        }
        functNetMapNode.maskAlarm(!iFvNetNode.isInCircuit(), n);
        if (this.sd.on()) {
            switch (n) {
                case 0: {
                    object = "NO_ALARM";
                    break;
                }
                case 1: {
                    object = "MINOR_STATE";
                    break;
                }
                case 2: {
                    object = "MAJOR_STATE";
                    break;
                }
                case 3: {
                    object = "CRITICAL_STATE";
                    break;
                }
                default: {
                    object = "ERROR IN SEVERITY";
                }
            }
            this.sd.println(iFvNetNode.getName() + " painr sev" + (String)object);
        }
    }

    private void populateAlarmUnits() {
        if (this.sd.on()) {
            this.sd.println("Enter populateBalloon");
        }
        if (this.alarmStore == null) {
            return;
        }
        Collection collection = this.alarmStore.getAllObjects();
        FvNetworkMap fvNetworkMap = FvNetworkMap.getInstance();
        for (EventInfo eventInfo : collection) {
            FunctNetMapNode functNetMapNode;
            block11: {
                int n = eventInfo.getNodeId();
                IFvNetNode iFvNetNode = fvNetworkMap.getNetworkModel().findIFvNetElem(n).getNetworkNode();
                functNetMapNode = (FunctNetMapNode)fvNetworkMap.getMapNode(iFvNetNode);
                if (iFvNetNode.isFVActive()) {
                    IEntityModel iEntityModel;
                    try {
                        int n2 = eventInfo.getIndex();
                        iEntityModel = ((NodeModel)iFvNetNode).getEntityTable().getEntityModelByIndex(n2);
                        if (iEntityModel instanceof IFvCardModel) {
                            this.addElement(((IFvCardModel)iEntityModel).getIndex(), 0, eventInfo, functNetMapNode);
                            break block11;
                        }
                        if (!(iEntityModel instanceof IFvPortModel)) break block11;
                        this.addElement(((IFvPortModel)iEntityModel).getCardModel().getIndex(), iEntityModel.getEntityIndex(), eventInfo, functNetMapNode);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        try {
                            iEntityModel = iFvNetNode.getInterfaceModelByIndex(eventInfo.getIndex()).getThePortModel();
                            this.addElement(iEntityModel.getCardModel().getIndex(), iEntityModel.getEntityIndex(), eventInfo, functNetMapNode);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException2) {
                            if (!this.sd.on()) continue;
                            this.sd.println("AbstractCmsNoSuchEntityException");
                            continue;
                        }
                        catch (InvalidNodeId invalidNodeId) {
                            if (!this.sd.on()) continue;
                            this.sd.println("InvalidNodeId");
                            continue;
                        }
                    }
                }
            }
            this.addElement(eventInfo.getNodeId(), 0, eventInfo, functNetMapNode);
        }
        if (this.sd.on()) {
            this.sd.println("Exit populateBalloon");
        }
    }

    private void addElement(int n, int n2, EventInfo eventInfo, FunctNetMapNode functNetMapNode) {
        int n3 = eventInfo.getSeverity();
        String string = eventInfo.getCondDesc();
        int n4 = eventInfo.getNodeId();
        if (eventInfo.getState() != 'C') {
            if (this.alarmedObject.containsKey(n4)) {
                NodeAlarmedCard nodeAlarmedCard = this.alarmedObject.get(n4);
                nodeAlarmedCard.addAlarm(n, n2, string, n3);
            } else {
                NodeAlarmedCard nodeAlarmedCard = new NodeAlarmedCard(functNetMapNode, n, n2, string, n3);
                this.alarmedObject.put(n4, nodeAlarmedCard);
            }
        }
    }

    public void clearAlarms() {
    }

    private class NodeAlarmedCard {
        private FVNodeAlarmed fvAlarm;
        private FunctNetMapNode node;

        public NodeAlarmedCard(FunctNetMapNode functNetMapNode, int n, int n2, String string, int n3) {
            this.node = functNetMapNode;
            this.fvAlarm = new FVNodeAlarmed(n, n2, string, n3);
            if (FVPaintAlarm.this.sd.on()) {
                FVPaintAlarm.this.sd.println("Created " + functNetMapNode.getNodeModel().getName() + "Sev = " + n3);
            }
        }

        public void addAlarm(Integer n, int n2, String string, int n3) {
            this.fvAlarm.addAlarm(n, n2, string, n3);
            if (FVPaintAlarm.this.sd.on()) {
                FVPaintAlarm.this.sd.println("Added Element " + n + " in node " + this.node.getNodeModel().getName() + "Sev = " + n3);
            }
        }

        public IFVNodeAlarmed getAlarms() {
            return this.fvAlarm;
        }

        public IFvNetNode getNodeModel() {
            return (IFvNetNode)this.node.getUserObject();
        }

        public FunctNetMapNode getNodeMap() {
            return this.node;
        }
    }
}

