/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.alarms;

import cerent.cms.model.ICircuitId;
import cerent.cms.model.event.AbstractAlarmStore;
import cerent.cms.model.event.EventFilter;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.ncp.INetCircuit;
import cerent.util.SDebug;
import com.cisco.fv.alarms.FVNetworkAlarmPane;
import com.cisco.fv.alarms.FVPaintAlarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FvNetworkAlarmStore
extends AbstractAlarmStore {
    private NetworkAlarmStore alarmStore;
    private FVNetworkAlarmPane filterPane;
    private ArrayList<EventInfo> circuitAffected;
    private ArrayList<EventInfo> noCircuitAffected;
    private boolean listInitialized = false;
    private Thread alarmTask;
    private int update = 0;
    private boolean exitTask = false;
    private boolean circuitMaskAlarm = false;

    public FvNetworkAlarmStore(NetworkAlarmStore networkAlarmStore, String string) {
        super(string);
        this.db = new SDebug(string);
        this.alarmStore = networkAlarmStore;
        this.circuitAffected = new ArrayList();
        this.noCircuitAffected = new ArrayList();
        this.alarmTask = new Thread((Runnable)new UpdateListTask(), this.getClass().getSimpleName());
        this.alarmTask.start();
    }

    @Override
    public Collection getAllObjects() {
        ArrayList<EventInfo> arrayList = this.prepareList();
        if (this.db.on()) {
            this.db.println("Number Of Objects = " + arrayList.size());
        }
        return (Collection)arrayList.clone();
    }

    protected ArrayList<EventInfo> prepareList() {
        if (!this.listInitialized) {
            this.listInitialized = true;
            if (this.db.on()) {
                this.db.print("List empty prepare : ");
            }
            Collection collection = this.alarmStore.getAllObjects();
            if (this.db.on()) {
                this.db.println("with a number of " + collection.size() + " alarms: ");
            }
            for (EventInfo eventInfo : collection) {
                if (this.filterPane.circuitAlarm(eventInfo)) {
                    this.circuitAffected.add(eventInfo);
                    continue;
                }
                this.noCircuitAffected.add(eventInfo);
            }
        }
        if (this.db.on()) {
            this.db.println("circuit Affected are = " + this.circuitAffected.size());
        }
        if (this.db.on()) {
            this.db.println("NOT circuit Affected are = " + this.noCircuitAffected.size());
        }
        return this.circuitAffected;
    }

    public ArrayList<EventInfo> prepareList(INetCircuit iNetCircuit) {
        ICircuitId iCircuitId = iNetCircuit.getCircuitId();
        int n = iNetCircuit.getCircuitOptChannel();
        Collection collection = this.alarmStore.getAllObjects();
        if (this.db.on()) {
            this.db.print("with a number of " + collection.size() + " alarms: ");
        }
        for (EventInfo eventInfo : collection) {
            if (eventInfo.getWavelength() == n || eventInfo.getWavelength() == -1) {
                if (this.filterPane.circuitAlarm(eventInfo, iCircuitId)) {
                    this.circuitAffected.add(eventInfo);
                    continue;
                }
                this.noCircuitAffected.add(eventInfo);
                continue;
            }
            this.noCircuitAffected.add(eventInfo);
        }
        return this.circuitAffected;
    }

    @Override
    public Object getObjectAtRow(int n) {
        EventInfo eventInfo = this.prepareList().get(n);
        if (this.db.on()) {
            this.db.println("Objects at [" + n + "] is" + eventInfo);
        }
        return eventInfo;
    }

    @Override
    public int getRowCount() {
        if (this.db.on()) {
            this.db.print("getRowCount: = ");
        }
        int n = 0;
        if (this.filterPane == null) {
            n = this.alarmStore.getRowCount();
            if (this.db.on()) {
                this.db.print("alarmStoreRows - ");
            }
        } else {
            n = this.prepareList().size();
            if (this.db.on()) {
                this.db.print("FValarmStore = ");
            }
        }
        if (this.db.on()) {
            this.db.println(String.valueOf(n));
        }
        return n;
    }

    @Override
    public EventFilter getEventFilter() {
        return this.alarmStore.getEventFilter();
    }

    @Override
    protected void localUpdateStatus(EventInfo eventInfo) {
    }

    public void flushAlarmStore() {
        if (this.db.on()) {
            this.db.println("flushAlarmStore");
        }
        this.clearList();
        this.prepareList();
        this.alarmStore.flushAlarmStore();
        this.alarmStore.getAllPendingAlarms();
    }

    public void clearList() {
        if (this.db.on()) {
            this.db.println("clearList");
        }
        this.circuitAffected.clear();
        this.noCircuitAffected.clear();
        this.listInitialized = false;
    }

    public void addFilterPane(FVNetworkAlarmPane fVNetworkAlarmPane) {
        this.filterPane = fVNetworkAlarmPane;
    }

    public FVNetworkAlarmPane getFilterPane() {
        return this.filterPane;
    }

    public NetworkAlarmStore getAlarmStore() {
        return this.alarmStore;
    }

    public void updateReceived() {
        ++this.update;
        if (this.db.on()) {
            this.db.println("updateReceived");
        }
        this.clearList();
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stopTaskUpdate();
    }

    protected void stopTaskUpdate() {
        this.exitTask = true;
    }

    public void filterForCircuit(boolean bl) {
        this.circuitMaskAlarm = bl;
    }

    private class UpdateListTask
    implements Runnable {
        private boolean startUpdate = false;
        private boolean readyTostart = false;

        private UpdateListTask() {
        }

        public void run() {
            while (!FvNetworkAlarmStore.this.exitTask) {
                if (FvNetworkAlarmStore.this.update != 0) {
                    this.startUpdate = false;
                    this.readyTostart = true;
                } else if (this.readyTostart) {
                    this.startUpdate = true;
                }
                FvNetworkAlarmStore.this.update = 0;
                if (this.startUpdate) {
                    FvNetworkAlarmStore.this.prepareList();
                    if (FvNetworkAlarmStore.this.circuitMaskAlarm) {
                        FVPaintAlarm.getInstance().setAlarmMask(true);
                    }
                    this.startUpdate = false;
                    this.readyTostart = false;
                }
                this.waitResponse(2000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitResponse(long l) {
            UpdateListTask updateListTask = this;
            synchronized (updateListTask) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

