/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractTabbedView;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.FVCircuitsTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.network.NetworkTabbedView;
import cerent.util.EID;
import cerent.util.SDebug;
import cerent.util.gui.IFunctionalView;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.alarms.FVNetworkAlarmPane;
import com.cisco.fv.alarms.FvNetworkAlarmStore;
import com.cisco.fv.circuit.FVNetOpticalPowerPane;
import com.cisco.fv.circuit.FVSelectedCircuitPane;
import com.cisco.fv.circuit.model.FvCircuitModels;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import java.awt.Component;
import java.awt.Dimension;

public class FVNetworkCircuitPanel
extends AbstractTabbedView
implements IFunctionalView {
    private static final int SelectedCircuit = 3;
    private FVCircuitsTabbedView circuitTabPane;
    private FVSelectedCircuitPane selectedPane;
    private FVNetOpticalPowerPane powerPane;
    private SDebug db = new SDebug("FVNetworkCircuitPanel");
    private FVNetworkAlarmPane networkAlarmPane;
    private FunctionalNetworkDialog frameDialog;

    public FVNetworkCircuitPanel(IUiToolkit iUiToolkit, FunctionalNetworkDialog functionalNetworkDialog) {
        super(NetworkModel.instance());
        this.circuitTabPane = (FVCircuitsTabbedView)((Object)iUiToolkit.getGuestPane(15, (TabbedView)this));
        FunctViewManagerDelegate.getInstance().addCircuitPane(this.circuitTabPane);
        this.addTab("Circuits", (Component)((Object)this.circuitTabPane));
        this.powerPane = new FVNetOpticalPowerPane(this);
        this.addTab("Optical Power", (Component)((Object)this.powerPane));
        this.getAlarmTab();
        this.addTab("Alarms", (Component)((Object)this.networkAlarmPane));
        this.frameDialog = functionalNetworkDialog;
        this.frameDialog.addTableToExport(this.networkAlarmPane.getTable());
        this.frameDialog.addTableToExport(this.powerPane.getTable());
        this.selectedPane = new FVSelectedCircuitPane(this);
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }

    public void createDwdmPath(IFVSelectedPowerModel iFVSelectedPowerModel, int n) {
        FvNetworkCircuitPath.getInstance().paintCircuit(iFVSelectedPowerModel, n);
        PowerBallon.getInstance().setForCircuit(true);
        SpanLossBalloon.getInstance().setForCircuit(true);
    }

    public void deleteAllDwdmPath() {
        FvCircuitModels.getInstance().deleteCircuits(true);
    }

    public void deleteDwdmPath(int n) {
    }

    public IFvSideModel getSide() {
        return null;
    }

    public FVSelectedCircuitPane getSelectedPane() {
        return this.selectedPane;
    }

    public void setSelectedCircuitTabVisible(boolean bl, String string) {
        block10: {
            String string2 = "Circuit: " + string;
            if (this.getTabCount() > 3) {
                if (!bl) {
                    this.frameDialog.removeTableToExport(this.selectedPane.getTables());
                    this.removeTab(this.getTitleAt(3));
                } else {
                    for (int i = 0; i < this.getTabCount(); ++i) {
                        if (!this.getTitleAt(i).contains("Circuit: ")) continue;
                        this.setTitleAt(i, string2);
                    }
                    this.frameDialog.setExportableTitle(string2 + " ");
                }
                try {
                    this.setShowing(true);
                }
                catch (AbstractLeavePageException abstractLeavePageException) {
                    if (this.db.on()) {
                        this.db.println("Error in showing Selected Circuit Pane");
                    }
                    break block10;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("Error in showing Selected Circuit Pane");
                    }
                    break block10;
                }
            }
            if (bl) {
                this.frameDialog.addTableToExport(this.selectedPane.getTables());
                this.frameDialog.setExportableTitle(string2 + " ");
                this.addTab(string2, (Component)((Object)this.selectedPane));
            }
        }
    }

    public void getAlarmTab() {
        IEventPanelController iEventPanelController = ((NetworkTabbedView)NetworkViewController.instance().getTabbedView()).getEventController();
        FvNetworkAlarmStore fvNetworkAlarmStore = FunctViewManagerDelegate.getAlarmStore();
        this.networkAlarmPane = new FVNetworkAlarmPane("Alarms", (TabbedView)this, fvNetworkAlarmStore, iEventPanelController);
        fvNetworkAlarmStore.addFilterPane(this.networkAlarmPane);
    }

    public FVNetOpticalPowerPane getPowerPane() {
        return this.powerPane;
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 200);
    }

    public void destroy() {
        super.destroy();
        this.selectedPane.destroy();
        this.powerPane.destroy();
    }
}

