/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.net.IFvNetNode;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.circuit.model.CircuitTableRowModel;
import com.cisco.fv.circuit.model.PowerTableRowModel;
import com.cisco.fv.circuit.model.SelectedPowerRowModel;
import javax.swing.table.AbstractTableModel;

public class FVCircuitTableModel
extends AbstractTableModel
implements IObserver {
    public static final int NAME = 0;
    public static final int PIN = 1;
    public static final int POUT = 2;
    public static final int SPAN = 3;
    public static final int NODE = 0;
    static final SDebug sd = new SDebug("FVCircuitTableModel");
    private static String[] fvPowerColumnNames = new String[]{"Optical Link", "PIn", "POut", "SpLoss"};
    CircuitTableRowModel allObjectsList = null;

    public int getColumnCount() {
        return fvPowerColumnNames.length;
    }

    public int getRowCount() {
        if (this.allObjectsList == null) {
            return 0;
        }
        return this.allObjectsList.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.allObjectsList.size()) {
            return "N/A";
        }
        switch (n2) {
            case 0: {
                return this.allObjectsList.getName(n);
            }
            case 1: {
                if (this.allObjectsList.getType(n) == 0) {
                    return this.allObjectsList.getPowerInSpann(n);
                }
                return "";
            }
            case 2: {
                if (this.allObjectsList.getType(n) == 0) {
                    return this.allObjectsList.getPowerOut(n);
                }
                return "";
            }
            case 3: {
                if (this.allObjectsList.getType(n) == 3) {
                    return this.allObjectsList.getPowerInSpann(n);
                }
                return "";
            }
        }
        if (sd.on()) {
            sd.println("try to print a cell in a wrong column number ");
        }
        return null;
    }

    public String getColumnName(int n) {
        return fvPowerColumnNames[n];
    }

    public void addModel(IFVPowerModel iFVPowerModel) {
        if (this.allObjectsList != null) {
            this.allObjectsList.dispose();
        }
        Object var2_2 = null;
        this.allObjectsList = iFVPowerModel instanceof IFVSelectedPowerModel ? new SelectedPowerRowModel((IFVSelectedPowerModel)iFVPowerModel) : new PowerTableRowModel(iFVPowerModel);
    }

    public void updateNodeModel(FunctObserverArgument functObserverArgument) {
        IFvNetNode iFvNetNode = functObserverArgument.getNode();
        if (this.allObjectsList != null) {
            if (functObserverArgument.getType() == 3) {
                this.allObjectsList.removeData(iFvNetNode);
            }
            this.allObjectsList.prepareNodeData(iFvNetNode);
        }
    }

    public void update(IObservable iObservable, Object object) {
    }
}

