/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher;

import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.fv.net.IFvVirtualLink;
import cerent.cms.fv.net.IFvVirtualLinksDirector;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.ui.network.LinkClassIconUtil;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.IPowerBallon;
import cerent.util.view.fv.helper.FunctDebug;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.MapDwdmGraph;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapObjectAdapter;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.util.FunctLinkBundle;
import com.cisco.fv.grapher.util.FunctProtSwitchState;
import com.cisco.fv.grapher.util.FvMapToolkit;
import com.cisco.fv.grapher.util.LinkBalloon;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import ilog.views.IlvGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLinkAttachmentLocation;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FunctNetMapLink
extends DetailedMapLink
implements IPowerBallon {
    private static final double UP = -90.0;
    private static final double DOWN = 90.0;
    private static final double RIGHT = 0.0;
    private static final double LEFT = 180.0;
    public static final int LINK_SELECTED_STATE = 0;
    public static final int LINK_DOWN_STATE = 1;
    public static final int LINK_UP_STATE = 2;
    public static final int LINK_INCLUDED_STATE = 3;
    public static final int LINK_ACTIVE_STATE = 4;
    public static final int LINK_STANDBY_STATE = 5;
    public static final int LINK_EXCLUDED_STATE = 6;
    public static final int LINK_ROLL_STATE = 7;
    private static final double MAX_X_PIXEL_DISTANCE = 70.0;
    private static final String PWR_CMD = "Hide/Show SpanLoss";
    public static Color LINK_UNKNOWN_COLOR = Color.gray;
    public static Color LINK_SELECTED_COLOR = Color.yellow;
    public static Color LINK_DOWN_COLOR = Color.gray;
    public static Color LINK_UP_COLOR = Color.green;
    public static Color LINK_INCLUDED_COLOR = Color.blue;
    public static Color LINK_ACTIVE_COLOR = Color.green;
    public static Color LINK_STANDBY_COLOR = Color.magenta;
    public static Color LINK_EXCLUDED_COLOR = Color.red;
    public static Color LINK_ROLL_COLOR = Color.orange;
    private MapDwdmGraph sideLabel;
    private LinkBalloon spanLossInfoBalloon;
    private static final SDebug db = new SDebug("FunctNetMapLink");
    private FunctLinkBundle linkBundle;
    private FunctProtSwitchState pss;
    private boolean balloonOpened;
    private boolean isReverseLink = false;
    private boolean isHiddenByInterLink = false;
    private boolean isOnCircuit;

    public FunctNetMapLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string) {
        super(mapToolkit, mapNode, mapNode2, string);
    }

    public void placeBalloons(boolean bl) {
        if (this.spanLossInfoBalloon == null) {
            int n;
            this.spanLossInfoBalloon = new LinkBalloon("power", LinkBalloon.BASE_COLOR, 10);
            int n2 = n = this.getChildren() != null ? this.getChildren().length : 0;
            if (this.getLinkClass().equals("OTS") || !this.isReverseLink) {
                this.setChildren(n, (IlvGraphic)this.spanLossInfoBalloon);
                this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, IlvLinkAttachmentLocation.ToLink));
            } else {
                this.setChildren(n, (IlvGraphic)this.spanLossInfoBalloon);
                this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, IlvLinkAttachmentLocation.FromLink));
            }
            this.spanLossInfoBalloon.showIt(false);
        }
    }

    public synchronized void init(Object object, Object object2) {
        super.init(object, object2);
        if (!this.mtk.isDetailed()) {
            this.pss = new FunctProtSwitchState((FvMapToolkit)this.mtk, this);
        }
    }

    public String getToolTipText() {
        Object object = this.getUserObject();
        if (object instanceof IFvNetLink) {
            return this.getNetLinkTooltip();
        }
        return "External Link";
    }

    public String getVitalStatsString() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return "";
        }
        IFvNetLink iFvNetLink = (IFvNetLink)this.getUserObject();
        StringBuffer stringBuffer = new StringBuffer();
        if (iFvNetLink.isVirtual()) {
            IFvVirtualLink iFvVirtualLink = (IFvVirtualLink)this.getUserObject();
            try {
                if (this.mtk instanceof FvNetworkMap) {
                    IFvVirtualLinksDirector iFvVirtualLinksDirector = ((FvNetworkMap)this.mtk).getVirtualLinksDirector();
                    iFvVirtualLinksDirector.getTheLinkTerminations(iFvVirtualLink);
                    if (iFvVirtualLinksDirector.hasASeparateTxRx(iFvVirtualLink)) {
                        stringBuffer.append("TX " + this.getVLinkName() + "\n");
                        stringBuffer.append("RX " + this.getPeerVLinkName());
                    } else {
                        stringBuffer.append(this.getVLinkName());
                    }
                    stringBuffer.append("\n  Provisionable Patchcord\n");
                }
            }
            catch (Exception exception) {
                FunctDebug.printStackTrace((Throwable)exception);
                stringBuffer.append("\n  Incomplete Provisionable Patchcord\n");
            }
        } else {
            stringBuffer.append(this.getLinkName() + "\n");
            stringBuffer.append("  \n");
            stringBuffer.append("  \n");
            String string = null;
            if (string != null) {
                stringBuffer.append("  Protection Switch: " + string + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getMenuHeaderText() {
        String string = "";
        try {
            Object object = this.getUserObject();
            if (object != null && object instanceof IFvNetLink) {
                IFvNetLink iFvNetLink = (IFvNetLink)object;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in getTooltip() " + exception);
        }
        return string;
    }

    private String getNetLinkTooltip() {
        return "";
    }

    public String getLinkDesc() {
        IFvNetLink iFvNetLink = (IFvNetLink)this.getUserObject();
        return "";
    }

    public String getLinkTypeString() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return "";
        }
        return "";
    }

    public String getProtectionTypeString() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return "";
        }
        return "";
    }

    public String getLinkName() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return "";
        }
        return "";
    }

    public String getSrcEntityString() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return "";
        }
        IFvNetLink iFvNetLink = (IFvNetLink)this.getUserObject();
        return "";
    }

    public String getDstEntityString() {
        return "";
    }

    public IFvEntityModel getSrcEntity() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return null;
        }
        return null;
    }

    public IFvEntityModel getDstEntity() {
        if (!(this.getUserObject() instanceof IFvNetLink)) {
            return null;
        }
        IFvNetLink iFvNetLink = (IFvNetLink)this.getUserObject();
        return null;
    }

    public void setState(int n) {
        final int n2 = n;
        super.setState(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FunctNetMapLink.this.setLineColor(FunctNetMapLink.stateToColor(n2));
            }
        });
    }

    public static Color stateToColor(int n) {
        switch (n) {
            case 1: {
                return LINK_DOWN_COLOR;
            }
            case 2: {
                return LINK_UP_COLOR;
            }
            case 0: {
                return LINK_SELECTED_COLOR;
            }
            case 3: {
                return LINK_INCLUDED_COLOR;
            }
            case 4: {
                return LINK_ACTIVE_COLOR;
            }
            case 5: {
                return LINK_STANDBY_COLOR;
            }
            case 6: {
                return LINK_EXCLUDED_COLOR;
            }
            case 7: {
                return LINK_ROLL_COLOR;
            }
        }
        return LINK_UNKNOWN_COLOR;
    }

    public static int getLinkAggregatedState(MapLink[] mapLinkArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < mapLinkArray.length; ++i) {
            FunctNetMapLink functNetMapLink;
            if (!(mapLinkArray[i] instanceof FunctNetMapLink) || (functNetMapLink = (FunctNetMapLink)mapLinkArray[i]) == null) continue;
            int n7 = functNetMapLink.getState();
            if (n7 == 2) {
                ++n;
                continue;
            }
            if (n7 == 1) {
                ++n2;
                continue;
            }
            if (n7 == 3) {
                ++n3;
                continue;
            }
            if (n7 == 6) {
                ++n4;
                continue;
            }
            if (n7 == 4) {
                ++n5;
                continue;
            }
            if (n7 != 5) continue;
            ++n6;
        }
        if (n5 > 0) {
            return 4;
        }
        if (n6 > 0) {
            return 5;
        }
        if (n3 > 0) {
            return 3;
        }
        if (n4 > 0) {
            return 6;
        }
        if (n2 > 0) {
            return 1;
        }
        return 2;
    }

    public void destroy() {
        if (!this.mtk.isDetailed()) {
            this.pss.destroy();
        }
        super.destroy();
    }

    protected Image getLinkIcon(String string) {
        return LinkClassIconUtil.getLinkIcon(string);
    }

    public String getVLinkName() {
        String string = "";
        if (this.getUserObject() instanceof IFvVirtualLink) {
            IFvVirtualLink iFvVirtualLink = (IFvVirtualLink)this.getUserObject();
            string = this.parseVirtualNetLink(iFvVirtualLink);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPeerVLinkName() {
        String string = "incomplete";
        try {
            if (this.getUserObject() instanceof IFvVirtualLink && !((FvNetworkMap)this.mtk).getVirtualLinksDirector().hasASeparateTxRx((IFvVirtualLink)this.getUserObject())) return string;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        return string;
    }

    private String formatLinkName(IFvNetNode iFvNetNode, IFvEntityModel iFvEntityModel, IFvNetNode iFvNetNode2, IFvEntityModel iFvEntityModel2) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    private String parseVirtualNetLink(IFvVirtualLink iFvVirtualLink) {
        String string = "unknown";
        return string;
    }

    public void placeOrientedIcon() {
        if (!this.getLinkClass().equals("OTS")) {
            return;
        }
        double d = this.needRotation();
        if (d != 0.0) {
            this.linkIcon.mirror(d);
            this.reDraw();
        }
    }

    private double needRotation() {
        double d = MapObjectAdapter.getCenterX(this.getTo());
        double d2 = MapObjectAdapter.getCenterX(this.getFrom());
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = Math.abs(d - d2) <= 70.0;
        d3 = bl ? this.verticalRotation(this.src.getCenterY(), this.dst.getCenterY()) : this.orrizontalRotation(d, d2);
        return d3 + d4;
    }

    private double verticalRotation(double d, double d2) {
        double d3 = 0.0 - this.linkIcon.getCurrentRotation();
        double d4 = 0.0;
        d4 = d < d2 ? d3 + 90.0 : d3 + -90.0;
        return d4;
    }

    private double orrizontalRotation(double d, double d2) {
        double d3 = 0.0 - this.linkIcon.getCurrentRotation();
        double d4 = 0.0;
        d4 = d > d2 ? d3 + 180.0 : d3 + 0.0;
        return d4;
    }

    public void placeDwdmSide(int n) {
        if (this.getUserObject() == null) {
            return;
        }
        if (this.getLinkClass().equals("OTS") || this.getLinkClass().equals("PPC")) {
            if (this.sideLabel == null) {
                this.sideLabel = new MapDwdmGraph(this, n);
            } else {
                this.sideLabel.initLink(this, n);
            }
        }
    }

    public MapDwdmGraph getSideLabel() {
        return this.sideLabel;
    }

    public void showBalloon(boolean bl) {
        if (this.linkBundle == null) {
            return;
        }
        if (bl && this.getSpanLossInfoBalloon().getLinkLabel().length() == 0) {
            return;
        }
        LinkBalloon linkBalloon = this.spanLossInfoBalloon;
        FvNetworkMap fvNetworkMap = FvNetworkMap.getInstance();
        if (bl) {
            if (PowerBallon.getInstance().isForCircuit()) {
                if (fvNetworkMap != null && fvNetworkMap.isZoomLevelVisible()) {
                    linkBalloon.showIt(bl && this.isOnCircuit);
                }
            } else if (fvNetworkMap != null && fvNetworkMap.isZoomLevelVisible()) {
                linkBalloon.showIt(bl);
            }
        } else if (fvNetworkMap != null && fvNetworkMap.isZoomLevelVisible()) {
            linkBalloon.showIt(bl);
        }
        this.balloonOpened = bl;
    }

    public boolean isBalloonOpened() {
        return this.balloonOpened;
    }

    public void setBalloonPower(String string, boolean bl) {
        if (this.linkBundle == null) {
            return;
        }
        LinkBalloon linkBalloon = this.spanLossInfoBalloon;
        this.isReverseLink = bl;
        linkBalloon.setLinkLabel(string);
        if (db.on()) {
            db.println(string);
        }
        this.placeIcons();
    }

    public String getBaloonPowerInfo() {
        if (this.linkBundle == null) {
            return null;
        }
        LinkBalloon linkBalloon = this.getSpanLossInfoBalloon();
        return linkBalloon.getLinkLabel();
    }

    public void setLinkBundle(FunctLinkBundle functLinkBundle) {
        this.linkBundle = functLinkBundle;
    }

    public LinkBalloon getSpanLossInfoBalloon() {
        return this.spanLossInfoBalloon;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        super.initPopupMenu(uPopupMenu);
        if (!this.mtk.isDetailed()) {
            uPopupMenu.addSeparator();
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/FVPower.gif", PWR_CMD, 66);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == PWR_CMD) {
            SpanLossBalloon.getInstance().startCalculation(this);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void resetBaloonPower() {
        if (this.linkBundle != null) {
            this.spanLossInfoBalloon.resetLinkLabel();
        }
    }

    protected MapLinkBundle doCollapseSimilarLinks() {
        MapLinkBundle mapLinkBundle = super.doCollapseSimilarLinks();
        mapLinkBundle.setForeground(this.getForeground());
        return mapLinkBundle;
    }

    public FunctLinkBundle getLinkBundle() {
        return this.linkBundle;
    }

    public void placeIcons() {
        int n;
        LinkBalloon linkBalloon = null;
        IlvGraphic[] ilvGraphicArray = this.getChildren();
        int n2 = 0;
        if (ilvGraphicArray == null) {
            super.placeIcons();
            return;
        }
        n2 = ilvGraphicArray.length;
        for (n = 0; n < n2; ++n) {
            if (!(ilvGraphicArray[n] instanceof LinkBalloon)) continue;
            linkBalloon = (LinkBalloon)ilvGraphicArray[n];
        }
        super.placeIcons();
        if (linkBalloon != null) {
            int n3 = n = this.getChildren() != null ? this.getChildren().length : 0;
            if (!this.isReverseLink) {
                this.setChildren(n, (IlvGraphic)linkBalloon);
                this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, IlvLinkAttachmentLocation.ToLink));
            } else {
                this.setChildren(n, (IlvGraphic)linkBalloon);
                this.setConstraints(n++, new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, IlvLinkAttachmentLocation.FromLink));
            }
        }
    }

    public void setHiddenByInterLink(boolean bl) {
        this.isHiddenByInterLink = bl;
    }

    public void setBalloonUnderCircuit(boolean bl) {
        if (this.spanLossInfoBalloon != null) {
            this.isOnCircuit = bl;
        }
    }

    public void powerPortIsReady() {
    }

    public void spanLossIsReady() {
        this.showBalloon(!this.getSpanLossInfoBalloon().isVisible());
    }

    public boolean isOnCircuit() {
        return this.isOnCircuit;
    }
}

