/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher;

import cerent.cms.fv.IFvAlarmStatus;
import cerent.cms.fv.IFvEleAlarmStore;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeType;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.network.MapPersist;
import cerent.util.IObservable;
import cerent.util.SDebug;
import cerent.util.view.fv.ViewManagerToolKit;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.InterGraphLink;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapLabel;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.util.FvMapGraph;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class FunctNetMapNode
extends DetailedMapNode
implements Observer {
    private static final SDebug db = new SDebug("NetMapNode");
    private IFvNetNode nodeModel;
    private Image[] cachedIcons;
    private String toolTipNodeType;
    private static final int ALARM_LABEL = 1;
    private boolean instantiated = true;
    public static final String POSITION_XY = "PositionXY";
    public static final int OK_STATE = 0;
    public static final int MINOR_STATE = 1;
    public static final int MAJOR_STATE = 2;
    public static final int CRITICAL_STATE = 3;
    public static final int DISCONNECTED_STATE = 4;
    public static final int UNKNOWN_STATE = 5;
    public static final int OOS_MT_STATE = 6;
    public static final int IS_AINS_STATE = 7;
    public static final int NOT_IN_CIRCUIT_STATE = 8;
    public static final String OK_STRING = "OK";
    public static final String MINOR_STRING = "Minor";
    public static final String MAJOR_STRING = "Major";
    public static final String CRITICAL_STRING = "Critical";
    public static final String DISCONNECTED_STRING = "Disconnected";
    public static final String OOS_MT_STRING = "OOS_MT";
    public static final String IS_AINS_STRING = "IS_AINS";
    public static final Color OK_COLOR = Color.green;
    public static final Color MINOR_COLOR = Color.yellow;
    public static final Color MAJOR_COLOR = Color.orange;
    public static final Color CRITICAL_COLOR = Color.red;
    public static final Color DISCONNECTED_COLOR = Color.gray;
    public static final Color OOS_MT_COLOR = Color.cyan;
    public static final Color IS_AINS_COLOR = new Color(205, 205, 255);
    protected int state = 5;
    private boolean isCmsHost;
    private int nodeType;
    private int opticalNodeType;
    private IFvEleAlarmStore alarmStore;
    private IFvNetElement ne = null;
    private ViewManagerToolKit nodeFv;
    private boolean maskAlarm = false;
    private static final Image[] DEFAULT_UNK_IMAGE = new Image[]{FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_green_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_yellow_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_orange_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_red_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_grey_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_blue.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_dkblue_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_magenta_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_green_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_yellow_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_orange_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_red_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_grey_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_blue.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_dkblue_dim.gif"), FunctNetMapNode.createImage("/images/icons/unknown/32x32-Unknown_magenta_dim.gif")};
    public static final int CLEAR_FV_SEVERITY = -1;
    private UpdateNodeAttributes updateNodeAttributes = new UpdateNodeAttributes();
    private Paint baseNameColor;
    private int highestSeverity = -1;
    private boolean resetNodePos = true;

    public FunctNetMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public void init(Object object, double d, double d2, Object object2) {
        super.init(object, d, d2, object2);
        if (this.getUserObject() instanceof IFvNetNode) {
            this.nodeModel = (IFvNetNode)this.getUserObject();
            if (this.nodeModel != null) {
                this.isCmsHost = this.nodeModel.isCmsHost();
                this.nodeType = this.getNodeType();
                this.opticalNodeType = this.getModelOpticalType();
                this.addObservers();
                this.updateNodeAttributes();
            }
        }
    }

    private void addObservers() {
        if (this.nodeModel != null && this.nodeModel.getTheConnectionNotifier() != null) {
            this.nodeModel.getTheConnectionNotifier().addObserver((Observer)this);
        }
        ModelIndirectObservable.instance().addObserver((IObservable)((NodeModel)this.nodeModel), this);
        if (this.ne != null) {
            this.ne.addObserver((Observer)this);
        }
    }

    private void updateNodeAttributes() {
        this.checkConnection();
        this.checkNodeNameChanged();
        if (!this.isVirtual()) {
            this.checkNodeAttributes();
        }
        this.baseNameColor = ((MapLabel)this.getChildren(1)).getFillPaint();
        this.updateNodePosition();
        this.resetNodePos = true;
    }

    private void updateNodePosition() {
        if (this.resetNodePos) {
            if (!this.mtk.getMapProperty(this, 101)) {
                this.resetPosition();
            }
            this.mtk.updateView();
        }
    }

    protected synchronized void resetPosition() {
        block5: {
            Point2D.Double double_;
            block4: {
                if (!(this.getUserObject() instanceof IFvNetNode)) {
                    return;
                }
                double_ = FunctNetMapNode.getPositionXY(this.mtk, (IFvNetNode)this.getUserObject());
                FunctNetMapNode functNetMapNode = this;
                if (double_.getX() != (double)functNetMapNode.mtk.getCanvasCenterX()) break block4;
                FunctNetMapNode functNetMapNode2 = this;
                if (double_.getY() == (double)functNetMapNode2.mtk.getCanvasCenterY()) break block5;
            }
            this.setCoordinates(MapPersist.toNewX((int)double_.getX()), MapPersist.toNewY((int)double_.getY()));
        }
        this.mtk.updateView();
    }

    public static Point2D.Double getPositionXY(MapToolkit mapToolkit, IFvNetNode iFvNetNode) {
        double d = mapToolkit.getCanvasCenterX();
        double d2 = mapToolkit.getCanvasCenterY();
        if (iFvNetNode == null) {
            return new Point2D.Double(d, d2);
        }
        if (!iFvNetNode.isInited() || iFvNetNode.getNodeId() == 0) {
            return new Point2D.Double(d, d2);
        }
        try {
            String string = iFvNetNode.getProperty(POSITION_XY);
            String string2 = string.substring(0, string.indexOf(44));
            String string3 = string.substring(string.indexOf(44) + 1);
            d = Double.parseDouble(string2);
            d2 = Double.parseDouble(string3);
            return new Point2D.Double(d, d2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                d = mapToolkit.toWorldX(iFvNetNode.getLongitude());
                d2 = mapToolkit.toWorldY(iFvNetNode.getLatitude());
                return new Point2D.Double(d, d2);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                return new Point2D.Double(d, d2);
            }
        }
    }

    private void checkNodeAttributes() {
    }

    private void checkNodeNameChanged() {
        try {
            String string = this.getName();
            String string2 = this.getNewNodeName();
            if (!string2.equals(string)) {
                this.changeNodeName(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void changeNodeName(String string) {
        try {
            FvNetworkMap fvNetworkMap;
            if (this.isTopoHost()) {
                string = string + "*";
            }
            this.setName(string);
            if (this.isCmsHost && this.isFvNetworkMap()) {
                this.setFontStyle(1);
            }
            if ((fvNetworkMap = FvNetworkMap.getInstance()) != null) {
                fvNetworkMap.changeNodeAttributes(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isFvNetworkMap() {
        return this.mtk instanceof FvNetworkMap;
    }

    private boolean isTopoHost() {
        boolean bl = false;
        if (this.ne == null) {
            if (this.nodeModel != null) {
                if (this.mtk instanceof FvNetworkMap) {
                    this.ne = ((FvNetworkMap)this.mtk).getNetworkModel().findIFvNetElem(this.nodeModel.getNodeId());
                }
            } else {
                return bl;
            }
        }
        if (this.ne != null) {
            bl = this.ne.isTopoHost();
        }
        return bl;
    }

    private String getNewNodeName() {
        String string = this.getName();
        try {
            string = this.nodeModel.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() {
        int n;
        int n2;
        int n3 = this.getState();
        if (n3 != (n2 = this.getModelState())) {
            try {
                Object var5_6;
                block10: {
                    try {
                        AbstractGraph abstractGraph;
                        if (n3 == 5 || n3 == 4) {
                            this.startObservingAlarmStore();
                            abstractGraph = this.getChildGrapher();
                            if (abstractGraph != null && abstractGraph instanceof FvMapGraph) {
                                ((FvMapGraph)abstractGraph).restoreNodeFv();
                            }
                            break block10;
                        }
                        if (n2 != 4) break block10;
                        this.stopObservingAlarmStore();
                        abstractGraph = this.getChildGrapher();
                        if (abstractGraph == null || !(abstractGraph instanceof FvMapGraph)) break block10;
                        ((FvMapGraph)abstractGraph).removeNodeFv();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        var5_6 = null;
                        this.setState(n2);
                    }
                }
                var5_6 = null;
                this.setState(n2);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.setState(n2);
                throw throwable;
            }
        }
        boolean bl = false;
        int n4 = this.getNodeType();
        if (this.nodeType != n4) {
            bl = true;
            this.nodeType = n4;
        }
        if (this.opticalNodeType != (n = this.getModelOpticalType())) {
            bl = true;
            this.opticalNodeType = n;
        }
        if (bl) {
            this.updateGraphic();
            this.nodeType = n4;
            this.opticalNodeType = n;
        }
    }

    private void stopObservingAlarmStore() {
        IFvEleAlarmStore iFvEleAlarmStore = this.getElementAlarmStore();
        if (iFvEleAlarmStore != null) {
            iFvEleAlarmStore.deleteAlarmStatusObserver((Observer)this);
            this.resetElementAlarmStore();
        }
    }

    private void resetElementAlarmStore() {
        this.alarmStore = null;
    }

    private void startObservingAlarmStore() {
        IFvEleAlarmStore iFvEleAlarmStore = this.getElementAlarmStore();
        if (iFvEleAlarmStore != null) {
            iFvEleAlarmStore.addAlarmStatusObserver((Observer)this);
        }
    }

    private int getModelState() {
        IFvEleAlarmStore iFvEleAlarmStore;
        if (this.nodeModel == null || !this.nodeModel.neTypeKnown()) {
            return 5;
        }
        if (this.nodeModel.isInited() && this.nodeModel.getConnectionState() && (iFvEleAlarmStore = this.getElementAlarmStore()) != null) {
            return FunctNetMapNode.getMapNodeState(iFvEleAlarmStore.getAlarmStatus());
        }
        return 4;
    }

    public static int getMapNodeState(IAlarmStatus iAlarmStatus) {
        int n = 0;
        if (iAlarmStatus != null) {
            switch (iAlarmStatus.getHighestSeverity()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    n = 4;
                }
            }
        }
        return n;
    }

    public Color stateToColor(int n) {
        switch (n) {
            case 0: {
                return OK_COLOR;
            }
            case 1: {
                return MINOR_COLOR;
            }
            case 2: {
                return MAJOR_COLOR;
            }
            case 3: {
                return CRITICAL_COLOR;
            }
            case 6: {
                return OOS_MT_COLOR;
            }
            case 7: {
                return IS_AINS_COLOR;
            }
        }
        return DISCONNECTED_COLOR;
    }

    private IFvEleAlarmStore getElementAlarmStore() {
        block5: {
            if (this.alarmStore == null && this.nodeModel != null) {
                try {
                    this.alarmStore = this.nodeModel.getTheElementAlarmStore();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        db.println("Caught exception in getElementAlarmStore()");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Caught exception in getElementAlarmStore()");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return this.alarmStore;
    }

    private int getModelOpticalType() {
        int n = 0;
        if (this.nodeModel != null && this.nodeModel.isInited() && (this.getNodeType() == 2 || this.getNodeType() == 1)) {
            try {
                n = this.nodeModel.getNodeOpticalType();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    protected void updateGraphic() {
        if (this.mtk.isDetailed()) {
            this.setColor(this.stateToColor(this.getState()));
        } else {
            this.setIcon(this.getIcon());
        }
    }

    protected Image getIcon() {
        if (this.mtk.isDetailed()) {
            return null;
        }
        int n = 8;
        try {
            Image[] imageArray = this.fetchIcons(this.getUserObject());
            if (this.isVirtual()) {
                return imageArray[this.getState() + n];
            }
            return imageArray[this.getState()];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setState(int n) {
        this.state = n;
        this.updateGraphic();
    }

    public int getState() {
        if (!this.instantiated) {
            return 5;
        }
        if (!this.maskAlarm) {
            if (this.highestSeverity == -1) {
                return this.state;
            }
            return this.highestSeverity;
        }
        return 8;
    }

    protected Image[] fetchIcons(Object object) {
        if (object != null && this.cachedIcons == null) {
            this.nodeModel = (IFvNetNode)object;
            Image[] imageArray = this.getIconSet();
            if (imageArray != null) {
                this.cachedIcons = imageArray;
                this.toolTipNodeType = this.getNodeTypeTooltip();
                return this.cachedIcons;
            }
        }
        if (this.cachedIcons != null) {
            return this.cachedIcons;
        }
        return DEFAULT_UNK_IMAGE;
    }

    private String getNodeTypeTooltip() {
        String string = null;
        try {
            if (this.getNodeType() == 2 || this.getNodeType() == 1) {
                string = INodeType.NODE_OPT_TYPES[this.nodeModel.getNodeOpticalType()];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private int getNodeType() {
        int n = 0;
        if (this.nodeModel != null && this.nodeModel.isInited()) {
            try {
                n = this.nodeModel.getNodeType();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof NodeModel.ConnectionNotifier || observable instanceof IFvNetNode && object == ModelUpdateType.CHANGED || observable instanceof IFvNetElement && object == ModelUpdateType.CHANGED || object instanceof IFvAlarmStatus) {
            this.resetNodePos = false;
            SwingUtilities.invokeLater(this.updateNodeAttributes);
        }
    }

    protected Image[] getIconSet() {
        try {
            if (this.nodeModel != null) {
                return ElementFactoryFinder.getElementFactory((NodeModel)this.nodeModel).getIconSet((INodeModel)((NodeModel)this.nodeModel));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public MapGraph getMapGraph() {
        return (MapGraph)this.getChildGrapher();
    }

    public void setNodeFv(ViewManagerToolKit viewManagerToolKit) {
        this.nodeFv = viewManagerToolKit;
    }

    public ViewManagerToolKit getNodeFv() {
        return this.nodeFv;
    }

    public static String getStateDescription(int n) {
        switch (n) {
            case 0: {
                return OK_STRING;
            }
            case 1: {
                return MINOR_STRING;
            }
            case 2: {
                return MAJOR_STRING;
            }
            case 3: {
                return CRITICAL_STRING;
            }
            case 6: {
                return OOS_MT_STRING;
            }
            case 7: {
                return IS_AINS_STRING;
            }
        }
        return DISCONNECTED_STRING;
    }

    public String getToolTipText() {
        IFvEleAlarmStore iFvEleAlarmStore;
        if (this.getState() != 4 && (iFvEleAlarmStore = this.getElementAlarmStore()) != null) {
            IAlarmStatus iAlarmStatus = iFvEleAlarmStore.getAlarmStatus();
            String string = this.toolTipNodeType != null ? this.toolTipNodeType + ":" : "";
            if (iAlarmStatus != null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.isVirtual()) {
                    stringBuffer.append(this.getRealNode().getDomainName() + "(");
                }
                stringBuffer.append(this.getName() + ":");
                stringBuffer.append(string);
                stringBuffer.append(" CR:" + iAlarmStatus.critical());
                stringBuffer.append(" MJ:" + iAlarmStatus.major());
                stringBuffer.append(" MN:" + iAlarmStatus.minor());
                if (this.isVirtual()) {
                    stringBuffer.append(")");
                }
                return stringBuffer.toString();
            }
            if (this.isVirtual()) {
                return "(" + this.getName() + ":" + string + " CR:0 MJ:0 MN:0 )";
            }
            return this.getName() + ":" + string + " CR:0 MJ:0 MN:0";
        }
        return this.getName() + ": Node not responding";
    }

    public void maskAlarm(boolean bl, int n) {
        this.maskAlarm = bl;
        this.highestSeverity = n;
        this.updateGraphic();
    }

    public IFvNetNode getNodeModel() {
        return this.nodeModel;
    }

    public void otsLinkAdjust() {
        super.otsLinkAdjust();
        FvNetworkMap fvNetworkMap = FvNetworkMap.getInstance();
        IFvNetNode iFvNetNode = this.getNodeModel();
        if (fvNetworkMap != null && iFvNetNode != null) {
            int n = iFvNetNode.getNodeId();
            LinkedList<InterGraphLink> linkedList = fvNetworkMap.getInterGraphLinks();
            for (InterGraphLink interGraphLink : linkedList) {
                if (!interGraphLink.connectNode(n)) continue;
                interGraphLink.placeOrientedIcon();
            }
        }
    }

    private class UpdateNodeAttributes
    implements Runnable {
        private UpdateNodeAttributes() {
        }

        public void run() {
            FunctNetMapNode.this.updateNodeAttributes();
        }
    }
}

