/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.circuit;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvOpticsChannelModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvViewCircuitPath;
import cerent.cms.fv.net.IFVCircuitSpan;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.topo.INetElement;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.alarms.FVPaintAlarm;
import com.cisco.fv.circuit.FvSelCircuitToolPane;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FVNetCircuitPathElements;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FvNetworkCircuitPath
extends UObservable
implements Observer,
Runnable {
    private static final int ALL_THREAD_END = 0;
    private static FvNetworkCircuitPath netCircuitPath;
    private HashMap<MapLink, Color> linksOriginalStates;
    private int prevSelectedCircuitId = -1;
    private LinkedList<ViewManager> openNodeVms;
    private Thread threadPaint;
    private IFVSelectedPowerModel activeCircuit;
    private IFVSelectedPowerModel selectedCircuit;
    private int circuitId;
    private boolean threadWorking;
    private FVNetCircuitPathElements activeElements = null;
    private int allThreadFinish;
    public static long circuitDbgtime;
    private LinkedList<ViewPin> sourceDestination = new LinkedList();
    private static SDebug sd;

    private FvNetworkCircuitPath() {
        this.openNodeVms = new LinkedList();
        this.sourceDestination = new LinkedList();
        this.linksOriginalStates = new HashMap();
        this.addObserver(FvSelCircuitToolPane.getInstance());
    }

    public static FvNetworkCircuitPath getInstance() {
        if (netCircuitPath == null) {
            netCircuitPath = new FvNetworkCircuitPath();
            FunctViewManagerDelegate.getInstance().addObserver(netCircuitPath);
        }
        return netCircuitPath;
    }

    public void paintCircuit(IFVSelectedPowerModel iFVSelectedPowerModel, int n) {
        boolean bl = true;
        if (this.prevSelectedCircuitId != -1 && this.prevSelectedCircuitId == n) {
            bl = false;
        }
        if (bl) {
            if (!this.threadWorking) {
                if (sd.on()) {
                    sd.println("Paint start after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                }
                this.selectedCircuit = iFVSelectedPowerModel;
                this.circuitId = n;
                String string = "Paint CircuitId " + n;
                this.threadWorking = true;
                this.threadPaint = new Thread((Runnable)this, string);
                this.threadPaint.start();
            } else if (sd.on()) {
                sd.println("already Running");
            }
        }
    }

    private boolean isInActivePath(IFvNetElement iFvNetElement, List<IFvNetLink> list, List<IFVCircuitSpan> list2) {
        boolean bl = true;
        boolean bl2 = true;
        for (IFVCircuitSpan iFVCircuitSpan : list2) {
            boolean bl3;
            if (iFVCircuitSpan.getIFvLink().getDestination() == iFvNetElement) {
                boolean bl4 = bl3 = ((NetCircuitSpan)iFVCircuitSpan).getSpanState(((NetCircuitSpan)iFVCircuitSpan).getDstNCN().getNodeModel()) != 1;
                if (bl != bl3 && !bl2) {
                    return true;
                }
                bl = bl3;
                bl2 = false;
            }
            if (iFVCircuitSpan.getIFvLink().getSource() != iFvNetElement) continue;
            boolean bl5 = bl3 = ((NetCircuitSpan)iFVCircuitSpan).getSpanState(((NetCircuitSpan)iFVCircuitSpan).getSrcNCN().getNodeModel()) != 1;
            if (bl != bl3 && !bl2) {
                return true;
            }
            bl = bl3;
            bl2 = false;
        }
        return bl;
    }

    public void clearActiveCircuit(FvNetworkMap fvNetworkMap, boolean bl) {
        ViewManager viewManager;
        int n;
        List list;
        if (sd.on()) {
            sd.println("Clear Enter after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        if (bl) {
            PowerBallon.getInstance().setForCircuit(false);
            SpanLossBalloon.getInstance().setForCircuit(false);
        }
        if (this.openNodeVms != null) {
            list = (LinkedList)this.openNodeVms.clone();
            this.openNodeVms.clear();
            for (n = 0; n < ((LinkedList)list).size(); ++n) {
                viewManager = (ViewManager)((LinkedList)list).get(n);
                viewManager.getCircuitsPathManager().clearActiveCircuit();
                viewManager.getNode().setPowerCalculated(false);
                if (!sd.on()) continue;
                sd.println("\t after cleared " + viewManager.getNode().getName() + " " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
        }
        if (sd.on()) {
            sd.println("\t after clearActiveCircuit" + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        if (this.sourceDestination != null && this.sourceDestination.size() != 0) {
            while (this.sourceDestination.size() != 0) {
                list = this.sourceDestination.removeFirst();
                ((ViewPin)list).pinCompo.setChildren(1, null);
                ((ViewPin)list).grapher.allSourceDestination.remove(((ViewPin)list).key);
            }
            this.sourceDestination.clear();
        }
        if (sd.on()) {
            sd.println("\t after Source/Destination" + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        if (this.linksOriginalStates != null && this.linksOriginalStates.size() > 0) {
            fvNetworkMap.restoreLinkStates(this.linksOriginalStates);
            this.linksOriginalStates.clear();
        }
        if (this.activeElements != null) {
            this.activeElements.setPowerBallon(false);
        }
        if (this.activeCircuit != null) {
            list = this.activeCircuit.getSpanNodes();
            for (n = 0; n < list.size(); ++n) {
                viewManager = (IFvNetNode)list.get(n);
                viewManager.setInCircuit(false);
            }
        }
        this.clearGraphTool(bl);
        this.prevSelectedCircuitId = -1;
        this.activeCircuit = null;
        if (sd.on()) {
            sd.println("Clear Exit after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
    }

    private void clearGraphTool(boolean bl) {
        FVPaintAlarm.getInstance().setAlarmMask(false);
        if (bl) {
            FvNetworkMap.getInstance().calculatePowerBalloon();
            FvNetworkMap.getInstance().calculateSpanLossBalloon();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof FunctObserverArgument) {
            int n = ((FunctObserverArgument)object).getType();
            IFvNetNode iFvNetNode = ((FunctObserverArgument)object).getNode();
            FvNetworkMap fvNetworkMap = FunctViewManagerDelegate.getInstance().getNetworkMap();
            switch (n) {
                case 1: {
                    ViewManager viewManager;
                    this.updateNodeCircuits(false, iFvNetNode, fvNetworkMap);
                    ViewManagerToolKit viewManagerToolKit = fvNetworkMap.getTk(iFvNetNode);
                    ViewGrapher viewGrapher = viewManagerToolKit.getGraph();
                    if (viewGrapher == null || !this.openNodeVms.contains(viewManager = viewGrapher.getViewManager())) break;
                    this.openNodeVms.remove(viewManager);
                    break;
                }
                case 0: 
                case 3: {
                    if (((FunctObserverArgument)object).hasMoreData() == 2) break;
                    this.updateNodeCircuits(true, iFvNetNode, fvNetworkMap);
                }
            }
        }
    }

    public void updateCircuits(boolean bl) {
        if (bl && this.prevSelectedCircuitId != -1 && this.activeCircuit != null) {
            int n = this.prevSelectedCircuitId;
            IFVSelectedPowerModel iFVSelectedPowerModel = this.activeCircuit;
            if (iFVSelectedPowerModel instanceof FvSelectedCircuitModel) {
                ((FvSelectedCircuitModel)iFVSelectedPowerModel).addPortsForCircuitNodes();
            }
            this.prevSelectedCircuitId = -1;
            this.paintCircuit(iFVSelectedPowerModel, n);
        }
    }

    @Override
    public void run() {
        Thread thread;
        LinkedList linkedList = (LinkedList)FunctViewManagerDelegate.getInstance().getAllOpenNodes().clone();
        if (sd.on()) {
            sd.println("");
            sd.println("");
            sd.println("Circuit " + ((INetCircuit)this.selectedCircuit.getCircuitModel()).getCircuitName());
            sd.println("Task started " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            sd.println("DEACTIVATE BUTTON");
        }
        FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(false);
        FvNetworkMap fvNetworkMap = FunctViewManagerDelegate.getInstance().getNetworkMap();
        if (this.selectedCircuit.getCircuitModel() == null) {
            return;
        }
        this.prepareCircuitNetLink(fvNetworkMap);
        this.activeElements.setPowerBallon(true);
        if (sd.on()) {
            sd.println("\t end setPowerBallon after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        this.placeSpanLossBalloon(fvNetworkMap);
        List list = this.selectedCircuit.getSpanNodes();
        block0: for (int i = 0; i < list.size(); ++i) {
            Object object = (IFvNetNode)list.get(i);
            object.setInCircuit(true);
            if (!object.isFVActive()) continue;
            thread = new Thread((Runnable)new nodeThread((IFvNetNode)object, fvNetworkMap, true), "nodePaint");
            thread.start();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                FunctNetMapNode functNetMapNode = (FunctNetMapNode)iterator.next();
                if (functNetMapNode.getNodeModel() != object) continue;
                iterator.remove();
                continue block0;
            }
        }
        for (Object object : linkedList) {
            thread = new Thread((Runnable)new nodeThread(((FunctNetMapNode)object).getNodeModel(), fvNetworkMap, false), "nodePaint");
            thread.start();
        }
        this.paintFinished(false);
    }

    private void updateNodeCircuits(boolean bl, IFvNetNode iFvNetNode, FvNetworkMap fvNetworkMap) {
        if (this.activeCircuit == null) {
            return;
        }
        if (iFvNetNode.isFVActive() && iFvNetNode.isInCircuit()) {
            if (sd.on()) {
                sd.println("DEACTIVATE BUTTON");
            }
            FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(false);
            ((FvSelectedCircuitModel)this.activeCircuit).addPortsForCircuitNode(iFvNetNode);
            Thread thread = new Thread((Runnable)new nodeThread(iFvNetNode, fvNetworkMap, true), "nodePaint");
            thread.start();
        }
    }

    private synchronized void paintFinished(boolean bl) {
        if (bl) {
            --this.allThreadFinish;
            if (sd.on()) {
                sd.println("Decremented Thread = " + this.allThreadFinish);
            }
        }
        if (this.allThreadFinish == 0) {
            FunctObserverArgument functObserverArgument = new FunctObserverArgument(null, 5);
            this.setChanged();
            this.notifyObservers(functObserverArgument);
            FVPaintAlarm.getInstance().setAlarmMask(true);
            this.threadWorking = false;
            if (sd.on()) {
                sd.println("Paint finish after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                sd.println("ACTIVATE BUTTON");
            }
            FunctViewManagerDelegate.getInstance().circuitTableAndToolsButtonEnable(true);
        }
    }

    private void prepareCircuitNetLink(FvNetworkMap fvNetworkMap) {
        List list = this.selectedCircuit.getCircuitLink();
        List list2 = this.selectedCircuit.getCircuitSpans();
        this.activeElements = new FVNetCircuitPathElements(list2, list, this.selectedCircuit.isBidirectional());
        if (sd.on()) {
            sd.println("\t prepare Link start after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
        this.linksOriginalStates = fvNetworkMap.showSelectedCircuit(this.activeElements);
        this.prevSelectedCircuitId = this.circuitId;
        this.activeCircuit = this.selectedCircuit;
        if (sd.on()) {
            sd.println("\t prepare Link finish after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
    }

    public void dispose() {
        this.prevSelectedCircuitId = -1;
        this.linksOriginalStates.clear();
        this.linksOriginalStates = null;
        this.openNodeVms.clear();
        this.openNodeVms = null;
        FunctViewManagerDelegate.getInstance().deleteObserver(netCircuitPath);
        netCircuitPath = null;
        this.sourceDestination.clear();
    }

    public void printDbgStr(String string) {
        if (sd.on()) {
            sd.println(string);
        }
    }

    private void placeSpanLossBalloon(FvNetworkMap fvNetworkMap) {
        fvNetworkMap.showPower(false, 0);
        boolean bl = FunctViewManagerDelegate.getInstance().isSpanLossPowerVisible();
        if (bl) {
            FunctViewManagerDelegate.getInstance().powerButtonAction(bl, 0);
        }
        if (sd.on()) {
            sd.println("\t\t spanLoss placed after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
        }
    }

    static {
        sd = new SDebug("FvNetworkCircuitPath");
    }

    private class nodeThread
    implements Runnable {
        private IFvNetNode node;
        private FvNetworkMap netMap;
        private boolean nodeInCircuit;

        public nodeThread(IFvNetNode iFvNetNode, FvNetworkMap fvNetworkMap, boolean bl) {
            FvNetworkCircuitPath.this.allThreadFinish++;
            if (sd.on()) {
                sd.println("[" + FvNetworkCircuitPath.this.allThreadFinish + "]Node " + iFvNetNode.getName() + " Added ");
            }
            this.node = iFvNetNode;
            this.netMap = fvNetworkMap;
            this.nodeInCircuit = bl;
        }

        public void run() {
            if (this.nodeInCircuit) {
                this.paintInCircuit();
            } else {
                this.makeBalloonVisible(this.netMap.getTk(this.node), false, false);
                FvNetworkCircuitPath.this.paintFinished(true);
            }
        }

        private void paintInCircuit() {
            IFvOpticsPortModel iFvOpticsPortModel;
            List list;
            int n;
            ViewPin viewPin;
            String string;
            List list2;
            IFvPortModel iFvPortModel;
            int n2;
            int n3;
            Object object;
            Object object2;
            Object object32;
            Object object4;
            ViewManager viewManager;
            IFvViewCircuitPath iFvViewCircuitPath = null;
            IFvInterfaceModel iFvInterfaceModel = null;
            INodeOpticsTopologyModel iNodeOpticsTopologyModel = null;
            ViewManagerToolKit viewManagerToolKit = this.netMap.getTk(this.node);
            ViewGrapher viewGrapher = viewManagerToolKit.getGraph();
            if (viewGrapher != null) {
                viewManager = viewGrapher.getViewManager();
                if (FvNetworkCircuitPath.this.openNodeVms.contains(viewManager)) {
                    if (sd.on()) {
                        sd.println("\t" + viewManager.getNode().getName() + " already present in the list");
                    }
                    return;
                }
            } else {
                return;
            }
            FvNetworkCircuitPath.this.openNodeVms.add(viewManager);
            this.makeBalloonVisible(viewManagerToolKit, false, false);
            if (sd.on()) {
                sd.println("\t Start patchcords for node  " + this.node.getName() + "after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            NetCircuitManager netCircuitManager = NetCircuitManager.instance();
            INetElement iNetElement = netCircuitManager.getNetwork().getNetElem(this.node.getNodeId());
            LinkedList<IFvEntityModel> linkedList = ((FvSelectedCircuitModel)FvNetworkCircuitPath.this.selectedCircuit).getPathInForNode(iNetElement);
            boolean bl = FvNetworkCircuitPath.this.isInActivePath(iNetElement, FvNetworkCircuitPath.this.selectedCircuit.getCircuitLink(), FvNetworkCircuitPath.this.selectedCircuit.getCircuitSpans());
            if (linkedList == null) {
                return;
            }
            if (linkedList.size() > 0) {
                for (int i = 0; i < linkedList.size(); ++i) {
                    object4 = (IEntityModel)linkedList.get(i);
                    if (hashMap.containsKey(object4.getIndex())) continue;
                    hashMap.put(object4.getIndex(), object4);
                }
            }
            Integer n4 = FvNetworkCircuitPath.this.selectedCircuit.getCircuitType();
            for (Object object32 : hashMap.values()) {
                if (!(object32 instanceof IPortModel)) continue;
                object2 = (IPortModel)object32;
                IFvInterfaceModel[] iFvInterfaceModelArray = null;
                iFvInterfaceModel = (IFvInterfaceModel)object2.getInterfaceModel();
                if (!(iFvInterfaceModel instanceof IFvDwdmTrkLineModel) && !(iFvInterfaceModel instanceof IFvOpticsChannelModel)) {
                    if (!(iFvInterfaceModel instanceof IFvOpticsLineModel)) continue;
                    object = (IFvInterfaceModel)object2.getInterfaceModel();
                    iFvInterfaceModelArray = object.getTheHigherLayerModels();
                    for (n3 = 0; n3 < iFvInterfaceModelArray.length; ++n3) {
                        try {
                            if (((IOpticsChannelModel)iFvInterfaceModelArray[n3]).getActualWaveLength() != FvNetworkCircuitPath.this.selectedCircuit.getLambda()) continue;
                            iFvInterfaceModel = iFvInterfaceModelArray[n3];
                            continue;
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            wrongInterfaceType.printStackTrace();
                            continue;
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            noSuchInterface.printStackTrace();
                        }
                    }
                }
                iNodeOpticsTopologyModel = iNetElement.getNodeModel().getINodeOpticsTopologyModel();
                if (this.netMap == null) continue;
                viewManager = viewGrapher.getViewManager();
                iFvViewCircuitPath = viewManager.getFunctionalCircuitPath();
                iFvViewCircuitPath.addCircuitPath(iNodeOpticsTopologyModel.getAllOchListFromPort(iFvInterfaceModel.getIndex()), n4.intValue(), ((FvSelectedCircuitModel)FvNetworkCircuitPath.this.selectedCircuit).getLambdaForNode(iNetElement), bl);
            }
            if (iFvViewCircuitPath != null) {
                iFvViewCircuitPath.paint();
            }
            object4 = (INetCircuit)FvNetworkCircuitPath.this.selectedCircuit.getCircuitModel();
            object32 = object4.getSources();
            object2 = object4.getDrops();
            for (n2 = 0; n2 < object32.size(); ++n2) {
                OchncCircuit ochncCircuit;
                object = (INetCircuitEnd)object32.get(n2);
                if (object.getNodeId() != viewManagerToolKit.getNodeModel().getNodeId()) continue;
                if (object4 instanceof OchncCircuit && (ochncCircuit = (OchncCircuit)object4).getEndPointForOchTrail(object.getNetElement()) != null) {
                    object = ochncCircuit.getEndPointForOchTrail(object.getNetElement());
                }
                n3 = object.getEntityIndex();
                iFvPortModel = (IFvPortModel)viewManagerToolKit.getNodeModel().getEntityModelByIndex(n3);
                list2 = null;
                if (iFvPortModel.getPortString().contains("TX")) {
                    list2 = iFvPortModel.getIFVNextPorts(true);
                    string = "TX";
                } else {
                    list2 = iFvPortModel.getIFVPrevPorts(true);
                    string = "RX";
                }
                if (list2.size() != 0 && ((IFvPortModel)list2.get(0)).getCardModel().isPassiveModule()) {
                    viewPin = ((IFvPortModel)list2.get(0)).getCardModel();
                    n = object4.getCircuitOptChannel();
                    try {
                        list = viewPin.getListOfPorts();
                        for (int i = 1; i <= list.size(); ++i) {
                            iFvOpticsPortModel = (IFvOpticsPortModel)list.get(i - 1);
                            try {
                                if (iFvOpticsPortModel.getWaveLength() != n || (!iFvOpticsPortModel.isOptPortTypeTX() || string != "TX") && (!iFvOpticsPortModel.isOptPortTypeRX() || string != "RX")) continue;
                                n3 = iFvOpticsPortModel.getEntityIndex();
                                continue;
                            }
                            catch (WrongPortType wrongPortType) {
                                KDebug.printStackTrace((Throwable)wrongPortType);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        KDebug.printStackTrace((Throwable)numberFormatException);
                    }
                }
                if ((viewPin = viewManagerToolKit.connectSourceDestination(n3, true, object4.isBidirectional())) == null) continue;
                FvNetworkCircuitPath.this.sourceDestination.add(viewPin);
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                OchncCircuit ochncCircuit;
                object = (INetCircuitEnd)object2.get(n2);
                if (object.getNodeId() != viewManagerToolKit.getNodeModel().getNodeId()) continue;
                if (object4 instanceof OchncCircuit && (ochncCircuit = (OchncCircuit)object4).getEndPointForOchTrail(object.getNetElement()) != null) {
                    object = ochncCircuit.getEndPointForOchTrail(object.getNetElement());
                }
                n3 = object.getEntityIndex();
                iFvPortModel = (IFvPortModel)viewManagerToolKit.getNodeModel().getEntityModelByIndex(n3);
                list2 = null;
                if (iFvPortModel.getPortString().contains("TX")) {
                    list2 = iFvPortModel.getIFVNextPorts(true);
                    string = "TX";
                } else {
                    list2 = iFvPortModel.getIFVPrevPorts(true);
                    string = "RX";
                }
                if (list2.size() != 0 && ((IFvPortModel)list2.get(0)).getCardModel().isPassiveModule()) {
                    viewPin = ((IFvPortModel)list2.get(0)).getCardModel();
                    n = object4.getCircuitOptChannel();
                    try {
                        list = viewPin.getListOfPorts();
                        for (int i = 1; i <= list.size(); ++i) {
                            iFvOpticsPortModel = (IFvOpticsPortModel)list.get(i - 1);
                            try {
                                if (iFvOpticsPortModel.getWaveLength() != n || (!iFvOpticsPortModel.isOptPortTypeTX() || string != "TX") && (iFvOpticsPortModel.isOptPortTypeTX() || string != "RX")) continue;
                                n3 = iFvOpticsPortModel.getEntityIndex();
                                continue;
                            }
                            catch (WrongPortType wrongPortType) {
                                KDebug.printStackTrace((Throwable)wrongPortType);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        KDebug.printStackTrace((Throwable)numberFormatException);
                    }
                }
                if ((viewPin = viewManagerToolKit.connectSourceDestination(n3, false, object4.isBidirectional())) == null) continue;
                FvNetworkCircuitPath.this.sourceDestination.add(viewPin);
            }
            if (sd.on()) {
                sd.println("\t\t End patchcords for node  " + this.node.getName() + "after " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
            n2 = FunctViewManagerDelegate.getInstance().isPowerVisible() ? 1 : 0;
            this.makeBalloonVisible(viewManagerToolKit, n2 != 0, true);
            object = new FunctObserverArgument(this.node, 0);
            FvNetworkCircuitPath.this.setChanged();
            FvNetworkCircuitPath.this.notifyObservers(object);
            FvNetworkCircuitPath.this.paintFinished(true);
        }

        private void makeBalloonVisible(ViewManagerToolKit viewManagerToolKit, boolean bl, boolean bl2) {
            boolean bl3 = FunctViewManagerDelegate.getInstance().isPowerVisible();
            if (bl3) {
                viewManagerToolKit.setBalloonsPowerAndVisibility(bl, bl2);
                viewManagerToolKit.showFunctViewPowerBallons();
            }
        }
    }
}

