/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.util;

import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.linkbundle.LinkBundleSelectionChangedEvent;
import com.cisco.ctc.util.map.linkbundle.LinkBundleSelectionChangedListener;
import com.cisco.fv.grapher.FunctNetMapLink;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class FunctLinkBundle
extends LinkBundle
implements LinkBundleSelectionChangedListener,
ManagerContentChangedListener {
    private AbstractGraph src;
    private AbstractGraph dst;
    private String bundleKey;
    private boolean registered = false;
    private boolean spanLossBalloonAdded = false;
    private FunctNetMapLink spanInfoLink;

    public FunctLinkBundle(MapToolkit mapToolkit, AbstractGraph abstractGraph, AbstractGraph abstractGraph2, String string) {
        super(abstractGraph, abstractGraph2, false);
        this.mtk = mapToolkit;
        this.src = abstractGraph;
        this.dst = abstractGraph2;
        this.bundleKey = string;
        if (!mapToolkit.isDetailed()) {
            new IlvClippingLinkConnector((IlvGraphic)abstractGraph);
            new IlvClippingLinkConnector((IlvGraphic)abstractGraph2);
        }
        super.addLinkBundleSelectionChangedListener(this);
        super.setOffset(mapToolkit.getLinkOffset());
    }

    public boolean contains(IlvLinkImage ilvLinkImage) {
        IlvLinkImage[] ilvLinkImageArray = super.getSublinks();
        if (ilvLinkImageArray != null) {
            for (int i = 0; i < ilvLinkImageArray.length; ++i) {
                if (ilvLinkImageArray[i] != ilvLinkImage) continue;
                return true;
            }
        }
        return false;
    }

    public void addLink(Link link) {
        if (!this.contains((IlvLinkImage)link)) {
            if (link instanceof FunctNetMapLink) {
                ((FunctNetMapLink)link).setLinkBundle(this);
                ((FunctNetMapLink)link).placeBalloons(this.spanLossBalloonAdded);
                if (!this.spanLossBalloonAdded) {
                    this.spanInfoLink = (FunctNetMapLink)link;
                    this.spanLossBalloonAdded = true;
                }
            }
            link.placeIcons();
            this.reDraw();
            super.addSublink((IlvLinkImage)link);
        }
    }

    public void removeLink(Link link) {
        if (this.contains((IlvLinkImage)link)) {
            IlvRect ilvRect = this.boundingBox(this.mtk.getTransformer());
            super.removeSublink((IlvLinkImage)link);
            this.mtk.reDraw((Rectangle2D)ilvRect);
        }
    }

    public Link[] getLinks() {
        ArrayList<IlvLinkImage> arrayList = new ArrayList<IlvLinkImage>();
        IlvLinkImage[] ilvLinkImageArray = super.getSublinks();
        if (ilvLinkImageArray != null) {
            for (int i = 0; i < ilvLinkImageArray.length; ++i) {
                if (!(ilvLinkImageArray[i] instanceof Link)) continue;
                arrayList.add(ilvLinkImageArray[i]);
            }
        }
        return arrayList.toArray(new Link[0]);
    }

    String getBundleKey() {
        return this.bundleKey;
    }

    void onInitPopupMenu(UPopupMenu uPopupMenu, MouseEvent mouseEvent) {
        IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
        IlvLinkImage ilvLinkImage = super.getSublink(ilvPoint, this.mtk.getTransformer());
        if (ilvLinkImage instanceof Link) {
            ((Link)ilvLinkImage).onInitPopupMenu(uPopupMenu);
        }
    }

    void clicked(MouseEvent mouseEvent) {
        IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
        IlvLinkImage ilvLinkImage = super.getSublink(ilvPoint, this.mtk.getTransformer());
        if (ilvLinkImage instanceof Link) {
            Link link = (Link)ilvLinkImage;
            this.setSelected((IlvLinkImage)link, true);
            link.clicked();
        }
    }

    void doubleClicked(MouseEvent mouseEvent) {
        IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
        IlvLinkImage ilvLinkImage = super.getSublink(ilvPoint, this.mtk.getTransformer());
        if (ilvLinkImage instanceof Link) {
            ((Link)ilvLinkImage).doubleClicked();
        }
    }

    public AbstractGraph getGraph() {
        return (AbstractGraph)super.getGraphicBag();
    }

    public void selectionChanged(LinkBundleSelectionChangedEvent linkBundleSelectionChangedEvent) {
        IlvLinkImage ilvLinkImage = linkBundleSelectionChangedEvent.getSublink();
        if (ilvLinkImage instanceof Link) {
            Link link = (Link)ilvLinkImage;
            int n = linkBundleSelectionChangedEvent.getType();
            if (n == 1) {
                link.setSelected(true);
            } else {
                link.setSelected(false);
            }
        }
    }

    public void setSelected(IlvLinkImage ilvLinkImage, boolean bl) {
        if (ilvLinkImage == null || !this.contains(ilvLinkImage) || bl && this.isSelected(ilvLinkImage)) {
            return;
        }
        if (bl) {
            this.mtk.deselectLinksInLinkBundles();
        }
        if (this.isSelected(ilvLinkImage) != bl) {
            super.setSelected(ilvLinkImage, bl);
        }
        this.reDraw();
    }

    public boolean isSelected(IlvLinkImage ilvLinkImage) {
        if (this.contains(ilvLinkImage)) {
            return super.isSelected(ilvLinkImage);
        }
        return false;
    }

    public final void setSelected(boolean bl) {
        AbstractGraph abstractGraph;
        if (bl && (abstractGraph = this.getGraph()) != null) {
            abstractGraph.setSelected((IlvGraphic)this, false, true);
        }
    }

    void deselectAllLinks() {
        Link[] linkArray = this.getLinks();
        if (linkArray != null) {
            for (int i = 0; i < linkArray.length; ++i) {
                Link link = linkArray[i];
                if (!this.isSelected((IlvLinkImage)link)) continue;
                this.setSelected((IlvLinkImage)link, false);
            }
        }
        AbstractGraph abstractGraph = this.getGraph();
        this.reDraw();
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (!this.registered) {
            this.addObserver();
        }
        return super.boundingBox(ilvTransformer);
    }

    private void addObserver() {
        if (this.getGraphicBag() != null) {
            this.getGraph().addManagerContentChangedListener(this);
            this.registered = true;
        }
    }

    public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 2: {
                ObjectRemovedEvent objectRemovedEvent = (ObjectRemovedEvent)managerContentChangedEvent;
                if (objectRemovedEvent.getGraphicObject() != this) break;
                objectRemovedEvent.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this);
                this.registered = false;
                break;
            }
            case 4: {
                ObjectBBoxChangedEvent objectBBoxChangedEvent = (ObjectBBoxChangedEvent)managerContentChangedEvent;
                if (objectBBoxChangedEvent.getGraphicObject() != this) break;
            }
        }
    }

    void placeIcons() {
        Link[] linkArray = this.getLinks();
        for (int i = 0; i < linkArray.length; ++i) {
            Link link = linkArray[i];
            if (link instanceof FunctNetMapLink) {
                boolean bl = false;
                if (link.equals(this.spanInfoLink)) {
                    bl = true;
                }
                ((FunctNetMapLink)link).placeBalloons(!bl);
                link.reDraw();
            }
            link.placeIcons();
        }
    }

    double getRotationAngle() {
        return this.mtk.getRotationAngle((IlvLinkImage)this);
    }

    public void reDraw() {
        super.reDraw();
    }

    public void setFromTo(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null) {
            abstractGraph.removeLink((IlvLinkImage)this, false);
            this.setFrom(ilvGraphic);
            this.setTo(ilvGraphic2);
            abstractGraph.addLink((IlvLinkImage)this, false);
        } else {
            this.setFrom(ilvGraphic);
            this.setTo(ilvGraphic2);
        }
    }

    public FunctNetMapLink getSpanInfoLink() {
        return this.spanInfoLink;
    }
}

